/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.currency;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.jvmcore.currency.Amount;
import java.math.BigDecimal;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\n"}, d2={"Lcom/stripe/jvmcore/currency/CurrencyFormatter;", "", "()V", "format", "", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "locale", "Ljava/util/Locale;", "", "currency", "Lcom/neovisionaries/i18n/CurrencyCode;", "currencyCode", "decimals", ""})
@SourceDebugExtension(value={"SMAP\nCurrencyFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrencyFormatter.kt\ncom/stripe/jvmcore/currency/CurrencyFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class CurrencyFormatter {
    @Inject
    public CurrencyFormatter() {
    }

    @NotNull
    public final String format(long amount, @NotNull CurrencyCode currency, @Nullable Locale locale) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return this.format(amount, currency.name(), currency.getMinorUnit(), locale);
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l2, CurrencyCode currencyCode, Locale locale, int n2, Object object) {
        if ((n2 & 4) != 0) {
            locale = null;
        }
        return currencyFormatter.format(l2, currencyCode, locale);
    }

    @NotNull
    public final String format(@NotNull Amount amount, @Nullable Locale locale) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.format(amount.getValue(), amount.getCurrency(), locale);
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, Amount amount, Locale locale, int n2, Object object) {
        if ((n2 & 2) != 0) {
            locale = null;
        }
        return currencyFormatter.format(amount, locale);
    }

    @NotNull
    public final String format(long amount, @NotNull String currencyCode, int decimals, @Nullable Locale locale) {
        String string;
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        int fractionDigits = decimals < 0 ? 0 : decimals;
        BigDecimal bigDecimal = BigDecimal.valueOf(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
        BigDecimal normalizedValue = bigDecimal.movePointLeft(fractionDigits);
        String sign = normalizedValue.signum() == -1 ? "-" : "";
        try {
            Cloneable cloneable;
            block5: {
                block4: {
                    cloneable = locale;
                    if (cloneable == null) break block4;
                    Locale p0 = cloneable;
                    boolean bl = false;
                    NumberFormat numberFormat = NumberFormat.getCurrencyInstance(p0);
                    cloneable = numberFormat;
                    if (numberFormat != null) break block5;
                }
                cloneable = NumberFormat.getCurrencyInstance();
            }
            Cloneable numberFormat = cloneable;
            ((NumberFormat)numberFormat).setCurrency(Currency.getInstance(currencyCode));
            String formatted = ((Format)numberFormat).format(normalizedValue.abs());
            string = sign + formatted;
        }
        catch (IllegalArgumentException e2) {
            StringBuilder stringBuilder = new StringBuilder().append(sign);
            String string2 = currencyCode.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            string = stringBuilder.append(string2).append(' ').append(normalizedValue.abs()).toString();
        }
        return string;
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l2, String string, int n2, Locale locale, int n3, Object object) {
        if ((n3 & 8) != 0) {
            locale = null;
        }
        return currencyFormatter.format(l2, string, n2, locale);
    }
}

