/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.featureflag;

import com.stripe.jvmcore.factoryimage.FactoryImageHelper;
import com.stripe.jvmcore.storage.KeyValueStore;
import com.stripe.jvmcore.storage.SharedPrefs;
import com.stripe.proto.model.config.ReaderFeatureFlags;
import java.security.MessageDigest;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020\tJ\u0006\u0010*\u001a\u00020&J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\tR!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "", "sharedPrefs", "Lcom/stripe/jvmcore/storage/SharedPrefs;", "factoryImageHelper", "Lcom/stripe/jvmcore/factoryimage/FactoryImageHelper;", "(Lcom/stripe/jvmcore/storage/SharedPrefs;Lcom/stripe/jvmcore/factoryimage/FactoryImageHelper;)V", "_featureFlagsUpdated", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/proto/model/config/ReaderFeatureFlags;", "get_featureFlagsUpdated", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "_featureFlagsUpdated$delegate", "Lkotlin/Lazy;", "applicationSelectionInQuickChipEnabled", "", "getApplicationSelectionInQuickChipEnabled", "()Z", "connectAndCollectEnabledForMPos", "getConnectAndCollectEnabledForMPos", "enableMagstripePin", "getEnableMagstripePin", "featureFlagsUpdated", "Lkotlinx/coroutines/flow/Flow;", "getFeatureFlagsUpdated", "()Lkotlinx/coroutines/flow/Flow;", "featureFlagsUpdated$delegate", "pluggedInDischargingMinimumMillis", "", "getPluggedInDischargingMinimumMillis", "()J", "pluggedInMinimumDischargePercent", "getPluggedInMinimumDischargePercent", "shareDeviceReportsEnabled", "getShareDeviceReportsEnabled", "ttpaEmvConfigFromBackendEnabled", "getTtpaEmvConfigFromBackendEnabled", "encodeSha256", "", "value", "", "getFeatureFlags", "getReaderFeatureFlagsHash", "putFeatureFlags", "", "readerFeatureFlags", "Companion", "featureflag"})
public final class FeatureFlagsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPrefs sharedPrefs;
    @NotNull
    private final FactoryImageHelper factoryImageHelper;
    private final boolean shareDeviceReportsEnabled;
    @NotNull
    private final Lazy _featureFlagsUpdated$delegate;
    @NotNull
    private final Lazy featureFlagsUpdated$delegate;
    @NotNull
    private static final ReaderFeatureFlags FACTORY_IMAGE_FEATURE_FLAGS = new ReaderFeatureFlags(false, false, false, false, 0L, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0L, false, false, false, false, false, false, 0L, 0L, false, 0L, null, -1, -1, 255, null);

    @Inject
    public FeatureFlagsRepository(@NotNull SharedPrefs sharedPrefs, @NotNull FactoryImageHelper factoryImageHelper) {
        Intrinsics.checkNotNullParameter((Object)sharedPrefs, (String)"sharedPrefs");
        Intrinsics.checkNotNullParameter((Object)factoryImageHelper, (String)"factoryImageHelper");
        this.sharedPrefs = sharedPrefs;
        this.factoryImageHelper = factoryImageHelper;
        this.shareDeviceReportsEnabled = this.getFeatureFlags().enable_sharing_device_report;
        this._featureFlagsUpdated$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableStateFlow<ReaderFeatureFlags>>(this){
            final /* synthetic */ FeatureFlagsRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MutableStateFlow<ReaderFeatureFlags> invoke() {
                return StateFlowKt.MutableStateFlow((Object)((Object)this.this$0.getFeatureFlags()));
            }
        }));
        this.featureFlagsUpdated$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableStateFlow<ReaderFeatureFlags>>(this){
            final /* synthetic */ FeatureFlagsRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MutableStateFlow<ReaderFeatureFlags> invoke() {
                return this.this$0.get_featureFlagsUpdated();
            }
        }));
    }

    public final long getPluggedInMinimumDischargePercent() {
        return this.getFeatureFlags().device_plugged_in_but_not_charging_minimum_battery_discharge_percent;
    }

    public final long getPluggedInDischargingMinimumMillis() {
        return this.getFeatureFlags().device_plugged_in_but_not_charging_minimum_required_duration_millis;
    }

    public final boolean getConnectAndCollectEnabledForMPos() {
        return this.getFeatureFlags().enable_new_payment_collection_android_sdk;
    }

    public final boolean getApplicationSelectionInQuickChipEnabled() {
        return this.getFeatureFlags().enable_application_selection_in_quick_chip;
    }

    public final boolean getEnableMagstripePin() {
        return this.getFeatureFlags().enable_mag_stripe_pin;
    }

    public final boolean getTtpaEmvConfigFromBackendEnabled() {
        return false;
    }

    public final boolean getShareDeviceReportsEnabled() {
        return this.shareDeviceReportsEnabled;
    }

    @NotNull
    protected final MutableStateFlow<ReaderFeatureFlags> get_featureFlagsUpdated() {
        Lazy lazy = this._featureFlagsUpdated$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    @NotNull
    public final Flow<ReaderFeatureFlags> getFeatureFlagsUpdated() {
        Lazy lazy = this.featureFlagsUpdated$delegate;
        return (Flow)lazy.getValue();
    }

    @NotNull
    public final ReaderFeatureFlags getFeatureFlags() {
        return this.factoryImageHelper.isFactoryImage() ? FACTORY_IMAGE_FEATURE_FLAGS : this.sharedPrefs.getFeatureFlags();
    }

    @NotNull
    public final String getReaderFeatureFlagsHash() {
        return this.encodeSha256(this.getFeatureFlags().encode());
    }

    public final void putFeatureFlags(@NotNull ReaderFeatureFlags readerFeatureFlags) {
        Intrinsics.checkNotNullParameter((Object)((Object)readerFeatureFlags), (String)"readerFeatureFlags");
        this.sharedPrefs.putFeatureFlags(readerFeatureFlags);
        if (this.factoryImageHelper.isFactoryImage()) {
            this.get_featureFlagsUpdated().setValue((Object)FACTORY_IMAGE_FEATURE_FLAGS);
        } else {
            this.get_featureFlagsUpdated().setValue((Object)readerFeatureFlags);
        }
    }

    private final String encodeSha256(byte[] value) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] hash = messageDigest.digest(value);
        KeyValueStore keyValueStore = this.sharedPrefs.getKeyValueStore();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        return keyValueStore.base64Encode(hash);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository$Companion;", "", "()V", "FACTORY_IMAGE_FEATURE_FLAGS", "Lcom/stripe/proto/model/config/ReaderFeatureFlags;", "getFACTORY_IMAGE_FEATURE_FLAGS$featureflag", "()Lcom/stripe/proto/model/config/ReaderFeatureFlags;", "featureflag"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReaderFeatureFlags getFACTORY_IMAGE_FEATURE_FLAGS$featureflag() {
            return FACTORY_IMAGE_FEATURE_FLAGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

