/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.hardware.emv;

import com.stripe.jvmcore.hardware.emv.DomesticDebitAidsParser;
import com.stripe.jvmcore.logging.terminal.log.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u0007H\u0000\u00a2\u0006\u0002\b\tJ\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/jvmcore/hardware/emv/DefaultDomesticDebitAidsParser;", "Lcom/stripe/jvmcore/hardware/emv/DomesticDebitAidsParser;", "logger", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "(Lcom/stripe/jvmcore/logging/terminal/log/Log;)V", "parse", "", "", "domesticDebitAids", "parse$hardware", "readByte", "", "cursor", "hardware"})
public final class DefaultDomesticDebitAidsParser
implements DomesticDebitAidsParser {
    @NotNull
    private final Log logger;

    public DefaultDomesticDebitAidsParser(@NotNull Log logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
    }

    @Override
    @NotNull
    public List<String> parse(@NotNull String domesticDebitAids) {
        Intrinsics.checkNotNullParameter((Object)domesticDebitAids, (String)"domesticDebitAids");
        return this.parse$hardware(domesticDebitAids);
    }

    @NotNull
    public final List<String> parse$hardware(@NotNull String $this$parse) {
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        List domesticDebitAids = new ArrayList();
        if (((CharSequence)$this$parse).length() > 0 && $this$parse.length() >= 2) {
            int n2;
            int cursor = 0;
            try {
                n2 = this.readByte($this$parse, cursor);
            }
            catch (NumberFormatException e2) {
                this.logger.e("Number of AIDs is not hex representable: " + $this$parse, e2, new Pair[0]);
                return CollectionsKt.emptyList();
            }
            int numAids = n2;
            if (numAids <= 10) {
                cursor += 2;
                while (cursor <= $this$parse.length() - 2) {
                    String aid;
                    int e2;
                    try {
                        e2 = this.readByte($this$parse, cursor) * 2;
                    }
                    catch (NumberFormatException e3) {
                        this.logger.e("AID length is not hex representable: " + $this$parse, e3, new Pair[0]);
                        return CollectionsKt.emptyList();
                    }
                    int aidLength = e2;
                    if (aidLength > 20 || (cursor += 2) + aidLength > $this$parse.length()) {
                        this.logger.e("Domestic debit AID length greater than 10 bytes: " + aidLength, new Pair[0]);
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)$this$parse.substring(cursor, cursor + aidLength), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    domesticDebitAids.add(aid);
                    cursor += aidLength;
                }
                if (((Collection)domesticDebitAids).size() != numAids) {
                    this.logger.e("Domestic debit AID list mismatch: Expected " + numAids + " but got " + ((Collection)domesticDebitAids).size(), new Pair[0]);
                    return CollectionsKt.emptyList();
                }
            } else {
                this.logger.e("Domestic debit AID list size greater than 10: " + numAids, new Pair[0]);
            }
        }
        return domesticDebitAids;
    }

    private final int readByte(String $this$readByte, int cursor) throws NumberFormatException {
        String string = $this$readByte.substring(cursor, cursor + 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return Integer.parseInt(string, CharsKt.checkRadix((int)16));
    }
}

