/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.hardware.emv;

import com.stripe.jvmcore.hardware.emv.ApplicationId;
import com.stripe.jvmcore.hardware.emv.ApplicationIdKt;
import com.stripe.jvmcore.hardware.emv.CvmStatus;
import com.stripe.jvmcore.hardware.emv.CvmType;
import com.stripe.jvmcore.hardware.emv.SourceType;
import com.stripe.jvmcore.misc.CardBrand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010(\n\u0002\u0010&\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0004J\u0013\u0010*\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020\u0004J\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040/0.J\u0006\u00100\u001a\u00020\u0004R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001f\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0019\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00062"}, d2={"Lcom/stripe/jvmcore/hardware/emv/TlvMap;", "", "map", "", "", "(Ljava/util/Map;)V", "applicationId", "Lcom/stripe/jvmcore/hardware/emv/ApplicationId;", "getApplicationId", "()Lcom/stripe/jvmcore/hardware/emv/ApplicationId;", "applicationName", "getApplicationName", "()Ljava/lang/String;", "cardholderName", "getCardholderName", "cardholderVerificationMethod", "getCardholderVerificationMethod", "dedicatedFileName", "getDedicatedFileName", "expMonthAndYear", "Lkotlin/Pair;", "getExpMonthAndYear", "()Lkotlin/Pair;", "isMobileWallet", "", "()Z", "languagePreferences", "", "getLanguagePreferences", "()Ljava/util/List;", "last4", "getLast4", "size", "", "getSize", "()I", "sourceType", "Lcom/stripe/jvmcore/hardware/emv/SourceType;", "getSourceType", "()Lcom/stripe/jvmcore/hardware/emv/SourceType;", "contains", "tag", "equals", "other", "get", "getTags", "", "", "toBlob", "Companion", "hardware"})
@SourceDebugExtension(value={"SMAP\nTlvMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlvMap.kt\ncom/stripe/jvmcore/hardware/emv/TlvMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n1#2:424\n*E\n"})
public final class TlvMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> map;
    @NotNull
    public static final String TAG_ACCOUNT_TYPE = "5F57";
    @NotNull
    public static final String TAG_ACQUIRER_IDENTIFIER = "9F01";
    @NotNull
    public static final String TAG_ADDITIONAL_TERMINAL_CAPABILITIES = "9F40";
    @NotNull
    public static final String TAG_CONTACTLESS_READER_CAPABILITIES = "9F6D";
    @NotNull
    public static final String TAG_ADF_NAME = "4F";
    @NotNull
    public static final String TAG_AMOUNT_AUTHORIZED = "9F02";
    @NotNull
    public static final String TAG_APPLICATION_CRYPTOGRAM = "9F26";
    @NotNull
    public static final String TAG_APPLICATION_ID = "9F06";
    @NotNull
    public static final String TAG_APPLICATION_INTERCHANGE_PROFILE = "82";
    @NotNull
    public static final String TAG_APPLICATION_LABEL = "50";
    @NotNull
    public static final String TAG_APPLICATION_PAN_SEQUENCE_NUMBER = "5F34";
    @NotNull
    public static final String TAG_APPLICATION_PREFERRED_NAME = "9F12";
    @NotNull
    public static final String TAG_APPLICATION_PRIMARY_ACCOUNT_NUMBER = "5A";
    @NotNull
    public static final String TAG_APPLICATION_TRANSACTION_COUNTER = "9F36";
    @NotNull
    public static final String TAG_APPLICATION_USAGE_CONTROL = "9F07";
    @NotNull
    public static final String TAG_BLUETOOTH_DISCOVERY_TIMEOUT = "DF837B";
    @NotNull
    public static final String TAG_CARDHOLDER_NAME = "5F20";
    @NotNull
    public static final String TAG_CASHBACK_AMOUNT = "9F03";
    @NotNull
    public static final String TAG_CRYPTOGRAM_INFORMATION_DATA = "9F27";
    @NotNull
    public static final String TAG_CUSTOM_BLUETOOTH_NAME_PREFIX = "DF8408";
    @NotNull
    public static final String TAG_CUSTOM_BLUETOOTH_SERIAL_SUFFIX = "DF8409";
    @NotNull
    public static final String TAG_DDOL = "9F49";
    @NotNull
    public static final String TAG_DEDICATED_FILE_NAME = "84";
    @NotNull
    public static final String TAG_DOMESTIC_DEBIT_AID_LIST = "DF8926";
    @NotNull
    public static final String TAG_FIRMWARE_FALLBACK_ENABLED = "DF8407";
    @NotNull
    public static final String TAG_FIRMWARE_FORCE_CHIP_ENABLED = "DF840D";
    @NotNull
    public static final String TAG_ICC_TRANSACTION_BEEP_ENABLED = "DF8421";
    @NotNull
    public static final String TAG_ISSUER_APPLICATION_DATA = "9F10";
    @NotNull
    public static final String TAG_KEYPAD_EVENT_BEEP_ENABLED = "DF842C";
    @NotNull
    public static final String TAG_LANGUAGE_PREFERENCE = "5F2D";
    @NotNull
    public static final String TAG_MERCHANT_NAME = "9F4E";
    @NotNull
    public static final String TAG_MERCHANT_IDENTIFIER = "9F16";
    @NotNull
    public static final String TAG_MSR_PIN_ENTRY_TIMEOUT = "DF8403";
    @NotNull
    public static final String TAG_NORMAL_MODE_TIMEOUT = "DF8370";
    @NotNull
    public static final String TAG_POS_ENTRY_MODE = "9F39";
    @NotNull
    public static final String TAG_SERVICE_CODE = "5F30";
    @NotNull
    public static final String TAG_SPOC_MODE_ENABLED = "DF866B";
    @NotNull
    public static final String TAG_STANDBY_MODE_TIMEOUT = "DF8367";
    @NotNull
    public static final String TAG_TDOL = "97";
    @NotNull
    public static final String TAG_APPLICATION_VERSION_NUMBER = "9F08";
    @NotNull
    public static final String TAG_TERMINAL_APPLICATION_VERSION_NUMBER = "9F09";
    @NotNull
    public static final String TAG_TERMINAL_CAPABILITIES = "9F33";
    @NotNull
    public static final String TAG_TERMINAL_COUNTRY_CODE = "9F1A";
    @NotNull
    public static final String TAG_TERMINAL_IDENTIFICATION = "9F1C";
    @NotNull
    public static final String TAG_TERMINAL_SERIAL_NUMBER = "9F1E";
    @NotNull
    public static final String TAG_TERMINAL_VERIFICATION_RESULTS = "95";
    @NotNull
    public static final String TAG_TERMINAL_TYPE = "9F35";
    @NotNull
    public static final String TAG_TERMINAL_FLOOR_LIMIT = "9F1B";
    @NotNull
    public static final String TAG_TRACK_2_DATA = "57";
    @NotNull
    public static final String TAG_TRANSACTION_CURRENCY_CODE = "5F2A";
    @NotNull
    public static final String TAG_TRANSACTION_CURRENCY_EXPONENT = "5F36";
    @NotNull
    public static final String TAG_TRANSACTION_SEQUENCE_COUNTER = "9F41";
    @NotNull
    public static final String TAG_TRANSACTION_STATUS_INFORMATION = "9B";
    @NotNull
    public static final String TAG_TRANSACTION_TIME = "9F21";
    @NotNull
    public static final String TAG_TRANSACTION_TYPE = "9C";
    @NotNull
    public static final String TAG_UNPREDICTABLE_NUMBER = "9F37";
    @NotNull
    public static final String TAG_VISA_DYNAMIC_READER_LIMIT = "DFDF09";
    @NotNull
    public static final String TAG_AUTH_RESPONSE_CODE = "8A";
    @NotNull
    public static final String TAG_CUSTOMER_VERIFICATION_METHOD_RESULTS = "9F34";
    @NotNull
    public static final String TAG_FORM_FACTOR_INDICATOR = "9F6E";
    @NotNull
    public static final String TAG_MOBILE_CVM_RESULTS = "9F71";
    @NotNull
    public static final String TAG_EXPIRATION_DATE = "5F24";
    @NotNull
    public static final String TAG_TRANSACTION_DATE = "9A";
    @NotNull
    public static final String TAG_PIN_DATA = "99";
    @NotNull
    public static final String TAG_BUZZER_SOUND_ENABLED = "DF8424";
    @NotNull
    public static final String TAG_BBPOS_PAN_FIRST_SIX_AND_LAST_FOUR = "C4";
    @NotNull
    public static final String SET_BUZZER_ENABLED_VALUE = "00";
    @NotNull
    public static final String SET_BUZZER_DISABLED_VALUE = "01";
    @NotNull
    public static final String AID_INTERAC = "A0000002771010";
    @NotNull
    public static final String AID_EFTPOS = "A00000038410";
    @NotNull
    public static final String AID_VISA_US_COMMON_DEBIT = "A0000000980840";
    @NotNull
    private static final List<String> MASTERCARD_CARD_FORM_FACTORS;

    public TlvMap(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.map = map2;
    }

    public final int getSize() {
        return this.map.size();
    }

    @Nullable
    public final String get(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.map.get(tag);
    }

    public final boolean contains(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.map.containsKey(tag);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof TlvMap ? Intrinsics.areEqual(this.map, ((TlvMap)other).map) : false;
    }

    @NotNull
    public final Iterator<Map.Entry<String, String>> getTags() {
        return this.map.entrySet().iterator();
    }

    @NotNull
    public final String getApplicationName() {
        CharSequence charSequence = this.map.get(TAG_APPLICATION_PREFERRED_NAME);
        String ret = charSequence == null || charSequence.length() == 0 ? ((charSequence = (CharSequence)this.map.get(TAG_APPLICATION_LABEL)) == null || charSequence.length() == 0 ? this.getDedicatedFileName() : TlvMap.Companion.fromHexToAscii((String)MapsKt.getValue(this.map, (Object)TAG_APPLICATION_LABEL))) : TlvMap.Companion.fromHexToAscii((String)MapsKt.getValue(this.map, (Object)TAG_APPLICATION_PREFERRED_NAME));
        return Intrinsics.areEqual((Object)ret, (Object)"Stripe PIN Credi") ? "Stripe PIN Credit" : ret;
    }

    @Nullable
    public final ApplicationId getApplicationId() {
        return ApplicationIdKt.getApplicationIdOrNull(this.map.get(TAG_APPLICATION_ID));
    }

    @Nullable
    public final List<String> getLanguagePreferences() {
        CharSequence charSequence = this.map.get(TAG_LANGUAGE_PREFERENCE);
        return !(charSequence == null || charSequence.length() == 0) && ((String)MapsKt.getValue(this.map, (Object)TAG_LANGUAGE_PREFERENCE)).length() % 4 == 0 ? StringsKt.chunked((CharSequence)TlvMap.Companion.fromHexToAscii((String)MapsKt.getValue(this.map, (Object)TAG_LANGUAGE_PREFERENCE)), (int)2) : null;
    }

    @NotNull
    public final SourceType getSourceType() {
        return StringsKt.startsWith$default((String)this.getDedicatedFileName(), (String)ApplicationId.INTERAC.getId(), (boolean)false, (int)2, null) ? SourceType.INTERAC_PRESENT : SourceType.CARD_PRESENT;
    }

    @NotNull
    public final String getDedicatedFileName() {
        String string = this.map.get(TAG_ADF_NAME);
        if (string == null) {
            string = (String)MapsKt.getValue(this.map, (Object)TAG_DEDICATED_FILE_NAME);
        }
        return string;
    }

    @Nullable
    public final String getCardholderVerificationMethod() {
        CvmType cvmType;
        String cvmResults = this.get(TAG_CUSTOMER_VERIFICATION_METHOD_RESULTS);
        if (cvmResults == null || cvmResults.length() < 6) {
            return null;
        }
        byte[] bytes = ByteString.Companion.decodeHex(cvmResults).toByteArray();
        byte cvmStatus = bytes[2];
        byte cvmCode = (byte)(ArraysKt.first((byte[])bytes) & 0x1F);
        CvmType cvmType2 = CvmType.Companion.fromCode(cvmCode);
        switch (WhenMappings.$EnumSwitchMapping$0[cvmType2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (cvmStatus != CvmStatus.UNKNOWN.ordinal()) {
                    cvmType = CvmType.FAILURE;
                    break;
                }
                cvmType = cvmType2;
                break;
            }
            case 4: 
            case 5: {
                if (cvmStatus != CvmStatus.SUCCESS.ordinal()) {
                    cvmType = CvmType.FAILURE;
                    break;
                }
                cvmType = cvmType2;
                break;
            }
            default: {
                cvmType = cvmType2;
            }
        }
        return cvmType.toString();
    }

    @NotNull
    public final String toBlob() {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string;
            Object[] objectArray;
            String string2;
            String tag = entry.getKey();
            String value = entry.getValue();
            int valueLength = value.length() >>> 1;
            int valueLengthInBytes = (valueLength >>> 8) + 1;
            if (valueLength < 128) {
                string2 = "%02X";
                objectArray = new Object[]{valueLength};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                string2 = "%02X";
                objectArray = new Object[]{128 + valueLengthInBytes};
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
                StringBuilder stringBuilder2 = stringBuilder.append(string4);
                string2 = "%0" + valueLengthInBytes * 2 + 'X';
                objectArray = new Object[]{valueLength};
                String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
                string = stringBuilder2.append(string5).toString();
            }
            String length = string;
            ret.append(tag).append(length).append(value);
        }
        String string = ret.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ret.toString()");
        return string;
    }

    public final boolean isMobileWallet() {
        ApplicationId applicationId = this.getApplicationId();
        CardBrand cardBrand = applicationId != null ? ApplicationIdKt.getCardBrandForApplication(applicationId) : null;
        switch (cardBrand == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cardBrand.ordinal()]) {
            case 1: {
                String formFactorIndicatorHex = this.get(TAG_FORM_FACTOR_INDICATOR);
                if (formFactorIndicatorHex != null) {
                    String it = formFactorIndicatorHex;
                    boolean bl = false;
                    if (it.length() < 2) {
                        return false;
                    }
                    byte formFactorIndicator = ArraysKt.first((byte[])ByteString.Companion.decodeHex(it).toByteArray());
                    int deviceFormFactor = formFactorIndicator & 0x1F;
                    return deviceFormFactor == 3 || deviceFormFactor == 4;
                }
                return false;
            }
            case 2: {
                String mobileCvmResultsHex = this.get(TAG_MOBILE_CVM_RESULTS);
                if (mobileCvmResultsHex != null) {
                    String it = mobileCvmResultsHex;
                    boolean bl = false;
                    if (it.length() < 2) {
                        return false;
                    }
                    byte mobileCvmResults = ArraysKt.first((byte[])ByteString.Companion.decodeHex(it).toByteArray());
                    return (byte)(mobileCvmResults & 0x3F) == 1;
                }
                return false;
            }
            case 3: {
                String formFactorIndicatorHex = this.get(TAG_FORM_FACTOR_INDICATOR);
                if (formFactorIndicatorHex != null) {
                    boolean hasDeviceType;
                    String it = formFactorIndicatorHex;
                    boolean bl = false;
                    if (it.length() < 6) {
                        return false;
                    }
                    byte uniqueIdentifier = ByteString.Companion.decodeHex(it).toByteArray()[2];
                    boolean bl2 = hasDeviceType = (uniqueIdentifier & 0x80) != 128;
                    if (!hasDeviceType) {
                        return false;
                    }
                    if (it.length() < 12) {
                        return false;
                    }
                    String string = it.substring(8, 12);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String deviceType = TlvMap.Companion.fromHexToAscii(string);
                    return !MASTERCARD_CARD_FORM_FACTORS.contains(deviceType);
                }
                return false;
            }
            case 4: {
                String issuerApplicationDataHex = this.get(TAG_ISSUER_APPLICATION_DATA);
                if (issuerApplicationDataHex != null) {
                    String it = issuerApplicationDataHex;
                    boolean bl = false;
                    if (it.length() < 8) {
                        return false;
                    }
                    String string = it.substring(5, 7);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String string2 = Integer.toString(Integer.parseInt(string, CharsKt.checkRadix((int)16)), CharsKt.checkRadix((int)2));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                    String binaryCvr = string2;
                    return binaryCvr.length() > 1 && binaryCvr.charAt(binaryCvr.length() - 2) == '1';
                }
                return false;
            }
            case -1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    public final Pair<String, String> getExpMonthAndYear() {
        Pair pair;
        String string = this.get(TAG_EXPIRATION_DATE);
        if (string != null) {
            String $this$_get_expMonthAndYear__u24lambda_u244 = string;
            boolean bl = false;
            String string2 = $this$_get_expMonthAndYear__u24lambda_u244.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string3 = $this$_get_expMonthAndYear__u24lambda_u244.substring(2, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            pair = new Pair((Object)string2, (Object)string3);
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public final String getLast4() {
        String string;
        String string2;
        String string3;
        String string4 = this.get(TAG_BBPOS_PAN_FIRST_SIX_AND_LAST_FOUR);
        if (string4 != null && (string3 = StringsKt.replace$default((String)string4, (String)"F", (String)"", (boolean)false, (int)4, null)) != null && (string2 = StringsKt.takeLast((String)string3, (int)4)) != null) {
            String string5;
            String it = string5 = string2;
            boolean bl = false;
            string = !(it.length() != 4) ? string5 : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getCardholderName() {
        String string = this.get(TAG_CARDHOLDER_NAME);
        return string != null ? TlvMap.Companion.fromHexToAscii(string) : null;
    }

    static {
        Object[] objectArray = new String[]{SET_BUZZER_ENABLED_VALUE, "20"};
        MASTERCARD_CARD_FORM_FACTORS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\bH\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010O\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010P\u001a\u0004\u0018\u00010Q*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/stripe/jvmcore/hardware/emv/TlvMap$Companion;", "", "()V", "AID_EFTPOS", "", "AID_INTERAC", "AID_VISA_US_COMMON_DEBIT", "MASTERCARD_CARD_FORM_FACTORS", "", "getMASTERCARD_CARD_FORM_FACTORS", "()Ljava/util/List;", "SET_BUZZER_DISABLED_VALUE", "SET_BUZZER_ENABLED_VALUE", "TAG_ACCOUNT_TYPE", "TAG_ACQUIRER_IDENTIFIER", "TAG_ADDITIONAL_TERMINAL_CAPABILITIES", "TAG_ADF_NAME", "TAG_AMOUNT_AUTHORIZED", "TAG_APPLICATION_CRYPTOGRAM", "TAG_APPLICATION_ID", "TAG_APPLICATION_INTERCHANGE_PROFILE", "TAG_APPLICATION_LABEL", "TAG_APPLICATION_PAN_SEQUENCE_NUMBER", "TAG_APPLICATION_PREFERRED_NAME", "TAG_APPLICATION_PRIMARY_ACCOUNT_NUMBER", "TAG_APPLICATION_TRANSACTION_COUNTER", "TAG_APPLICATION_USAGE_CONTROL", "TAG_APPLICATION_VERSION_NUMBER", "TAG_AUTH_RESPONSE_CODE", "TAG_BBPOS_PAN_FIRST_SIX_AND_LAST_FOUR", "TAG_BLUETOOTH_DISCOVERY_TIMEOUT", "TAG_BUZZER_SOUND_ENABLED", "TAG_CARDHOLDER_NAME", "TAG_CASHBACK_AMOUNT", "TAG_CONTACTLESS_READER_CAPABILITIES", "TAG_CRYPTOGRAM_INFORMATION_DATA", "TAG_CUSTOMER_VERIFICATION_METHOD_RESULTS", "TAG_CUSTOM_BLUETOOTH_NAME_PREFIX", "TAG_CUSTOM_BLUETOOTH_SERIAL_SUFFIX", "TAG_DDOL", "TAG_DEDICATED_FILE_NAME", "TAG_DOMESTIC_DEBIT_AID_LIST", "TAG_EXPIRATION_DATE", "TAG_FIRMWARE_FALLBACK_ENABLED", "TAG_FIRMWARE_FORCE_CHIP_ENABLED", "TAG_FORM_FACTOR_INDICATOR", "TAG_ICC_TRANSACTION_BEEP_ENABLED", "TAG_ISSUER_APPLICATION_DATA", "TAG_KEYPAD_EVENT_BEEP_ENABLED", "TAG_LANGUAGE_PREFERENCE", "TAG_MERCHANT_IDENTIFIER", "TAG_MERCHANT_NAME", "TAG_MOBILE_CVM_RESULTS", "TAG_MSR_PIN_ENTRY_TIMEOUT", "TAG_NORMAL_MODE_TIMEOUT", "TAG_PIN_DATA", "TAG_POS_ENTRY_MODE", "TAG_SERVICE_CODE", "TAG_SPOC_MODE_ENABLED", "TAG_STANDBY_MODE_TIMEOUT", "TAG_TDOL", "TAG_TERMINAL_APPLICATION_VERSION_NUMBER", "TAG_TERMINAL_CAPABILITIES", "TAG_TERMINAL_COUNTRY_CODE", "TAG_TERMINAL_FLOOR_LIMIT", "TAG_TERMINAL_IDENTIFICATION", "TAG_TERMINAL_SERIAL_NUMBER", "TAG_TERMINAL_TYPE", "TAG_TERMINAL_VERIFICATION_RESULTS", "TAG_TRACK_2_DATA", "TAG_TRANSACTION_CURRENCY_CODE", "TAG_TRANSACTION_CURRENCY_EXPONENT", "TAG_TRANSACTION_DATE", "TAG_TRANSACTION_SEQUENCE_COUNTER", "TAG_TRANSACTION_STATUS_INFORMATION", "TAG_TRANSACTION_TIME", "TAG_TRANSACTION_TYPE", "TAG_UNPREDICTABLE_NUMBER", "TAG_VISA_DYNAMIC_READER_LIMIT", "fromHexToAscii", "toTlvMap", "Lcom/stripe/jvmcore/hardware/emv/TlvMap;", "hardware"})
    @SourceDebugExtension(value={"SMAP\nTlvMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlvMap.kt\ncom/stripe/jvmcore/hardware/emv/TlvMap$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,423:1\n1549#2:424\n1620#2,3:425\n*S KotlinDebug\n*F\n+ 1 TlvMap.kt\ncom/stripe/jvmcore/hardware/emv/TlvMap$Companion\n*L\n418#1:424\n418#1:425,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getMASTERCARD_CARD_FORM_FACTORS() {
            return MASTERCARD_CARD_FORM_FACTORS;
        }

        @Nullable
        public final TlvMap toTlvMap(@NotNull String $this$toTlvMap) {
            Intrinsics.checkNotNullParameter((Object)$this$toTlvMap, (String)"<this>");
            try {
                int length;
                HashMap tlvs = new HashMap();
                for (int index = 0; index < $this$toTlvMap.length(); index += length << 1) {
                    String tag;
                    int n2;
                    int lengthOfLength;
                    String string = $this$toTlvMap.substring(index, index + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    int currentTagByte = Integer.parseInt(string, 16);
                    int lengthOfTag = 1;
                    if ((currentTagByte & 0x1F) == 31) {
                        String string2;
                        do {
                            string2 = $this$toTlvMap.substring(index + (++lengthOfTag - 1 << 1), index + (lengthOfTag << 1));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        } while (((currentTagByte = Integer.parseInt(string2, 16)) & 0x80) == 128);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)$this$toTlvMap.substring(index, index + (lengthOfTag << 1)), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String string3 = $this$toTlvMap.substring(index += lengthOfTag << 1, index + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    int initialLengthByte = Integer.parseInt(string3, 16);
                    int n3 = lengthOfLength = (initialLengthByte & 0x80) == 128 ? (initialLengthByte & 0xFFFFFF7F) + 1 : 1;
                    if (lengthOfLength == 1) {
                        String string4 = $this$toTlvMap.substring(index, index + 2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        n2 = Integer.parseInt(string4, 16);
                    } else {
                        String string5 = $this$toTlvMap.substring(index + 2, index + (lengthOfLength << 1));
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        n2 = Integer.parseInt(string5, 16);
                    }
                    length = n2;
                    Map map2 = tlvs;
                    String string6 = $this$toTlvMap.substring(index += lengthOfLength << 1, index + (length << 1));
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    map2.put(tag, string6);
                }
                return new TlvMap(tlvs);
            }
            catch (Exception e2) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String fromHexToAscii(String $this$fromHexToAscii) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = StringsKt.chunked((CharSequence)$this$fromHexToAscii, (int)2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf((char)Integer.parseInt((String)it, CharsKt.checkRadix((int)16))));
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CvmType.values().length];
            try {
                nArray[CvmType.OFFLINE_PLAINTEXT_PIN_AND_SIGNATURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CvmType.OFFLINE_ENCIPHERED_PIN_AND_SIGNATURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CvmType.ONLINE_ENCIPHERED_PIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CvmType.OFFLINE_ENCIPHERED_PIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CvmType.OFFLINE_PLAINTEXT_PIN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardBrand.values().length];
            try {
                nArray[CardBrand.VISA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.AMEX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.MASTERCARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.DISCOVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.JCB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.UNIONPAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.DINERS_CLUB.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.EFTPOS_AU.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.UNKNOWN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

