/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging;

import com.stripe.jvmcore.batchdispatcher.Dispatcher;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/stripe/jvmcore/logging/CompositeDispatcher;", "T", "Lcom/stripe/jvmcore/batchdispatcher/Dispatcher;", "clientLogger", "gator", "flagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "(Lcom/stripe/jvmcore/batchdispatcher/Dispatcher;Lcom/stripe/jvmcore/batchdispatcher/Dispatcher;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;)V", "dispatch", "Lcom/stripe/jvmcore/batchdispatcher/Dispatcher$Result;", "batch", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logging"})
public final class CompositeDispatcher<T>
implements Dispatcher<T> {
    @NotNull
    private final Dispatcher<T> clientLogger;
    @NotNull
    private final Dispatcher<T> gator;
    @NotNull
    private final FeatureFlagsRepository flagsRepository;

    public CompositeDispatcher(@NotNull Dispatcher<T> clientLogger, @NotNull Dispatcher<T> gator, @NotNull FeatureFlagsRepository flagsRepository) {
        Intrinsics.checkNotNullParameter(clientLogger, (String)"clientLogger");
        Intrinsics.checkNotNullParameter(gator, (String)"gator");
        Intrinsics.checkNotNullParameter((Object)flagsRepository, (String)"flagsRepository");
        this.clientLogger = clientLogger;
        this.gator = gator;
        this.flagsRepository = flagsRepository;
    }

    @Override
    @Nullable
    public Object dispatch(@NotNull List<? extends T> batch, @NotNull Continuation<? super Dispatcher.Result> $completion) {
        boolean clientLoggerEnabled = this.flagsRepository.getFeatureFlags().enable_client_logger_dispatcher;
        if (clientLoggerEnabled) {
            return this.clientLogger.dispatch(batch, $completion);
        }
        return this.gator.dispatch(batch, $completion);
    }
}

