/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging;

import com.stripe.jvmcore.batchdispatcher.BatchDispatcher;
import com.stripe.jvmcore.logging.MetricResult;
import com.stripe.jvmcore.loggingmodels.Metric;
import com.stripe.jvmcore.loggingmodels.MetricLogger;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.loggingmodels.Tag;
import com.stripe.jvmcore.time.Clock;
import com.stripe.proto.api.gator.EventResultPb;
import com.stripe.proto.api.gator.ProxyEventPb;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J6\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J>\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J>\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J.\u0010!\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/jvmcore/logging/DefaultMetricLogger;", "Lcom/stripe/jvmcore/loggingmodels/MetricLogger;", "batchDispatcher", "Lcom/stripe/jvmcore/batchdispatcher/BatchDispatcher;", "Lcom/stripe/proto/api/gator/ProxyEventPb;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "(Lcom/stripe/jvmcore/batchdispatcher/BatchDispatcher;Lcom/stripe/jvmcore/time/Clock;)V", "buildProxyEventPb", "metric", "Lcom/stripe/jvmcore/loggingmodels/Metric;", "metricResult", "Lcom/stripe/jvmcore/logging/MetricResult;", "buildTagStringsMap", "", "", "tags", "", "Lcom/stripe/jvmcore/loggingmodels/Tag;", "endTimedMetric", "", "outcome", "Lcom/stripe/jvmcore/loggingmodels/Outcome;", "init", "", "recordCounterMetric", "domain", "scope", "event", "recordGaugeMetric", "measurement", "recordTimedMetric", "durationMillis", "startTimedMetric", "submitMetric", "logging"})
@SourceDebugExtension(value={"SMAP\nDefaultMetricLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultMetricLogger.kt\ncom/stripe/jvmcore/logging/DefaultMetricLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n1179#2,2:304\n1253#2,4:306\n*S KotlinDebug\n*F\n+ 1 DefaultMetricLogger.kt\ncom/stripe/jvmcore/logging/DefaultMetricLogger\n*L\n277#1:304,2\n277#1:306,4\n*E\n"})
public final class DefaultMetricLogger
implements MetricLogger {
    @NotNull
    private final BatchDispatcher<ProxyEventPb> batchDispatcher;
    @NotNull
    private final Clock clock;

    @Inject
    public DefaultMetricLogger(@NotNull BatchDispatcher<ProxyEventPb> batchDispatcher, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(batchDispatcher, (String)"batchDispatcher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.batchDispatcher = batchDispatcher;
        this.clock = clock;
    }

    @Override
    public void init() {
        this.batchDispatcher.init();
    }

    @Override
    @NotNull
    public Metric startTimedMetric(@NotNull String domain, @NotNull String scope, @NotNull String event, @NotNull List<? extends Tag> tags) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new Metric(domain, scope, event, tags, this.clock.currentTimeMillis());
    }

    @Override
    public long endTimedMetric(@NotNull Metric metric, @NotNull Outcome outcome, @NotNull List<? extends Tag> tags) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        long durationMillis = this.clock.currentTimeMillis() - metric.getStartTimeMillis();
        this.submitMetric(metric, new MetricResult.TimedMetricResult(outcome, tags, durationMillis));
        return durationMillis;
    }

    @Override
    public void recordTimedMetric(@NotNull String domain, @NotNull String scope, @NotNull String event, long durationMillis, @NotNull List<? extends Tag> tags, @NotNull Outcome outcome) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        long startTimeMillis = this.clock.currentTimeMillis() - durationMillis;
        this.submitMetric(new Metric(domain, scope, event, tags, startTimeMillis), new MetricResult.TimedMetricResult(outcome, CollectionsKt.emptyList(), durationMillis));
    }

    @Override
    public void recordCounterMetric(@NotNull String domain, @NotNull String scope, @NotNull String event, @NotNull List<? extends Tag> tags, @NotNull Outcome outcome) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        this.submitMetric(new Metric(domain, scope, event, tags, this.clock.currentTimeMillis()), new MetricResult.CounterMetricResult(outcome, CollectionsKt.emptyList()));
    }

    @Override
    public void recordGaugeMetric(@NotNull String domain, @NotNull String scope, @NotNull String event, long measurement, @NotNull List<? extends Tag> tags, @NotNull Outcome outcome) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        this.submitMetric(new Metric(domain, scope, event, tags, this.clock.currentTimeMillis()), new MetricResult.GaugeMetricResult(outcome, CollectionsKt.emptyList(), measurement));
    }

    private final void submitMetric(Metric metric, MetricResult metricResult) {
        this.batchDispatcher.add(this.buildProxyEventPb(metric, metricResult));
    }

    private final ProxyEventPb buildProxyEventPb(Metric metric, MetricResult metricResult) {
        Outcome outcome = metricResult.getOutcome();
        return new ProxyEventPb(null, null, null, new EventResultPb(metric.getDomain(), metric.getScope(), metric.getEvent(), this.buildTagStringsMap(CollectionsKt.plus((Collection)metric.getTags(), (Iterable)metricResult.getTags())), metricResult.getOutcome() instanceof Outcome.Success ? EventResultPb.Result.OK : EventResultPb.Result.ERROR, outcome instanceof Outcome.Ok ? "" : outcome.getOutcome(), metricResult instanceof MetricResult.TimedMetricResult ? Long.valueOf(((MetricResult.TimedMetricResult)metricResult).getDurationMillis$logging()) : null, metricResult instanceof MetricResult.GaugeMetricResult ? Long.valueOf(((MetricResult.GaugeMetricResult)metricResult).getMeasurement$logging()) : null, null, 256, null), null, 23, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> buildTagStringsMap(List<? extends Tag> tags) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = tags;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Tag tag = (Tag)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)tag.getKey(), (Object)tag.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }
}

