/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.wire.Message;
import com.squareup.wire.WireJsonAdapterFactory;
import com.stripe.jvmcore.batchdispatcher.BatchDispatcher;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.logging.DefaultTraceLoggerKt;
import com.stripe.jvmcore.logging.TraceResult;
import com.stripe.jvmcore.loggingmodels.LogPoint;
import com.stripe.jvmcore.loggingmodels.Trace;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.jvmcore.time.Clock;
import com.stripe.proto.api.gator.ClientSummaryPb;
import com.stripe.proto.api.gator.ProxySpanPb;
import com.stripe.proto.api.gator.ReportedSpanPb;
import com.stripe.proto.terminal.clientlogger.pub.AdditionalContext;
import com.stripe.proto.terminal.clientlogger.pub.SearchIndices;
import com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.LegacyTraceData;
import com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.Metadata;
import com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.ObservabilityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B3\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J:\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0016J8\u0010!\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0016J8\u0010$\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010%\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010&2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0016J.\u0010$\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u001b2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\u0095\u0001\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0010\u0010+\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010&2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-2\b\u0010/\u001a\u0004\u0018\u00010-2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u001b2\b\u00103\u001a\u0004\u0018\u00010\u001b2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0002\u00106J\u008b\u0001\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-2\b\u0010/\u001a\u0004\u0018\u00010-2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u001b2\b\u00103\u001a\u0004\u0018\u00010\u001b2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/stripe/jvmcore/logging/DefaultTraceLogger;", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "proxySpanPbBatchDispatcher", "Lcom/stripe/jvmcore/batchdispatcher/BatchDispatcher;", "Lcom/stripe/proto/api/gator/ProxySpanPb;", "observabilityDataBatchDispatcher", "Lcom/stripe/proto/terminal/clientlogger/pub/message/observability_schema/ObservabilityData;", "flagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "(Lcom/stripe/jvmcore/batchdispatcher/BatchDispatcher;Lcom/stripe/jvmcore/batchdispatcher/BatchDispatcher;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;Lcom/stripe/jvmcore/time/Clock;)V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "buildLegacyTraceData", "Lcom/stripe/proto/terminal/clientlogger/pub/message/observability_schema/LegacyTraceData;", "trace", "Lcom/stripe/jvmcore/loggingmodels/Trace;", "traceResult", "Lcom/stripe/jvmcore/logging/TraceResult;", "buildObservabilityData", "buildProxySpanPb", "buildSearchIndices", "Lcom/stripe/proto/terminal/clientlogger/pub/SearchIndices;", "buildTags", "", "", "endTraceWithErrorMessage", "", "message", "statusCode", "httpResponseHeaders", "endTraceWithException", "t", "", "endTraceWithSuccess", "response", "Lcom/squareup/wire/Message;", "init", "startTrace", "service", "method", "request", "rootId", "", "parentId", "currentId", "context", "Lcom/stripe/jvmcore/loggingmodels/Trace$Context;", "httpUrl", "httpMethod", "httpRequestHeaders", "tags", "(Ljava/lang/String;Ljava/lang/String;Lcom/squareup/wire/Message;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Lcom/stripe/jvmcore/loggingmodels/Trace$Context;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)Lcom/stripe/jvmcore/loggingmodels/Trace;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Lcom/stripe/jvmcore/loggingmodels/Trace$Context;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)Lcom/stripe/jvmcore/loggingmodels/Trace;", "submitTrace", "Companion", "logging"})
@SourceDebugExtension(value={"SMAP\nDefaultTraceLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTraceLogger.kt\ncom/stripe/jvmcore/logging/DefaultTraceLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1549#2:368\n1620#2,3:369\n1549#2:372\n1620#2,3:373\n*S KotlinDebug\n*F\n+ 1 DefaultTraceLogger.kt\ncom/stripe/jvmcore/logging/DefaultTraceLogger\n*L\n230#1:368\n230#1:369,3\n258#1:372\n258#1:373,3\n*E\n"})
public final class DefaultTraceLogger
implements TraceLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BatchDispatcher<ProxySpanPb> proxySpanPbBatchDispatcher;
    @NotNull
    private final BatchDispatcher<ObservabilityData> observabilityDataBatchDispatcher;
    @NotNull
    private final FeatureFlagsRepository flagsRepository;
    @NotNull
    private final Clock clock;
    private final Moshi moshi;
    @NotNull
    public static final String TAG_KEY_HTTP_URL = "httpUrl";
    @NotNull
    public static final String TAG_KEY_HTTP_METHOD = "httpMethod";
    @NotNull
    public static final String TAG_KEY_HTTP_REQUEST_HEADERS = "httpRequestHeaders";
    @NotNull
    public static final String TAG_KEY_HTTP_RESPONSE_HEADERS = "httpResponseHeaders";

    @Inject
    public DefaultTraceLogger(@NotNull BatchDispatcher<ProxySpanPb> proxySpanPbBatchDispatcher, @NotNull BatchDispatcher<ObservabilityData> observabilityDataBatchDispatcher, @NotNull FeatureFlagsRepository flagsRepository, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(proxySpanPbBatchDispatcher, (String)"proxySpanPbBatchDispatcher");
        Intrinsics.checkNotNullParameter(observabilityDataBatchDispatcher, (String)"observabilityDataBatchDispatcher");
        Intrinsics.checkNotNullParameter((Object)flagsRepository, (String)"flagsRepository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.proxySpanPbBatchDispatcher = proxySpanPbBatchDispatcher;
        this.observabilityDataBatchDispatcher = observabilityDataBatchDispatcher;
        this.flagsRepository = flagsRepository;
        this.clock = clock;
        this.moshi = new Moshi.Builder().add((JsonAdapter.Factory)new WireJsonAdapterFactory(null, false, 3, null)).build();
    }

    @Override
    public void init() {
        this.proxySpanPbBatchDispatcher.init();
        this.observabilityDataBatchDispatcher.init();
    }

    @Override
    @NotNull
    public Trace startTrace(@NotNull String service, @NotNull String method, @Nullable Message<?, ?> request, @Nullable Long rootId, @Nullable Long parentId, @Nullable Long currentId, @Nullable Trace.Context context, @Nullable String httpUrl, @Nullable String httpMethod, @Nullable Map<String, String> httpRequestHeaders, @NotNull Map<String, String> tags) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter(tags, (String)"tags");
                object = request;
                if (object == null) break block2;
                Moshi moshi2 = this.moshi;
                Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"moshi");
                if ((object = DefaultTraceLoggerKt.toTraceJson(object, moshi2)) != null) break block3;
            }
            object = "";
        }
        return this.startTrace(service, method, (String)object, rootId, parentId, currentId, context, httpUrl, httpMethod, httpRequestHeaders, tags);
    }

    @Override
    @NotNull
    public Trace startTrace(@NotNull String service, @NotNull String method, @NotNull String request, @Nullable Long rootId, @Nullable Long parentId, @Nullable Long currentId, @Nullable Trace.Context context, @Nullable String httpUrl, @Nullable String httpMethod, @Nullable Map<String, String> httpRequestHeaders, @NotNull Map<String, String> tags) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new Trace(this.clock.currentTimeMillis(), service, method, request, rootId, parentId, currentId, context, httpUrl, httpMethod, httpRequestHeaders, this.clock, tags);
    }

    @Override
    public void endTraceWithSuccess(@NotNull Trace trace, @Nullable Message<?, ?> response, @Nullable Map<String, String> httpResponseHeaders) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                object = response;
                if (object == null) break block2;
                Moshi moshi2 = this.moshi;
                Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"moshi");
                if ((object = DefaultTraceLoggerKt.toTraceJson(object, moshi2)) != null) break block3;
            }
            object = "";
        }
        this.endTraceWithSuccess(trace, (String)object, httpResponseHeaders);
    }

    @Override
    public void endTraceWithSuccess(@NotNull Trace trace, @NotNull String response, @Nullable Map<String, String> httpResponseHeaders) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.submitTrace(trace, new TraceResult(response, null, null, httpResponseHeaders));
    }

    @Override
    public void endTraceWithException(@NotNull Trace trace, @NotNull Throwable t2, @Nullable String statusCode, @Nullable Map<String, String> httpResponseHeaders) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.endTraceWithErrorMessage(trace, ExceptionsKt.stackTraceToString((Throwable)t2), statusCode, httpResponseHeaders);
    }

    @Override
    public void endTraceWithErrorMessage(@NotNull Trace trace, @Nullable String message, @Nullable String statusCode, @Nullable Map<String, String> httpResponseHeaders) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.submitTrace(trace, new TraceResult("", message, statusCode, httpResponseHeaders));
    }

    private final void submitTrace(Trace trace, TraceResult traceResult) {
        boolean tracesToObservabilityDataEnabled = this.flagsRepository.getFeatureFlags().enable_traces_to_observability_data_endpoint;
        if (tracesToObservabilityDataEnabled) {
            this.observabilityDataBatchDispatcher.add(this.buildObservabilityData(trace, traceResult));
        } else {
            this.proxySpanPbBatchDispatcher.add(this.buildProxySpanPb(trace, traceResult));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ProxySpanPb buildProxySpanPb(Trace trace, TraceResult traceResult) {
        Collection<ReportedSpanPb.SpanPointPb> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        String string2;
        AdditionalContext additionalContext;
        String string3;
        String string4;
        String string5;
        Trace.Context context = trace.getContext();
        if (context != null) {
            String string6;
            String string7;
            Trace.Context it = context;
            boolean bl = false;
            String string8 = it.getSerialNumber();
            if (string8 == null) {
                string8 = string5 = "";
            }
            if ((string7 = it.getSessionId()) == null) {
                string7 = string4 = "";
            }
            if ((string6 = it.getActionId()) == null) {
                string6 = "";
            }
            string3 = string6;
            additionalContext = new AdditionalContext(string3, string5, string4, null, null, 24, null);
        } else {
            additionalContext = null;
        }
        AdditionalContext additionalContext2 = additionalContext;
        long l2 = trace.getStartTimeMillis();
        long l3 = this.clock.currentTimeMillis() - trace.getStartTimeMillis();
        string5 = trace.getService();
        string4 = trace.getMethod();
        string3 = trace.getRequest();
        Long l4 = trace.getRootId();
        long l5 = l4 != null ? l4 : 0L;
        Long l6 = trace.getParentId();
        long l7 = l6 != null ? l6 : 0L;
        Long l8 = trace.getCurrentId();
        long l9 = l8 != null ? l8 : 0L;
        String string9 = traceResult.getResponse();
        String string10 = traceResult.getException();
        if (string10 == null) {
            string10 = string2 = "";
        }
        if ((string = traceResult.getStatusCode()) == null) {
            string = "";
        }
        String string11 = string;
        Map<String, String> map2 = this.buildTags(trace, traceResult);
        Iterable iterable = trace.getLogPoints();
        String string12 = null;
        String string13 = null;
        String string14 = null;
        boolean $i$f$map = false;
        void var24_23 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            LogPoint logPoint = (LogPoint)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toGatorProto());
        }
        Collection<ReportedSpanPb.SpanPointPb> collection2 = collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 55;
        ByteString byteString = null;
        ClientSummaryPb clientSummaryPb = null;
        ReportedSpanPb reportedSpanPb = new ReportedSpanPb(l5, l7, l9, null, null, null, null, null, l2, l3, string5, string4, string3, null, string9, null, string2, string11, null, map2, additionalContext2, null, (List)collection2, null, 10789112, null);
        String string15 = string12;
        String string16 = string13;
        String string17 = string14;
        return new ProxySpanPb(string17, string16, string15, reportedSpanPb, clientSummaryPb, byteString, n2, defaultConstructorMarker);
    }

    private final ObservabilityData buildObservabilityData(Trace trace, TraceResult traceResult) {
        Metadata metadata = new Metadata(this.clock.currentTimeMillis(), null, null, null, 14, null);
        LegacyTraceData legacyTraceData = this.buildLegacyTraceData(trace, traceResult);
        SearchIndices searchIndices = this.buildSearchIndices(trace);
        return new ObservabilityData(metadata, searchIndices, null, null, null, legacyTraceData, null, null, 220, null);
    }

    /*
     * WARNING - void declaration
     */
    private final LegacyTraceData buildLegacyTraceData(Trace trace, TraceResult traceResult) {
        LegacyTraceData.Builder legacyTraceBuilder;
        block5: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = trace.getLogPoints();
            LegacyTraceData.Builder builder = new LegacyTraceData.Builder().start_time_ms(trace.getStartTimeMillis()).total_time_ms(this.clock.currentTimeMillis() - trace.getStartTimeMillis()).service(trace.getService()).method(trace.getMethod()).tags(this.buildTags(trace, traceResult));
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                LogPoint logPoint = (LogPoint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.toLegacyTraceProto());
            }
            legacyTraceBuilder = builder.traces((List)destination$iv$iv).request(trace.getRequest()).response(traceResult.getResponse());
            Long l2 = trace.getRootId();
            if (l2 != null) {
                long it = ((Number)l2).longValue();
                boolean bl = false;
                legacyTraceBuilder.root_span_id(it);
            }
            Long l3 = trace.getParentId();
            if (l3 != null) {
                long it = ((Number)l3).longValue();
                boolean bl = false;
                legacyTraceBuilder.parent_span_id(it);
            }
            Long l4 = trace.getCurrentId();
            if (l4 != null) {
                long it = ((Number)l4).longValue();
                boolean bl = false;
                legacyTraceBuilder.current_span_id(it);
            }
            String string = traceResult.getException();
            if (string != null) {
                String it = string;
                boolean bl = false;
                legacyTraceBuilder.exception(it);
            }
            String string2 = traceResult.getStatusCode();
            if (string2 == null) break block5;
            String it = string2;
            boolean bl = false;
            legacyTraceBuilder.status_code(it);
        }
        return legacyTraceBuilder.build();
    }

    private final SearchIndices buildSearchIndices(Trace trace) {
        long it;
        Object object;
        Object object2;
        Object it2;
        SearchIndices.Builder searchIndicesBuilder = new SearchIndices.Builder();
        Object object3 = trace.getContext();
        if (object3 != null && (object3 = ((Trace.Context)object3).getActionId()) != null) {
            it2 = object3;
            boolean bl = false;
            searchIndicesBuilder.action_id((String)it2);
        }
        if ((object2 = trace.getContext()) != null && (object2 = ((Trace.Context)object2).getSerialNumber()) != null) {
            it2 = object2;
            boolean bl = false;
            searchIndicesBuilder.serial_number((String)it2);
        }
        if ((object = trace.getContext()) != null && (object = ((Trace.Context)object).getSessionId()) != null) {
            it2 = object;
            boolean bl = false;
            searchIndicesBuilder.session_id((String)it2);
        }
        Long l2 = trace.getRootId();
        if (l2 != null) {
            it = ((Number)l2).longValue();
            boolean bl = false;
            searchIndicesBuilder.trace_id(it);
        }
        Long l3 = trace.getParentId();
        if (l3 != null) {
            it = ((Number)l3).longValue();
            boolean bl = false;
            searchIndicesBuilder.parent_span_id(it);
        }
        Long l4 = trace.getCurrentId();
        if (l4 != null) {
            it = ((Number)l4).longValue();
            boolean bl = false;
            searchIndicesBuilder.current_span_id(it);
        }
        SearchIndices searchIndices = searchIndicesBuilder.build();
        return Intrinsics.areEqual((Object)((Object)searchIndices), (Object)((Object)new SearchIndices(null, null, null, 0L, 0L, 0L, null, null, 255, null))) ? null : searchIndices;
    }

    private final Map<String, String> buildTags(Trace trace, TraceResult traceResult) {
        Map map2;
        block3: {
            Map<String, String> it;
            Map $this$buildTags_u24lambda_u2417 = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            String string = trace.getHttpUrl();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$buildTags_u24lambda_u2417.put(TAG_KEY_HTTP_URL, it);
            }
            String string2 = trace.getHttpMethod();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$buildTags_u24lambda_u2417.put(TAG_KEY_HTTP_METHOD, it);
            }
            Map<String, String> map3 = trace.getHttpRequestHeaders();
            if (map3 != null) {
                it = map3;
                boolean bl4 = false;
                $this$buildTags_u24lambda_u2417.put(TAG_KEY_HTTP_REQUEST_HEADERS, DefaultTraceLoggerKt.toKeyValuePairsString(it));
            }
            Map<String, String> map4 = traceResult.getHttpResponseHeaders();
            if (map4 == null) break block3;
            it = map4;
            boolean bl5 = false;
            $this$buildTags_u24lambda_u2417.put(TAG_KEY_HTTP_RESPONSE_HEADERS, DefaultTraceLoggerKt.toKeyValuePairsString(it));
        }
        return MapsKt.plus((Map)map2, trace.getTags());
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/jvmcore/logging/DefaultTraceLogger$Companion;", "", "()V", "TAG_KEY_HTTP_METHOD", "", "TAG_KEY_HTTP_REQUEST_HEADERS", "TAG_KEY_HTTP_RESPONSE_HEADERS", "TAG_KEY_HTTP_URL", "logging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

