/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging;

import com.squareup.wire.Message;
import com.stripe.jvmcore.dagger.Debug;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthMetricListener;
import com.stripe.jvmcore.logging.MetricType;
import com.stripe.jvmcore.logging.PendingTimer;
import com.stripe.jvmcore.logging.ReflectionUtils;
import com.stripe.jvmcore.loggingmodels.Metric;
import com.stripe.jvmcore.loggingmodels.MetricLogger;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.loggingmodels.Tag;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.proto.terminal.clientlogger.pub.message.health.HealthMetric;
import com.stripe.proto.terminal.clientlogger.pub.message.health.metrictype.Counter;
import com.stripe.proto.terminal.clientlogger.pub.message.health.metrictype.Gauge;
import com.stripe.proto.terminal.clientlogger.pub.message.health.metrictype.Timer;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 R*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004*\u0014\b\u0002\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0002*\u0014\b\u0003\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00042\u00020\u0007:\u0005RSTUVB\u00bd\u0001\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012'\u0010\u000b\u001a#\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\fj\b\u0012\u0004\u0012\u00028\u0000`\u000f\u00a2\u0006\u0002\b\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\t\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00030\t\u0012-\u0010\u0013\u001a)\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002`\u0014\u00a2\u0006\u0002\b\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0001\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJJ\u0010\u001f\u001a\u00020 \"\u0004\b\u0004\u0010!2\u0006\u0010\"\u001a\u0002H!2-\u0010#\u001a)\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u0002H!`$\u00a2\u0006\u0002\b\u0010H\u0002\u00a2\u0006\u0002\u0010%J<\u0010&\u001a\u00020\u000e2\b\u0010'\u001a\u0004\u0018\u00010(2\b\b\u0002\u0010)\u001a\u00020*2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/Ja\u00100\u001a\u00020\u000e2\b\b\u0002\u0010)\u001a\u00020*2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2-\u00101\u001a)\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u000202`$\u00a2\u0006\u0002\b\u0010J\u0010\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020-H\u0002J\u0018\u00105\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001062\u0006\u00107\u001a\u00020 H\u0002J\u0017\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010;J\u001d\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010=2\u0006\u0010>\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010?J]\u0010@\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020-2\u0006\u0010:\u001a\u00020-2\u0006\u0010\"\u001a\u00020-2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,2\u0006\u0010)\u001a\u00020*2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002\u00a2\u0006\u0002\u0010EJ\u001e\u0010F\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010G2\u0006\u0010H\u001a\u00020 H\u0002Ji\u0010I\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020D2\b\b\u0002\u0010)\u001a\u00020*2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2-\u0010K\u001a)\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020L`$\u00a2\u0006\u0002\b\u0010Ji\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020D2\b\b\u0002\u0010)\u001a\u00020*2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2-\u0010O\u001a)\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020P`$\u00a2\u0006\u0002\b\u0010JM\u0010Q\u001a\u0004\u0018\u00010(2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0,2-\u0010O\u001a)\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020P`$\u00a2\u0006\u0002\b\u0010R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000b\u001a#\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\fj\b\u0012\u0004\u0012\u00028\u0000`\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0013\u001a)\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002`\u0014\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger;", "D", "Lcom/squareup/wire/Message;", "DB", "Lcom/squareup/wire/Message$Builder;", "S", "SB", "", "domainClass", "Ljava/lang/Class;", "domainBuilderClass", "domainSetter", "Lkotlin/Function2;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/HealthMetric$Builder;", "", "Lcom/stripe/jvmcore/logging/DomainSetter;", "Lkotlin/ExtensionFunctionType;", "scopeClass", "scopeBuilderClass", "scopeSetter", "Lcom/stripe/jvmcore/logging/ScopeSetter;", "metricLogger", "Lcom/stripe/jvmcore/loggingmodels/MetricLogger;", "isDebug", "", "listeners", "", "Lcom/stripe/jvmcore/logging/HealthMetricListener;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Ljava/lang/Class;Ljava/lang/Class;Lkotlin/jvm/functions/Function2;Ljava/lang/Class;Ljava/lang/Class;Lkotlin/jvm/functions/Function2;Lcom/stripe/jvmcore/loggingmodels/MetricLogger;ZLjava/util/List;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "buildHealthMetric", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/HealthMetric;", "T", "event", "eventSetter", "Lcom/stripe/jvmcore/logging/EventSetter;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lcom/stripe/proto/terminal/clientlogger/pub/message/health/HealthMetric;", "endTimer", "pendingTimer", "Lcom/stripe/jvmcore/logging/PendingTimer;", "outcome", "Lcom/stripe/jvmcore/loggingmodels/Outcome;", "tags", "", "", "cause", "", "incrementCounter", "counterSetter", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Counter;", "logOrCrash", "message", "lookupDomain", "Lcom/stripe/jvmcore/logging/HealthLogger$Domain;", "metric", "lookupEvent", "Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "scope", "(Lcom/squareup/wire/Message;)Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "lookupScope", "Lcom/stripe/jvmcore/logging/HealthLogger$Scope;", "domain", "(Lcom/squareup/wire/Message;)Lcom/stripe/jvmcore/logging/HealthLogger$Scope;", "notifyListeners", "type", "Lcom/stripe/jvmcore/logging/MetricType;", "value", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/jvmcore/logging/MetricType;Ljava/lang/Long;Ljava/util/Map;Lcom/stripe/jvmcore/loggingmodels/Outcome;Ljava/lang/Throwable;)V", "parseHealthMetric", "Lcom/stripe/jvmcore/logging/HealthLogger$ParsedHealthMetric;", "healthMetric", "recordGauge", "measurement", "gaugeSetter", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Gauge;", "recordTimer", "durationMillis", "timerSetter", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Timer;", "startTimer", "Companion", "Domain", "Event", "ParsedHealthMetric", "Scope", "logging"})
@SourceDebugExtension(value={"SMAP\nHealthLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,637:1\n1179#2,2:638\n1253#2,4:640\n1855#2,2:645\n1#3:644\n*S KotlinDebug\n*F\n+ 1 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLogger\n*L\n165#1:638,2\n165#1:640,4\n354#1:645,2\n*E\n"})
public final class HealthLogger<D extends Message<D, DB>, DB extends Message.Builder<D, DB>, S extends Message<S, SB>, SB extends Message.Builder<S, SB>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<D> domainClass;
    @NotNull
    private final Class<DB> domainBuilderClass;
    @NotNull
    private final Function2<HealthMetric.Builder, D, Unit> domainSetter;
    @NotNull
    private final Class<S> scopeClass;
    @NotNull
    private final Class<SB> scopeBuilderClass;
    @NotNull
    private final Function2<DB, S, Unit> scopeSetter;
    @NotNull
    private final MetricLogger metricLogger;
    private final boolean isDebug;
    @NotNull
    private final List<HealthMetricListener> listeners;
    @NotNull
    private final LogWriter logWriter;
    private static final String TAG = HealthLogger.class.getSimpleName();

    public HealthLogger(@NotNull Class<D> domainClass, @NotNull Class<DB> domainBuilderClass, @NotNull Function2<? super HealthMetric.Builder, ? super D, Unit> domainSetter, @NotNull Class<S> scopeClass, @NotNull Class<SB> scopeBuilderClass, @NotNull Function2<? super DB, ? super S, Unit> scopeSetter, @NotNull MetricLogger metricLogger, @Debug boolean isDebug, @NotNull List<? extends HealthMetricListener> listeners, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter(domainClass, (String)"domainClass");
        Intrinsics.checkNotNullParameter(domainBuilderClass, (String)"domainBuilderClass");
        Intrinsics.checkNotNullParameter(domainSetter, (String)"domainSetter");
        Intrinsics.checkNotNullParameter(scopeClass, (String)"scopeClass");
        Intrinsics.checkNotNullParameter(scopeBuilderClass, (String)"scopeBuilderClass");
        Intrinsics.checkNotNullParameter(scopeSetter, (String)"scopeSetter");
        Intrinsics.checkNotNullParameter((Object)metricLogger, (String)"metricLogger");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.domainClass = domainClass;
        this.domainBuilderClass = domainBuilderClass;
        this.domainSetter = domainSetter;
        this.scopeClass = scopeClass;
        this.scopeBuilderClass = scopeBuilderClass;
        this.scopeSetter = scopeSetter;
        this.metricLogger = metricLogger;
        this.isDebug = isDebug;
        this.listeners = listeners;
        this.logWriter = logWriter;
    }

    public final void incrementCounter(@NotNull Outcome outcome, @NotNull Map<String, String> tags, @Nullable Throwable cause, @NotNull Function2<? super SB, ? super Counter, Unit> counterSetter) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(counterSetter, (String)"counterSetter");
        HealthMetric healthMetric = this.buildHealthMetric((Object)((Object)new Counter(null, 1, null)), (Function2)counterSetter);
        ParsedHealthMetric<D, S> parsedHealthMetric = this.parseHealthMetric(healthMetric);
        if (parsedHealthMetric == null) {
            this.logOrCrash("Failed to parse health metric for counter: " + (Object)((Object)healthMetric));
            return;
        }
        this.metricLogger.recordCounterMetric(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), Tag.HealthTag.Companion.toHealthTags(tags), outcome);
        this.notifyListeners(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), MetricType.COUNTER, null, tags, outcome, cause);
    }

    public static /* synthetic */ void incrementCounter$default(HealthLogger healthLogger2, Outcome outcome, Map map2, Throwable throwable, Function2 function2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            outcome = Outcome.Ok.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        healthLogger2.incrementCounter(outcome, map2, throwable, function2);
    }

    @Nullable
    public final PendingTimer startTimer(@NotNull Map<String, String> tags, @NotNull Function2<? super SB, ? super Timer, Unit> timerSetter) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(timerSetter, (String)"timerSetter");
        HealthMetric healthMetric = this.buildHealthMetric((Object)((Object)new Timer(null, null, 3, null)), (Function2)timerSetter);
        ParsedHealthMetric<D, S> parsedHealthMetric = this.parseHealthMetric(healthMetric);
        if (parsedHealthMetric == null) {
            this.logOrCrash("Failed to parse health metric for counter: " + (Object)((Object)healthMetric));
            return null;
        }
        Metric metric = this.metricLogger.startTimedMetric(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), Tag.HealthTag.Companion.toHealthTags(tags));
        return new PendingTimer(metric);
    }

    public static /* synthetic */ PendingTimer startTimer$default(HealthLogger healthLogger2, Map map2, Function2 function2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return healthLogger2.startTimer(map2, function2);
    }

    /*
     * WARNING - void declaration
     */
    public final void endTimer(@Nullable PendingTimer pendingTimer, @NotNull Outcome outcome, @NotNull Map<String, String> tags, @Nullable Throwable cause) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (pendingTimer == null) {
            this.logOrCrash("Received null pendingTimer for a call to endTimer");
            return;
        }
        long durationMillis = this.metricLogger.endTimedMetric(pendingTimer.getMetric$logging(), outcome, Tag.HealthTag.Companion.toHealthTags(tags));
        Iterable iterable = pendingTimer.getMetric$logging().getTags();
        Long l2 = durationMillis;
        MetricType metricType = MetricType.TIMER;
        String string = pendingTimer.getMetric$logging().getEvent();
        String string2 = pendingTimer.getMetric$logging().getScope();
        String string3 = pendingTimer.getMetric$logging().getDomain();
        HealthLogger healthLogger2 = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var10_15 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Tag it = (Tag)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getKey(), (Object)it.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        healthLogger2.notifyListeners(string3, string2, string, metricType, l2, MapsKt.plus((Map)map3, tags), outcome, cause);
    }

    public static /* synthetic */ void endTimer$default(HealthLogger healthLogger2, PendingTimer pendingTimer, Outcome outcome, Map map2, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            outcome = Outcome.Ok.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        healthLogger2.endTimer(pendingTimer, outcome, map2, throwable);
    }

    public final void recordTimer(long durationMillis, @NotNull Outcome outcome, @NotNull Map<String, String> tags, @Nullable Throwable cause, @NotNull Function2<? super SB, ? super Timer, Unit> timerSetter) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(timerSetter, (String)"timerSetter");
        HealthMetric healthMetric = this.buildHealthMetric((Object)((Object)new Timer(null, null, 3, null)), (Function2)timerSetter);
        ParsedHealthMetric<D, S> parsedHealthMetric = this.parseHealthMetric(healthMetric);
        if (parsedHealthMetric == null) {
            this.logOrCrash("Failed to parse health metric for timer: " + (Object)((Object)healthMetric));
            return;
        }
        this.metricLogger.recordTimedMetric(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), durationMillis, Tag.HealthTag.Companion.toHealthTags(tags), outcome);
        this.notifyListeners(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), MetricType.TIMER, durationMillis, tags, outcome, cause);
    }

    public static /* synthetic */ void recordTimer$default(HealthLogger healthLogger2, long l2, Outcome outcome, Map map2, Throwable throwable, Function2 function2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            outcome = Outcome.Ok.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        healthLogger2.recordTimer(l2, outcome, map2, throwable, function2);
    }

    public final void recordGauge(long measurement, @NotNull Outcome outcome, @NotNull Map<String, String> tags, @Nullable Throwable cause, @NotNull Function2<? super SB, ? super Gauge, Unit> gaugeSetter) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(gaugeSetter, (String)"gaugeSetter");
        HealthMetric healthMetric = this.buildHealthMetric((Object)((Object)new Gauge(null, null, 3, null)), (Function2)gaugeSetter);
        ParsedHealthMetric<D, S> parsedHealthMetric = this.parseHealthMetric(healthMetric);
        if (parsedHealthMetric == null) {
            this.logOrCrash("Failed to parse health metric for gauge: " + (Object)((Object)healthMetric));
            return;
        }
        this.metricLogger.recordGaugeMetric(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), measurement, Tag.HealthTag.Companion.toHealthTags(tags), outcome);
        this.notifyListeners(parsedHealthMetric.getDomain().getName(), parsedHealthMetric.getScope().getName(), parsedHealthMetric.getEvent().getName(), MetricType.GAUGE, measurement, tags, outcome, cause);
    }

    public static /* synthetic */ void recordGauge$default(HealthLogger healthLogger2, long l2, Outcome outcome, Map map2, Throwable throwable, Function2 function2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            outcome = Outcome.Ok.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        healthLogger2.recordGauge(l2, outcome, map2, throwable, function2);
    }

    private final <T> HealthMetric buildHealthMetric(T event, Function2<? super SB, ? super T, Unit> eventSetter) {
        SB SB = this.scopeBuilderClass.newInstance();
        Message.Builder $this$buildHealthMetric_u24lambda_u241 = (Message.Builder)SB;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$buildHealthMetric_u24lambda_u241, (String)"buildHealthMetric$lambda$1");
        eventSetter.invoke((Object)$this$buildHealthMetric_u24lambda_u241, event);
        Message scope = ((Message.Builder)SB).build();
        Object object = this.domainBuilderClass.newInstance();
        Message.Builder $this$buildHealthMetric_u24lambda_u242 = (Message.Builder)object;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$buildHealthMetric_u24lambda_u242, (String)"buildHealthMetric$lambda$2");
        this.scopeSetter.invoke((Object)$this$buildHealthMetric_u24lambda_u242, (Object)scope);
        Message domain = ((Message.Builder)object).build();
        Object $this$buildHealthMetric_u24lambda_u243 = object = new HealthMetric.Builder();
        boolean bl3 = false;
        this.domainSetter.invoke($this$buildHealthMetric_u24lambda_u243, (Object)domain);
        return ((HealthMetric.Builder)((Object)object)).build();
    }

    private final ParsedHealthMetric<D, S> parseHealthMetric(HealthMetric healthMetric) {
        Domain<D> domain = this.lookupDomain(healthMetric);
        if (domain == null) {
            return null;
        }
        Domain<D> domain2 = domain;
        Scope<S> scope = this.lookupScope((Message)domain2.getValue());
        if (scope == null) {
            return null;
        }
        Scope<S> scope2 = scope;
        Event event = this.lookupEvent((Message)scope2.getValue());
        if (event == null) {
            return null;
        }
        Event event2 = event;
        return new ParsedHealthMetric<D, S>(domain2, scope2, event2);
    }

    private final Domain<D> lookupDomain(HealthMetric metric) {
        Field field = (Field)SequencesKt.firstOrNull(ReflectionUtils.INSTANCE.withType(ReflectionUtils.INSTANCE.withOneOf(ReflectionUtils.INSTANCE.properties(HealthMetric.class), "domain"), this.domainClass));
        if (field == null) {
            return null;
        }
        Field domainProperty = field;
        String string = ReflectionUtils.INSTANCE.declaredFieldName(domainProperty);
        if (string == null) {
            string = domainProperty.getName();
        }
        String domainName = string;
        Object object = domainProperty.get((Object)metric);
        Message message = object instanceof Message ? (Message)object : null;
        if (message == null) {
            return null;
        }
        Message domainValue = message;
        Intrinsics.checkNotNullExpressionValue((Object)domainName, (String)"domainName");
        return new Domain<Message>(domainName, domainValue);
    }

    private final Scope<S> lookupScope(D domain) {
        Field field = (Field)SequencesKt.firstOrNull(ReflectionUtils.INSTANCE.withType(ReflectionUtils.INSTANCE.withOneOf(ReflectionUtils.INSTANCE.properties(this.domainClass), "scope"), this.scopeClass));
        if (field == null) {
            return null;
        }
        Field scopeProperty = field;
        String string = ReflectionUtils.INSTANCE.declaredFieldName(scopeProperty);
        if (string == null) {
            string = scopeProperty.getName();
        }
        String scopeName = string;
        Object object = scopeProperty.get(domain);
        Message message = object instanceof Message ? (Message)object : null;
        if (message == null) {
            return null;
        }
        Message scopeValue = message;
        Intrinsics.checkNotNullExpressionValue((Object)scopeName, (String)"scopeName");
        return new Scope<Message>(scopeName, scopeValue);
    }

    private final Event lookupEvent(S scope) {
        Event event;
        Object object;
        String eventName;
        Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map(ReflectionUtils.INSTANCE.withOneOf(ReflectionUtils.INSTANCE.properties(this.scopeClass), "event"), (Function1)((Function1)new Function1<Field, Pair<? extends Field, ? extends Object>>(scope){
            final /* synthetic */ S $scope;
            {
                this.$scope = $scope;
                super(1);
            }

            @NotNull
            public final Pair<Field, Object> invoke(@NotNull Field property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                return TuplesKt.to((Object)property, (Object)property.get(this.$scope));
            }
        })), (Function1)lookupEvent.2.INSTANCE));
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        Field eventProperty = (Field)pair2.component1();
        Object eventValue = pair2.component2();
        String string = ReflectionUtils.INSTANCE.declaredFieldName(eventProperty);
        if (string == null) {
            string = eventName = eventProperty.getName();
        }
        if ((object = eventValue) instanceof Counter) {
            Intrinsics.checkNotNullExpressionValue((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullExpressionValue((Object)eventValue, (String)"eventValue");
            event = new Event.CounterEvent(eventName, (Counter)((Object)eventValue));
        } else if (object instanceof Timer) {
            Intrinsics.checkNotNullExpressionValue((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullExpressionValue((Object)eventValue, (String)"eventValue");
            event = new Event.TimerEvent(eventName, (Timer)((Object)eventValue));
        } else if (object instanceof Gauge) {
            Intrinsics.checkNotNullExpressionValue((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullExpressionValue((Object)eventValue, (String)"eventValue");
            event = new Event.GaugeEvent(eventName, (Gauge)((Object)eventValue));
        } else {
            event = null;
        }
        return event;
    }

    private final void notifyListeners(String domain, String scope, String event, MetricType type, Long value, Map<String, String> tags, Outcome outcome, Throwable cause) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HealthMetricListener listener2 = (HealthMetricListener)element$iv;
            boolean bl = false;
            listener2.onHealthMetricLogged(domain, scope, event, type, value, tags, outcome, cause);
        }
    }

    private final void logOrCrash(String message) {
        if (this.isDebug) {
            throw new IllegalStateException(message.toString());
        }
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        this.logWriter.e(string, message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "logging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0004\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\r\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00040\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Domain;", "D", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/stripe/jvmcore/logging/HealthLogger$Domain;", "equals", "", "other", "hashCode", "", "toString", "logging"})
    private static final class Domain<D> {
        @NotNull
        private final String name;
        private final D value;

        public Domain(@NotNull String name, D value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final D getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final D component2() {
            return this.value;
        }

        @NotNull
        public final Domain<D> copy(@NotNull String name, D value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Domain<D>(name, value);
        }

        public static /* synthetic */ Domain copy$default(Domain domain, String string, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                string = domain.name;
            }
            if ((n2 & 2) != 0) {
                object = domain.value;
            }
            return domain.copy(string, object);
        }

        @NotNull
        public String toString() {
            return "Domain(name=" + this.name + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Domain)) {
                return false;
            }
            Domain domain = (Domain)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)domain.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.value, domain.value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "CounterEvent", "GaugeEvent", "TimerEvent", "Lcom/stripe/jvmcore/logging/HealthLogger$Event$CounterEvent;", "Lcom/stripe/jvmcore/logging/HealthLogger$Event$GaugeEvent;", "Lcom/stripe/jvmcore/logging/HealthLogger$Event$TimerEvent;", "logging"})
    private static abstract class Event {
        private Event() {
        }

        @NotNull
        public abstract String getName();

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Event$CounterEvent;", "Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "name", "", "value", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Counter;", "(Ljava/lang/String;Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Counter;)V", "getName", "()Ljava/lang/String;", "getValue", "()Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Counter;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "logging"})
        public static final class CounterEvent
        extends Event {
            @NotNull
            private final String name;
            @NotNull
            private final Counter value;

            public CounterEvent(@NotNull String name, @NotNull Counter value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                super(null);
                this.name = name;
                this.value = value;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final Counter getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Counter component2() {
                return this.value;
            }

            @NotNull
            public final CounterEvent copy(@NotNull String name, @NotNull Counter value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                return new CounterEvent(name, value);
            }

            public static /* synthetic */ CounterEvent copy$default(CounterEvent counterEvent, String string, Counter counter, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = counterEvent.name;
                }
                if ((n2 & 2) != 0) {
                    counter = counterEvent.value;
                }
                return counterEvent.copy(string, counter);
            }

            @NotNull
            public String toString() {
                return "CounterEvent(name=" + this.name + ", value=" + (Object)((Object)this.value) + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + this.value.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CounterEvent)) {
                    return false;
                }
                CounterEvent counterEvent = (CounterEvent)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)counterEvent.name)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.value), (Object)((Object)counterEvent.value));
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Event$GaugeEvent;", "Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "name", "", "value", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Gauge;", "(Ljava/lang/String;Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Gauge;)V", "getName", "()Ljava/lang/String;", "getValue", "()Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Gauge;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "logging"})
        public static final class GaugeEvent
        extends Event {
            @NotNull
            private final String name;
            @NotNull
            private final Gauge value;

            public GaugeEvent(@NotNull String name, @NotNull Gauge value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                super(null);
                this.name = name;
                this.value = value;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final Gauge getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Gauge component2() {
                return this.value;
            }

            @NotNull
            public final GaugeEvent copy(@NotNull String name, @NotNull Gauge value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                return new GaugeEvent(name, value);
            }

            public static /* synthetic */ GaugeEvent copy$default(GaugeEvent gaugeEvent, String string, Gauge gauge, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = gaugeEvent.name;
                }
                if ((n2 & 2) != 0) {
                    gauge = gaugeEvent.value;
                }
                return gaugeEvent.copy(string, gauge);
            }

            @NotNull
            public String toString() {
                return "GaugeEvent(name=" + this.name + ", value=" + (Object)((Object)this.value) + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + this.value.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GaugeEvent)) {
                    return false;
                }
                GaugeEvent gaugeEvent = (GaugeEvent)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)gaugeEvent.name)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.value), (Object)((Object)gaugeEvent.value));
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Event$TimerEvent;", "Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "name", "", "value", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Timer;", "(Ljava/lang/String;Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Timer;)V", "getName", "()Ljava/lang/String;", "getValue", "()Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Timer;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "logging"})
        public static final class TimerEvent
        extends Event {
            @NotNull
            private final String name;
            @NotNull
            private final Timer value;

            public TimerEvent(@NotNull String name, @NotNull Timer value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                super(null);
                this.name = name;
                this.value = value;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final Timer getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Timer component2() {
                return this.value;
            }

            @NotNull
            public final TimerEvent copy(@NotNull String name, @NotNull Timer value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                return new TimerEvent(name, value);
            }

            public static /* synthetic */ TimerEvent copy$default(TimerEvent timerEvent, String string, Timer timer2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = timerEvent.name;
                }
                if ((n2 & 2) != 0) {
                    timer2 = timerEvent.value;
                }
                return timerEvent.copy(string, timer2);
            }

            @NotNull
            public String toString() {
                return "TimerEvent(name=" + this.name + ", value=" + (Object)((Object)this.value) + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + this.value.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TimerEvent)) {
                    return false;
                }
                TimerEvent timerEvent = (TimerEvent)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)timerEvent.name)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.value), (Object)((Object)timerEvent.value));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0004\u0010\u0001*\u0004\b\u0005\u0010\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00040\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00040\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J?\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00040\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00040\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$ParsedHealthMetric;", "D", "S", "", "domain", "Lcom/stripe/jvmcore/logging/HealthLogger$Domain;", "scope", "Lcom/stripe/jvmcore/logging/HealthLogger$Scope;", "event", "Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "(Lcom/stripe/jvmcore/logging/HealthLogger$Domain;Lcom/stripe/jvmcore/logging/HealthLogger$Scope;Lcom/stripe/jvmcore/logging/HealthLogger$Event;)V", "getDomain", "()Lcom/stripe/jvmcore/logging/HealthLogger$Domain;", "getEvent", "()Lcom/stripe/jvmcore/logging/HealthLogger$Event;", "getScope", "()Lcom/stripe/jvmcore/logging/HealthLogger$Scope;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "logging"})
    private static final class ParsedHealthMetric<D, S> {
        @NotNull
        private final Domain<D> domain;
        @NotNull
        private final Scope<S> scope;
        @NotNull
        private final Event event;

        public ParsedHealthMetric(@NotNull Domain<D> domain, @NotNull Scope<S> scope, @NotNull Event event) {
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.domain = domain;
            this.scope = scope;
            this.event = event;
        }

        @NotNull
        public final Domain<D> getDomain() {
            return this.domain;
        }

        @NotNull
        public final Scope<S> getScope() {
            return this.scope;
        }

        @NotNull
        public final Event getEvent() {
            return this.event;
        }

        @NotNull
        public final Domain<D> component1() {
            return this.domain;
        }

        @NotNull
        public final Scope<S> component2() {
            return this.scope;
        }

        @NotNull
        public final Event component3() {
            return this.event;
        }

        @NotNull
        public final ParsedHealthMetric<D, S> copy(@NotNull Domain<D> domain, @NotNull Scope<S> scope, @NotNull Event event) {
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return new ParsedHealthMetric<D, S>(domain, scope, event);
        }

        public static /* synthetic */ ParsedHealthMetric copy$default(ParsedHealthMetric parsedHealthMetric, Domain domain, Scope scope, Event event, int n2, Object object) {
            if ((n2 & 1) != 0) {
                domain = parsedHealthMetric.domain;
            }
            if ((n2 & 2) != 0) {
                scope = parsedHealthMetric.scope;
            }
            if ((n2 & 4) != 0) {
                event = parsedHealthMetric.event;
            }
            return parsedHealthMetric.copy(domain, scope, event);
        }

        @NotNull
        public String toString() {
            return "ParsedHealthMetric(domain=" + this.domain + ", scope=" + this.scope + ", event=" + this.event + ')';
        }

        public int hashCode() {
            int result2 = this.domain.hashCode();
            result2 = result2 * 31 + this.scope.hashCode();
            result2 = result2 * 31 + this.event.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedHealthMetric)) {
                return false;
            }
            ParsedHealthMetric parsedHealthMetric = (ParsedHealthMetric)other;
            if (!Intrinsics.areEqual(this.domain, parsedHealthMetric.domain)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.scope, parsedHealthMetric.scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.event, (Object)parsedHealthMetric.event);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0004\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\r\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00040\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u0004H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/stripe/jvmcore/logging/HealthLogger$Scope;", "S", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/stripe/jvmcore/logging/HealthLogger$Scope;", "equals", "", "other", "hashCode", "", "toString", "logging"})
    private static final class Scope<S> {
        @NotNull
        private final String name;
        private final S value;

        public Scope(@NotNull String name, S value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final S getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final S component2() {
            return this.value;
        }

        @NotNull
        public final Scope<S> copy(@NotNull String name, S value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Scope<S>(name, value);
        }

        public static /* synthetic */ Scope copy$default(Scope scope, String string, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                string = scope.name;
            }
            if ((n2 & 2) != 0) {
                object = scope.value;
            }
            return scope.copy(string, object);
        }

        @NotNull
        public String toString() {
            return "Scope(name=" + this.name + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Scope)) {
                return false;
            }
            Scope scope = (Scope)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)scope.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.value, scope.value);
        }
    }
}

