/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging;

import com.stripe.proto.model.observability.schema.crash.Crash;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0000X\u0081T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"MAX_MESSAGE_LENGTH", "", "MAX_STACK_TRACE_LENGTH", "TRUNCATED_LINE", "", "truncateString", "string", "maxLength", "toLogModel", "Lcom/stripe/proto/model/observability/schema/crash/Crash;", "", "thread", "Ljava/lang/Thread;", "logging"})
public final class LogModelExtKt {
    @VisibleForTesting
    public static final int MAX_MESSAGE_LENGTH = 65536;
    @VisibleForTesting
    public static final int MAX_STACK_TRACE_LENGTH = 65536;
    @NotNull
    public static final String TRUNCATED_LINE = "\n<truncated>";

    @NotNull
    public static final Crash toLogModel(@NotNull Throwable $this$toLogModel, @NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)$this$toLogModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        String string = $this$toLogModel.getMessage();
        if (string == null) {
            string = "";
        }
        String string2 = LogModelExtKt.truncateString(string, 65536);
        String string3 = LogModelExtKt.truncateString(ExceptionsKt.stackTraceToString((Throwable)$this$toLogModel), 65536);
        String string4 = thread.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"thread.name");
        return new Crash(string2, string3, string4, null, 8, null);
    }

    private static final String truncateString(String string, int maxLength) {
        String string2;
        if (string.length() > maxLength) {
            StringBuilder stringBuilder;
            StringBuilder $this$truncateString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$truncateString_u24lambda_u240.append(StringsKt.take((String)string, (int)(maxLength - 12)));
            $this$truncateString_u24lambda_u240.append(TRUNCATED_LINE);
            String string3 = stringBuilder.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string2 = string;
        }
        return string2;
    }
}

