/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.dagger;

import com.google.gson.Gson;
import com.stripe.jvmcore.logging.terminal.contracts.LogInitializer;
import com.stripe.jvmcore.logging.terminal.log.DefaultLogInitializer;
import com.stripe.jvmcore.logging.terminal.log.LogFlusher;
import com.stripe.jvmcore.logging.terminal.log.LogUploader;
import com.stripe.jvmcore.logging.terminal.log.TraceManager;
import com.stripe.jvmcore.loggingmodels.MetricLogger;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.logwriter.dagger.LogWriterModule;
import com.stripe.jvmcore.time.Clock;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module(includes={Bindings.class, LogWriterModule.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0010H\u0007J*\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stripe/jvmcore/logging/terminal/dagger/JvmCoreLogModule;", "", "()V", "DEFAULT_FLUSH_DELAY_MS", "", "provideDefaultLogInitializer", "Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogInitializer;", "traceManager", "Lcom/stripe/jvmcore/logging/terminal/log/TraceManager;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "metricLogger", "Lcom/stripe/jvmcore/loggingmodels/MetricLogger;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "gson", "Lcom/google/gson/Gson;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "provideFlushDelay", "provideGson", "provideLogFlusher", "Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher;", "delayMs", "logUploader", "Lcom/stripe/jvmcore/logging/terminal/log/LogUploader;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "provideTraceManager", "Bindings", "logging-terminal"})
public final class JvmCoreLogModule {
    @NotNull
    public static final JvmCoreLogModule INSTANCE = new JvmCoreLogModule();
    private static final long DEFAULT_FLUSH_DELAY_MS = 60000L;

    private JvmCoreLogModule() {
    }

    @Provides
    @Named(value="flush_delay")
    public final long provideFlushDelay() {
        return 60000L;
    }

    @Singleton
    @Provides
    @NotNull
    public final LogFlusher provideLogFlusher(@Named(value="flush_delay") long delayMs, @NotNull LogUploader logUploader, @NotNull LogWriter logWriter, @NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)logUploader, (String)"logUploader");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        return new LogFlusher(delayMs, logUploader, logWriter, executorService);
    }

    @Singleton
    @Provides
    @NotNull
    public final TraceManager provideTraceManager() {
        return new TraceManager();
    }

    @Provides
    @Reusable
    @NotNull
    public final Gson provideGson() {
        return new Gson();
    }

    @Provides
    @NotNull
    public final DefaultLogInitializer provideDefaultLogInitializer(@NotNull TraceManager traceManager, @NotNull TraceLogger traceLogger, @NotNull MetricLogger metricLogger, @NotNull Clock clock, @NotNull Gson gson, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)traceManager, (String)"traceManager");
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)metricLogger, (String)"metricLogger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        return new DefaultLogInitializer(traceLogger, metricLogger, traceManager, clock, logWriter, gson);
    }

    @Module
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/stripe/jvmcore/logging/terminal/dagger/JvmCoreLogModule$Bindings;", "", "bindLogInitializer", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogInitializer;", "Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogInitializer;", "logging-terminal"})
    public static interface Bindings {
        @Binds
        @NotNull
        public LogInitializer bindLogInitializer(@NotNull DefaultLogInitializer var1);
    }
}

