/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.log;

import com.google.gson.Gson;
import com.stripe.jvmcore.logging.terminal.contracts.LogInitializer;
import com.stripe.jvmcore.logging.terminal.log.DefaultLogOperationCollector;
import com.stripe.jvmcore.logging.terminal.log.DefaultLogOperationFactory;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.logging.terminal.log.TraceManager;
import com.stripe.jvmcore.loggingmodels.MetricLogger;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogInitializer;", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogInitializer;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "metricLogger", "Lcom/stripe/jvmcore/loggingmodels/MetricLogger;", "traceManager", "Lcom/stripe/jvmcore/logging/terminal/log/TraceManager;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "gson", "Lcom/google/gson/Gson;", "(Lcom/stripe/jvmcore/loggingmodels/TraceLogger;Lcom/stripe/jvmcore/loggingmodels/MetricLogger;Lcom/stripe/jvmcore/logging/terminal/log/TraceManager;Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/jvmcore/logwriter/LogWriter;Lcom/google/gson/Gson;)V", "initialize", "", "logging-terminal"})
public final class DefaultLogInitializer
implements LogInitializer {
    @NotNull
    private final TraceLogger traceLogger;
    @NotNull
    private final MetricLogger metricLogger;
    @NotNull
    private final TraceManager traceManager;
    @NotNull
    private final Clock clock;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final Gson gson;

    public DefaultLogInitializer(@NotNull TraceLogger traceLogger, @NotNull MetricLogger metricLogger, @NotNull TraceManager traceManager, @NotNull Clock clock, @NotNull LogWriter logWriter, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)metricLogger, (String)"metricLogger");
        Intrinsics.checkNotNullParameter((Object)traceManager, (String)"traceManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.traceLogger = traceLogger;
        this.metricLogger = metricLogger;
        this.traceManager = traceManager;
        this.clock = clock;
        this.logWriter = logWriter;
        this.gson = gson;
    }

    @Override
    public void initialize() {
        this.traceLogger.init();
        this.metricLogger.init();
        Log.Companion.init(this.clock, new DefaultLogOperationFactory(this.traceLogger, this.metricLogger, this.traceManager, this.gson), new DefaultLogOperationCollector(this.traceLogger, this.metricLogger, this.gson), this.logWriter);
    }
}

