/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.log;

import com.google.gson.Gson;
import com.stripe.jvmcore.logging.terminal.contracts.LogOperationFactory;
import com.stripe.jvmcore.logging.terminal.log.DefaultLogOperation;
import com.stripe.jvmcore.logging.terminal.log.TraceManager;
import com.stripe.jvmcore.loggingmodels.ApplicationTrace;
import com.stripe.jvmcore.loggingmodels.MetricLogger;
import com.stripe.jvmcore.loggingmodels.Tag;
import com.stripe.jvmcore.loggingmodels.Trace;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\tH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogOperationFactory;", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperationFactory;", "Lcom/stripe/jvmcore/loggingmodels/ApplicationTrace;", "Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogOperation;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "metricLogger", "Lcom/stripe/jvmcore/loggingmodels/MetricLogger;", "traceManager", "Lcom/stripe/jvmcore/logging/terminal/log/TraceManager;", "gson", "Lcom/google/gson/Gson;", "(Lcom/stripe/jvmcore/loggingmodels/TraceLogger;Lcom/stripe/jvmcore/loggingmodels/MetricLogger;Lcom/stripe/jvmcore/logging/terminal/log/TraceManager;Lcom/google/gson/Gson;)V", "create", "request", "context", "Lcom/stripe/jvmcore/loggingmodels/Trace$Context;", "tags", "", "", "Companion", "logging-terminal"})
@SourceDebugExtension(value={"SMAP\nDefaultLogOperationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLogOperationFactory.kt\ncom/stripe/jvmcore/logging/terminal/log/DefaultLogOperationFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class DefaultLogOperationFactory
implements LogOperationFactory<ApplicationTrace, DefaultLogOperation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TraceLogger traceLogger;
    @NotNull
    private final MetricLogger metricLogger;
    @NotNull
    private final TraceManager traceManager;
    @NotNull
    private final Gson gson;
    @NotNull
    private static final String TERMINAL_SCOPE = "terminal";
    @NotNull
    private static final String TERMINAL_DOMAIN = "terminal_request";
    @NotNull
    private static final String TAG_ACTION_ID = "terminal_action_id";

    public DefaultLogOperationFactory(@NotNull TraceLogger traceLogger, @NotNull MetricLogger metricLogger, @NotNull TraceManager traceManager, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)metricLogger, (String)"metricLogger");
        Intrinsics.checkNotNullParameter((Object)traceManager, (String)"traceManager");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.traceLogger = traceLogger;
        this.metricLogger = metricLogger;
        this.traceManager = traceManager;
        this.gson = gson;
    }

    @Override
    @NotNull
    public DefaultLogOperation create(@NotNull ApplicationTrace request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Trace.Context cxt = this.context(this.traceManager);
        String string = request.getService();
        String string2 = request.getMethod();
        String string3 = this.gson.toJson((Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"gson.toJson(request)");
        String string4 = cxt.getActionId();
        return new DefaultLogOperation(TraceLogger.startTrace$default(this.traceLogger, string, string2, string3, null, null, string4 != null ? StringsKt.toLongOrNull((String)string4) : null, cxt, null, null, MapsKt.emptyMap(), MapsKt.plus(this.tags(this.traceManager), request.getTags()), 8, null), this.metricLogger.startTimedMetric(TERMINAL_DOMAIN, TERMINAL_SCOPE, request.getMethod(), Tag.HealthTag.Companion.toHealthTags(request.getTags())));
    }

    private final Trace.Context context(TraceManager $this$context) {
        return new Trace.Context($this$context.getSerialNumber(), $this$context.getSessionId(), $this$context.nextTraceId());
    }

    private final Map<String, String> tags(TraceManager $this$tags) {
        Map map2;
        block0: {
            Map $this$tags_u24lambda_u241 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            String string = $this$tags.getTerminalActionId();
            if (string == null) break block0;
            String it = string;
            boolean bl2 = false;
            $this$tags_u24lambda_u241.put(TAG_ACTION_ID, it);
        }
        return MapsKt.build((Map)map2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogOperationFactory$Companion;", "", "()V", "TAG_ACTION_ID", "", "TERMINAL_DOMAIN", "TERMINAL_SCOPE", "logging-terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

