/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.log;

import com.stripe.jvmcore.logging.terminal.contracts.LogOperation;
import com.stripe.jvmcore.logging.terminal.contracts.LogReferenceIdGenerator;
import com.stripe.jvmcore.logging.terminal.contracts.LogRepository;
import com.stripe.jvmcore.logging.terminal.log.DefaultLogReferenceGenerator;
import com.stripe.jvmcore.logging.terminal.models.PendingLogPoint;
import com.stripe.jvmcore.loggingmodels.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J,\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0017\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogRepository;", "T", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperation;", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogRepository;", "idGenerator", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogReferenceIdGenerator;", "(Lcom/stripe/jvmcore/logging/terminal/contracts/LogReferenceIdGenerator;)V", "logOperations", "", "", "pendingLogPoints", "", "Lcom/stripe/jvmcore/logging/terminal/models/PendingLogPoint;", "add", "", "id", "data", "(Ljava/lang/String;Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperation;)V", "addLog", "message", "throwable", "", "level", "Lcom/stripe/jvmcore/loggingmodels/LogLevel;", "currentTimeMillis", "", "getLongRunningOperations", "", "hasPendingLogs", "", "hasSavedOperations", "operationExists", "remove", "(Ljava/lang/String;)Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperation;", "removeAll", "logging-terminal"})
@SourceDebugExtension(value={"SMAP\nDefaultLogRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLogRepository.kt\ncom/stripe/jvmcore/logging/terminal/log/DefaultLogRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,102:1\n1#2:103\n1#2:116\n1855#3,2:104\n1855#3,2:106\n483#4,7:108\n563#5:115\n*S KotlinDebug\n*F\n+ 1 DefaultLogRepository.kt\ncom/stripe/jvmcore/logging/terminal/log/DefaultLogRepository\n*L\n78#1:116\n47#1:104,2\n69#1:106,2\n77#1:108,7\n78#1:115\n*E\n"})
public final class DefaultLogRepository<T extends LogOperation<T>>
implements LogRepository<T> {
    @NotNull
    private final LogReferenceIdGenerator idGenerator;
    @NotNull
    private final Map<String, T> logOperations;
    @NotNull
    private final List<PendingLogPoint> pendingLogPoints;

    public DefaultLogRepository(@NotNull LogReferenceIdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        this.idGenerator = idGenerator;
        this.logOperations = new LinkedHashMap();
        this.pendingLogPoints = new ArrayList();
    }

    public /* synthetic */ DefaultLogRepository(LogReferenceIdGenerator logReferenceIdGenerator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            logReferenceIdGenerator = new DefaultLogReferenceGenerator();
        }
        this(logReferenceIdGenerator);
    }

    @Override
    public synchronized boolean operationExists(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.logOperations.containsKey(id);
    }

    @Override
    @Nullable
    public synchronized T remove(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (T)((LogOperation)this.logOperations.remove(id));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized List<T> removeAll() {
        List list;
        if (this.hasSavedOperations()) {
            void var1_1;
            List operations = CollectionsKt.toList((Iterable)this.logOperations.values());
            this.logOperations.clear();
            list = var1_1;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addLog(@Nullable String message, @Nullable Throwable throwable, @NotNull LogLevel level, long currentTimeMillis) {
        Map<String, T> map2;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Object object = this.logOperations;
        Map<String, T> it = object;
        boolean bl2 = false;
        Map<String, T> map3 = map2 = !it.isEmpty() ? object : null;
        if (map2 != null && (object = map2.values()) != null) {
            void $this$forEach$iv;
            Iterable bl2 = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LogOperation operation = (LogOperation)element$iv;
                boolean bl3 = false;
                operation.log(message, throwable, level, currentTimeMillis);
            }
        } else {
            this.pendingLogPoints.add(new PendingLogPoint(message, throwable, level, currentTimeMillis));
        }
    }

    @Override
    public synchronized boolean hasPendingLogs() {
        return !((Collection)this.pendingLogPoints).isEmpty();
    }

    @Override
    public synchronized boolean hasSavedOperations() {
        return !this.logOperations.isEmpty();
    }

    @Override
    public synchronized void add(@NotNull String id, @NotNull T data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.logOperations.put(id, data);
        if (this.hasPendingLogs()) {
            Iterable $this$forEach$iv = this.pendingLogPoints;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PendingLogPoint it = (PendingLogPoint)element$iv;
                boolean bl = false;
                data.log(it.getMessage(), it.getThrowable(), it.getLogLevel(), it.getCurrentTimeMillis());
            }
            this.pendingLogPoints.clear();
        }
    }

    @Override
    @NotNull
    public synchronized List<T> getLongRunningOperations(long currentTimeMillis) {
        Map map2;
        Map<String, T> $this$filterValues$iv = this.logOperations;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, T> result$iv = new LinkedHashMap<String, T>();
        for (Map.Entry<String, T> entry$iv : $this$filterValues$iv.entrySet()) {
            LogOperation it = (LogOperation)entry$iv.getValue();
            boolean bl = false;
            if (!LogOperation.isLongRunning$default(it, currentTimeMillis, 0L, 2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$onEach$iv = result$iv;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u242$iv = map2 = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object t2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String id = (String)entry.getKey();
            LogOperation op = (LogOperation)entry.getValue();
            String ref = this.idGenerator.uniqueId();
            op.log("Continuing in " + ref, null, LogLevel.NONE, currentTimeMillis);
            Map<String, T> map3 = this.logOperations;
            Object newOp = t2 = op.new(currentTimeMillis);
            boolean bl3 = false;
            newOp.log("Continuing from " + ref, null, LogLevel.NONE, currentTimeMillis);
            map3.put(id, t2);
        }
        return CollectionsKt.toList((Iterable)map2.values());
    }

    public DefaultLogRepository() {
        this(null, 1, null);
    }
}

