/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.log;

import com.stripe.jvmcore.logging.terminal.contracts.LogOperation;
import com.stripe.jvmcore.logging.terminal.contracts.LogOperationCollector;
import com.stripe.jvmcore.logging.terminal.contracts.LogOperationFactory;
import com.stripe.jvmcore.logging.terminal.contracts.LogRepository;
import com.stripe.jvmcore.logging.terminal.contracts.LoggerHelper;
import com.stripe.jvmcore.logging.terminal.log.SimpleLogger;
import com.stripe.jvmcore.loggingmodels.ApplicationTrace;
import com.stripe.jvmcore.loggingmodels.ApplicationTraceResult;
import com.stripe.jvmcore.loggingmodels.LogLevel;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u000e\b\u0002\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0007:\u0001*Bg\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u001d\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0018H\u0016J)\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0010\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0018H\u0016J\u001d\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010)R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogger;", "T", "Lcom/stripe/jvmcore/loggingmodels/ApplicationTrace;", "R", "Lcom/stripe/jvmcore/loggingmodels/ApplicationTraceResult;", "L", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperation;", "Lcom/stripe/jvmcore/logging/terminal/log/SimpleLogger;", "className", "", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "repository", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogRepository;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "operationFactory", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperationFactory;", "operationCollector", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperationCollector;", "helper", "Lcom/stripe/jvmcore/logging/terminal/contracts/LoggerHelper;", "(Ljava/lang/String;Lcom/stripe/jvmcore/logwriter/LogWriter;Lcom/stripe/jvmcore/logging/terminal/contracts/LogRepository;Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperationFactory;Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperationCollector;Lcom/stripe/jvmcore/logging/terminal/contracts/LoggerHelper;)V", "endAllOperations", "", "endLongRunningOperations", "endOperation", "applicationTraceResult", "identifier", "(Lcom/stripe/jvmcore/loggingmodels/ApplicationTraceResult;Ljava/lang/String;)V", "flushPending", "log", "message", "logLevel", "Lcom/stripe/jvmcore/loggingmodels/LogLevel;", "throwable", "", "log$logging_terminal", "onShutDown", "startOperation", "applicationTrace", "(Lcom/stripe/jvmcore/loggingmodels/ApplicationTrace;Ljava/lang/String;)V", "Companion", "logging-terminal"})
@SourceDebugExtension(value={"SMAP\nDefaultLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLogger.kt\ncom/stripe/jvmcore/logging/terminal/log/DefaultLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n1855#3,2:98\n1855#3,2:100\n*S KotlinDebug\n*F\n+ 1 DefaultLogger.kt\ncom/stripe/jvmcore/logging/terminal/log/DefaultLogger\n*L\n56#1:98,2\n89#1:100,2\n*E\n"})
public final class DefaultLogger<T extends ApplicationTrace, R extends ApplicationTraceResult, L extends LogOperation<L>>
extends SimpleLogger<T, R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogRepository<L> repository;
    @NotNull
    private final Clock clock;
    @NotNull
    private final LogOperationFactory<T, L> operationFactory;
    @NotNull
    private final LogOperationCollector<R, L> operationCollector;
    @NotNull
    private final LoggerHelper<T, R> helper;
    @NotNull
    private static final String FLUSH_IDENTIFIER = "flush_operation";

    public DefaultLogger(@NotNull String className, @NotNull LogWriter logWriter, @NotNull LogRepository<L> repository, @NotNull Clock clock, @NotNull LogOperationFactory<? super T, L> operationFactory, @NotNull LogOperationCollector<? super R, L> operationCollector, @NotNull LoggerHelper<? extends T, ? extends R> helper) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        Intrinsics.checkNotNullParameter(repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(operationFactory, (String)"operationFactory");
        Intrinsics.checkNotNullParameter(operationCollector, (String)"operationCollector");
        Intrinsics.checkNotNullParameter(helper, (String)"helper");
        super(className, logWriter);
        this.repository = repository;
        this.clock = clock;
        this.operationFactory = operationFactory;
        this.operationCollector = operationCollector;
        this.helper = helper;
    }

    @Override
    public synchronized void startOperation(@NotNull T applicationTrace, @NotNull String identifier) {
        Intrinsics.checkNotNullParameter(applicationTrace, (String)"applicationTrace");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (this.repository.operationExists(identifier)) {
            this.endOperation(this.helper.duplicateTraceResult(identifier), identifier);
        }
        T t2 = applicationTrace;
        LogOperationFactory<T, L> logOperationFactory = this.operationFactory;
        T p0 = t2;
        boolean bl = false;
        L data = logOperationFactory.create(p0);
        boolean bl2 = false;
        this.repository.add(identifier, data);
    }

    @Override
    public synchronized void endOperation(@NotNull R applicationTraceResult, @NotNull String identifier) {
        block0: {
            Intrinsics.checkNotNullParameter(applicationTraceResult, (String)"applicationTraceResult");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            String string = identifier;
            LogRepository<L> logRepository = this.repository;
            String p0 = string;
            boolean bl = false;
            L l2 = logRepository.remove(p0);
            if (l2 == null) break block0;
            L data = l2;
            boolean bl2 = false;
            this.operationCollector.collect(applicationTraceResult, data, true);
        }
    }

    @Override
    public synchronized void endAllOperations() {
        Iterable $this$forEach$iv = this.repository.removeAll();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogOperation it = (LogOperation)element$iv;
            boolean bl = false;
            this.operationCollector.collect(this.helper.getInterruptedTraceResult(), it, true);
        }
    }

    @Override
    public synchronized void log$logging_terminal(@Nullable String message, @NotNull LogLevel logLevel, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.repository.addLog(message, throwable, logLevel, this.clock.currentTimeMillis());
    }

    @Override
    public synchronized void flushPending() {
        if (this.repository.hasPendingLogs() && !this.repository.hasSavedOperations()) {
            this.startOperation(this.helper.getFlushTrace(), FLUSH_IDENTIFIER);
            this.endOperation(this.helper.getFlushTraceResult(), FLUSH_IDENTIFIER);
        }
    }

    @Override
    public synchronized void onShutDown() {
        this.flushPending();
        this.endAllOperations();
    }

    @Override
    public synchronized void endLongRunningOperations() {
        Iterable $this$forEach$iv = this.repository.getLongRunningOperations(this.clock.currentTimeMillis());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogOperation op = (LogOperation)element$iv;
            boolean bl = false;
            this.operationCollector.collect(this.helper.getFlushTraceResult(), op, false);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DefaultLogger$Companion;", "", "()V", "FLUSH_IDENTIFIER", "", "logging-terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

