/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.log;

import com.squareup.wire.Message;
import com.stripe.jvmcore.crpcclient.CrpcResponse;
import com.stripe.jvmcore.dagger.DeviceUuid;
import com.stripe.jvmcore.dagger.LogRole;
import com.stripe.jvmcore.logging.terminal.log.Event;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.logging.terminal.log.LogUploadResult;
import com.stripe.jvmcore.logging.terminal.log.LogUploader;
import com.stripe.jvmcore.logging.terminal.log.Span;
import com.stripe.jvmcore.loggingmodels.LogPoint;
import com.stripe.proto.terminal.clientlogger.pub.AdditionalContext;
import com.stripe.proto.terminal.clientlogger.pub.api.ClientLoggerApi;
import com.stripe.proto.terminal.clientlogger.pub.api.EventResultPb;
import com.stripe.proto.terminal.clientlogger.pub.api.ProxyEventPb;
import com.stripe.proto.terminal.clientlogger.pub.api.ProxySpanPb;
import com.stripe.proto.terminal.clientlogger.pub.api.ReportEventRequest;
import com.stripe.proto.terminal.clientlogger.pub.api.ReportTraceRequest;
import com.stripe.proto.terminal.clientlogger.pub.api.ReportedSpanPb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010\b\u001a\u00020\t\"\u0012\b\u0000\u0010\n*\f\u0012\u0004\u0012\u0002H\n\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0012H\u0002J\f\u0010\u0016\u001a\u00020\u0018*\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DeviceRoleLogUploader;", "Lcom/stripe/jvmcore/logging/terminal/log/LogUploader;", "deviceUuid", "", "role", "clientLoggerApi", "Lcom/stripe/proto/terminal/clientlogger/pub/api/ClientLoggerApi;", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/proto/terminal/clientlogger/pub/api/ClientLoggerApi;)V", "getResultFromResponse", "Lcom/stripe/jvmcore/logging/terminal/log/LogUploadResult;", "T", "Lcom/squareup/wire/Message;", "crpcResponse", "Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "entityType", "uploadEvents", "events", "", "Lcom/stripe/jvmcore/logging/terminal/log/Event;", "uploadTraces", "spans", "Lcom/stripe/jvmcore/logging/terminal/log/Span;", "toClientLoggerProto", "Lcom/stripe/proto/terminal/clientlogger/pub/api/EventResultPb;", "Lcom/stripe/proto/terminal/clientlogger/pub/api/ReportedSpanPb;", "Companion", "logging-terminal"})
@SourceDebugExtension(value={"SMAP\nDeviceRoleLogUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceRoleLogUploader.kt\ncom/stripe/jvmcore/logging/terminal/log/DeviceRoleLogUploader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n1549#2:123\n1620#2,3:124\n1549#2:127\n1620#2,3:128\n*S KotlinDebug\n*F\n+ 1 DeviceRoleLogUploader.kt\ncom/stripe/jvmcore/logging/terminal/log/DeviceRoleLogUploader\n*L\n26#1:119\n26#1:120,3\n40#1:123\n40#1:124,3\n65#1:127\n65#1:128,3\n*E\n"})
public final class DeviceRoleLogUploader
implements LogUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String deviceUuid;
    @NotNull
    private final String role;
    @NotNull
    private final ClientLoggerApi clientLoggerApi;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(DeviceRoleLogUploader.class);

    @Inject
    public DeviceRoleLogUploader(@DeviceUuid @NotNull String deviceUuid, @LogRole @NotNull String role, @NotNull ClientLoggerApi clientLoggerApi) {
        Intrinsics.checkNotNullParameter((Object)deviceUuid, (String)"deviceUuid");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)clientLoggerApi, (String)"clientLoggerApi");
        this.deviceUuid = deviceUuid;
        this.role = role;
        this.clientLoggerApi = clientLoggerApi;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LogUploadResult uploadEvents(@NotNull List<Event> events) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$map$iv = events;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Event event = (Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProxyEventPb(this.role, this.deviceUuid, null, this.toClientLoggerProto((Event)it), null, 20, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 2;
        ByteString byteString = null;
        List list = (List)destination$iv$iv;
        ReportEventRequest request = new ReportEventRequest(list, byteString, n2, defaultConstructorMarker);
        return this.getResultFromResponse(this.clientLoggerApi.reportEvent(request), "events");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LogUploadResult uploadTraces(@NotNull List<Span> spans) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        Iterable $this$map$iv = spans;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Span span = (Span)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProxySpanPb(this.role, this.deviceUuid, null, this.toClientLoggerProto((Span)it), null, null, 52, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 2;
        ByteString byteString = null;
        List list = (List)destination$iv$iv;
        ReportTraceRequest request = new ReportTraceRequest(list, byteString, n2, defaultConstructorMarker);
        return this.getResultFromResponse(this.clientLoggerApi.reportTrace(request), "traces");
    }

    /*
     * WARNING - void declaration
     */
    private final ReportedSpanPb toClientLoggerProto(Span $this$toClientLoggerProto) {
        void $this$mapTo$iv$iv;
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = $this$toClientLoggerProto.getTraceId();
        String string6 = $this$toClientLoggerProto.getSessionId();
        if (string6 == null) {
            string6 = string4 = "";
        }
        if ((string3 = $this$toClientLoggerProto.getSerialNumber()) == null) {
            string3 = "";
        }
        String string7 = string3;
        AdditionalContext additionalContext = new AdditionalContext(string5, string7, string4, null, null, 24, null);
        long l2 = $this$toClientLoggerProto.getStartTimeMs();
        string7 = $this$toClientLoggerProto.getService();
        String string8 = $this$toClientLoggerProto.getRequest();
        if (string8 == null) {
            string8 = string2 = "";
        }
        if ((string = $this$toClientLoggerProto.getResponse()) == null) {
            string = "";
        }
        String string9 = string;
        String string10 = $this$toClientLoggerProto.getMethod();
        Iterable $this$map$iv = $this$toClientLoggerProto.getLogPoints();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LogPoint logPoint = (LogPoint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toClientLoggerProto());
        }
        List list = (List)destination$iv$iv;
        String string11 = $this$toClientLoggerProto.getException();
        if (string11 == null) {
            string11 = "";
        }
        String string12 = string11;
        Long l3 = $this$toClientLoggerProto.getTotalTimeMs();
        long l4 = l3 != null ? l3 : 0L;
        Map<String, String> map2 = $this$toClientLoggerProto.getTags();
        return new ReportedSpanPb(0L, 0L, 0L, null, null, null, null, null, l2, l4, string7, string10, string2, null, string9, null, string12, null, null, map2, additionalContext, null, list, null, 10920191, null);
    }

    private final EventResultPb toClientLoggerProto(Event $this$toClientLoggerProto) {
        EventResultPb.Result result2;
        String string = $this$toClientLoggerProto.getEvent();
        String string2 = $this$toClientLoggerProto.getScope();
        String string3 = $this$toClientLoggerProto.getDomain();
        long l2 = $this$toClientLoggerProto.getDuration();
        String string4 = $this$toClientLoggerProto.getOutcome();
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        Event.EventResult eventResult = $this$toClientLoggerProto.getResult();
        switch (eventResult == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventResult.ordinal()]) {
            case 1: {
                result2 = EventResultPb.Result.OK;
                break;
            }
            case 2: {
                result2 = EventResultPb.Result.ERROR;
                break;
            }
            case -1: {
                result2 = EventResultPb.Result.OK;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        EventResultPb.Result result3 = result2;
        Map<String, String> map2 = $this$toClientLoggerProto.getTags();
        return new EventResultPb(string3, string2, string, map2, result3, string5, l2, null, null, 384, null);
    }

    private final <T extends Message<T, ?>> LogUploadResult getResultFromResponse(CrpcResponse<T> crpcResponse, String entityType) {
        LogUploadResult logUploadResult;
        CrpcResponse<T> crpcResponse2 = crpcResponse;
        if (crpcResponse2 instanceof CrpcResponse.Success) {
            logUploadResult = LogUploadResult.Succeeded.INSTANCE;
        } else if (crpcResponse2 instanceof CrpcResponse.ApplicationError) {
            LOGGER.w("Failed to upload " + entityType + ", not retrying", new Pair[0]);
            logUploadResult = new LogUploadResult.Failed(false);
        } else if (crpcResponse2 instanceof CrpcResponse.RpcError) {
            boolean shouldRetry = ((CrpcResponse.RpcError)crpcResponse).isRetryable();
            LOGGER.w("Failed to upload " + entityType + ", " + (!shouldRetry ? "not" : "retrying"), new Pair[0]);
            logUploadResult = new LogUploadResult.Failed(shouldRetry);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return logUploadResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/DeviceRoleLogUploader$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "logging-terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Event.EventResult.values().length];
            try {
                nArray[Event.EventResult.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Event.EventResult.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

