/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logging.terminal.log;

import com.stripe.jvmcore.logging.terminal.log.Event;
import com.stripe.jvmcore.logging.terminal.log.LogUploadResult;
import com.stripe.jvmcore.logging.terminal.log.LogUploader;
import com.stripe.jvmcore.logging.terminal.log.Span;
import com.stripe.jvmcore.logwriter.LogWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB)\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rJ\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0011J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fJ\u0014\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher;", "", "delayMs", "", "logUploader", "Lcom/stripe/jvmcore/logging/terminal/log/LogUploader;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(JLcom/stripe/jvmcore/logging/terminal/log/LogUploader;Lcom/stripe/jvmcore/logwriter/LogWriter;Ljava/util/concurrent/ScheduledExecutorService;)V", "pendingEvents", "", "Lcom/stripe/jvmcore/logging/terminal/log/Event;", "pendingSpans", "Lcom/stripe/jvmcore/logging/terminal/log/Span;", "clearPendingEvents", "", "clearPendingTraces", "stopExecutingJobs", "", "submitEvent", "event", "submitEvents", "events", "submitTrace", "span", "submitTraces", "spans", "Companion", "ReportEventJob", "ReportTraceJob", "logging-terminal"})
public final class LogFlusher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogUploader logUploader;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final List<Event> pendingEvents;
    @NotNull
    private final List<Span> pendingSpans;
    @NotNull
    private static final String TAG;

    @Inject
    public LogFlusher(@Named(value="flush_delay") long delayMs, @NotNull LogUploader logUploader, @NotNull LogWriter logWriter, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)logUploader, (String)"logUploader");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.logUploader = logUploader;
        this.logWriter = logWriter;
        this.executor = executor;
        this.pendingEvents = new ArrayList();
        this.pendingSpans = new ArrayList();
        this.executor.scheduleAtFixedRate(new ReportTraceJob(), delayMs, delayMs, TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(new ReportEventJob(), delayMs, delayMs, TimeUnit.MILLISECONDS);
    }

    public final synchronized void submitEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.pendingEvents.add(event);
    }

    public final synchronized void submitEvents(@NotNull List<Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        this.pendingEvents.addAll((Collection<Event>)events);
    }

    public final synchronized void submitTrace(@NotNull Span span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        this.pendingSpans.add(span);
    }

    public final synchronized void submitTraces(@NotNull List<Span> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        this.pendingSpans.addAll((Collection<Span>)spans);
    }

    @NotNull
    public final synchronized List<Event> clearPendingEvents() {
        ArrayList tempList = new ArrayList(this.pendingEvents);
        this.pendingEvents.clear();
        return tempList;
    }

    @NotNull
    public final synchronized List<Span> clearPendingTraces() {
        ArrayList tempList = new ArrayList(this.pendingSpans);
        this.pendingSpans.clear();
        return tempList;
    }

    public final synchronized void stopExecutingJobs() {
        this.executor.shutdown();
    }

    static {
        String string = LogFlusher.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LogFlusher::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher$Companion;", "", "()V", "TAG", "", "logging-terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher$ReportEventJob;", "Ljava/lang/Runnable;", "(Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher;)V", "run", "", "logging-terminal"})
    public final class ReportEventJob
    implements Runnable {
        @Override
        public void run() {
            List<Event> tempList = LogFlusher.this.clearPendingEvents();
            if (!((Collection)tempList).isEmpty()) {
                LogFlusher.this.logWriter.d(TAG, "Reporting " + tempList.size() + " events");
                LogUploadResult result2 = LogFlusher.this.logUploader.uploadEvents(tempList);
                if (result2 instanceof LogUploadResult.Succeeded) {
                    LogFlusher.this.logWriter.d(TAG, "Sent " + tempList.size() + " events");
                } else if (result2 instanceof LogUploadResult.Failed) {
                    LogFlusher.this.logWriter.e(TAG, "Failed sending " + tempList.size() + " events " + (((LogUploadResult.Failed)result2).getShouldRetry() ? "will" : "won't retry"));
                    if (((LogUploadResult.Failed)result2).getShouldRetry()) {
                        LogFlusher.this.submitEvents(tempList);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher$ReportTraceJob;", "Ljava/lang/Runnable;", "(Lcom/stripe/jvmcore/logging/terminal/log/LogFlusher;)V", "run", "", "logging-terminal"})
    public final class ReportTraceJob
    implements Runnable {
        @Override
        public void run() {
            List<Span> tempList = LogFlusher.this.clearPendingTraces();
            if (!((Collection)tempList).isEmpty()) {
                LogFlusher.this.logWriter.d(TAG, "Reporting " + tempList.size() + " traces");
                LogUploadResult result2 = LogFlusher.this.logUploader.uploadTraces(tempList);
                if (result2 instanceof LogUploadResult.Succeeded) {
                    LogFlusher.this.logWriter.d(TAG, "Sent " + tempList.size() + " traces");
                } else if (result2 instanceof LogUploadResult.Failed) {
                    LogFlusher.this.logWriter.e(TAG, "Failed sending " + tempList.size() + " traces " + (((LogUploadResult.Failed)result2).getShouldRetry() ? "will" : "won't retry"));
                    if (((LogUploadResult.Failed)result2).getShouldRetry()) {
                        LogFlusher.this.submitTraces(tempList);
                    }
                }
            }
        }
    }
}

