/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logginginterceptors;

import com.squareup.wire.Message;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.redaction.Extensions;
import com.stripe.jvmcore.redaction.terminal.TerminalMessageRedactor;
import com.stripe.jvmcore.restclient.RestClient;
import com.stripe.jvmcore.restclient.RestInterceptor;
import com.stripe.jvmcore.restclient.RestResponse;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0088\u0001\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\b\"\u001c\b\u0000\u0010\u000b*\u0016\u0012\u0004\u0012\u0002H\u000b\u0012\u0002\b\u00030\fj\b\u0012\u0004\u0012\u0002H\u000b`\r\"\u001c\b\u0001\u0010\t*\u0016\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\fj\b\u0012\u0004\u0012\u0002H\t`\r\"\u001c\b\u0002\u0010\n*\u0016\u0012\u0004\u0012\u0002H\n\u0012\u0002\b\u00030\fj\b\u0012\u0004\u0012\u0002H\n`\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/jvmcore/logginginterceptors/ApiLogPointInterceptor;", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "()V", "name", "", "getName", "()Ljava/lang/String;", "intercept", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Rsp", "Err", "Rq", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "chain", "Lcom/stripe/jvmcore/restclient/RestInterceptor$Chain;", "Companion", "logging-interceptors"})
public final class ApiLogPointInterceptor
extends RestInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(RestClient.class);
    @NotNull
    private static final String CUSTOM_INTERCEPTOR_NAME = "ApiLogPointInterceptor";

    @Inject
    public ApiLogPointInterceptor() {
        this.name = CUSTOM_INTERCEPTOR_NAME;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> intercept(@NotNull RestInterceptor.Chain<Rq, Rsp, Err> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        LOGGER.i("url=" + chain.request().url() + " request=" + Extensions.toLogJson$default(Extensions.INSTANCE, chain.rpcRequest(), TerminalMessageRedactor.INSTANCE, null, 2, null), new Pair[0]);
        RestResponse<Rsp, Err> response = chain.proceed(chain.request());
        LOGGER.i("url=" + chain.request().url() + ' ' + response.toLogString(), new Pair[0]);
        return response;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/jvmcore/logginginterceptors/ApiLogPointInterceptor$Companion;", "", "()V", "CUSTOM_INTERCEPTOR_NAME", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "logging-interceptors"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

