/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.logginginterceptors;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.wire.Message;
import com.squareup.wire.RedactingJsonAdapterKt;
import com.squareup.wire.WireJsonAdapterFactory;
import com.stripe.jvmcore.logginginterceptors.PendingCall;
import com.stripe.jvmcore.loggingmodels.MetricLogger;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.loggingmodels.Tag;
import com.stripe.jvmcore.loggingmodels.TagKt;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.restclient.RestInterceptor;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0088\u0001\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u0015\"\u001c\b\u0000\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0018`\u001a\"\u001c\b\u0001\u0010\u0016*\u0016\u0012\u0004\u0012\u0002H\u0016\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0016`\u001a\"\u001c\b\u0002\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0017`\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u001cH\u0016J\u009d\u0001\u0010\u001d\u001a\u00020\u001e\"\u001c\b\u0000\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0018`\u001a\"\u001c\b\u0001\u0010\u0016*\u0016\u0012\u0004\u0012\u0002H\u0016\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0016`\u001a\"\u001c\b\u0002\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0017`\u001a2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u0002H\u00182\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u0015H\u0001\u00a2\u0006\u0004\b$\u0010%JM\u0010&\u001a\u00020\u001e\"\u001c\b\u0000\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H\u0018`\u001a2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u0002H\u0018H\u0001\u00a2\u0006\u0004\b'\u0010(J3\u0010)\u001a\u00020\u0011\"\u001c\b\u0000\u0010**\u0016\u0012\u0004\u0012\u0002H*\u0012\u0002\b\u00030\u0019j\b\u0012\u0004\u0012\u0002H*`\u001a2\u0006\u0010+\u001a\u0002H*H\u0007\u00a2\u0006\u0002\u0010,J\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/stripe/jvmcore/logginginterceptors/TraceLoggingRestClientInterceptor;", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "metricLogger", "Lcom/stripe/jvmcore/loggingmodels/MetricLogger;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lcom/stripe/jvmcore/loggingmodels/MetricLogger;Lcom/stripe/jvmcore/loggingmodels/TraceLogger;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "callMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lokhttp3/Request;", "Lcom/stripe/jvmcore/logginginterceptors/PendingCall;", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "name", "", "getName", "()Ljava/lang/String;", "intercept", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Rsp", "Err", "Rq", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "chain", "Lcom/stripe/jvmcore/restclient/RestInterceptor$Chain;", "postCallAction", "", "service", "method", "okHttpRequest", "rpcRequest", "response", "postCallAction$logging_interceptors", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/Request;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestResponse;)V", "preCallAction", "preCallAction$logging_interceptors", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/Request;Lcom/squareup/wire/Message;)V", "protoToJson", "M", "message", "(Lcom/squareup/wire/Message;)Ljava/lang/String;", "toMetricTags", "", "Lcom/stripe/jvmcore/loggingmodels/Tag;", "Companion", "logging-interceptors"})
public final class TraceLoggingRestClientInterceptor
extends RestInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetricLogger metricLogger;
    @NotNull
    private final TraceLogger traceLogger;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final String name;
    @NotNull
    private final ConcurrentHashMap<Request, PendingCall> callMap;
    private final Moshi moshi;
    private static final String TAG = TraceLoggingRestClientInterceptor.class.getSimpleName();
    @NotNull
    private static final String CUSTOM_INTERCEPTOR_NAME = "TraceLoggingRestInterceptor";
    @NotNull
    private static final String METRIC_DOMAIN = "rest_client";
    @VisibleForTesting
    @NotNull
    public static final String FAILURE_TO_PARSE_MESSAGE = "Failed to parse REST response body.";

    @Inject
    public TraceLoggingRestClientInterceptor(@NotNull MetricLogger metricLogger, @NotNull TraceLogger traceLogger, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)metricLogger, (String)"metricLogger");
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.metricLogger = metricLogger;
        this.traceLogger = traceLogger;
        this.logWriter = logWriter;
        this.name = CUSTOM_INTERCEPTOR_NAME;
        this.callMap = new ConcurrentHashMap();
        this.moshi = new Moshi.Builder().add((JsonAdapter.Factory)new WireJsonAdapterFactory(null, false, 3, null)).build();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    public final <Rq extends Message<Rq, ?>> void preCallAction$logging_interceptors(@NotNull String service, @NotNull String method, @NotNull Request okHttpRequest, @NotNull Rq rpcRequest) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)okHttpRequest, (String)"okHttpRequest");
        Intrinsics.checkNotNullParameter(rpcRequest, (String)"rpcRequest");
        ((Map)this.callMap).put(okHttpRequest, new PendingCall(TraceLogger.startTrace$default(this.traceLogger, service, method, rpcRequest, null, null, null, null, okHttpRequest.url().toString(), okHttpRequest.method(), MapsKt.toMap((Iterable)((Iterable)okHttpRequest.headers())), null, 1144, null), MetricLogger.startTimedMetric$default(this.metricLogger, METRIC_DOMAIN, service, method, null, 8, null)));
    }

    @VisibleForTesting
    public final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> void postCallAction$logging_interceptors(@NotNull String service, @NotNull String method, @NotNull Request okHttpRequest, @NotNull Rq rpcRequest, @NotNull RestResponse<Rsp, Err> response) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)okHttpRequest, (String)"okHttpRequest");
        Intrinsics.checkNotNullParameter(rpcRequest, (String)"rpcRequest");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        PendingCall call = this.callMap.remove(okHttpRequest);
        if (call == null) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            this.logWriter.e(string, "Failed to find call for REST request.");
            return;
        }
        RestResponse<Rsp, Err> restResponse = response;
        if (restResponse instanceof RestResponse.Success) {
            this.traceLogger.endTraceWithSuccess(call.getTrace(), (Message<?, ?>)((RestResponse.Success)response).getResponse(), (Map<String, String>)response.getHeaders());
            MetricLogger.endTimedMetric$default(this.metricLogger, call.getMetric(), Outcome.Ok.INSTANCE, null, 4, null);
        } else if (restResponse instanceof RestResponse.ServerError) {
            TraceLogger.endTraceWithErrorMessage$default(this.traceLogger, call.getTrace(), this.protoToJson((Message)((RestResponse.ServerError)response).getResponse()), String.valueOf((Object)response.getStatusCode()), null, 8, null);
            this.metricLogger.endTimedMetric(call.getMetric(), Outcome.HttpError.Companion.toOutcome(response.getStatusCode()), this.toMetricTags((Message<?, ?>)((RestResponse.ServerError)response).getResponse()));
        } else if (restResponse instanceof RestResponse.ParseError) {
            TraceLogger.endTraceWithErrorMessage$default(this.traceLogger, call.getTrace(), FAILURE_TO_PARSE_MESSAGE, String.valueOf((Object)response.getStatusCode()), null, 8, null);
            MetricLogger.endTimedMetric$default(this.metricLogger, call.getMetric(), Outcome.HttpError.ParseError.INSTANCE, null, 4, null);
        }
    }

    @Override
    @NotNull
    public <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> intercept(@NotNull RestInterceptor.Chain<Rq, Rsp, Err> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        this.preCallAction$logging_interceptors(chain.service(), chain.method(), chain.request(), chain.rpcRequest());
        RestResponse<Rsp, Err> response = chain.proceed(chain.request());
        this.postCallAction$logging_interceptors(chain.service(), chain.method(), chain.request(), chain.rpcRequest(), response);
        return response;
    }

    @VisibleForTesting
    @NotNull
    public final <M extends Message<M, ?>> String protoToJson(@NotNull M message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        JsonAdapter jsonAdapter = this.moshi.adapter(message.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(message.javaClass)");
        String string = RedactingJsonAdapterKt.redacting((JsonAdapter)jsonAdapter).toJson(message);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi.adapter(message.ja\u2026dacting().toJson(message)");
        return string;
    }

    private final List<Tag> toMetricTags(Message<?, ?> $this$toMetricTags) {
        return $this$toMetricTags instanceof ErrorWrapper ? TagKt.toTags((ErrorWrapper)$this$toMetricTags) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/jvmcore/logginginterceptors/TraceLoggingRestClientInterceptor$Companion;", "", "()V", "CUSTOM_INTERCEPTOR_NAME", "", "FAILURE_TO_PARSE_MESSAGE", "METRIC_DOMAIN", "TAG", "kotlin.jvm.PlatformType", "logging-interceptors"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

