/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.loggingmodels;

import com.stripe.jvmcore.loggingmodels.LogLevel;
import com.stripe.jvmcore.loggingmodels.LogLevelHelperKt;
import com.stripe.jvmcore.strings.StringsExtKt;
import com.stripe.proto.api.gator.ReportedSpanPb;
import com.stripe.proto.terminal.clientlogger.pub.api.ReportedSpanPb;
import com.stripe.proto.terminal.clientlogger.pub.message.observability_schema.LegacyTraceData;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001#B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/stripe/jvmcore/loggingmodels/LogPoint;", "", "message", "", "exception", "logLevel", "Lcom/stripe/jvmcore/loggingmodels/LogLevel;", "offsetMs", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/jvmcore/loggingmodels/LogLevel;I)V", "data", "Lcom/stripe/jvmcore/loggingmodels/LogPoint$LogPointData;", "getException", "()Ljava/lang/String;", "getLogLevel", "()Lcom/stripe/jvmcore/loggingmodels/LogLevel;", "getMessage", "getOffsetMs", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toClientLoggerProto", "Lcom/stripe/proto/terminal/clientlogger/pub/api/ReportedSpanPb$SpanPointPb;", "toGatorProto", "Lcom/stripe/proto/api/gator/ReportedSpanPb$SpanPointPb;", "toLegacyTraceProto", "Lcom/stripe/proto/terminal/clientlogger/pub/message/observability_schema/LegacyTraceData$SpanPointPb;", "toString", "LogPointData", "logging-models"})
public final class LogPoint {
    @Nullable
    private final String message;
    @Nullable
    private final String exception;
    @NotNull
    private final LogLevel logLevel;
    private final int offsetMs;
    @NotNull
    private final LogPointData data;

    public LogPoint(@Nullable String message, @Nullable String exception, @NotNull LogLevel logLevel, int offsetMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.message = message;
        this.exception = exception;
        this.logLevel = logLevel;
        this.offsetMs = offsetMs;
        this.data = new LogPointData(this.message, this.exception, LogLevelHelperKt.importance(this.logLevel));
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final String getException() {
        return this.exception;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final int getOffsetMs() {
        return this.offsetMs;
    }

    @Deprecated(message="Deprecated data type. Should be migrated to clientlogger")
    @NotNull
    public final ReportedSpanPb.SpanPointPb toGatorProto() {
        return new ReportedSpanPb.SpanPointPb(this.offsetMs, this.data.toGatorProto(), null, null, 12, null);
    }

    @NotNull
    public final ReportedSpanPb.SpanPointPb toClientLoggerProto() {
        return new ReportedSpanPb.SpanPointPb(this.offsetMs, this.data.toClientLoggerProto(), null, null, 12, null);
    }

    @NotNull
    public final LegacyTraceData.SpanPointPb toLegacyTraceProto() {
        return new LegacyTraceData.SpanPointPb(this.offsetMs, this.data.toLegacyTraceProto(), null, null, 12, null);
    }

    @Nullable
    public final String component1() {
        return this.message;
    }

    @Nullable
    public final String component2() {
        return this.exception;
    }

    @NotNull
    public final LogLevel component3() {
        return this.logLevel;
    }

    public final int component4() {
        return this.offsetMs;
    }

    @NotNull
    public final LogPoint copy(@Nullable String message, @Nullable String exception, @NotNull LogLevel logLevel, int offsetMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        return new LogPoint(message, exception, logLevel, offsetMs);
    }

    public static /* synthetic */ LogPoint copy$default(LogPoint logPoint, String string, String string2, LogLevel logLevel, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = logPoint.message;
        }
        if ((n3 & 2) != 0) {
            string2 = logPoint.exception;
        }
        if ((n3 & 4) != 0) {
            logLevel = logPoint.logLevel;
        }
        if ((n3 & 8) != 0) {
            n2 = logPoint.offsetMs;
        }
        return logPoint.copy(string, string2, logLevel, n2);
    }

    @NotNull
    public String toString() {
        return "LogPoint(message=" + this.message + ", exception=" + this.exception + ", logLevel=" + (Object)((Object)this.logLevel) + ", offsetMs=" + this.offsetMs + ')';
    }

    public int hashCode() {
        int result2 = this.message == null ? 0 : this.message.hashCode();
        result2 = result2 * 31 + (this.exception == null ? 0 : this.exception.hashCode());
        result2 = result2 * 31 + this.logLevel.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.offsetMs);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogPoint)) {
            return false;
        }
        LogPoint logPoint = (LogPoint)other;
        if (!Intrinsics.areEqual((Object)this.message, (Object)logPoint.message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.exception, (Object)logPoint.exception)) {
            return false;
        }
        if (this.logLevel != logPoint.logLevel) {
            return false;
        }
        return this.offsetMs == logPoint.offsetMs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0007J\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/jvmcore/loggingmodels/LogPoint$LogPointData;", "", "message", "", "exception", "logLevel", "", "(Lcom/stripe/jvmcore/loggingmodels/LogPoint;Ljava/lang/String;Ljava/lang/String;I)V", "toClientLoggerProto", "Lcom/stripe/proto/terminal/clientlogger/pub/api/ReportedSpanPb$SpanPointPb$LogPoint;", "toGatorProto", "Lcom/stripe/proto/api/gator/ReportedSpanPb$SpanPointPb$LogPoint;", "toLegacyTraceProto", "Lcom/stripe/proto/terminal/clientlogger/pub/message/observability_schema/LegacyTraceData$SpanPointPb$LogPoint;", "logging-models"})
    private final class LogPointData {
        @Nullable
        private final String message;
        private final int logLevel;
        @Nullable
        private final String exception;

        public LogPointData(@Nullable String message, String exception, int logLevel) {
            this.message = message;
            this.logLevel = logLevel;
            String string = exception;
            this.exception = string != null ? StringsExtKt.escape(string) : null;
        }

        @Deprecated(message="Deprecated data type. Should be migrated to clientlogger")
        @NotNull
        public final ReportedSpanPb.SpanPointPb.LogPoint toGatorProto() {
            String string;
            String string2 = this.message;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.exception) == null) {
                string = "";
            }
            return new ReportedSpanPb.SpanPointPb.LogPoint(this.logLevel, null, string2, string, null, 18, null);
        }

        @NotNull
        public final ReportedSpanPb.SpanPointPb.LogPoint toClientLoggerProto() {
            String string;
            String string2 = this.message;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.exception) == null) {
                string = "";
            }
            return new ReportedSpanPb.SpanPointPb.LogPoint(this.logLevel, null, string2, string, null, 18, null);
        }

        @NotNull
        public final LegacyTraceData.SpanPointPb.LogPoint toLegacyTraceProto() {
            String string;
            String string2 = this.message;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.exception) == null) {
                string = "";
            }
            return new LegacyTraceData.SpanPointPb.LogPoint(this.logLevel, null, string2, string, null, 18, null);
        }
    }
}

