/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.offlinemode.storage;

import com.stripe.jvmcore.offlinemode.storage.OfflineKeyValueStore;
import com.stripe.jvmcore.storage.KeyValueStore;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/jvmcore/offlinemode/storage/DefaultOfflineKeyValueStore;", "Lcom/stripe/jvmcore/offlinemode/storage/OfflineKeyValueStore;", "keyValueStore", "Lcom/stripe/jvmcore/storage/KeyValueStore;", "(Lcom/stripe/jvmcore/storage/KeyValueStore;)V", "accountIdStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "clear", "", "getAccountId", "getSavedAccountIdStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "saveAccountId", "accountId", "offlinemode"})
public final class DefaultOfflineKeyValueStore
implements OfflineKeyValueStore {
    @NotNull
    private final KeyValueStore keyValueStore;
    @NotNull
    private final MutableStateFlow<String> accountIdStateFlow;

    @Inject
    public DefaultOfflineKeyValueStore(@NotNull KeyValueStore keyValueStore) {
        Intrinsics.checkNotNullParameter((Object)keyValueStore, (String)"keyValueStore");
        this.keyValueStore = keyValueStore;
        this.accountIdStateFlow = StateFlowKt.MutableStateFlow((Object)this.getAccountId());
    }

    @Override
    public void saveAccountId(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.keyValueStore.putString("offline_account_id", accountId);
        this.accountIdStateFlow.setValue((Object)accountId);
    }

    @Override
    @Nullable
    public String getAccountId() {
        return this.keyValueStore.getString("offline_account_id", null);
    }

    @Override
    @NotNull
    public StateFlow<String> getSavedAccountIdStateFlow() {
        return (StateFlow)this.accountIdStateFlow;
    }

    @Override
    public void clear() {
        this.keyValueStore.remove("offline_account_id");
        this.accountIdStateFlow.setValue(null);
    }
}

