/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.restclient;

import com.squareup.wire.Message;
import com.stripe.jvmcore.dagger.Files;
import com.stripe.jvmcore.dagger.Mainland;
import com.stripe.jvmcore.environment.EnvironmentKt;
import com.stripe.jvmcore.restclient.CoreTransactionRepository;
import com.stripe.jvmcore.restclient.CustomHeadersProvider;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.restclient.RestClient;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.restclient.RestTimeout;
import com.stripe.jvmcore.restclient.TransactionOpType;
import com.stripe.proto.api.rest.ActivateConnectionTokenRequest;
import com.stripe.proto.api.rest.AddEmvSecondGenerationDataRefundRequest;
import com.stripe.proto.api.rest.AddEmvSecondGenerationDataRequest;
import com.stripe.proto.api.rest.CancelPaymentIntentRequest;
import com.stripe.proto.api.rest.CancelSetupIntentRequest;
import com.stripe.proto.api.rest.ConfirmPaymentIntentRequest;
import com.stripe.proto.api.rest.ConfirmSetupIntentRequest;
import com.stripe.proto.api.rest.CreatePaymentIntentRequest;
import com.stripe.proto.api.rest.CreateSetupIntentRequest;
import com.stripe.proto.api.rest.DetachPaymentMethodRequest;
import com.stripe.proto.api.rest.DiscoverLocationsRequest;
import com.stripe.proto.api.rest.DiscoverLocationsResponse;
import com.stripe.proto.api.rest.FilesApi;
import com.stripe.proto.api.rest.ListAllReadersRequest;
import com.stripe.proto.api.rest.ListAllReadersResponse;
import com.stripe.proto.api.rest.ListLocationsRequest;
import com.stripe.proto.api.rest.ListLocationsResponse;
import com.stripe.proto.api.rest.MainlandApi;
import com.stripe.proto.api.rest.ReadCardPaymentMethodRequest;
import com.stripe.proto.api.rest.RefundChargeRequest;
import com.stripe.proto.api.rest.RetrieveLocationRequest;
import com.stripe.proto.api.rest.RetrievePaymentIntentRequest;
import com.stripe.proto.api.rest.RetrieveSetupIntentRequest;
import com.stripe.proto.api.rest.UpdatePaymentIntentRequest;
import com.stripe.proto.api.rest.UpdateSdiActionRequest;
import com.stripe.proto.api.rest.UpdateSdiActionResponse;
import com.stripe.proto.api.rest.UploadFileRequest;
import com.stripe.proto.api.rest.UploadFileResponse;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.rest.ActivatedConnectionToken;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.PaymentIntent;
import com.stripe.proto.model.rest.PaymentIntentExpandedMethod;
import com.stripe.proto.model.rest.PaymentMethod;
import com.stripe.proto.model.rest.Refund;
import com.stripe.proto.model.rest.SetupIntent;
import com.stripe.proto.model.rest.TerminalUserAgent;
import com.stripe.proto.model.rest.UserAgent;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Credentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 q2\u00020\u0001:\u0001qB1\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ2\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J0\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020(2\u0014\b\u0002\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*J0\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020-2\u0014\b\u0002\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*2\u0006\u0010/\u001a\u00020 H\u0002J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020 H\u0002J\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u000207J\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020:J6\u0010;\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020<2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*2\u0006\u0010$\u001a\u00020%J\u001a\u0010=\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020>J\"\u0010?\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020@2\u0006\u0010$\u001a\u00020%J\u001a\u0010A\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020BJ\u0014\u0010C\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*H\u0016J\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020FJ\"\u0010G\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u00103\u001a\u00020 2\u0006\u0010\"\u001a\u00020IJ\b\u0010J\u001a\u00020\u0016H\u0007J\u0010\u0010K\u001a\u00020\u00162\u0006\u00105\u001a\u00020 H\u0002J*\u0010L\u001a\u000e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u00103\u001a\u00020 2\u0006\u0010\"\u001a\u00020N2\u0006\u0010$\u001a\u00020%J\"\u0010O\u001a\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020Q2\u0006\u00103\u001a\u00020 J\u001a\u0010R\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020SJ.\u0010T\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020U2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*J\"\u0010V\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020X2\u0006\u00103\u001a\u00020 J\"\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020X2\u0006\u00105\u001a\u00020 J&\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020[2\n\b\u0002\u00103\u001a\u0004\u0018\u00010 J&\u0010\\\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020]2\n\b\u0002\u00103\u001a\u0004\u0018\u00010 J\u0006\u0010^\u001a\u00020_JL\u0010`\u001a\u00020_\"\u0012\b\u0000\u0010a*\f\u0012\u0004\u0012\u0002Ha\u0012\u0002\b\u00030b\"\u0012\b\u0001\u0010c*\f\u0012\u0004\u0012\u0002Hc\u0012\u0002\b\u00030b2\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u0002Ha\u0012\u0004\u0012\u0002Hc0\u001c2\u0006\u0010e\u001a\u00020fH\u0002J\u000e\u0010g\u001a\u00020_2\u0006\u00105\u001a\u00020 J.\u0010h\u001a\u000e\u0012\u0004\u0012\u00020i\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020j2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*J6\u0010k\u001a\u000e\u0012\u0004\u0012\u00020l\u0012\u0004\u0012\u00020\u001e0\u001c2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*2\u0006\u00105\u001a\u00020 2\u0006\u0010\"\u001a\u00020mJ\"\u0010n\u001a\u000e\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\"\u001a\u00020p2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;", "Lcom/stripe/jvmcore/restclient/CustomHeadersProvider;", "baseRestClient", "Lcom/stripe/jvmcore/restclient/RestClient;", "baseFilesRestClient", "userAgentProvider", "Ljavax/inject/Provider;", "Lcom/stripe/proto/model/rest/UserAgent;", "transactionRepository", "Lcom/stripe/jvmcore/restclient/CoreTransactionRepository;", "(Lcom/stripe/jvmcore/restclient/RestClient;Lcom/stripe/jvmcore/restclient/RestClient;Ljavax/inject/Provider;Lcom/stripe/jvmcore/restclient/CoreTransactionRepository;)V", "filesApi", "Lcom/stripe/proto/api/rest/FilesApi;", "getFilesApi", "()Lcom/stripe/proto/api/rest/FilesApi;", "setFilesApi", "(Lcom/stripe/proto/api/rest/FilesApi;)V", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "getIntegrationType", "()Lcom/stripe/jvmcore/restclient/IntegrationType;", "mainlandApi", "Lcom/stripe/proto/api/rest/MainlandApi;", "getMainlandApi", "()Lcom/stripe/proto/api/rest/MainlandApi;", "setMainlandApi", "(Lcom/stripe/proto/api/rest/MainlandApi;)V", "activateTerminal", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Lcom/stripe/proto/model/rest/ActivatedConnectionToken;", "Lcom/stripe/proto/model/rest/ErrorWrapper;", "activationToken", "", "parentTraceId", "request", "Lcom/stripe/proto/api/rest/ActivateConnectionTokenRequest;", "timeout", "Lcom/stripe/jvmcore/restclient/RestTimeout;", "addEmvSecondGenerationData", "Lcom/stripe/proto/model/rest/PaymentIntent;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRequest;", "headers", "", "addEmvSecondGenerationRefundData", "Lcom/stripe/proto/model/rest/Refund;", "Lcom/stripe/proto/api/rest/AddEmvSecondGenerationDataRefundRequest;", "authHeaders", "bearerToken", "username", "password", "buildConnectionTokenClient", "connectionToken", "buildSessionTokenClient", "sessionToken", "cancelPaymentIntent", "Lcom/stripe/proto/api/rest/CancelPaymentIntentRequest;", "cancelSetupIntent", "Lcom/stripe/proto/model/rest/SetupIntent;", "Lcom/stripe/proto/api/rest/CancelSetupIntentRequest;", "confirmPaymentIntent", "Lcom/stripe/proto/api/rest/ConfirmPaymentIntentRequest;", "confirmSetupIntent", "Lcom/stripe/proto/api/rest/ConfirmSetupIntentRequest;", "createPaymentIntent", "Lcom/stripe/proto/api/rest/CreatePaymentIntentRequest;", "createSetupIntent", "Lcom/stripe/proto/api/rest/CreateSetupIntentRequest;", "customHeaders", "detachPaymentMethod", "Lcom/stripe/proto/model/rest/PaymentMethod;", "Lcom/stripe/proto/api/rest/DetachPaymentMethodRequest;", "discoverLocations", "Lcom/stripe/proto/api/rest/DiscoverLocationsResponse;", "Lcom/stripe/proto/api/rest/DiscoverLocationsRequest;", "getMainlandApiForIntegrationMode", "getServerDrivenMainlandApi", "listAllReaders", "Lcom/stripe/proto/api/rest/ListAllReadersResponse;", "Lcom/stripe/proto/api/rest/ListAllReadersRequest;", "listLocations", "Lcom/stripe/proto/api/rest/ListLocationsResponse;", "Lcom/stripe/proto/api/rest/ListLocationsRequest;", "readCardPaymentMethod", "Lcom/stripe/proto/api/rest/ReadCardPaymentMethodRequest;", "refundCharge", "Lcom/stripe/proto/api/rest/RefundChargeRequest;", "retrieveLocation", "Lcom/stripe/proto/model/merchant/ApiLocationPb;", "Lcom/stripe/proto/api/rest/RetrieveLocationRequest;", "retrieveLocationWithSessionToken", "retrievePaymentIntent", "Lcom/stripe/proto/api/rest/RetrievePaymentIntentRequest;", "retrieveSetupIntent", "Lcom/stripe/proto/api/rest/RetrieveSetupIntentRequest;", "setBlankSession", "", "setRequestId", "M", "Lcom/squareup/wire/Message;", "E", "restResponse", "opType", "Lcom/stripe/jvmcore/restclient/TransactionOpType;", "setServerDrivenStripeSessionToken", "updatePaymentIntentExpandedMethod", "Lcom/stripe/proto/model/rest/PaymentIntentExpandedMethod;", "Lcom/stripe/proto/api/rest/UpdatePaymentIntentRequest;", "updateSdiAction", "Lcom/stripe/proto/api/rest/UpdateSdiActionResponse;", "Lcom/stripe/proto/api/rest/UpdateSdiActionRequest;", "uploadFile", "Lcom/stripe/proto/api/rest/UploadFileResponse;", "Lcom/stripe/proto/api/rest/UploadFileRequest;", "Companion", "transaction"})
public final class AuthenticatedRestClient
implements CustomHeadersProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RestClient baseRestClient;
    @NotNull
    private final RestClient baseFilesRestClient;
    @NotNull
    private final Provider<UserAgent> userAgentProvider;
    @NotNull
    private final CoreTransactionRepository transactionRepository;
    @VisibleForTesting
    @NotNull
    private MainlandApi mainlandApi;
    @VisibleForTesting
    @NotNull
    private FilesApi filesApi;
    @VisibleForTesting
    @Nullable
    private static MainlandApi serverDrivenMainlandApi;

    @Inject
    public AuthenticatedRestClient(@Mainland @NotNull RestClient baseRestClient, @Files @NotNull RestClient baseFilesRestClient, @NotNull Provider<UserAgent> userAgentProvider, @NotNull CoreTransactionRepository transactionRepository) {
        Intrinsics.checkNotNullParameter((Object)baseRestClient, (String)"baseRestClient");
        Intrinsics.checkNotNullParameter((Object)baseFilesRestClient, (String)"baseFilesRestClient");
        Intrinsics.checkNotNullParameter(userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        this.baseRestClient = baseRestClient;
        this.baseFilesRestClient = baseFilesRestClient;
        this.userAgentProvider = userAgentProvider;
        this.transactionRepository = transactionRepository;
        this.mainlandApi = new MainlandApi(this.baseRestClient);
        this.filesApi = new FilesApi(this.baseFilesRestClient);
    }

    @NotNull
    public final MainlandApi getMainlandApi() {
        return this.mainlandApi;
    }

    public final void setMainlandApi(@NotNull MainlandApi mainlandApi) {
        Intrinsics.checkNotNullParameter((Object)mainlandApi, (String)"<set-?>");
        this.mainlandApi = mainlandApi;
    }

    @NotNull
    public final FilesApi getFilesApi() {
        return this.filesApi;
    }

    public final void setFilesApi(@NotNull FilesApi filesApi) {
        Intrinsics.checkNotNullParameter((Object)filesApi, (String)"<set-?>");
        this.filesApi = filesApi;
    }

    private final IntegrationType getIntegrationType() {
        return this.transactionRepository.getIntegrationType();
    }

    public final void setServerDrivenStripeSessionToken(@NotNull String sessionToken) {
        Intrinsics.checkNotNullParameter((Object)sessionToken, (String)"sessionToken");
        UserAgent userAgent = (UserAgent)((Object)this.userAgentProvider.get());
        serverDrivenMainlandApi = this.getServerDrivenMainlandApi(sessionToken);
        RestClient.Builder builder = this.baseFilesRestClient.toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAgent), (String)"userAgent");
        this.filesApi = new FilesApi(builder.addCustomHeaders(EnvironmentKt.stripeCustomHeaders(userAgent)).addCustomHeaders(this.authHeaders(sessionToken)).build());
    }

    private final MainlandApi getServerDrivenMainlandApi(String sessionToken) {
        RestClient.Builder builder = this.baseRestClient.toBuilder();
        Object object = this.userAgentProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"userAgentProvider.get()");
        return new MainlandApi(builder.addCustomHeaders(EnvironmentKt.stripeCustomHeaders((UserAgent)((Object)object))).addCustomHeaders(this.authHeaders(sessionToken)).build());
    }

    public final void setBlankSession() {
        UserAgent userAgent = (UserAgent)((Object)this.userAgentProvider.get());
        RestClient.Builder builder = this.baseRestClient.toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAgent), (String)"userAgent");
        this.mainlandApi = new MainlandApi(builder.addCustomHeaders(EnvironmentKt.stripeCustomHeaders(userAgent)).addCustomHeaders(this.authHeaders("")).build());
    }

    @NotNull
    public final RestResponse<ActivatedConnectionToken, ErrorWrapper> activateTerminal(@NotNull String activationToken, @NotNull String parentTraceId, @NotNull ActivateConnectionTokenRequest request, @NotNull RestTimeout timeout) {
        RestResponse<ActivatedConnectionToken, ErrorWrapper> restResponse;
        Intrinsics.checkNotNullParameter((Object)activationToken, (String)"activationToken");
        Intrinsics.checkNotNullParameter((Object)parentTraceId, (String)"parentTraceId");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        TerminalUserAgent terminalUserAgent = new TerminalUserAgent(request.pos_version_info, request.pos_device_info, null, request.reader_, null, 20, null);
        UserAgent userAgent = (UserAgent)((Object)this.userAgentProvider.get());
        RestClient.Builder builder = this.baseRestClient.toBuilder().addCustomHeaders(this.authHeaders(activationToken, "")).addCustomHeaders(EnvironmentKt.stripeUserAgentHeader(terminalUserAgent));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAgent), (String)"userAgent");
        RestClient restClient = builder.addCustomHeaders(EnvironmentKt.stripeCustomHeaders(userAgent)).build();
        RestResponse<ActivatedConnectionToken, ErrorWrapper> restResponse2 = new MainlandApi(restClient).activateConnectionToken(request, EnvironmentKt.stripeTraceHeader(parentTraceId), timeout);
        if (restResponse2 instanceof RestResponse.Success) {
            this.mainlandApi = new MainlandApi(this.baseRestClient.toBuilder().addCustomHeaders(EnvironmentKt.stripeCustomHeaders(userAgent)).build());
        }
        RestResponse<ActivatedConnectionToken, ErrorWrapper> it = restResponse = restResponse2;
        boolean bl = false;
        this.setRequestId(it, TransactionOpType.ACTIVATION);
        return restResponse;
    }

    @NotNull
    public final RestResponse<PaymentIntent, ErrorWrapper> addEmvSecondGenerationData(@NotNull AddEmvSecondGenerationDataRequest request, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return MainlandApi.addEmvSecondGenerationData$default(this.getMainlandApiForIntegrationMode(), request, headers, null, 4, null);
    }

    public static /* synthetic */ RestResponse addEmvSecondGenerationData$default(AuthenticatedRestClient authenticatedRestClient, AddEmvSecondGenerationDataRequest addEmvSecondGenerationDataRequest, Map map2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return authenticatedRestClient.addEmvSecondGenerationData(addEmvSecondGenerationDataRequest, map2);
    }

    @NotNull
    public final RestResponse<Refund, ErrorWrapper> addEmvSecondGenerationRefundData(@NotNull AddEmvSecondGenerationDataRefundRequest request, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return MainlandApi.addEmvSecondGenerationRefundData$default(this.getMainlandApiForIntegrationMode(), request, headers, null, 4, null);
    }

    public static /* synthetic */ RestResponse addEmvSecondGenerationRefundData$default(AuthenticatedRestClient authenticatedRestClient, AddEmvSecondGenerationDataRefundRequest addEmvSecondGenerationDataRefundRequest, Map map2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return authenticatedRestClient.addEmvSecondGenerationRefundData(addEmvSecondGenerationDataRefundRequest, map2);
    }

    @NotNull
    public final RestResponse<PaymentIntent, ErrorWrapper> cancelPaymentIntent(@NotNull CancelPaymentIntentRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return MainlandApi.cancelPaymentIntent$default(this.getMainlandApiForIntegrationMode(), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<PaymentIntent, ErrorWrapper> confirmPaymentIntent(@NotNull ConfirmPaymentIntentRequest request, @NotNull Map<String, String> headers, @NotNull RestTimeout timeout) {
        RestResponse<PaymentIntent, ErrorWrapper> restResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        RestResponse<PaymentIntent, ErrorWrapper> it = restResponse = this.getMainlandApiForIntegrationMode().confirmPaymentIntent(request, headers, timeout);
        boolean bl = false;
        this.setRequestId(it, TransactionOpType.CONFIRM_PAYMENT_INTENT);
        return restResponse;
    }

    @NotNull
    public final RestResponse<PaymentIntentExpandedMethod, ErrorWrapper> updatePaymentIntentExpandedMethod(@NotNull UpdatePaymentIntentRequest request, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return MainlandApi.updatePaymentIntentExpandMethod$default(this.getMainlandApiForIntegrationMode(), request, headers, null, 4, null);
    }

    @NotNull
    public final RestResponse<SetupIntent, ErrorWrapper> confirmSetupIntent(@NotNull ConfirmSetupIntentRequest request) {
        RestResponse restResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        RestResponse it = restResponse = MainlandApi.confirmSetupIntent$default(this.getMainlandApiForIntegrationMode(), request, null, null, 6, null);
        boolean bl = false;
        this.setRequestId(it, TransactionOpType.CONFIRM_SETUP_INTENT);
        return restResponse;
    }

    @NotNull
    public final RestResponse<SetupIntent, ErrorWrapper> cancelSetupIntent(@NotNull CancelSetupIntentRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return MainlandApi.cancelSetupIntent$default(this.getMainlandApiForIntegrationMode(), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<SetupIntent, ErrorWrapper> retrieveSetupIntent(@NotNull RetrieveSetupIntentRequest request, @Nullable String connectionToken) {
        RestResponse restResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        if (connectionToken != null) {
            RestClient restClient = this.buildConnectionTokenClient(connectionToken);
            restResponse = MainlandApi.retrieveSetupIntent$default(new MainlandApi(restClient), request, null, null, 6, null);
        } else {
            restResponse = MainlandApi.retrieveSetupIntent$default(this.getMainlandApiForIntegrationMode(), RetrieveSetupIntentRequest.copy$default(request, null, null, null, null, 11, null), null, null, 6, null);
        }
        return restResponse;
    }

    public static /* synthetic */ RestResponse retrieveSetupIntent$default(AuthenticatedRestClient authenticatedRestClient, RetrieveSetupIntentRequest retrieveSetupIntentRequest, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return authenticatedRestClient.retrieveSetupIntent(retrieveSetupIntentRequest, string);
    }

    @NotNull
    public final RestResponse<PaymentIntent, ErrorWrapper> createPaymentIntent(@NotNull CreatePaymentIntentRequest request, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return MainlandApi.createPaymentIntent$default(this.getMainlandApiForIntegrationMode(), request, null, timeout, 2, null);
    }

    @NotNull
    public final RestResponse<SetupIntent, ErrorWrapper> createSetupIntent(@NotNull CreateSetupIntentRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return MainlandApi.createSetupIntent$default(this.getMainlandApiForIntegrationMode(), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<PaymentMethod, ErrorWrapper> detachPaymentMethod(@NotNull DetachPaymentMethodRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return MainlandApi.detachPaymentMethod$default(this.getMainlandApiForIntegrationMode(), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<DiscoverLocationsResponse, ErrorWrapper> discoverLocations(@NotNull String connectionToken, @NotNull DiscoverLocationsRequest request) {
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        RestClient restClient = this.buildConnectionTokenClient(connectionToken);
        return MainlandApi.discoverLocations$default(new MainlandApi(restClient), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<ListAllReadersResponse, ErrorWrapper> listAllReaders(@NotNull String connectionToken, @NotNull ListAllReadersRequest request, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        RestClient restClient = this.buildConnectionTokenClient(connectionToken);
        return MainlandApi.listAllReaders$default(new MainlandApi(restClient), request, null, timeout, 2, null);
    }

    @NotNull
    public final RestResponse<PaymentMethod, ErrorWrapper> readCardPaymentMethod(@NotNull ReadCardPaymentMethodRequest request) {
        RestResponse restResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        RestResponse it = restResponse = MainlandApi.readCardPaymentMethod$default(this.getMainlandApiForIntegrationMode(), request, null, null, 6, null);
        boolean bl = false;
        this.setRequestId(it, TransactionOpType.CONFIRM_REUSABLE_CARD);
        return restResponse;
    }

    @NotNull
    public final RestResponse<Refund, ErrorWrapper> refundCharge(@NotNull RefundChargeRequest request, @NotNull Map<String, String> headers) {
        RestResponse restResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        RestResponse it = restResponse = MainlandApi.refundCharge$default(this.getMainlandApiForIntegrationMode(), request, headers, null, 4, null);
        boolean bl = false;
        this.setRequestId(it, TransactionOpType.CONFIRM_INTERAC_REFUND);
        return restResponse;
    }

    @NotNull
    public final RestResponse<ListLocationsResponse, ErrorWrapper> listLocations(@NotNull ListLocationsRequest request, @NotNull String connectionToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        RestClient restClient = this.buildConnectionTokenClient(connectionToken);
        return MainlandApi.listLocations$default(new MainlandApi(restClient), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<ApiLocationPb, ErrorWrapper> retrieveLocation(@NotNull RetrieveLocationRequest request, @NotNull String connectionToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        RestClient restClient = this.buildConnectionTokenClient(connectionToken);
        return MainlandApi.retrieveLocation$default(new MainlandApi(restClient), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<ApiLocationPb, ErrorWrapper> retrieveLocationWithSessionToken(@NotNull RetrieveLocationRequest request, @NotNull String sessionToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)sessionToken, (String)"sessionToken");
        RestClient restClient = this.buildSessionTokenClient(sessionToken);
        return MainlandApi.retrieveLocation$default(new MainlandApi(restClient), request, null, null, 6, null);
    }

    @NotNull
    public final RestResponse<UpdateSdiActionResponse, ErrorWrapper> updateSdiAction(@NotNull Map<String, String> headers, @NotNull String sessionToken, @NotNull UpdateSdiActionRequest request) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)sessionToken, (String)"sessionToken");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return MainlandApi.updateSdiAction$default(this.getServerDrivenMainlandApi(sessionToken), request, headers, null, 4, null);
    }

    @NotNull
    public final RestResponse<PaymentIntent, ErrorWrapper> retrievePaymentIntent(@NotNull RetrievePaymentIntentRequest request, @Nullable String connectionToken) {
        RestResponse restResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        if (connectionToken != null) {
            RestClient restClient = this.buildConnectionTokenClient(connectionToken);
            restResponse = MainlandApi.retrievePaymentIntent$default(new MainlandApi(restClient), request, null, null, 6, null);
        } else {
            restResponse = MainlandApi.retrievePaymentIntent$default(this.getMainlandApiForIntegrationMode(), RetrievePaymentIntentRequest.copy$default(request, null, null, null, null, 11, null), null, null, 6, null);
        }
        return restResponse;
    }

    public static /* synthetic */ RestResponse retrievePaymentIntent$default(AuthenticatedRestClient authenticatedRestClient, RetrievePaymentIntentRequest retrievePaymentIntentRequest, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return authenticatedRestClient.retrievePaymentIntent(retrievePaymentIntentRequest, string);
    }

    @NotNull
    public final RestResponse<UploadFileResponse, ErrorWrapper> uploadFile(@NotNull UploadFileRequest request, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return FilesApi.uploadFile$default(this.filesApi, request, null, timeout, 2, null);
    }

    @VisibleForTesting
    @NotNull
    public final MainlandApi getMainlandApiForIntegrationMode() {
        if (this.getIntegrationType() == IntegrationType.SERVER_DRIVEN) {
            MainlandApi mainlandApi = serverDrivenMainlandApi;
            if (mainlandApi == null) {
                mainlandApi = this.mainlandApi;
            }
            return mainlandApi;
        }
        return this.mainlandApi;
    }

    @Override
    @NotNull
    public Map<String, String> customHeaders() {
        return this.getMainlandApiForIntegrationMode().getClient().customHeaders();
    }

    private final RestClient buildConnectionTokenClient(String connectionToken) {
        return this.baseRestClient.toBuilder().addCustomHeaders(this.authHeaders(connectionToken)).build();
    }

    private final Map<String, String> authHeaders(String bearerToken) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + bearerToken)));
    }

    private final RestClient buildSessionTokenClient(String sessionToken) {
        RestClient.Builder builder = this.baseRestClient.toBuilder().addCustomHeaders(this.authHeaders(sessionToken, ""));
        Object object = this.userAgentProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"userAgentProvider.get()");
        return builder.addCustomHeaders(EnvironmentKt.stripeCustomHeaders((UserAgent)((Object)object))).build();
    }

    private final Map<String, String> authHeaders(String username, String password) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)Credentials.basic$default((String)username, (String)password, null, (int)4, null)));
    }

    private final <M extends Message<M, ?>, E extends Message<E, ?>> void setRequestId(RestResponse<M, E> restResponse, TransactionOpType opType) {
        if (restResponse instanceof RestResponse.Success) {
            String string = restResponse.getHeaders().get("request-id");
            if (string == null) {
                string = "";
            }
            this.transactionRepository.setRequestId(opType, string);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient$Companion;", "", "()V", "serverDrivenMainlandApi", "Lcom/stripe/proto/api/rest/MainlandApi;", "getServerDrivenMainlandApi", "()Lcom/stripe/proto/api/rest/MainlandApi;", "setServerDrivenMainlandApi", "(Lcom/stripe/proto/api/rest/MainlandApi;)V", "transaction"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MainlandApi getServerDrivenMainlandApi() {
            return serverDrivenMainlandApi;
        }

        public final void setServerDrivenMainlandApi(@Nullable MainlandApi mainlandApi) {
            serverDrivenMainlandApi = mainlandApi;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

