/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.restclient;

import com.stripe.jvmcore.restclient.CustomHeadersProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/jvmcore/restclient/CustomHeadersInterceptor;", "Lokhttp3/Interceptor;", "Lcom/stripe/jvmcore/restclient/CustomHeadersProvider;", "customHeaders", "", "", "(Ljava/util/Map;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "base"})
public final class CustomHeadersInterceptor
implements Interceptor,
CustomHeadersProvider {
    @NotNull
    private final Map<String, String> customHeaders;

    public CustomHeadersInterceptor(@NotNull Map<String, String> customHeaders) {
        Intrinsics.checkNotNullParameter(customHeaders, (String)"customHeaders");
        this.customHeaders = customHeaders;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request.Builder requestBuilder = chain.request().newBuilder();
        for (Map.Entry<String, String> entry : this.customHeaders.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            requestBuilder.header(name, value);
        }
        return chain.proceed(requestBuilder.build());
    }

    @Override
    @NotNull
    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }
}

