/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.restclient;

import com.squareup.wire.Message;
import com.stripe.jvmcore.restclient.RestInterceptor;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.restclient.RestTimeout;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u001c\b\u0000\u0010\u0001*\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003*\u001c\b\u0001\u0010\u0004*\u0016\u0012\u0004\u0012\u0002H\u0004\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0004`\u0003*\u001c\b\u0002\u0010\u0005*\u0016\u0012\u0004\u0012\u0002H\u0005\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0005`\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0006BY\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00028\u0000\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00028\u0002\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0014\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0001\u00a2\u0006\u0002\b\u001cJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\r\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0014\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/stripe/jvmcore/restclient/InterceptorChain;", "Rq", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "Rsp", "Err", "Lcom/stripe/jvmcore/restclient/RestInterceptor$Chain;", "interceptors", "", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "index", "", "service", "", "method", "request", "Lokhttp3/Request;", "requestProto", "responseProtoType", "Ljava/lang/Class;", "error", "timeout", "Lcom/stripe/jvmcore/restclient/RestTimeout;", "(Ljava/util/List;ILjava/lang/String;Ljava/lang/String;Lokhttp3/Request;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestTimeout;)V", "Lcom/squareup/wire/Message;", "getTimeout", "()Lcom/stripe/jvmcore/restclient/RestTimeout;", "()Lcom/squareup/wire/Message;", "interceptors$base", "proceed", "Lcom/stripe/jvmcore/restclient/RestResponse;", "rpcRequest", "base"})
@SourceDebugExtension(value={"SMAP\nInterceptorChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterceptorChain.kt\ncom/stripe/jvmcore/restclient/InterceptorChain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class InterceptorChain<Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>>
implements RestInterceptor.Chain<Rq, Rsp, Err> {
    @NotNull
    private final List<RestInterceptor> interceptors;
    private final int index;
    @NotNull
    private final String service;
    @NotNull
    private final String method;
    @NotNull
    private final Request request;
    @NotNull
    private final Rq requestProto;
    @NotNull
    private final Class<Rsp> responseProtoType;
    @NotNull
    private final Err error;
    @NotNull
    private final RestTimeout timeout;

    public InterceptorChain(@NotNull List<? extends RestInterceptor> interceptors, int index, @NotNull String service, @NotNull String method, @NotNull Request request, @NotNull Rq requestProto, @NotNull Class<Rsp> responseProtoType, @NotNull Err error, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(requestProto, (String)"requestProto");
        Intrinsics.checkNotNullParameter(responseProtoType, (String)"responseProtoType");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.interceptors = interceptors;
        this.index = index;
        this.service = service;
        this.method = method;
        this.request = request;
        this.requestProto = requestProto;
        this.responseProtoType = responseProtoType;
        this.error = error;
        this.timeout = timeout;
        if (!(!((Collection)this.interceptors).isEmpty())) {
            boolean $i$a$-check-InterceptorChain$32 = false;
            String $i$a$-check-InterceptorChain$32 = "Interceptors in chain must not be empty";
            throw new IllegalStateException($i$a$-check-InterceptorChain$32.toString());
        }
        if (!(this.index >= 0)) {
            boolean bl = false;
            String string = "Invalid index " + this.index + ", must be greater than zero.";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public RestTimeout getTimeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public RestResponse<Rsp, Err> proceed(@NotNull Request request) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(this.index < this.interceptors.size())) {
            boolean $i$a$-check-InterceptorChain$proceed$22 = false;
            String $i$a$-check-InterceptorChain$proceed$22 = "index " + this.index + " does not map to an interceptor";
            throw new IllegalStateException($i$a$-check-InterceptorChain$proceed$22.toString());
        }
        InterceptorChain<Rq, Rsp, Err> next = new InterceptorChain<Rq, Rsp, Err>(this.interceptors, this.index + 1, this.service, this.method, request, this.requestProto, this.responseProtoType, this.error, this.getTimeout());
        RestInterceptor interceptor = this.interceptors.get(this.index);
        return interceptor.intercept(next);
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    @Override
    @NotNull
    public String method() {
        return this.method;
    }

    @Override
    @NotNull
    public String service() {
        return this.service;
    }

    @Override
    @NotNull
    public Rq rpcRequest() {
        return this.requestProto;
    }

    @Override
    @NotNull
    public Err error() {
        return this.error;
    }

    @Override
    @NotNull
    public Class<Rsp> responseProtoType() {
        return this.responseProtoType;
    }

    @VisibleForTesting
    @NotNull
    public final List<RestInterceptor> interceptors$base() {
        return this.interceptors;
    }
}

