/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.restclient;

import com.squareup.moshi.Moshi;
import com.squareup.wire.Message;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.redaction.CustomMessageRedactor;
import com.stripe.jvmcore.redaction.ResourceIdRedactor;
import com.stripe.jvmcore.restclient.RestInterceptor;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.restclient.RestTimeout;
import com.stripe.proto.model.rest.StatusCode;
import java.io.Closeable;
import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0088\u0001\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\u001c\b\u0000\u0010\u0013*\u0016\u0012\u0004\u0012\u0002H\u0013\u0012\u0002\b\u00030\u0014j\b\u0012\u0004\u0012\u0002H\u0013`\u0015\"\u001c\b\u0001\u0010\u0011*\u0016\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u0014j\b\u0012\u0004\u0012\u0002H\u0011`\u0015\"\u001c\b\u0002\u0010\u0012*\u0016\u0012\u0004\u0012\u0002H\u0012\u0012\u0002\b\u00030\u0014j\b\u0012\u0004\u0012\u0002H\u0012`\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/stripe/jvmcore/restclient/RequestSendInterceptor;", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "client", "Lokhttp3/OkHttpClient;", "moshi", "Lcom/squareup/moshi/Moshi;", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lokhttp3/OkHttpClient;Lcom/squareup/moshi/Moshi;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "name", "", "getName", "()Ljava/lang/String;", "intercept", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Rsp", "Err", "Rq", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "chain", "Lcom/stripe/jvmcore/restclient/RestInterceptor$Chain;", "base"})
public final class RequestSendInterceptor
extends RestInterceptor {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Moshi moshi;
    @Nullable
    private final CustomMessageRedactor customMessageRedactor;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final String name;

    public RequestSendInterceptor(@NotNull OkHttpClient client, @NotNull Moshi moshi2, @Nullable CustomMessageRedactor customMessageRedactor, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.client = client;
        this.moshi = moshi2;
        this.customMessageRedactor = customMessageRedactor;
        this.logWriter = logWriter;
        this.name = "requestSendInterceptor";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> intercept(@NotNull RestInterceptor.Chain<Rq, Rsp, Err> chain) {
        Object object;
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        RestTimeout t2 = chain.getTimeout();
        OkHttpClient okHttpClient = t2 instanceof RestTimeout.Specified ? this.client.newBuilder().connectTimeout(((RestTimeout.Specified)t2).getTimeout_ms(), TimeUnit.MILLISECONDS).readTimeout(((RestTimeout.Specified)t2).getTimeout_ms(), TimeUnit.MILLISECONDS).build() : this.client;
        try {
            object = (Closeable)okHttpClient.newCall(chain.request()).execute();
            Throwable throwable = null;
            try {
                Object it = (Response)object;
                boolean bl = false;
                it = RestResponse.Companion.toRestResponse((Response)it, this.moshi, chain.responseProtoType(), chain.error(), this.customMessageRedactor, this.logWriter);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it;
        }
        catch (IOException e2) {
            this.logWriter.e("RequestSendInterceptor", "IOException in REST Call: " + e2.getMessage(), e2);
            String redactedUrl = new HttpUrl.Builder().scheme(chain.request().url().scheme()).host(chain.request().url().host()).addPathSegments(StringsKt.removePrefix((String)new ResourceIdRedactor(chain.request().url().encodedPath()).redact(), (CharSequence)"/")).build().toString();
            object = new RestResponse.ServerError(chain.error(), StatusCode.HTTP_ERROR_UNKNOWN_STATE, redactedUrl, null, this.moshi, this.customMessageRedactor, new TreeMap<String, String>());
        }
        Closeable response = object;
        return response;
    }
}

