/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.restclient;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.wire.Message;
import com.squareup.wire.WireJsonAdapterFactory;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.redaction.CustomMessageRedactor;
import com.stripe.jvmcore.restclient.CustomHeadersInterceptor;
import com.stripe.jvmcore.restclient.CustomHeadersProvider;
import com.stripe.jvmcore.restclient.IdempotencyGenerator;
import com.stripe.jvmcore.restclient.IdempotencyHeader;
import com.stripe.jvmcore.restclient.IdempotencyInterceptor;
import com.stripe.jvmcore.restclient.InterceptorChain;
import com.stripe.jvmcore.restclient.RequestSendInterceptor;
import com.stripe.jvmcore.restclient.RestClient;
import com.stripe.jvmcore.restclient.RestInterceptor;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.restclient.RestTimeout;
import com.stripe.jvmcore.traffictype.TrafficType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002?@B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u00cb\u0001\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u001c\b\u0000\u0010\u0019*\u0016\u0012\u0004\u0012\u0002H\u0019\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0019`\u001b\"\u001c\b\u0001\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0017`\u001b\"\u001c\b\u0002\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0018`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010$\u001a\u0002H\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&2\u0006\u0010'\u001a\u0002H\u00182\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*J\u00cb\u0001\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u001c\b\u0000\u0010\u0019*\u0016\u0012\u0004\u0012\u0002H\u0019\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0019`\u001b\"\u001c\b\u0001\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0017`\u001b\"\u001c\b\u0002\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0018`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010$\u001a\u0002H\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&2\u0006\u0010'\u001a\u0002H\u00182\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010.J\u00cb\u0001\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u001c\b\u0000\u0010\u0019*\u0016\u0012\u0004\u0012\u0002H\u0019\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0019`\u001b\"\u001c\b\u0001\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0017`\u001b\"\u001c\b\u0002\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0018`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00100\u001a\u0002012\u0006\u0010!\u001a\u00020\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010$\u001a\u0002H\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&2\u0006\u0010'\u001a\u0002H\u00182\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u00102J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#H\u0016J\u00b1\u0001\u00103\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u001c\b\u0000\u0010\u0019*\u0016\u0012\u0004\u0012\u0002H\u0019\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0019`\u001b\"\u001c\b\u0001\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0017`\u001b\"\u001c\b\u0002\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0018`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00104\u001a\u0002052\u0006\u0010$\u001a\u0002H\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&2\u0006\u0010'\u001a\u0002H\u00182\u0006\u0010(\u001a\u00020)H\u0002\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020\u001dH\u0007J\b\u00108\u001a\u00020\bH\u0007J\b\u00109\u001a\u00020\u000fH\u0007J\u00cd\u0001\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u001c\b\u0000\u0010\u0019*\u0016\u0012\u0004\u0012\u0002H\u0019\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0019`\u001b\"\u001c\b\u0001\u0010\u0017*\u0016\u0012\u0004\u0012\u0002H\u0017\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0017`\u001b\"\u001c\b\u0002\u0010\u0018*\u0016\u0012\u0004\u0012\u0002H\u0018\u0012\u0002\b\u00030\u001aj\b\u0012\u0004\u0012\u0002H\u0018`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020<2\u0006\u0010!\u001a\u00020\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010$\u001a\u0002H\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&2\u0006\u0010'\u001a\u0002H\u00182\u0006\u0010(\u001a\u00020)H\u0002\u00a2\u0006\u0002\u0010=J\u0006\u0010>\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/stripe/jvmcore/restclient/RestClient;", "Lcom/stripe/jvmcore/restclient/CustomHeadersProvider;", "builder", "Lcom/stripe/jvmcore/restclient/RestClient$Builder;", "(Lcom/stripe/jvmcore/restclient/RestClient$Builder;)V", "baseUrlProvider", "Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;", "client", "Lokhttp3/OkHttpClient;", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "customRestInterceptors", "", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "requestSendInterceptor", "Lcom/stripe/jvmcore/restclient/RequestSendInterceptor;", "blockingGet", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Rsp", "Err", "Rq", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "service", "", "method", "urlBuilder", "Lokhttp3/HttpUrl$Builder;", "path", "customHeaders", "", "requestProto", "responseProtoType", "Ljava/lang/Class;", "error", "timeout", "Lcom/stripe/jvmcore/restclient/RestTimeout;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/HttpUrl$Builder;Ljava/lang/String;Ljava/util/Map;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestTimeout;)Lcom/stripe/jvmcore/restclient/RestResponse;", "blockingMultipartPost", "multipartBuilder", "Lokhttp3/MultipartBody$Builder;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/MultipartBody$Builder;Ljava/lang/String;Ljava/util/Map;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestTimeout;)Lcom/stripe/jvmcore/restclient/RestResponse;", "blockingPost", "formBuilder", "Lokhttp3/FormBody$Builder;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/FormBody$Builder;Ljava/lang/String;Ljava/util/Map;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestTimeout;)Lcom/stripe/jvmcore/restclient/RestResponse;", "execute", "request", "Lokhttp3/Request;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/Request;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestTimeout;)Lcom/stripe/jvmcore/restclient/RestResponse;", "getBaseUrl", "getHttpClient", "getLogWriter", "postHelper", "requestBody", "Lokhttp3/RequestBody;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/RequestBody;Ljava/lang/String;Ljava/util/Map;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/restclient/RestTimeout;)Lcom/stripe/jvmcore/restclient/RestResponse;", "toBuilder", "BaseUrlProvider", "Builder", "base"})
@SourceDebugExtension(value={"SMAP\nRestClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestClient.kt\ncom/stripe/jvmcore/restclient/RestClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n800#2,11:276\n1789#2,3:287\n*S KotlinDebug\n*F\n+ 1 RestClient.kt\ncom/stripe/jvmcore/restclient/RestClient\n*L\n168#1:276,11\n169#1:287,3\n*E\n"})
public final class RestClient
implements CustomHeadersProvider {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final BaseUrlProvider baseUrlProvider;
    @NotNull
    private final Set<RestInterceptor> customRestInterceptors;
    private final Moshi moshi;
    @Nullable
    private final CustomMessageRedactor customMessageRedactor;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final RequestSendInterceptor requestSendInterceptor;

    public RestClient(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = builder.getClientBuilder$base().build();
        this.baseUrlProvider = builder.getBaseUrlProvider$base();
        this.customRestInterceptors = builder.getCustomApplicationInterceptors$base();
        Moshi moshi2 = builder.getMoshi$base();
        if (moshi2 == null) {
            moshi2 = new Moshi.Builder().add((JsonAdapter.Factory)new WireJsonAdapterFactory(null, false, 3, null)).build();
        }
        this.moshi = moshi2;
        this.customMessageRedactor = builder.getCustomMessageRedactor$base();
        this.logWriter = builder.getLogWriter$base();
        Moshi moshi3 = this.moshi;
        Intrinsics.checkNotNullExpressionValue((Object)moshi3, (String)"moshi");
        this.requestSendInterceptor = new RequestSendInterceptor(this.client, moshi3, builder.getCustomMessageRedactor$base(), builder.getLogWriter$base());
    }

    @TestOnly
    @NotNull
    public final OkHttpClient getHttpClient() {
        return this.client;
    }

    @TestOnly
    @NotNull
    public final LogWriter getLogWriter() {
        return this.logWriter;
    }

    @TestOnly
    @NotNull
    public final String getBaseUrl() {
        return this.baseUrlProvider.getBaseUrl();
    }

    @NotNull
    public final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> blockingPost(@NotNull String service, @NotNull String method, @NotNull FormBody.Builder formBuilder, @NotNull String path, @NotNull Map<String, String> customHeaders, @NotNull Rq requestProto, @NotNull Class<Rsp> responseProtoType, @NotNull Err error, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)formBuilder, (String)"formBuilder");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(customHeaders, (String)"customHeaders");
        Intrinsics.checkNotNullParameter(requestProto, (String)"requestProto");
        Intrinsics.checkNotNullParameter(responseProtoType, (String)"responseProtoType");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.postHelper(service, method, (RequestBody)formBuilder.build(), path, customHeaders, requestProto, responseProtoType, error, timeout);
    }

    @NotNull
    public final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> blockingMultipartPost(@NotNull String service, @NotNull String method, @NotNull MultipartBody.Builder multipartBuilder, @NotNull String path, @NotNull Map<String, String> customHeaders, @NotNull Rq requestProto, @NotNull Class<Rsp> responseProtoType, @NotNull Err error, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)multipartBuilder, (String)"multipartBuilder");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(customHeaders, (String)"customHeaders");
        Intrinsics.checkNotNullParameter(requestProto, (String)"requestProto");
        Intrinsics.checkNotNullParameter(responseProtoType, (String)"responseProtoType");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return this.postHelper(service, method, (RequestBody)multipartBuilder.build(), path, customHeaders, requestProto, responseProtoType, error, timeout);
    }

    private final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> postHelper(String service, String method, RequestBody requestBody, String path, Map<String, String> customHeaders, Rq requestProto, Class<Rsp> responseProtoType, Err error, RestTimeout timeout) {
        HttpUrl url = HttpUrl.Companion.get(this.baseUrlProvider.getBaseUrl()).newBuilder().addPathSegments(path).build();
        Request request = new Request.Builder().url(url).post(requestBody).headers(Headers.Companion.of(customHeaders)).tag(TrafficType.class, (Object)TrafficType.Rest.INSTANCE).build();
        return this.execute(service, method, request, requestProto, responseProtoType, error, timeout);
    }

    @NotNull
    public final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> blockingGet(@NotNull String service, @NotNull String method, @NotNull HttpUrl.Builder urlBuilder, @NotNull String path, @NotNull Map<String, String> customHeaders, @NotNull Rq requestProto, @NotNull Class<Rsp> responseProtoType, @NotNull Err error, @NotNull RestTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(customHeaders, (String)"customHeaders");
        Intrinsics.checkNotNullParameter(requestProto, (String)"requestProto");
        Intrinsics.checkNotNullParameter(responseProtoType, (String)"responseProtoType");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        HttpUrl baseUrl = HttpUrl.Companion.get(this.baseUrlProvider.getBaseUrl());
        HttpUrl url = urlBuilder.scheme(baseUrl.scheme()).host(baseUrl.host()).port(baseUrl.port()).addPathSegments(path).build();
        Request request = new Request.Builder().url(url).get().headers(Headers.Companion.of(customHeaders)).tag(TrafficType.class, (Object)TrafficType.Rest.INSTANCE).build();
        return this.execute(service, method, request, requestProto, responseProtoType, error, timeout);
    }

    private final <Rq extends Message<Rq, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> RestResponse<Rsp, Err> execute(String service, String method, Request request, Rq requestProto, Class<Rsp> responseProtoType, Err error, RestTimeout timeout) {
        InterceptorChain<Rq, Rsp, Err> chain = new InterceptorChain<Rq, Rsp, Err>(CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)this.customRestInterceptors), (Object)this.requestSendInterceptor), 0, service, method, request, requestProto, responseProtoType, error, timeout);
        return chain.proceed(request);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> customHeaders() {
        void $this$fold$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.client.interceptors();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CustomHeadersProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void provider;
            Object element$iv$iv;
            element$iv$iv = (CustomHeadersProvider)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = MapsKt.plus((Map)acc, provider.customHeaders());
        }
        return accumulator$iv;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this, this.customMessageRedactor, this.logWriter);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;", "", "getBaseUrl", "", "base"})
    public static interface BaseUrlProvider {
        @NotNull
        public String getBaseUrl();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010'\u001a\u00020\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0)J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0017J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010-\u001a\u00020\u0003J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0000J\u000e\u00102\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u00106\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010/\u001a\u000200R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006;"}, d2={"Lcom/stripe/jvmcore/restclient/RestClient$Builder;", "", "client", "Lcom/stripe/jvmcore/restclient/RestClient;", "restRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lcom/stripe/jvmcore/restclient/RestClient;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "Lokhttp3/OkHttpClient;", "baseUrlProvider", "Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;", "(Lokhttp3/OkHttpClient;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Lcom/stripe/jvmcore/logwriter/LogWriter;Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;)V", "getBaseUrlProvider$base", "()Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;", "setBaseUrlProvider$base", "(Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;)V", "clientBuilder", "Lokhttp3/OkHttpClient$Builder;", "getClientBuilder$base", "()Lokhttp3/OkHttpClient$Builder;", "customApplicationInterceptors", "", "Lcom/stripe/jvmcore/restclient/RestInterceptor;", "getCustomApplicationInterceptors$base", "()Ljava/util/Set;", "customMessageRedactor", "getCustomMessageRedactor$base", "()Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "setCustomMessageRedactor$base", "(Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;)V", "getLogWriter$base", "()Lcom/stripe/jvmcore/logwriter/LogWriter;", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi$base", "()Lcom/squareup/moshi/Moshi;", "setMoshi$base", "(Lcom/squareup/moshi/Moshi;)V", "addCustomHeaders", "customHeaders", "", "", "addCustomRestInterceptor", "interceptor", "build", "callTimeout", "seconds", "", "clearCustomHeaders", "connectTimeout", "idempotencyKeyGeneration", "generator", "Lcom/stripe/jvmcore/restclient/IdempotencyGenerator;", "readTimeout", "retryOnConnectionFailure", "retry", "", "writeTimeout", "base"})
    @SourceDebugExtension(value={"SMAP\nRestClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestClient.kt\ncom/stripe/jvmcore/restclient/RestClient$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
    public static final class Builder {
        @NotNull
        private BaseUrlProvider baseUrlProvider;
        @Nullable
        private Moshi moshi;
        @NotNull
        private final OkHttpClient.Builder clientBuilder;
        @NotNull
        private final Set<RestInterceptor> customApplicationInterceptors;
        @Nullable
        private CustomMessageRedactor customMessageRedactor;
        @NotNull
        private final LogWriter logWriter;

        public Builder(@NotNull OkHttpClient client, @Nullable CustomMessageRedactor restRedactor, @NotNull LogWriter logWriter, @NotNull BaseUrlProvider baseUrlProvider) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
            Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"baseUrlProvider");
            this.baseUrlProvider = baseUrlProvider;
            this.clientBuilder = client.newBuilder();
            this.customApplicationInterceptors = new LinkedHashSet();
            this.customMessageRedactor = restRedactor;
            this.logWriter = logWriter;
        }

        public /* synthetic */ Builder(OkHttpClient okHttpClient, CustomMessageRedactor customMessageRedactor, LogWriter logWriter, BaseUrlProvider baseUrlProvider, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                customMessageRedactor = null;
            }
            this(okHttpClient, customMessageRedactor, logWriter, baseUrlProvider);
        }

        @NotNull
        public final BaseUrlProvider getBaseUrlProvider$base() {
            return this.baseUrlProvider;
        }

        public final void setBaseUrlProvider$base(@NotNull BaseUrlProvider baseUrlProvider) {
            Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"<set-?>");
            this.baseUrlProvider = baseUrlProvider;
        }

        @Nullable
        public final Moshi getMoshi$base() {
            return this.moshi;
        }

        public final void setMoshi$base(@Nullable Moshi moshi2) {
            this.moshi = moshi2;
        }

        @NotNull
        public final OkHttpClient.Builder getClientBuilder$base() {
            return this.clientBuilder;
        }

        @NotNull
        public final Set<RestInterceptor> getCustomApplicationInterceptors$base() {
            return this.customApplicationInterceptors;
        }

        @Nullable
        public final CustomMessageRedactor getCustomMessageRedactor$base() {
            return this.customMessageRedactor;
        }

        public final void setCustomMessageRedactor$base(@Nullable CustomMessageRedactor customMessageRedactor) {
            this.customMessageRedactor = customMessageRedactor;
        }

        @NotNull
        public final LogWriter getLogWriter$base() {
            return this.logWriter;
        }

        public Builder(@NotNull RestClient client, @Nullable CustomMessageRedactor restRedactor, @NotNull LogWriter logWriter) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
            this(client.client, restRedactor, logWriter, client.baseUrlProvider);
            CollectionsKt.addAll((Collection)this.customApplicationInterceptors, (Iterable)client.customRestInterceptors);
            this.moshi = client.moshi;
        }

        @NotNull
        public final Builder addCustomHeaders(@NotNull Map<String, String> customHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(customHeaders, (String)"customHeaders");
            Builder $this$addCustomHeaders_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addCustomHeaders_u24lambda_u240.clientBuilder.addInterceptor((Interceptor)new CustomHeadersInterceptor(customHeaders));
            return builder;
        }

        @NotNull
        public final Builder clearCustomHeaders() {
            Builder builder;
            Builder $this$clearCustomHeaders_u24lambda_u241 = builder = this;
            boolean bl = false;
            CollectionsKt.removeAll((List)$this$clearCustomHeaders_u24lambda_u241.clientBuilder.interceptors(), (Function1)clearCustomHeaders.1.1.INSTANCE);
            return builder;
        }

        @NotNull
        public final Builder idempotencyKeyGeneration(@NotNull IdempotencyGenerator generator) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Builder $this$idempotencyKeyGeneration_u24lambda_u242 = builder = this;
            boolean bl = false;
            CollectionsKt.removeAll((List)$this$idempotencyKeyGeneration_u24lambda_u242.clientBuilder.interceptors(), (Function1)idempotencyKeyGeneration.1.1.INSTANCE);
            $this$idempotencyKeyGeneration_u24lambda_u242.clientBuilder.addInterceptor((Interceptor)new IdempotencyInterceptor(new IdempotencyHeader(generator)));
            return builder;
        }

        @NotNull
        public final Builder callTimeout(long seconds) {
            Builder builder;
            Builder $this$callTimeout_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$callTimeout_u24lambda_u243.clientBuilder.callTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder connectTimeout(long seconds) {
            Builder builder;
            Builder $this$connectTimeout_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$connectTimeout_u24lambda_u244.clientBuilder.callTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder readTimeout(long seconds) {
            Builder builder;
            Builder $this$readTimeout_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$readTimeout_u24lambda_u245.clientBuilder.readTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder writeTimeout(long seconds) {
            Builder builder;
            Builder $this$writeTimeout_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$writeTimeout_u24lambda_u246.clientBuilder.writeTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder retryOnConnectionFailure(boolean retry) {
            Builder builder;
            Builder $this$retryOnConnectionFailure_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$retryOnConnectionFailure_u24lambda_u247.clientBuilder.retryOnConnectionFailure(retry);
            return builder;
        }

        @NotNull
        public final Builder addCustomRestInterceptor(@NotNull RestInterceptor interceptor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            Builder $this$addCustomRestInterceptor_u24lambda_u248 = builder = this;
            boolean bl = false;
            ((Collection)$this$addCustomRestInterceptor_u24lambda_u248.customApplicationInterceptors).add(interceptor);
            return builder;
        }

        @NotNull
        public final Builder baseUrlProvider(@NotNull BaseUrlProvider baseUrlProvider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"baseUrlProvider");
            Builder $this$baseUrlProvider_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$baseUrlProvider_u24lambda_u249.baseUrlProvider = baseUrlProvider;
            return builder;
        }

        @NotNull
        public final Builder moshi(@NotNull Moshi moshi2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
            Builder $this$moshi_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$moshi_u24lambda_u2410.moshi = moshi2;
            return builder;
        }

        @NotNull
        public final Builder restRedactor(@NotNull CustomMessageRedactor restRedactor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)restRedactor, (String)"restRedactor");
            Builder $this$restRedactor_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$restRedactor_u24lambda_u2411.customMessageRedactor = restRedactor;
            return builder;
        }

        @NotNull
        public final RestClient build() {
            return new RestClient(this);
        }
    }
}

