/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.restclient;

import com.squareup.moshi.Moshi;
import com.squareup.wire.AnyMessage;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.redaction.CustomMessageRedactor;
import com.stripe.jvmcore.redaction.Extensions;
import com.stripe.jvmcore.redaction.ResourceIdRedactor;
import com.stripe.jvmcore.restclient.RestResponseKt;
import com.stripe.proto.model.rest.StatusCode;
import java.io.Closeable;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e*\u0012\b\u0000\u0010\u0001*\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002*\u0012\b\u0001\u0010\u0003*\f\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u00030\u00022\u00020\u0004:\u0004\u001e\u001f !B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0010H&J\u0006\u0010\u001d\u001a\u00020\u0010R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lcom/stripe/jvmcore/restclient/RestResponse;", "M", "Lcom/squareup/wire/Message;", "E", "", "()V", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "getCustomMessageRedactor", "()Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "durationMillis", "", "getDurationMillis", "()Ljava/lang/Long;", "headers", "Ljava/util/TreeMap;", "", "getHeaders", "()Ljava/util/TreeMap;", "statusCode", "Lcom/stripe/proto/model/rest/StatusCode;", "getStatusCode", "()Lcom/stripe/proto/model/rest/StatusCode;", "url", "getUrl", "()Ljava/lang/String;", "shouldRetry", "", "toLogString", "toString", "Companion", "ParseError", "ServerError", "Success", "Lcom/stripe/jvmcore/restclient/RestResponse$ParseError;", "Lcom/stripe/jvmcore/restclient/RestResponse$ServerError;", "Lcom/stripe/jvmcore/restclient/RestResponse$Success;", "base"})
public abstract class RestResponse<M extends Message<M, ?>, E extends Message<E, ?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "RestResponse";
    @NotNull
    private static final String KEY_STRIPE_SHOULD_RETRY = "stripe-should-retry";

    private RestResponse() {
    }

    @NotNull
    public abstract StatusCode getStatusCode();

    @NotNull
    public abstract String getUrl();

    @Nullable
    public abstract Long getDurationMillis();

    @Nullable
    public abstract CustomMessageRedactor getCustomMessageRedactor();

    @NotNull
    public abstract TreeMap<String, String> getHeaders();

    @NotNull
    public abstract String toLogString();

    @NotNull
    public final String toString() {
        return this.toLogString();
    }

    public final boolean shouldRetry() {
        return Boolean.parseBoolean(this.getHeaders().get(KEY_STRIPE_SHOULD_RETRY));
    }

    public /* synthetic */ RestResponse(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Js\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0012\b\u0002\u0010\b*\f\u0012\u0004\u0012\u0002H\b\u0012\u0002\b\u00030\n\"\u0012\b\u0003\u0010\t*\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u0006\u0010\u0010\u001a\u0002H\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/jvmcore/restclient/RestResponse$Companion;", "", "()V", "KEY_STRIPE_SHOULD_RETRY", "", "TAG", "toRestResponse", "Lcom/stripe/jvmcore/restclient/RestResponse;", "M", "E", "Lcom/squareup/wire/Message;", "Lokhttp3/Response;", "moshi", "Lcom/squareup/moshi/Moshi;", "messageType", "Ljava/lang/Class;", "error", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lokhttp3/Response;Lcom/squareup/moshi/Moshi;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Lcom/stripe/jvmcore/logwriter/LogWriter;)Lcom/stripe/jvmcore/restclient/RestResponse;", "base"})
    @SourceDebugExtension(value={"SMAP\nRestResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestResponse.kt\ncom/stripe/jvmcore/restclient/RestResponse$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final <M extends Message<M, ?>, E extends Message<E, ?>> RestResponse<M, E> toRestResponse(@NotNull Response $this$toRestResponse, @NotNull Moshi moshi2, @NotNull Class<M> messageType, @NotNull E error, @Nullable CustomMessageRedactor customMessageRedactor, @NotNull LogWriter logWriter) {
            RestResponse restResponse;
            Intrinsics.checkNotNullParameter((Object)$this$toRestResponse, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
            Intrinsics.checkNotNullParameter(messageType, (String)"messageType");
            Intrinsics.checkNotNullParameter(error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
            int n2 = $this$toRestResponse.code();
            StatusCode statusCode = n2 == 0 ? StatusCode.HTTP_ERROR_UNKNOWN_STATE : (n2 == 200 ? StatusCode.OK : (n2 == 400 ? StatusCode.BAD_REQUEST : (n2 == 401 ? StatusCode.UNAUTHORIZED : (n2 == 402 ? StatusCode.REQUEST_FAILED : (n2 == 403 ? StatusCode.FORBIDDEN : (n2 == 404 ? StatusCode.NOT_FOUND : (n2 == 409 ? StatusCode.CONFLICT : (n2 == 500 ? StatusCode.SERVER_ERROR : ((502 <= n2 ? n2 < 505 : false) ? StatusCode.SERVER_ERROR : StatusCode.UNKNOWN_STATUS)))))))));
            String url = new HttpUrl.Builder().scheme($this$toRestResponse.request().url().scheme()).host($this$toRestResponse.request().url().host()).addPathSegments(StringsKt.removePrefix((String)new ResourceIdRedactor($this$toRestResponse.request().url().encodedPath()).redact(), (CharSequence)"/")).build().toString();
            long durationMillis = $this$toRestResponse.receivedResponseAtMillis() - $this$toRestResponse.sentRequestAtMillis();
            logWriter.i(RestResponse.TAG, "REST response with code " + $this$toRestResponse.code() + " received");
            String string = (String)MapsKt.toMap((Iterable)((Iterable)$this$toRestResponse.headers())).get("request-id");
            if (string != null) {
                String it = string;
                boolean bl = false;
                logWriter.i(RestResponse.TAG, "request-id: " + it);
            }
            TreeMap headerTreeMap = RestResponseKt.access$toCaseInsensitive($this$toRestResponse.headers());
            ResponseBody responseBody = $this$toRestResponse.body();
            if (responseBody != null) {
                Closeable closeable = (Closeable)responseBody;
                Throwable throwable = null;
                try {
                    RestResponse restResponse2;
                    Object it = (ResponseBody)closeable;
                    boolean bl = false;
                    try {
                        RestResponse restResponse3;
                        if (statusCode == StatusCode.OK) {
                            Message message;
                            if (Intrinsics.areEqual(messageType, AnyMessage.class)) {
                                ByteString stringValue = ProtoAdapter.STRING_VALUE.encodeByteString((Object)it.string());
                                String string2 = ProtoAdapter.STRING_VALUE.getTypeUrl();
                                Intrinsics.checkNotNull((Object)string2);
                                message = (Message)new AnyMessage(string2, stringValue);
                            } else {
                                Object object = moshi2.adapter(messageType).fromJson(it.source());
                                Intrinsics.checkNotNull((Object)object);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                      \u2026                        }");
                                message = (Message)object;
                            }
                            Message parsedResponse = message;
                            restResponse3 = new Success(parsedResponse, headerTreeMap, statusCode, url, durationMillis, moshi2, customMessageRedactor);
                        } else {
                            Object object = moshi2.adapter(error.getClass()).fromJson(it.source());
                            Intrinsics.checkNotNull((Object)object);
                            Message parsedError = (Message)object;
                            restResponse3 = new ServerError(parsedError, statusCode, url, durationMillis, moshi2, customMessageRedactor, headerTreeMap);
                        }
                        restResponse2 = restResponse3;
                    }
                    catch (Exception e2) {
                        logWriter.w(RestResponse.TAG, "Failed to parse REST response");
                        restResponse2 = new ParseError(statusCode, url, durationMillis, customMessageRedactor, headerTreeMap);
                    }
                    it = restResponse2;
                    restResponse = it;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            Response $this$toRestResponse_u24lambda_u242 = $this$toRestResponse;
            boolean bl = false;
            restResponse = new ServerError(error, statusCode, url, durationMillis, moshi2, customMessageRedactor, headerTreeMap);
            return restResponse;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0012\b\u0002\u0010\u0001*\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002*\u0012\b\u0003\u0010\u0003*\f\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u00030\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B=\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u00c6\u0003J\\\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\b\u0010(\u001a\u00020\bH\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/stripe/jvmcore/restclient/RestResponse$ParseError;", "M", "Lcom/squareup/wire/Message;", "E", "Lcom/stripe/jvmcore/restclient/RestResponse;", "statusCode", "Lcom/stripe/proto/model/rest/StatusCode;", "url", "", "durationMillis", "", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "headers", "Ljava/util/TreeMap;", "(Lcom/stripe/proto/model/rest/StatusCode;Ljava/lang/String;Ljava/lang/Long;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Ljava/util/TreeMap;)V", "getCustomMessageRedactor", "()Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "getDurationMillis", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getHeaders", "()Ljava/util/TreeMap;", "getStatusCode", "()Lcom/stripe/proto/model/rest/StatusCode;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "(Lcom/stripe/proto/model/rest/StatusCode;Ljava/lang/String;Ljava/lang/Long;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Ljava/util/TreeMap;)Lcom/stripe/jvmcore/restclient/RestResponse$ParseError;", "equals", "", "other", "", "hashCode", "", "toLogString", "base"})
    public static final class ParseError<M extends Message<M, ?>, E extends Message<E, ?>>
    extends RestResponse<M, E> {
        @NotNull
        private final StatusCode statusCode;
        @NotNull
        private final String url;
        @Nullable
        private final Long durationMillis;
        @Nullable
        private final CustomMessageRedactor customMessageRedactor;
        @NotNull
        private final TreeMap<String, String> headers;

        public ParseError(@NotNull StatusCode statusCode, @NotNull String url, @Nullable Long durationMillis, @Nullable CustomMessageRedactor customMessageRedactor, @NotNull TreeMap<String, String> headers) {
            Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            super(null);
            this.statusCode = statusCode;
            this.url = url;
            this.durationMillis = durationMillis;
            this.customMessageRedactor = customMessageRedactor;
            this.headers = headers;
        }

        @Override
        @NotNull
        public StatusCode getStatusCode() {
            return this.statusCode;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }

        @Override
        @Nullable
        public Long getDurationMillis() {
            return this.durationMillis;
        }

        @Override
        @Nullable
        public CustomMessageRedactor getCustomMessageRedactor() {
            return this.customMessageRedactor;
        }

        @Override
        @NotNull
        public TreeMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        @NotNull
        public String toLogString() {
            return "status=" + (Object)((Object)this.getStatusCode()) + " headers=" + this.getHeaders();
        }

        @NotNull
        public final StatusCode component1() {
            return this.statusCode;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @Nullable
        public final Long component3() {
            return this.durationMillis;
        }

        @Nullable
        public final CustomMessageRedactor component4() {
            return this.customMessageRedactor;
        }

        @NotNull
        public final TreeMap<String, String> component5() {
            return this.headers;
        }

        @NotNull
        public final ParseError<M, E> copy(@NotNull StatusCode statusCode, @NotNull String url, @Nullable Long durationMillis, @Nullable CustomMessageRedactor customMessageRedactor, @NotNull TreeMap<String, String> headers) {
            Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            return new ParseError<M, E>(statusCode, url, durationMillis, customMessageRedactor, headers);
        }

        public static /* synthetic */ ParseError copy$default(ParseError parseError, StatusCode statusCode, String string, Long l2, CustomMessageRedactor customMessageRedactor, TreeMap treeMap, int n2, Object object) {
            if ((n2 & 1) != 0) {
                statusCode = parseError.statusCode;
            }
            if ((n2 & 2) != 0) {
                string = parseError.url;
            }
            if ((n2 & 4) != 0) {
                l2 = parseError.durationMillis;
            }
            if ((n2 & 8) != 0) {
                customMessageRedactor = parseError.customMessageRedactor;
            }
            if ((n2 & 0x10) != 0) {
                treeMap = parseError.headers;
            }
            return parseError.copy(statusCode, string, l2, customMessageRedactor, treeMap);
        }

        public int hashCode() {
            int result2 = this.statusCode.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + (this.durationMillis == null ? 0 : ((Object)this.durationMillis).hashCode());
            result2 = result2 * 31 + (this.customMessageRedactor == null ? 0 : this.customMessageRedactor.hashCode());
            result2 = result2 * 31 + this.headers.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseError)) {
                return false;
            }
            ParseError parseError = (ParseError)other;
            if (this.statusCode != parseError.statusCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)parseError.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.durationMillis, (Object)parseError.durationMillis)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.customMessageRedactor, (Object)parseError.customMessageRedactor)) {
                return false;
            }
            return Intrinsics.areEqual(this.headers, parseError.headers);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000*\u0012\b\u0002\u0010\u0001*\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002*\u0012\b\u0003\u0010\u0003*\f\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u00030\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BM\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010#\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010'\u001a\u00020\rH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u0015\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011H\u00c6\u0003Jp\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011H\u00c6\u0001\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\u0006\u00102\u001a\u00020-J\b\u00103\u001a\u00020\tH\u0016R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00064"}, d2={"Lcom/stripe/jvmcore/restclient/RestResponse$ServerError;", "M", "Lcom/squareup/wire/Message;", "E", "Lcom/stripe/jvmcore/restclient/RestResponse;", "response", "statusCode", "Lcom/stripe/proto/model/rest/StatusCode;", "url", "", "durationMillis", "", "moshi", "Lcom/squareup/moshi/Moshi;", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "headers", "Ljava/util/TreeMap;", "(Lcom/squareup/wire/Message;Lcom/stripe/proto/model/rest/StatusCode;Ljava/lang/String;Ljava/lang/Long;Lcom/squareup/moshi/Moshi;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Ljava/util/TreeMap;)V", "getCustomMessageRedactor", "()Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "getDurationMillis", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getHeaders", "()Ljava/util/TreeMap;", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "getResponse", "()Lcom/squareup/wire/Message;", "Lcom/squareup/wire/Message;", "getStatusCode", "()Lcom/stripe/proto/model/rest/StatusCode;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lcom/squareup/wire/Message;Lcom/stripe/proto/model/rest/StatusCode;Ljava/lang/String;Ljava/lang/Long;Lcom/squareup/moshi/Moshi;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;Ljava/util/TreeMap;)Lcom/stripe/jvmcore/restclient/RestResponse$ServerError;", "equals", "", "other", "", "hashCode", "", "isRetryable", "toLogString", "base"})
    public static final class ServerError<M extends Message<M, ?>, E extends Message<E, ?>>
    extends RestResponse<M, E> {
        @NotNull
        private final E response;
        @NotNull
        private final StatusCode statusCode;
        @NotNull
        private final String url;
        @Nullable
        private final Long durationMillis;
        @NotNull
        private final Moshi moshi;
        @Nullable
        private final CustomMessageRedactor customMessageRedactor;
        @NotNull
        private final TreeMap<String, String> headers;

        public ServerError(@NotNull E response, @NotNull StatusCode statusCode, @NotNull String url, @Nullable Long durationMillis, @NotNull Moshi moshi2, @Nullable CustomMessageRedactor customMessageRedactor, @NotNull TreeMap<String, String> headers) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            super(null);
            this.response = response;
            this.statusCode = statusCode;
            this.url = url;
            this.durationMillis = durationMillis;
            this.moshi = moshi2;
            this.customMessageRedactor = customMessageRedactor;
            this.headers = headers;
        }

        @NotNull
        public final E getResponse() {
            return this.response;
        }

        @Override
        @NotNull
        public StatusCode getStatusCode() {
            return this.statusCode;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }

        @Override
        @Nullable
        public Long getDurationMillis() {
            return this.durationMillis;
        }

        @NotNull
        public final Moshi getMoshi() {
            return this.moshi;
        }

        @Override
        @Nullable
        public CustomMessageRedactor getCustomMessageRedactor() {
            return this.customMessageRedactor;
        }

        @Override
        @NotNull
        public TreeMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        @NotNull
        public String toLogString() {
            return "status=" + (Object)((Object)this.getStatusCode()) + " headers=" + this.getHeaders() + " response=" + Extensions.INSTANCE.toLogJson(this.response, this.getCustomMessageRedactor(), this.moshi);
        }

        public final boolean isRetryable() {
            boolean bl;
            if (this.getHeaders().containsKey("Stripe-Should-Retry")) {
                return Boolean.parseBoolean(this.getHeaders().get("Stripe-Should-Retry"));
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.getStatusCode().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final E component1() {
            return this.response;
        }

        @NotNull
        public final StatusCode component2() {
            return this.statusCode;
        }

        @NotNull
        public final String component3() {
            return this.url;
        }

        @Nullable
        public final Long component4() {
            return this.durationMillis;
        }

        @NotNull
        public final Moshi component5() {
            return this.moshi;
        }

        @Nullable
        public final CustomMessageRedactor component6() {
            return this.customMessageRedactor;
        }

        @NotNull
        public final TreeMap<String, String> component7() {
            return this.headers;
        }

        @NotNull
        public final ServerError<M, E> copy(@NotNull E response, @NotNull StatusCode statusCode, @NotNull String url, @Nullable Long durationMillis, @NotNull Moshi moshi2, @Nullable CustomMessageRedactor customMessageRedactor, @NotNull TreeMap<String, String> headers) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            return new ServerError<M, E>(response, statusCode, url, durationMillis, moshi2, customMessageRedactor, headers);
        }

        public static /* synthetic */ ServerError copy$default(ServerError serverError, Message object, StatusCode statusCode, String string, Long l2, Moshi moshi2, CustomMessageRedactor customMessageRedactor, TreeMap treeMap, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = serverError.response;
            }
            if ((n2 & 2) != 0) {
                statusCode = serverError.statusCode;
            }
            if ((n2 & 4) != 0) {
                string = serverError.url;
            }
            if ((n2 & 8) != 0) {
                l2 = serverError.durationMillis;
            }
            if ((n2 & 0x10) != 0) {
                moshi2 = serverError.moshi;
            }
            if ((n2 & 0x20) != 0) {
                customMessageRedactor = serverError.customMessageRedactor;
            }
            if ((n2 & 0x40) != 0) {
                treeMap = serverError.headers;
            }
            return serverError.copy(object, statusCode, string, l2, moshi2, customMessageRedactor, treeMap);
        }

        public int hashCode() {
            int result2 = this.response.hashCode();
            result2 = result2 * 31 + this.statusCode.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + (this.durationMillis == null ? 0 : ((Object)this.durationMillis).hashCode());
            result2 = result2 * 31 + this.moshi.hashCode();
            result2 = result2 * 31 + (this.customMessageRedactor == null ? 0 : this.customMessageRedactor.hashCode());
            result2 = result2 * 31 + this.headers.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerError)) {
                return false;
            }
            ServerError serverError = (ServerError)other;
            if (!Intrinsics.areEqual(this.response, serverError.response)) {
                return false;
            }
            if (this.statusCode != serverError.statusCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)serverError.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.durationMillis, (Object)serverError.durationMillis)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moshi, (Object)serverError.moshi)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.customMessageRedactor, (Object)serverError.customMessageRedactor)) {
                return false;
            }
            return Intrinsics.areEqual(this.headers, serverError.headers);
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StatusCode.values().length];
                try {
                    nArray[StatusCode.CONFLICT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusCode.TOO_MANY_REQUESTS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StatusCode.SERVER_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0012\b\u0002\u0010\u0001*\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002*\u0012\b\u0003\u0010\u0003*\f\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u00030\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BM\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010!\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010&\u001a\u00020\u000fH\u00c2\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003Jp\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\b\u00100\u001a\u00020\bH\u0016R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lcom/stripe/jvmcore/restclient/RestResponse$Success;", "M", "Lcom/squareup/wire/Message;", "E", "Lcom/stripe/jvmcore/restclient/RestResponse;", "response", "headers", "Ljava/util/TreeMap;", "", "statusCode", "Lcom/stripe/proto/model/rest/StatusCode;", "url", "durationMillis", "", "moshi", "Lcom/squareup/moshi/Moshi;", "customMessageRedactor", "Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "(Lcom/squareup/wire/Message;Ljava/util/TreeMap;Lcom/stripe/proto/model/rest/StatusCode;Ljava/lang/String;Ljava/lang/Long;Lcom/squareup/moshi/Moshi;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;)V", "getCustomMessageRedactor", "()Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;", "getDurationMillis", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getHeaders", "()Ljava/util/TreeMap;", "getResponse", "()Lcom/squareup/wire/Message;", "Lcom/squareup/wire/Message;", "getStatusCode", "()Lcom/stripe/proto/model/rest/StatusCode;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lcom/squareup/wire/Message;Ljava/util/TreeMap;Lcom/stripe/proto/model/rest/StatusCode;Ljava/lang/String;Ljava/lang/Long;Lcom/squareup/moshi/Moshi;Lcom/stripe/jvmcore/redaction/CustomMessageRedactor;)Lcom/stripe/jvmcore/restclient/RestResponse$Success;", "equals", "", "other", "", "hashCode", "", "toLogString", "base"})
    public static final class Success<M extends Message<M, ?>, E extends Message<E, ?>>
    extends RestResponse<M, E> {
        @NotNull
        private final M response;
        @NotNull
        private final TreeMap<String, String> headers;
        @NotNull
        private final StatusCode statusCode;
        @NotNull
        private final String url;
        @Nullable
        private final Long durationMillis;
        @NotNull
        private final Moshi moshi;
        @Nullable
        private final CustomMessageRedactor customMessageRedactor;

        public Success(@NotNull M response, @NotNull TreeMap<String, String> headers, @NotNull StatusCode statusCode, @NotNull String url, @Nullable Long durationMillis, @NotNull Moshi moshi2, @Nullable CustomMessageRedactor customMessageRedactor) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
            super(null);
            this.response = response;
            this.headers = headers;
            this.statusCode = statusCode;
            this.url = url;
            this.durationMillis = durationMillis;
            this.moshi = moshi2;
            this.customMessageRedactor = customMessageRedactor;
        }

        @NotNull
        public final M getResponse() {
            return this.response;
        }

        @Override
        @NotNull
        public TreeMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        @NotNull
        public StatusCode getStatusCode() {
            return this.statusCode;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }

        @Override
        @Nullable
        public Long getDurationMillis() {
            return this.durationMillis;
        }

        @Override
        @Nullable
        public CustomMessageRedactor getCustomMessageRedactor() {
            return this.customMessageRedactor;
        }

        @Override
        @NotNull
        public String toLogString() {
            return "status=" + (Object)((Object)this.getStatusCode()) + " headers=" + this.getHeaders() + " response=" + Extensions.INSTANCE.toLogJson(this.response, this.getCustomMessageRedactor(), this.moshi);
        }

        @NotNull
        public final M component1() {
            return this.response;
        }

        @NotNull
        public final TreeMap<String, String> component2() {
            return this.headers;
        }

        @NotNull
        public final StatusCode component3() {
            return this.statusCode;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        @Nullable
        public final Long component5() {
            return this.durationMillis;
        }

        private final Moshi component6() {
            return this.moshi;
        }

        @Nullable
        public final CustomMessageRedactor component7() {
            return this.customMessageRedactor;
        }

        @NotNull
        public final Success<M, E> copy(@NotNull M response, @NotNull TreeMap<String, String> headers, @NotNull StatusCode statusCode, @NotNull String url, @Nullable Long durationMillis, @NotNull Moshi moshi2, @Nullable CustomMessageRedactor customMessageRedactor) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
            return new Success<M, E>(response, headers, statusCode, url, durationMillis, moshi2, customMessageRedactor);
        }

        public static /* synthetic */ Success copy$default(Success success, Message object, TreeMap treeMap, StatusCode statusCode, String string, Long l2, Moshi moshi2, CustomMessageRedactor customMessageRedactor, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = success.response;
            }
            if ((n2 & 2) != 0) {
                treeMap = success.headers;
            }
            if ((n2 & 4) != 0) {
                statusCode = success.statusCode;
            }
            if ((n2 & 8) != 0) {
                string = success.url;
            }
            if ((n2 & 0x10) != 0) {
                l2 = success.durationMillis;
            }
            if ((n2 & 0x20) != 0) {
                moshi2 = success.moshi;
            }
            if ((n2 & 0x40) != 0) {
                customMessageRedactor = success.customMessageRedactor;
            }
            return success.copy(object, treeMap, statusCode, string, l2, moshi2, customMessageRedactor);
        }

        public int hashCode() {
            int result2 = this.response.hashCode();
            result2 = result2 * 31 + this.headers.hashCode();
            result2 = result2 * 31 + this.statusCode.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + (this.durationMillis == null ? 0 : ((Object)this.durationMillis).hashCode());
            result2 = result2 * 31 + this.moshi.hashCode();
            result2 = result2 * 31 + (this.customMessageRedactor == null ? 0 : this.customMessageRedactor.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            if (!Intrinsics.areEqual(this.response, success.response)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, success.headers)) {
                return false;
            }
            if (this.statusCode != success.statusCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)success.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.durationMillis, (Object)success.durationMillis)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moshi, (Object)success.moshi)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.customMessageRedactor, (Object)success.customMessageRedactor);
        }
    }
}

