/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.storage;

import com.stripe.jvmcore.storage.KeyValueStore;
import com.stripe.jvmcore.storage.SharedPrefsChangeListener;
import com.stripe.jvmcore.storage.StoreChangeListener;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020$H\u0016J\u001c\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u001dH\u0016J\u0018\u0010(\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010'\u001a\u00020\"H\u0016J\u0018\u0010)\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010'\u001a\u00020$H\u0016J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0006J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/stripe/jvmcore/storage/DefaultKeyValueStore;", "Lcom/stripe/jvmcore/storage/KeyValueStore;", "preferences", "Ljava/util/prefs/Preferences;", "(Ljava/util/prefs/Preferences;)V", "changeListener", "Lcom/stripe/jvmcore/storage/StoreChangeListener;", "listenerMap", "", "", "", "Lcom/stripe/jvmcore/storage/SharedPrefsChangeListener;", "getListenerMap", "()Ljava/util/Map;", "base64Decode", "", "encodedMessage", "base64Encode", "byteArray", "batchRemoveFields", "", "keys", "", "batchSetFields", "map", "", "", "clear", "contains", "", "key", "getBoolean", "default", "getInt", "", "getLong", "", "getString", "putBoolean", "value", "putInt", "putLong", "putString", "registerChangeListener", "listener", "remove", "storage"})
@SourceDebugExtension(value={"SMAP\nDefaultKeyValueStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultKeyValueStore.kt\ncom/stripe/jvmcore/storage/DefaultKeyValueStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1855#2,2:102\n1855#2,2:104\n*S KotlinDebug\n*F\n+ 1 DefaultKeyValueStore.kt\ncom/stripe/jvmcore/storage/DefaultKeyValueStore\n*L\n59#1:102,2\n69#1:104,2\n*E\n"})
public final class DefaultKeyValueStore
implements KeyValueStore {
    @NotNull
    private final Preferences preferences;
    @NotNull
    private final Map<String, Set<SharedPrefsChangeListener>> listenerMap;
    @NotNull
    private final StoreChangeListener changeListener;

    @Inject
    public DefaultKeyValueStore(@NotNull Preferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.preferences = preferences;
        this.listenerMap = new LinkedHashMap();
        this.changeListener = new StoreChangeListener(this.getListenerMap());
        this.registerChangeListener(this.changeListener);
    }

    @Override
    @NotNull
    public Map<String, Set<SharedPrefsChangeListener>> getListenerMap() {
        return this.listenerMap;
    }

    @Override
    public void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.preferences.put(key, value);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.get(key, string);
    }

    @Override
    public void putBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.preferences.putBoolean(key, value);
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getBoolean(key, bl);
    }

    @Override
    public void putLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.preferences.putLong(key, value);
    }

    @Override
    public long getLong(@NotNull String key, long l2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getLong(key, l2);
    }

    @Override
    public void putInt(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.preferences.putInt(key, value);
    }

    @Override
    public int getInt(@NotNull String key, int n2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.preferences.getInt(key, n2);
    }

    @Override
    public void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.preferences.remove(key);
    }

    @Override
    public synchronized void batchRemoveFields(@NotNull List<String> keys) {
        Preferences preferences;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Preferences $this$batchRemoveFields_u24lambda_u241 = preferences = this.preferences;
        boolean bl = false;
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$batchRemoveFields_u24lambda_u241.remove(it);
        }
    }

    @Override
    public synchronized void batchSetFields(@NotNull Map<String, ? extends Object> map2) {
        Preferences preferences;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Preferences $this$batchSetFields_u24lambda_u243 = preferences = this.preferences;
        boolean bl = false;
        Iterable $this$forEach$iv = map2.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object v2 = value;
            if (v2 instanceof String) {
                $this$batchSetFields_u24lambda_u243.put(key, (String)value);
                continue;
            }
            if (v2 instanceof Integer) {
                $this$batchSetFields_u24lambda_u243.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (v2 instanceof Boolean) {
                $this$batchSetFields_u24lambda_u243.putBoolean(key, (Boolean)value);
                continue;
            }
            if (v2 instanceof Long) {
                $this$batchSetFields_u24lambda_u243.putLong(key, ((Number)value).longValue());
                continue;
            }
            throw new Exception("Unsupported data type for " + value + '.');
        }
    }

    public final void registerChangeListener(@NotNull StoreChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.preferences.addPreferenceChangeListener(arg_0 -> DefaultKeyValueStore.registerChangeListener$lambda$4(listener2, this, arg_0));
    }

    @Override
    public boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String[] stringArray = this.preferences.keys();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"preferences.keys()");
        return ArraysKt.contains((Object[])stringArray, (Object)key);
    }

    @Override
    public void clear() {
        this.preferences.clear();
    }

    @Override
    @NotNull
    public String base64Encode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        String string = Base64.getMimeEncoder().encodeToString(byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMimeEncoder().encodeToString(byteArray)");
        return string;
    }

    @Override
    @NotNull
    public byte[] base64Decode(@NotNull String encodedMessage) {
        Intrinsics.checkNotNullParameter((Object)encodedMessage, (String)"encodedMessage");
        byte[] byArray = Base64.getMimeDecoder().decode(encodedMessage);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getMimeDecoder().decode(encodedMessage)");
        return byArray;
    }

    private static final void registerChangeListener$lambda$4(StoreChangeListener $listener, DefaultKeyValueStore this$0, PreferenceChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $listener.onValueChanged(this$0, event.getKey());
    }
}

