/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.storage;

import com.squareup.wire.Message;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.reboot.RebootTimeSettingApproach;
import com.stripe.jvmcore.storage.KeyValueStore;
import com.stripe.jvmcore.storage.SharedPrefsChangeListener;
import com.stripe.proto.model.config.MagstripeConfig;
import com.stripe.proto.model.config.ReaderFeatureFlags;
import com.stripe.proto.terminal.terminal.pub.message.config.OfflineConfigPb;
import com.stripe.proto.terminal.terminal.pub.message.config.TippingConfigPb;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b$\b\u0016\u0018\u0000 U2\u00020\u0001:\u0001UB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J.\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\b\u0010\u001c\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\b\u0010 \u001a\u00020!H\u0016J/\u0010\"\u001a\u0002H#\"\u0012\b\u0000\u0010#*\f\u0012\u0004\u0012\u0002H#\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010\u001b\u001a\u0002H#\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u0004\u0018\u00010\tJ\b\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0013J\u0006\u0010,\u001a\u00020\tJ\u0006\u0010-\u001a\u00020\tJ\b\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020\u001aJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000fH\u0016J0\u00104\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u00132\b\b\u0002\u00108\u001a\u00020\u001aJ\u0010\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020\u0018H\u0016J\u000e\u0010;\u001a\u0002022\u0006\u0010<\u001a\u00020\tJ\u000e\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020\tJ\u0010\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020!H\u0016J/\u0010A\u001a\u000202\"\u0012\b\u0000\u0010#*\f\u0012\u0004\u0012\u0002H#\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010B\u001a\u0002H#\u00a2\u0006\u0002\u0010CJ\u000e\u0010D\u001a\u0002022\u0006\u0010E\u001a\u00020\tJ\u0010\u0010F\u001a\u0002022\u0006\u0010G\u001a\u00020)H\u0016J\u000e\u0010H\u001a\u0002022\u0006\u0010>\u001a\u00020\tJ\u000e\u0010I\u001a\u0002022\u0006\u0010>\u001a\u00020\tJ\u0010\u0010J\u001a\u0002022\u0006\u0010K\u001a\u00020/H\u0016J\u000e\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020\u001aJ\u000e\u0010N\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020\t2\u0006\u0010Q\u001a\u00020\tJ\u0016\u0010R\u001a\u0002022\u0006\u0010%\u001a\u00020\t2\u0006\u0010S\u001a\u00020\u000bJ\u0016\u0010T\u001a\u0002022\u0006\u0010%\u001a\u00020\t2\u0006\u0010S\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006V"}, d2={"Lcom/stripe/jvmcore/storage/SharedPrefs;", "", "keyValueStore", "Lcom/stripe/jvmcore/storage/KeyValueStore;", "(Lcom/stripe/jvmcore/storage/KeyValueStore;)V", "getKeyValueStore", "()Lcom/stripe/jvmcore/storage/KeyValueStore;", "listenerMap", "", "", "", "Lcom/stripe/jvmcore/storage/SharedPrefsChangeListener;", "getListenerMap", "()Ljava/util/Map;", "getAccountOfflineConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb$AccountOfflineConfigPb;", "getConfigRebootTimeWindowInSeconds", "Lkotlin/Pair;", "", "", "approach", "Lcom/stripe/jvmcore/reboot/RebootTimeSettingApproach;", "defaultTimeWindow", "getFeatureFlags", "Lcom/stripe/proto/model/config/ReaderFeatureFlags;", "getIsServerConfigRebootTimeEnforced", "", "defaultValue", "getKeyProfileName", "getLastAccessibilityUberLanguagePackVersion", "expectedAccessibilityIdentifier", "getLocationId", "getMagstripeConfig", "Lcom/stripe/proto/model/config/MagstripeConfig;", "getMessage", "M", "Lcom/squareup/wire/Message;", "key", "(Ljava/lang/String;Lcom/squareup/wire/Message;)Lcom/squareup/wire/Message;", "getMobilePosConfig", "getOfflineConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb;", "getRebootTimeInSeconds", "defaultTimeInSeconds", "getRpcSessionToken", "getSdkSessionToken", "getTippingConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/TippingConfigPb;", "getUpdateInProgress", "putAccountOfflineConfig", "", "accountOfflineConfig", "putConfigRebootTimeWindowInSeconds", "rebootTimeInSeconds", "startHour", "durationInSeconds", "isEnforced", "putFeatureFlags", "featureFlags", "putKeyProfileName", "keyProfileName", "putLocationId", "token", "putMagstripeConfig", "magstripeConfig", "putMessage", "message", "(Ljava/lang/String;Lcom/squareup/wire/Message;)V", "putMobilePosConfig", "merchantNameData", "putOfflineConfig", "offlineConfigPb", "putRpcSessionToken", "putSdkSessionToken", "putTippingConfig", "tippingConfig", "putUpdateInProgress", "inProgress", "removeConfigRebootTime", "setLastAccessibilityUberLanguagePackVersion", "version", "newAccessibilityInstallIdentifier", "subscribeToChanges", "listener", "unsubscribeFromChanges", "Companion", "storage"})
public class SharedPrefs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyValueStore keyValueStore;
    @NotNull
    private final Map<String, Set<SharedPrefsChangeListener>> listenerMap;
    @NotNull
    private static final String SDK_SESSION_TOKEN = "sdk_session_token";
    @NotNull
    private static final String DEFAULT_SDK_SESSION_TOKEN = "";
    @NotNull
    private static final String RPC_SESSION_TOKEN = "rpc_session_token";
    @NotNull
    private static final String DEFAULT_RPC_SESSION_TOKEN = "";
    @NotNull
    private static final String STRIPE_SESSION_TOKEN = "stripe_session_token";
    @NotNull
    private static final String DEFAULT_STRIPE_SESSION_TOKEN = "";
    @NotNull
    private static final String READER_LOCATION_KEY = "reader_location";
    @NotNull
    private static final String DEFAULT_READER_LOCATION = "";
    @NotNull
    private static final String MOBILE_POS_CONFIG = "mobile_pos_config";
    @NotNull
    private static final String DEFAULT_MOBILE_POS_CONFIG = "";
    @NotNull
    public static final String READER_FEATURE_FLAGS = "reader_feature_flags";
    @NotNull
    private static final String TIPPING_CONFIG = "tipping_config";
    @NotNull
    private static final String KEY_PROFILE_NAME = "key_profile_name";
    @NotNull
    private static final String ACCOUNT_OFFLINE_CONFIG = "offline_config";
    @NotNull
    private static final String FULL_OFFLINE_CONFIG = "full_offline_config";
    @NotNull
    private static final String MAGSTRIPE_CONFIG = "magstripe_config";
    @NotNull
    private static final String UPDATE_IN_PROGRESS = "update_in_progress";
    private static final boolean DEFAULT_UPDATE_IN_PROGRESS = false;
    @NotNull
    public static final String LAST_ACTIVE_OFFLINE_ACCOUNT_ID = "offline_account_id";
    @NotNull
    public static final String BLUETOOTH_DEVICE_NAME_SERIAL_MAPPING = "bluetooth_device_to_serial_mapping";
    @NotNull
    public static final String LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_VERSION = "accessibility_uber_pack_last_version";
    @NotNull
    public static final String LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_IDENTIFIER = "accessibility_uber_pack_identifier";
    @NotNull
    private static final String IS_SERVER_CONFIG_REBOOT_TIME_ENFORCED = "is_server_config_reboot_time_enforced";
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(SharedPrefs.class);

    @Inject
    public SharedPrefs(@NotNull KeyValueStore keyValueStore) {
        Intrinsics.checkNotNullParameter((Object)keyValueStore, (String)"keyValueStore");
        this.keyValueStore = keyValueStore;
        this.listenerMap = this.keyValueStore.getListenerMap();
    }

    @NotNull
    public final KeyValueStore getKeyValueStore() {
        return this.keyValueStore;
    }

    @NotNull
    public final Map<String, Set<SharedPrefsChangeListener>> getListenerMap() {
        return this.listenerMap;
    }

    @NotNull
    public final String getSdkSessionToken() {
        String string = this.keyValueStore.getString(SDK_SESSION_TOKEN, "");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void putSdkSessionToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.keyValueStore.putString(SDK_SESSION_TOKEN, token);
    }

    @NotNull
    public final String getRpcSessionToken() {
        String string = this.keyValueStore.getString(RPC_SESSION_TOKEN, "");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final void putRpcSessionToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.keyValueStore.putString(RPC_SESSION_TOKEN, token);
    }

    @NotNull
    public final String getLocationId() {
        String string = this.keyValueStore.getString(READER_LOCATION_KEY, "");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void putLocationId(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.keyValueStore.putString(READER_LOCATION_KEY, token);
    }

    @NotNull
    public ReaderFeatureFlags getFeatureFlags() {
        ReaderFeatureFlags readerFeatureFlags;
        try {
            readerFeatureFlags = (ReaderFeatureFlags)this.getMessage(READER_FEATURE_FLAGS, (Message)new ReaderFeatureFlags(false, false, false, false, 0L, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0L, false, false, false, false, false, false, 0L, 0L, false, 0L, null, -1, -1, 255, null));
        }
        catch (Exception exception) {
            this.keyValueStore.remove(READER_FEATURE_FLAGS);
            return new ReaderFeatureFlags(false, false, false, false, 0L, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0L, false, false, false, false, false, false, 0L, 0L, false, 0L, null, -1, -1, 255, null);
        }
        return readerFeatureFlags;
    }

    public void putFeatureFlags(@NotNull ReaderFeatureFlags featureFlags) {
        Intrinsics.checkNotNullParameter((Object)((Object)featureFlags), (String)"featureFlags");
        this.putMessage(READER_FEATURE_FLAGS, (Message)featureFlags);
    }

    @NotNull
    public TippingConfigPb getTippingConfig() {
        TippingConfigPb tippingConfigPb;
        try {
            tippingConfigPb = (TippingConfigPb)this.getMessage(TIPPING_CONFIG, (Message)new TippingConfigPb(null, null, 3, null));
        }
        catch (Exception exception) {
            this.keyValueStore.remove(TIPPING_CONFIG);
            return new TippingConfigPb(null, null, 3, null);
        }
        return tippingConfigPb;
    }

    public void putTippingConfig(@NotNull TippingConfigPb tippingConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)tippingConfig), (String)"tippingConfig");
        this.putMessage(TIPPING_CONFIG, (Message)tippingConfig);
    }

    @NotNull
    public OfflineConfigPb.AccountOfflineConfigPb getAccountOfflineConfig() {
        OfflineConfigPb.AccountOfflineConfigPb accountOfflineConfigPb;
        try {
            accountOfflineConfigPb = (OfflineConfigPb.AccountOfflineConfigPb)this.getMessage(ACCOUNT_OFFLINE_CONFIG, (Message)new OfflineConfigPb.AccountOfflineConfigPb(0, null, 0, 0, 0, 0, null, false, false, null, null, false, null, null, null, null, null, 131071, null));
        }
        catch (Exception e2) {
            this.keyValueStore.remove(ACCOUNT_OFFLINE_CONFIG);
            return new OfflineConfigPb.AccountOfflineConfigPb(0, null, 0, 0, 0, 0, null, false, false, null, null, false, null, null, null, null, null, 131071, null);
        }
        return accountOfflineConfigPb;
    }

    public void putAccountOfflineConfig(@NotNull OfflineConfigPb.AccountOfflineConfigPb accountOfflineConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)accountOfflineConfig), (String)"accountOfflineConfig");
        this.putMessage(ACCOUNT_OFFLINE_CONFIG, (Message)accountOfflineConfig);
    }

    @NotNull
    public OfflineConfigPb getOfflineConfig() {
        OfflineConfigPb offlineConfigPb;
        try {
            offlineConfigPb = (OfflineConfigPb)this.getMessage(FULL_OFFLINE_CONFIG, (Message)new OfflineConfigPb(false, 0, null, null, null, false, false, null, null, 511, null));
        }
        catch (Exception e2) {
            this.keyValueStore.remove(FULL_OFFLINE_CONFIG);
            return new OfflineConfigPb(false, 0, null, null, null, false, false, null, null, 511, null);
        }
        return offlineConfigPb;
    }

    public void putOfflineConfig(@NotNull OfflineConfigPb offlineConfigPb) {
        Intrinsics.checkNotNullParameter((Object)((Object)offlineConfigPb), (String)"offlineConfigPb");
        this.putMessage(FULL_OFFLINE_CONFIG, (Message)offlineConfigPb);
    }

    @NotNull
    public MagstripeConfig getMagstripeConfig() {
        MagstripeConfig magstripeConfig;
        try {
            magstripeConfig = (MagstripeConfig)this.getMessage(MAGSTRIPE_CONFIG, (Message)new MagstripeConfig(false, null, 3, null));
        }
        catch (Exception e2) {
            this.keyValueStore.remove(MAGSTRIPE_CONFIG);
            return new MagstripeConfig(false, null, 3, null);
        }
        return magstripeConfig;
    }

    public void putMagstripeConfig(@NotNull MagstripeConfig magstripeConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)magstripeConfig), (String)"magstripeConfig");
        this.putMessage(MAGSTRIPE_CONFIG, (Message)magstripeConfig);
    }

    public final void putUpdateInProgress(boolean inProgress) {
        this.keyValueStore.putBoolean(UPDATE_IN_PROGRESS, inProgress);
    }

    public final boolean getUpdateInProgress() {
        return this.keyValueStore.getBoolean(UPDATE_IN_PROGRESS, false);
    }

    public final long getRebootTimeInSeconds(@NotNull RebootTimeSettingApproach approach, long defaultTimeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)approach, (String)"approach");
        return this.keyValueStore.getLong(approach.name(), defaultTimeInSeconds);
    }

    public final void putConfigRebootTimeWindowInSeconds(@NotNull RebootTimeSettingApproach approach, long rebootTimeInSeconds, int startHour, long durationInSeconds, boolean isEnforced) {
        Intrinsics.checkNotNullParameter((Object)approach, (String)"approach");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)approach.name(), (Object)rebootTimeInSeconds), TuplesKt.to((Object)SharedPrefs.Companion.getStartHourName(approach), (Object)startHour), TuplesKt.to((Object)SharedPrefs.Companion.getDurationName(approach), (Object)durationInSeconds)};
        Map fieldsToWrite = MapsKt.mutableMapOf((Pair[])pairArray);
        if (approach == RebootTimeSettingApproach.REBOOT_TIME_BY_SERVER_DEFAULT) {
            Boolean bl = isEnforced;
            fieldsToWrite.put(IS_SERVER_CONFIG_REBOOT_TIME_ENFORCED, bl);
        }
        this.keyValueStore.batchSetFields(fieldsToWrite);
    }

    public static /* synthetic */ void putConfigRebootTimeWindowInSeconds$default(SharedPrefs sharedPrefs, RebootTimeSettingApproach rebootTimeSettingApproach, long l2, int n2, long l3, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: putConfigRebootTimeWindowInSeconds");
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        sharedPrefs.putConfigRebootTimeWindowInSeconds(rebootTimeSettingApproach, l2, n2, l3, bl);
    }

    @NotNull
    public final Pair<Integer, Long> getConfigRebootTimeWindowInSeconds(@NotNull RebootTimeSettingApproach approach, @NotNull Pair<Integer, Long> defaultTimeWindow) {
        Intrinsics.checkNotNullParameter((Object)approach, (String)"approach");
        Intrinsics.checkNotNullParameter(defaultTimeWindow, (String)"defaultTimeWindow");
        return new Pair((Object)this.keyValueStore.getInt(SharedPrefs.Companion.getStartHourName(approach), ((Number)defaultTimeWindow.getFirst()).intValue()), (Object)this.keyValueStore.getLong(SharedPrefs.Companion.getDurationName(approach), ((Number)defaultTimeWindow.getSecond()).longValue()));
    }

    public final void removeConfigRebootTime(@NotNull RebootTimeSettingApproach approach) {
        Intrinsics.checkNotNullParameter((Object)approach, (String)"approach");
        Object[] objectArray = new String[]{approach.name(), SharedPrefs.Companion.getStartHourName(approach), SharedPrefs.Companion.getDurationName(approach)};
        List fieldsToRemove = CollectionsKt.mutableListOf((Object[])objectArray);
        if (approach == RebootTimeSettingApproach.REBOOT_TIME_BY_SERVER_DEFAULT) {
            fieldsToRemove.add(IS_SERVER_CONFIG_REBOOT_TIME_ENFORCED);
        }
        this.keyValueStore.batchRemoveFields(fieldsToRemove);
    }

    @Nullable
    public final String getKeyProfileName() {
        return this.keyValueStore.getString(KEY_PROFILE_NAME, null);
    }

    public final void putKeyProfileName(@NotNull String keyProfileName) {
        Intrinsics.checkNotNullParameter((Object)keyProfileName, (String)"keyProfileName");
        this.keyValueStore.putString(KEY_PROFILE_NAME, keyProfileName);
    }

    public final boolean getIsServerConfigRebootTimeEnforced(boolean defaultValue) {
        return this.keyValueStore.getBoolean(IS_SERVER_CONFIG_REBOOT_TIME_ENFORCED, defaultValue);
    }

    public final <M extends Message<M, ?>> void putMessage(@NotNull String key, @NotNull M message) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.keyValueStore.putString(key, this.keyValueStore.base64Encode(message.encode()));
    }

    @NotNull
    public final <M extends Message<M, ?>> M getMessage(@NotNull String key, @NotNull M defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        String string = this.keyValueStore.getString(key, "");
        if (string == null) {
            return defaultValue;
        }
        String base64Message = string;
        if (((CharSequence)base64Message).length() == 0) {
            return defaultValue;
        }
        return (M)((Message)defaultValue.adapter().decode(this.keyValueStore.base64Decode(base64Message)));
    }

    public final void subscribeToChanges(@NotNull String key, @NotNull SharedPrefsChangeListener listener2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            if (!this.listenerMap.containsKey(key)) {
                this.listenerMap.put(key, new LinkedHashSet());
            }
            Set<SharedPrefsChangeListener> set = this.listenerMap.get(key);
            if (set == null) break block1;
            set.add(listener2);
        }
    }

    public final void unsubscribeFromChanges(@NotNull String key, @NotNull SharedPrefsChangeListener listener2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Set<SharedPrefsChangeListener> set = this.listenerMap.get(key);
            if (set == null) break block0;
            set.remove(listener2);
        }
    }

    @Nullable
    public final String getMobilePosConfig() {
        return this.keyValueStore.getString(MOBILE_POS_CONFIG, "");
    }

    public final void putMobilePosConfig(@NotNull String merchantNameData) {
        Intrinsics.checkNotNullParameter((Object)merchantNameData, (String)"merchantNameData");
        this.keyValueStore.putString(MOBILE_POS_CONFIG, merchantNameData);
    }

    @Nullable
    public final String getLastAccessibilityUberLanguagePackVersion(@NotNull String expectedAccessibilityIdentifier) {
        Intrinsics.checkNotNullParameter((Object)expectedAccessibilityIdentifier, (String)"expectedAccessibilityIdentifier");
        String actualAccessibilityIdentifier = this.keyValueStore.getString(LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_IDENTIFIER, null);
        if (!Intrinsics.areEqual((Object)actualAccessibilityIdentifier, (Object)expectedAccessibilityIdentifier)) {
            return null;
        }
        return this.keyValueStore.getString(LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_VERSION, null);
    }

    public final void setLastAccessibilityUberLanguagePackVersion(@NotNull String version, @NotNull String newAccessibilityInstallIdentifier) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)newAccessibilityInstallIdentifier, (String)"newAccessibilityInstallIdentifier");
        this.keyValueStore.putString(LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_VERSION, version);
        this.keyValueStore.putString(LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_IDENTIFIER, newAccessibilityInstallIdentifier);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u001e\u001a\u00020\u0004*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u0004*\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/stripe/jvmcore/storage/SharedPrefs$Companion;", "", "()V", "ACCOUNT_OFFLINE_CONFIG", "", "BLUETOOTH_DEVICE_NAME_SERIAL_MAPPING", "DEFAULT_MOBILE_POS_CONFIG", "DEFAULT_READER_LOCATION", "DEFAULT_RPC_SESSION_TOKEN", "DEFAULT_SDK_SESSION_TOKEN", "DEFAULT_STRIPE_SESSION_TOKEN", "DEFAULT_UPDATE_IN_PROGRESS", "", "FULL_OFFLINE_CONFIG", "IS_SERVER_CONFIG_REBOOT_TIME_ENFORCED", "KEY_PROFILE_NAME", "LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_IDENTIFIER", "LAST_ACCESSIBILITY_UBER_LANGUAGE_PACK_VERSION", "LAST_ACTIVE_OFFLINE_ACCOUNT_ID", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "MAGSTRIPE_CONFIG", "MOBILE_POS_CONFIG", "READER_FEATURE_FLAGS", "READER_LOCATION_KEY", "RPC_SESSION_TOKEN", "SDK_SESSION_TOKEN", "STRIPE_SESSION_TOKEN", "TIPPING_CONFIG", "UPDATE_IN_PROGRESS", "getDurationName", "Lcom/stripe/jvmcore/reboot/RebootTimeSettingApproach;", "getStartHourName", "storage"})
    public static final class Companion {
        private Companion() {
        }

        private final String getStartHourName(RebootTimeSettingApproach $this$getStartHourName) {
            return $this$getStartHourName.name() + "_start_hour";
        }

        private final String getDurationName(RebootTimeSettingApproach $this$getDurationName) {
            return $this$getDurationName.name() + "_duration_in_seconds";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

