/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.strings;

import com.stripe.jvmcore.strings.StringsExtKt;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0005\u001a\n\u0010\u000b\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"WhiteSpacePattern", "Ljava/util/regex/Pattern;", "containsWhiteSpace", "", "string", "", "capitalized", "locale", "Ljava/util/Locale;", "escape", "isSurroundedInDoubleQuotes", "removeSurroundingDoubleQuotes", "surroundInDoubleQuotes", "titleCase", "strings"})
public final class StringsExtKt {
    @NotNull
    private static final Pattern WhiteSpacePattern;

    @NotNull
    public static final String titleCase(@NotNull String $this$titleCase) {
        Intrinsics.checkNotNullParameter((Object)$this$titleCase, (String)"<this>");
        char[] cArray = new char[]{' '};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$titleCase, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, (Function1)titleCase.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalized(@NotNull String $this$capitalized, @NotNull Locale locale) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$capitalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string2 = $this$capitalized;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c2 = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it) ? CharsKt.titlecase((char)it, (Locale)locale) : String.valueOf((char)it)));
            String string3 = string2;
            int n2 = 1;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        return string;
    }

    public static /* synthetic */ String capitalized$default(String string, Locale locale, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return StringsExtKt.capitalized(string, locale);
    }

    public static final boolean isSurroundedInDoubleQuotes(@NotNull String $this$isSurroundedInDoubleQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$isSurroundedInDoubleQuotes, (String)"<this>");
        return $this$isSurroundedInDoubleQuotes.length() >= 2 && StringsKt.startsWith$default((String)$this$isSurroundedInDoubleQuotes, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$isSurroundedInDoubleQuotes, (String)"\"", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String surroundInDoubleQuotes(@NotNull String $this$surroundInDoubleQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$surroundInDoubleQuotes, (String)"<this>");
        return '\"' + $this$surroundInDoubleQuotes + '\"';
    }

    @NotNull
    public static final String removeSurroundingDoubleQuotes(@NotNull String $this$removeSurroundingDoubleQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeSurroundingDoubleQuotes, (String)"<this>");
        return StringsKt.removeSurrounding((String)$this$removeSurroundingDoubleQuotes, (CharSequence)"\"");
    }

    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        Intrinsics.checkNotNullParameter((Object)$this$escape, (String)"<this>");
        return StringsExtKt.containsWhiteSpace($this$escape) ? '\"' + $this$escape + '\"' : $this$escape;
    }

    private static final boolean containsWhiteSpace(String string) {
        return WhiteSpacePattern.matcher(string).find();
    }

    static {
        Pattern pattern = Pattern.compile("\\s");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\\\\s\")");
        WhiteSpacePattern = pattern;
    }
}

