/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.terminal.api;

import com.squareup.wire.Message;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.api.PosInfo;
import com.stripe.jvmcore.terminal.appinfo.ApplicationInformation;
import com.stripe.proto.model.common.ApplicationModel;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.HardwareModel;
import com.stripe.proto.model.common.Location;
import com.stripe.proto.model.common.POSInfo;
import com.stripe.proto.model.common.VersionInfoPb;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/jvmcore/terminal/api/PosInfoFactory;", "", "appInfo", "Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;", "(Lcom/stripe/jvmcore/terminal/appinfo/ApplicationInformation;)V", "createForLocalPos", "Lcom/stripe/jvmcore/terminal/api/PosInfo;", "createForRemotePos", "remotePosSdkVersionInfo", "Lcom/stripe/proto/model/common/VersionInfoPb;", "remotePosSecondarySdkVersionInfo", "remotePosDeviceInfo", "Lcom/stripe/proto/model/common/DeviceInfo;", "modifyRemotePosDeviceInfo", "Companion", "terminal-core"})
public final class PosInfoFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationInformation appInfo;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(PosInfoFactory.class);

    @Inject
    public PosInfoFactory(@NotNull ApplicationInformation appInfo) {
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        this.appInfo = appInfo;
    }

    @NotNull
    public final PosInfo createForLocalPos() {
        Enum enum_;
        String string = this.appInfo.getClientVersion();
        try {
            enum_ = VersionInfoPb.ClientType.valueOf(this.appInfo.getClientType());
        }
        catch (Exception e2) {
            enum_ = VersionInfoPb.ClientType.CLIENT_TYPE_INVALID;
        }
        Object object = enum_;
        VersionInfoPb posVersionInfo = new VersionInfoPb((VersionInfoPb.ClientType)((Object)object), string, 0, null, 12, null);
        object = new ApplicationModel(this.appInfo.getAppId(), this.appInfo.getAppVersion(), null, 4, null);
        enum_ = DeviceInfo.DeviceClass.POS;
        String string2 = this.appInfo.getDeviceUuid();
        HardwareModel hardwareModel = new HardwareModel(null, null, new POSInfo(this.appInfo.getDeviceName(), null, 2, null), null, null, null, null, null, 251, null);
        String string3 = this.appInfo.getDeviceModel();
        String string4 = this.appInfo.getDeviceOsVersion();
        DeviceInfo posDeviceInfo = new DeviceInfo((DeviceInfo.DeviceClass)enum_, string2, hardwareModel, (ApplicationModel)((Object)object), null, string3, string4, null, null, null, null, null, null, null, null, null, 65424, null);
        VersionInfoPb secondaryVersionInfo = this.appInfo.getEmbeddedWithinStripeReactNativeSdk() ? new VersionInfoPb(VersionInfoPb.ClientType.RN_ANDROID_SDK, this.appInfo.getReactNativeSdkVersion(), 0, null, 12, null) : null;
        return new PosInfo(posVersionInfo, posDeviceInfo, secondaryVersionInfo, this.appInfo.getDeviceUuid());
    }

    @NotNull
    public final PosInfo createForRemotePos(@Nullable VersionInfoPb remotePosSdkVersionInfo, @Nullable VersionInfoPb remotePosSecondarySdkVersionInfo, @Nullable DeviceInfo remotePosDeviceInfo) {
        DeviceInfo deviceInfo;
        VersionInfoPb versionInfoPb;
        VersionInfoPb versionInfoPb2 = remotePosSdkVersionInfo;
        if (versionInfoPb2 == null) {
            versionInfoPb2 = versionInfoPb = new VersionInfoPb(null, null, 0, null, 15, null);
        }
        if ((deviceInfo = remotePosDeviceInfo) == null) {
            deviceInfo = new DeviceInfo(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 65535, null);
        }
        DeviceInfo deviceInfo2 = this.modifyRemotePosDeviceInfo(deviceInfo);
        Object object = remotePosDeviceInfo;
        if (object == null || (object = object.device_uuid) == null) {
            object = "";
        }
        Object object2 = object;
        return new PosInfo(versionInfoPb, deviceInfo2, remotePosSecondarySdkVersionInfo, (String)object2);
    }

    private final DeviceInfo modifyRemotePosDeviceInfo(DeviceInfo remotePosDeviceInfo) {
        if (remotePosDeviceInfo.device_class == DeviceInfo.DeviceClass.POS) {
            return remotePosDeviceInfo;
        }
        Message message = remotePosDeviceInfo.app_model;
        Location location = remotePosDeviceInfo.location;
        DeviceInfo.DeviceClass deviceClass = DeviceInfo.DeviceClass.POS;
        Message modifiedDeviceInfo = message = new DeviceInfo(deviceClass, null, null, (ApplicationModel)message, null, null, null, null, null, null, null, null, null, null, location, null, 49142, null);
        boolean bl = false;
        LOGGER.w("Changed remote POS device info from " + (Object)((Object)remotePosDeviceInfo) + " to " + modifiedDeviceInfo, new Pair[0]);
        return message;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/terminal/api/PosInfoFactory$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "terminal-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

