/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.time;

import com.stripe.jvmcore.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/jvmcore/time/TestClock;", "Lcom/stripe/jvmcore/time/Clock;", "currentTimeMillis", "", "(J)V", "zdt", "Ljava/time/ZonedDateTime;", "(Ljava/time/ZonedDateTime;)V", "strategy", "Lcom/stripe/jvmcore/time/TestClock$Strategy;", "(Lcom/stripe/jvmcore/time/TestClock$Strategy;)V", "elapsedTimeMillis", "setLocalDate", "", "date", "Ljava/time/LocalDate;", "setTimeMillis", "ConstantStrategy", "Strategy", "time"})
public final class TestClock
implements Clock {
    @NotNull
    private Strategy strategy;

    public TestClock(@NotNull Strategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.strategy = strategy;
    }

    public /* synthetic */ TestClock(Strategy strategy, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            strategy = new ConstantStrategy(0L);
        }
        this(strategy);
    }

    public TestClock(long currentTimeMillis) {
        this(new ConstantStrategy(currentTimeMillis));
    }

    public TestClock(@NotNull ZonedDateTime zdt) {
        Intrinsics.checkNotNullParameter((Object)zdt, (String)"zdt");
        this(zdt.toInstant().toEpochMilli());
    }

    public final void setTimeMillis(long currentTimeMillis) {
        this.strategy = new ConstantStrategy(currentTimeMillis);
    }

    public final void setLocalDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        LocalDateTime ldt = LocalDateTime.of(date, LocalTime.of(1, 1));
        ZonedDateTime zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        this.setTimeMillis(zdt.toInstant().toEpochMilli());
    }

    @Override
    public long currentTimeMillis() {
        return this.strategy.currentTimeMillis();
    }

    @Override
    public long elapsedTimeMillis() {
        return this.strategy.elapsedTimeMillis();
    }

    public TestClock() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/time/TestClock$ConstantStrategy;", "Lcom/stripe/jvmcore/time/TestClock$Strategy;", "currentTimeMillis", "", "(J)V", "time"})
    public static final class ConstantStrategy
    implements Strategy {
        private final long currentTimeMillis;

        public ConstantStrategy(long currentTimeMillis) {
            this.currentTimeMillis = currentTimeMillis;
        }

        @Override
        public long currentTimeMillis() {
            return this.currentTimeMillis;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/stripe/jvmcore/time/TestClock$Strategy;", "", "currentTimeMillis", "", "elapsedTimeMillis", "time"})
    public static interface Strategy {
        public long currentTimeMillis();

        default public long elapsedTimeMillis() {
            return this.currentTimeMillis();
        }
    }
}

