/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/stripe/jvmcore/time/TimeUtil;", "", "()V", "epochSecondToZonedDateTime", "Ljava/time/ZonedDateTime;", "epochSecond", "", "zoneId", "Ljava/time/ZoneId;", "timeZone", "Ljava/util/TimeZone;", "localDate", "Ljava/time/LocalDate;", "instant", "Ljava/time/Instant;", "tz", "timeZoneId", "", "time"})
public final class TimeUtil {
    @NotNull
    public static final TimeUtil INSTANCE = new TimeUtil();

    private TimeUtil() {
    }

    @NotNull
    public final ZoneId zoneId(@NotNull String timeZoneId) {
        Intrinsics.checkNotNullParameter((Object)timeZoneId, (String)"timeZoneId");
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(timeZoneId)");
        return this.zoneId(timeZone);
    }

    @NotNull
    public final ZoneId zoneId(@NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        ZoneId zoneId = ZoneId.of(tz.getID(), ZoneId.SHORT_IDS);
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(tz.id, ZoneId.SHORT_IDS)");
        return zoneId;
    }

    @NotNull
    public final ZonedDateTime epochSecondToZonedDateTime(long epochSecond, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return this.epochSecondToZonedDateTime(epochSecond, this.zoneId(timeZone));
    }

    @NotNull
    public final ZonedDateTime epochSecondToZonedDateTime(long epochSecond, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond), zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(Instant.ofEpoc\u2026ond(epochSecond), zoneId)");
        return zonedDateTime;
    }

    @NotNull
    public final LocalDate localDate(@NotNull Instant instant, @NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        LocalDate localDate = instant.atZone(this.zoneId(tz)).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"instant.atZone(zoneId(tz)).toLocalDate()");
        return localDate;
    }
}

