/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.transaction;

import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.ExtendedActionConstants;
import com.stripe.proto.model.rest.Charge;
import com.stripe.proto.model.rest.ErrorResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.PaymentIntent;
import com.stripe.proto.model.rest.PaymentMethod;
import com.stripe.proto.model.rest.PaymentMethodDetails;
import com.stripe.proto.model.rest.Refund;
import com.stripe.proto.model.rest.SetupIntent;
import com.stripe.proto.model.rest.StatusCode;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u001d\u0010\n\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007H\u0007\u00a2\u0006\u0002\b\fJ\n\u0010\r\u001a\u00020\u0006*\u00020\u000eJ\u001d\u0010\u000f\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\b\u0011J\u001d\u0010\u000f\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\b\u0012J-\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\b\u001aJ%\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\b\u001bJ%\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0015\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\fJ\u0014\u0010\u001c\u001a\u00020\u0014*\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u0006J\u0014\u0010\u001c\u001a\u00020\u0014*\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u000e\u0010\u001e\u001a\u00020\u0014*\u0004\u0018\u00010\u001dH\u0002J\f\u0010\u001f\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0014\u0010 \u001a\u00020\u0014*\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010!\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/stripe/jvmcore/transaction/Extensions;", "", "()V", "TAG", "", "isDeclinedCharge", "", "Lcom/stripe/jvmcore/restclient/RestResponse$Success;", "Lcom/stripe/proto/model/rest/PaymentIntent;", "Lcom/stripe/proto/model/rest/ErrorWrapper;", "isSetupError", "Lcom/stripe/proto/model/rest/SetupIntent;", "toChargeAttemptForSetupIntent", "isSuccess", "Lcom/stripe/proto/model/rest/Refund;", "requiresExtendedAction", "Lcom/stripe/jvmcore/restclient/RestResponse;", "requiresExtendedActionForPaymentIntent", "requiresExtendedActionForSetupIntent", "toChargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "allowExtendedTransactions", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "toChargeAttemptForPaymentIntent", "Lcom/stripe/proto/model/rest/PaymentMethod;", "toChargeAttemptForPaymentMethod", "toChargeAttemptForRefund", "toDeclinedAttempt", "Lcom/stripe/proto/model/rest/ErrorResponse;", "toDeclinedAttemptForStandardAttempt", "toProperBrand", "toSuccessfulCharge", "toSuccessfulRefund", "jvm-transaction"})
public final class Extensions {
    @NotNull
    public static final Extensions INSTANCE = new Extensions();
    @NotNull
    private static final String TAG = "transaction/Extensions";

    private Extensions() {
    }

    @JvmName(name="requiresExtendedActionForPaymentIntent")
    public final boolean requiresExtendedActionForPaymentIntent(@NotNull RestResponse<PaymentIntent, ErrorWrapper> $this$requiresExtendedAction) {
        Intrinsics.checkNotNullParameter($this$requiresExtendedAction, (String)"<this>");
        if ($this$requiresExtendedAction instanceof RestResponse.ServerError) {
            ErrorResponse errorResponse = ((ErrorWrapper)((Object)((RestResponse.ServerError)$this$requiresExtendedAction).getResponse())).error;
            return ExtendedActionConstants.INSTANCE.isExtendedActionError(errorResponse != null ? errorResponse.code : null);
        }
        return false;
    }

    @JvmName(name="requiresExtendedActionForSetupIntent")
    public final boolean requiresExtendedActionForSetupIntent(@NotNull RestResponse<SetupIntent, ErrorWrapper> $this$requiresExtendedAction) {
        Intrinsics.checkNotNullParameter($this$requiresExtendedAction, (String)"<this>");
        if ($this$requiresExtendedAction instanceof RestResponse.ServerError) {
            ErrorResponse errorResponse = ((ErrorWrapper)((Object)((RestResponse.ServerError)$this$requiresExtendedAction).getResponse())).error;
            return ExtendedActionConstants.INSTANCE.isExtendedActionError(errorResponse != null ? errorResponse.code : null);
        }
        return false;
    }

    public final boolean isDeclinedCharge(@NotNull RestResponse.Success<PaymentIntent, ErrorWrapper> $this$isDeclinedCharge) {
        Intrinsics.checkNotNullParameter($this$isDeclinedCharge, (String)"<this>");
        return $this$isDeclinedCharge.getResponse().last_payment_error != null;
    }

    @JvmName(name="toChargeAttemptForSetupIntent")
    public final boolean toChargeAttemptForSetupIntent(@NotNull RestResponse.Success<SetupIntent, ErrorWrapper> $this$isSetupError) {
        Intrinsics.checkNotNullParameter($this$isSetupError, (String)"<this>");
        return $this$isSetupError.getResponse().last_setup_error != null;
    }

    @JvmName(name="toChargeAttemptForPaymentIntent")
    @NotNull
    public final ChargeAttempt toChargeAttemptForPaymentIntent(@NotNull RestResponse<PaymentIntent, ErrorWrapper> $this$toChargeAttempt, boolean allowExtendedTransactions, @NotNull LogWriter logWriter) {
        ChargeAttempt chargeAttempt;
        Intrinsics.checkNotNullParameter($this$toChargeAttempt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        RestResponse<PaymentIntent, ErrorWrapper> restResponse = $this$toChargeAttempt;
        if (restResponse instanceof RestResponse.Success) {
            chargeAttempt = this.isDeclinedCharge((RestResponse.Success)$this$toChargeAttempt) ? this.toDeclinedAttempt(new ErrorWrapper(((PaymentIntent)((Object)((RestResponse.Success)$this$toChargeAttempt).getResponse())).last_payment_error, null, null, 6, null), allowExtendedTransactions) : this.toSuccessfulCharge((PaymentIntent)((Object)((RestResponse.Success)$this$toChargeAttempt).getResponse()), logWriter);
        } else if (restResponse instanceof RestResponse.ServerError) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toChargeAttempt.getStatusCode().ordinal()]) {
                case 1: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                    break;
                }
                case 2: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                    break;
                }
                default: {
                    chargeAttempt = this.toDeclinedAttempt((ErrorWrapper)((Object)((RestResponse.ServerError)$this$toChargeAttempt).getResponse()), allowExtendedTransactions);
                    break;
                }
            }
        } else if (restResponse instanceof RestResponse.ParseError) {
            chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chargeAttempt;
    }

    @JvmName(name="toChargeAttemptForSetupIntent")
    @NotNull
    public final ChargeAttempt toChargeAttemptForSetupIntent(@NotNull RestResponse<SetupIntent, ErrorWrapper> $this$toChargeAttempt, boolean allowExtendedTransactions) {
        ChargeAttempt chargeAttempt;
        Intrinsics.checkNotNullParameter($this$toChargeAttempt, (String)"<this>");
        RestResponse<SetupIntent, ErrorWrapper> restResponse = $this$toChargeAttempt;
        if (restResponse instanceof RestResponse.Success) {
            chargeAttempt = this.toChargeAttemptForSetupIntent((RestResponse.Success)$this$toChargeAttempt) ? this.toDeclinedAttempt(new ErrorWrapper(null, ((SetupIntent)((Object)((RestResponse.Success)$this$toChargeAttempt).getResponse())).last_setup_error, null, 5, null), allowExtendedTransactions) : (ChargeAttempt)ChargeAttempt.CompletedAttempt.SuccessfulSetupIntent.INSTANCE;
        } else if (restResponse instanceof RestResponse.ServerError) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toChargeAttempt.getStatusCode().ordinal()]) {
                case 1: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                    break;
                }
                case 2: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                    break;
                }
                default: {
                    chargeAttempt = this.toDeclinedAttempt((ErrorWrapper)((Object)((RestResponse.ServerError)$this$toChargeAttempt).getResponse()), allowExtendedTransactions);
                    break;
                }
            }
        } else if (restResponse instanceof RestResponse.ParseError) {
            chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chargeAttempt;
    }

    private final ChargeAttempt toSuccessfulCharge(PaymentIntent $this$toSuccessfulCharge, LogWriter logWriter) {
        ChargeAttempt chargeAttempt;
        Object object = $this$toSuccessfulCharge.charges;
        PaymentMethodDetails details = object != null && (object = object.data_) != null && (object = (Charge)((Object)CollectionsKt.firstOrNull((List)object))) != null ? ((Charge)((Object)object)).payment_method_details : null;
        Long l2 = $this$toSuccessfulCharge.amount;
        long l3 = l2 != null ? l2 : 0L;
        String string = $this$toSuccessfulCharge.currency;
        if (string == null) {
            string = "";
        }
        Amount amount = new Amount(l3, string);
        PaymentMethodDetails paymentMethodDetails = details;
        if ((paymentMethodDetails != null ? paymentMethodDetails.card_present : null) != null) {
            Object object2;
            Object object3 = details.card_present;
            if (object3 == null || (object3 = object3.brand) == null || (object3 = this.toProperBrand((String)object3)) == null) {
                object3 = "";
            }
            if ((object2 = details.card_present) == null || (object2 = object2.last4) == null) {
                object2 = "";
            }
            chargeAttempt = new ChargeAttempt.CompletedAttempt.SuccessfulCharge((String)object3, (String)object2, amount);
        } else {
            PaymentMethodDetails paymentMethodDetails2 = details;
            if ((paymentMethodDetails2 != null ? paymentMethodDetails2.interac_present : null) != null) {
                Object object4;
                Object object5 = details.interac_present;
                if (object5 == null || (object5 = object5.brand) == null || (object5 = this.toProperBrand((String)object5)) == null) {
                    object5 = "";
                }
                if ((object4 = details.interac_present) == null || (object4 = object4.last4) == null) {
                    object4 = "";
                }
                chargeAttempt = new ChargeAttempt.CompletedAttempt.SuccessfulCharge((String)object5, (String)object4, amount);
            } else {
                PaymentMethodDetails paymentMethodDetails3 = details;
                if ((paymentMethodDetails3 != null ? paymentMethodDetails3.card : null) != null) {
                    Object object6;
                    Object object7 = details.card;
                    if (object7 == null || (object7 = object7.brand) == null || (object7 = this.toProperBrand((String)object7)) == null) {
                        object7 = "";
                    }
                    if ((object6 = details.card) == null || (object6 = object6.last4) == null) {
                        object6 = "";
                    }
                    chargeAttempt = new ChargeAttempt.CompletedAttempt.SuccessfulCharge((String)object7, (String)object6, amount);
                } else {
                    PaymentMethodDetails paymentMethodDetails4 = details;
                    logWriter.w(TAG, "Unable to parse type " + (paymentMethodDetails4 != null ? paymentMethodDetails4.type : null));
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                }
            }
        }
        return chargeAttempt;
    }

    private final ChargeAttempt toDeclinedAttempt(ErrorWrapper $this$toDeclinedAttempt, boolean allowExtendedTransactions) {
        return this.toDeclinedAttempt($this$toDeclinedAttempt.error, allowExtendedTransactions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final ChargeAttempt toDeclinedAttempt(@Nullable ErrorResponse $this$toDeclinedAttempt, boolean allowExtendedTransactions) {
        String string;
        ChargeAttempt chargeAttempt;
        if (!allowExtendedTransactions) {
            chargeAttempt = this.toDeclinedAttemptForStandardAttempt($this$toDeclinedAttempt);
            return chargeAttempt;
        }
        ErrorResponse errorResponse = $this$toDeclinedAttempt;
        String string2 = string = errorResponse != null ? errorResponse.decline_code : null;
        if (string != null) {
            int n2 = -1;
            switch (string.hashCode()) {
                case 748045013: {
                    if (!string.equals("online_or_offline_pin_required")) break;
                    n2 = 1;
                    break;
                }
                case -803280923: {
                    if (!string.equals("offline_pin_required")) break;
                    n2 = 2;
                    break;
                }
                case 1493626330: {
                    if (!string.equals("mobile_device_authentication_required")) break;
                    n2 = 3;
                    break;
                }
            }
            switch (n2) {
                case 2: {
                    Object object = $this$toDeclinedAttempt.payment_intent;
                    if (object == null || (object = object.id) == null) {
                        object = "";
                    }
                    chargeAttempt = new ChargeAttempt.ExtendedAttempt((String)object, ChargeAttempt.ExtendedAttempt.Requirement.OFFLINE_PIN_REQUIRED);
                    return chargeAttempt;
                }
                case 1: {
                    Object object = $this$toDeclinedAttempt.payment_intent;
                    if (object == null || (object = object.id) == null) {
                        object = "";
                    }
                    chargeAttempt = new ChargeAttempt.ExtendedAttempt((String)object, ChargeAttempt.ExtendedAttempt.Requirement.ONLINE_OR_OFFLINE_PIN_REQUIRED);
                    return chargeAttempt;
                }
                case 3: {
                    Object object = $this$toDeclinedAttempt.payment_intent;
                    if (object == null || (object = object.id) == null) {
                        object = "";
                    }
                    chargeAttempt = new ChargeAttempt.ExtendedAttempt((String)object, ChargeAttempt.ExtendedAttempt.Requirement.MOBILE_DEVICE_AUTHENTICATION_REQUIRED);
                    return chargeAttempt;
                }
            }
        }
        chargeAttempt = this.toDeclinedAttemptForStandardAttempt($this$toDeclinedAttempt);
        return chargeAttempt;
    }

    private final ChargeAttempt toDeclinedAttemptForStandardAttempt(ErrorResponse $this$toDeclinedAttemptForStandardAttempt) {
        ChargeAttempt chargeAttempt;
        ErrorResponse errorResponse = $this$toDeclinedAttemptForStandardAttempt;
        if (Intrinsics.areEqual((Object)(errorResponse != null ? errorResponse.code : null), (Object)"charge_already_refunded")) {
            chargeAttempt = ChargeAttempt.CompletedAttempt.AlreadyRefunded.INSTANCE;
        } else {
            Object object = $this$toDeclinedAttemptForStandardAttempt;
            if (object == null || (object = object.decline_code) == null) {
                object = "";
            }
            chargeAttempt = new ChargeAttempt.CompletedAttempt.DeclinedCharge((String)object);
        }
        return chargeAttempt;
    }

    @JvmName(name="toChargeAttemptForPaymentMethod")
    @NotNull
    public final ChargeAttempt toChargeAttemptForPaymentMethod(@NotNull RestResponse<PaymentMethod, ErrorWrapper> $this$toChargeAttempt) {
        ChargeAttempt chargeAttempt;
        Intrinsics.checkNotNullParameter($this$toChargeAttempt, (String)"<this>");
        RestResponse<PaymentMethod, ErrorWrapper> restResponse = $this$toChargeAttempt;
        if (restResponse instanceof RestResponse.Success) {
            chargeAttempt = ChargeAttempt.CompletedAttempt.SuccessfulReusableCard.INSTANCE;
        } else if (restResponse instanceof RestResponse.ServerError) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toChargeAttempt.getStatusCode().ordinal()]) {
                case 1: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                    break;
                }
                case 2: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
                    break;
                }
                default: {
                    chargeAttempt = this.toDeclinedAttempt((ErrorWrapper)((Object)((RestResponse.ServerError)$this$toChargeAttempt).getResponse()), false);
                    break;
                }
            }
        } else if (restResponse instanceof RestResponse.ParseError) {
            chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chargeAttempt;
    }

    private final String toProperBrand(String $this$toProperBrand) {
        String string;
        switch ($this$toProperBrand) {
            case "visa": {
                string = "Visa";
                break;
            }
            case "mastercard": {
                string = "MasterCard";
                break;
            }
            case "discover": {
                string = "Discover";
                break;
            }
            case "jcb": {
                string = "JCB";
                break;
            }
            case "unionpay": {
                string = "UnionPay";
                break;
            }
            case "diners": {
                string = "Diners Club";
                break;
            }
            case "amex": {
                string = "American Express";
                break;
            }
            default: {
                string = $this$toProperBrand;
            }
        }
        return string;
    }

    @JvmName(name="toChargeAttemptForRefund")
    @NotNull
    public final ChargeAttempt toChargeAttemptForRefund(@NotNull RestResponse<Refund, ErrorWrapper> $this$toChargeAttempt, @NotNull LogWriter logWriter) {
        ChargeAttempt chargeAttempt;
        Intrinsics.checkNotNullParameter($this$toChargeAttempt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        RestResponse<Refund, ErrorWrapper> restResponse = $this$toChargeAttempt;
        if (restResponse instanceof RestResponse.Success) {
            if (this.isSuccess((Refund)((Object)((RestResponse.Success)$this$toChargeAttempt).getResponse()))) {
                chargeAttempt = this.toSuccessfulRefund((Refund)((Object)((RestResponse.Success)$this$toChargeAttempt).getResponse()), logWriter);
            } else {
                String string = ((Refund)((Object)((RestResponse.Success)$this$toChargeAttempt).getResponse())).failure_reason;
                if (string == null) {
                    string = "";
                }
                chargeAttempt = new ChargeAttempt.CompletedAttempt.DeclinedRefund(string);
            }
        } else if (restResponse instanceof RestResponse.ServerError) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toChargeAttempt.getStatusCode().ordinal()]) {
                case 1: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE;
                    break;
                }
                case 2: {
                    chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE;
                    break;
                }
                default: {
                    chargeAttempt = this.toDeclinedAttempt((ErrorWrapper)((Object)((RestResponse.ServerError)$this$toChargeAttempt).getResponse()), false);
                    break;
                }
            }
        } else if (restResponse instanceof RestResponse.ParseError) {
            chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chargeAttempt;
    }

    private final ChargeAttempt toSuccessfulRefund(Refund $this$toSuccessfulRefund, LogWriter logWriter) {
        ChargeAttempt chargeAttempt;
        PaymentMethodDetails details = $this$toSuccessfulRefund.payment_method_details;
        Long l2 = $this$toSuccessfulRefund.amount;
        long l3 = l2 != null ? l2 : 0L;
        String string = $this$toSuccessfulRefund.currency;
        if (string == null) {
            string = "";
        }
        Amount amount = new Amount(l3, string);
        PaymentMethodDetails paymentMethodDetails = details;
        if ((paymentMethodDetails != null ? paymentMethodDetails.card_present : null) != null) {
            Object object;
            Object object2 = details.card_present;
            if (object2 == null || (object2 = object2.brand) == null || (object2 = this.toProperBrand((String)object2)) == null) {
                object2 = "";
            }
            if ((object = details.card_present) == null || (object = object.last4) == null) {
                object = "";
            }
            chargeAttempt = new ChargeAttempt.CompletedAttempt.SuccessfulRefund((String)object2, (String)object, amount);
        } else {
            PaymentMethodDetails paymentMethodDetails2 = details;
            if ((paymentMethodDetails2 != null ? paymentMethodDetails2.interac_present : null) != null) {
                Object object;
                Object object3 = details.interac_present;
                if (object3 == null || (object3 = object3.brand) == null || (object3 = this.toProperBrand((String)object3)) == null) {
                    object3 = "";
                }
                if ((object = details.interac_present) == null || (object = object.last4) == null) {
                    object = "";
                }
                chargeAttempt = new ChargeAttempt.CompletedAttempt.SuccessfulRefund((String)object3, (String)object, amount);
            } else {
                PaymentMethodDetails paymentMethodDetails3 = details;
                logWriter.w(TAG, "Unable to parse type " + (paymentMethodDetails3 != null ? paymentMethodDetails3.type : null));
                chargeAttempt = ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE;
            }
        }
        return chargeAttempt;
    }

    public final boolean isSuccess(@NotNull Refund $this$isSuccess) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isSuccess), (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isSuccess.status, (Object)"pending") || Intrinsics.areEqual((Object)$this$isSuccess.status, (Object)"succeeded");
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatusCode.values().length];
            try {
                nArray[StatusCode.HTTP_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatusCode.HTTP_ERROR_UNKNOWN_STATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

