/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.transaction.payment;

import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.SourceType;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.transaction.payment.EmvPaymentKt;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.proto.api.rest.RequestedPaymentMethod;
import com.stripe.proto.model.sdk.CardEntryMethod;
import com.stripe.proto.model.sdk.CardPaymentMethod;
import com.stripe.proto.model.sdk.PaymentMethod;
import dev.zacsweers.redacted.annotations.Redacted;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\b\u0010$\u001a\u00020\u000bH\u0016J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/stripe/jvmcore/transaction/payment/EmvPayment;", "Lcom/stripe/jvmcore/transaction/payment/Payment;", "authData", "", "interfaceType", "Lcom/stripe/jvmcore/hardware/emv/InterfaceType;", "transactionType", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "sourceType", "Lcom/stripe/jvmcore/hardware/emv/SourceType;", "encryptedEmv", "", "(Ljava/lang/String;Lcom/stripe/jvmcore/hardware/emv/InterfaceType;Lcom/stripe/jvmcore/hardware/emv/TransactionType;Lcom/stripe/jvmcore/hardware/emv/SourceType;Z)V", "getAuthData$annotations", "()V", "getAuthData", "()Ljava/lang/String;", "getEncryptedEmv", "()Z", "getInterfaceType", "()Lcom/stripe/jvmcore/hardware/emv/InterfaceType;", "getSourceType", "()Lcom/stripe/jvmcore/hardware/emv/SourceType;", "getTransactionType", "()Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "supportsSca", "toString", "jvm-transaction"})
public final class EmvPayment
extends Payment {
    @NotNull
    private final String authData;
    @NotNull
    private final InterfaceType interfaceType;
    @NotNull
    private final TransactionType transactionType;
    @NotNull
    private final SourceType sourceType;
    private final boolean encryptedEmv;

    public EmvPayment(@NotNull String authData, @NotNull InterfaceType interfaceType, @NotNull TransactionType transactionType, @NotNull SourceType sourceType, boolean encryptedEmv) {
        PaymentMethod paymentMethod;
        RequestedPaymentMethod requestedPaymentMethod;
        RequestedPaymentMethod.RequestedCardPresent requestedCardPresent;
        Intrinsics.checkNotNullParameter((Object)authData, (String)"authData");
        Intrinsics.checkNotNullParameter((Object)((Object)interfaceType), (String)"interfaceType");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
        this.authData = authData;
        this.interfaceType = interfaceType;
        this.transactionType = transactionType;
        this.sourceType = sourceType;
        this.encryptedEmv = encryptedEmv;
        switch (WhenMappings.$EnumSwitchMapping$0[this.interfaceType.ordinal()]) {
            case 1: {
                String string = this.encryptedEmv ? "encrypted_emv" : "emv";
                String string2 = this.authData;
                String string3 = EmvPaymentKt.toEmvProcessingMethod(this.transactionType);
                requestedCardPresent = new RequestedPaymentMethod.RequestedCardPresent(string, "contact_emv", null, null, string3, string2, null, null, null, null, null, null, null, null, null, 32716, null);
                break;
            }
            case 2: {
                TlvMap tlvMap = TlvMap.Companion.toTlvMap(this.authData);
                requestedCardPresent = new RequestedPaymentMethod.RequestedCardPresent(this.encryptedEmv ? "encrypted_emv" : "emv", Intrinsics.areEqual((Object)(tlvMap != null ? tlvMap.get("9F39") : null), (Object)"91") ? "contactless_magstripe_mode" : "contactless_emv", null, null, null, this.authData, null, null, null, null, null, null, null, null, null, 32732, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        RequestedPaymentMethod.RequestedCardPresent requestedCardPresent2 = requestedCardPresent;
        switch (WhenMappings.$EnumSwitchMapping$1[this.sourceType.ordinal()]) {
            case 1: {
                requestedPaymentMethod = RequestedPaymentMethod.copy$default(this.getRestSource(), "card_present", requestedCardPresent2, null, null, null, null, 60, null);
                break;
            }
            case 2: {
                requestedPaymentMethod = RequestedPaymentMethod.copy$default(this.getRestSource(), "interac_present", null, requestedCardPresent2, null, null, null, 58, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.setRestSource(requestedPaymentMethod);
        PaymentMethod paymentMethod2 = this.getSdkSource();
        if (paymentMethod2 != null) {
            CardEntryMethod cardEntryMethod;
            switch (WhenMappings.$EnumSwitchMapping$0[this.interfaceType.ordinal()]) {
                case 1: {
                    cardEntryMethod = CardEntryMethod.CHIP_READ;
                    break;
                }
                case 2: {
                    cardEntryMethod = CardEntryMethod.CONTACTLESS;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            paymentMethod = PaymentMethod.copy$default(paymentMethod2, new CardPaymentMethod(null, null, null, cardEntryMethod, null, 23, null), null, null, 6, null);
        } else {
            paymentMethod = null;
        }
        this.setSdkSource(paymentMethod);
    }

    public /* synthetic */ EmvPayment(String string, InterfaceType interfaceType, TransactionType transactionType, SourceType sourceType, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        this(string, interfaceType, transactionType, sourceType, bl);
    }

    @NotNull
    public final String getAuthData() {
        return this.authData;
    }

    @Redacted
    public static /* synthetic */ void getAuthData$annotations() {
    }

    @NotNull
    public final InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    @NotNull
    public final TransactionType getTransactionType() {
        return this.transactionType;
    }

    @NotNull
    public final SourceType getSourceType() {
        return this.sourceType;
    }

    public final boolean getEncryptedEmv() {
        return this.encryptedEmv;
    }

    @Override
    public boolean supportsSca() {
        return this.transactionType == TransactionType.TRADITIONAL;
    }

    @NotNull
    public final String component1() {
        return this.authData;
    }

    @NotNull
    public final InterfaceType component2() {
        return this.interfaceType;
    }

    @NotNull
    public final TransactionType component3() {
        return this.transactionType;
    }

    @NotNull
    public final SourceType component4() {
        return this.sourceType;
    }

    public final boolean component5() {
        return this.encryptedEmv;
    }

    @NotNull
    public final EmvPayment copy(@NotNull String authData, @NotNull InterfaceType interfaceType, @NotNull TransactionType transactionType, @NotNull SourceType sourceType, boolean encryptedEmv) {
        Intrinsics.checkNotNullParameter((Object)authData, (String)"authData");
        Intrinsics.checkNotNullParameter((Object)((Object)interfaceType), (String)"interfaceType");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
        return new EmvPayment(authData, interfaceType, transactionType, sourceType, encryptedEmv);
    }

    public static /* synthetic */ EmvPayment copy$default(EmvPayment emvPayment, String string, InterfaceType interfaceType, TransactionType transactionType, SourceType sourceType, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = emvPayment.authData;
        }
        if ((n2 & 2) != 0) {
            interfaceType = emvPayment.interfaceType;
        }
        if ((n2 & 4) != 0) {
            transactionType = emvPayment.transactionType;
        }
        if ((n2 & 8) != 0) {
            sourceType = emvPayment.sourceType;
        }
        if ((n2 & 0x10) != 0) {
            bl = emvPayment.encryptedEmv;
        }
        return emvPayment.copy(string, interfaceType, transactionType, sourceType, bl);
    }

    @NotNull
    public String toString() {
        return "EmvPayment(authData=\u2588\u2588, interfaceType=" + (Object)((Object)this.interfaceType) + ", transactionType=" + (Object)((Object)this.transactionType) + ", sourceType=" + (Object)((Object)this.sourceType) + ", encryptedEmv=" + this.encryptedEmv + ')';
    }

    public int hashCode() {
        int result2 = this.authData.hashCode();
        result2 = result2 * 31 + this.interfaceType.hashCode();
        result2 = result2 * 31 + this.transactionType.hashCode();
        result2 = result2 * 31 + this.sourceType.hashCode();
        int n2 = this.encryptedEmv ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmvPayment)) {
            return false;
        }
        EmvPayment emvPayment = (EmvPayment)other;
        if (!Intrinsics.areEqual((Object)this.authData, (Object)emvPayment.authData)) {
            return false;
        }
        if (this.interfaceType != emvPayment.interfaceType) {
            return false;
        }
        if (this.transactionType != emvPayment.transactionType) {
            return false;
        }
        if (this.sourceType != emvPayment.sourceType) {
            return false;
        }
        return this.encryptedEmv == emvPayment.encryptedEmv;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InterfaceType.values().length];
            try {
                nArray[InterfaceType.CONTACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InterfaceType.CONTACTLESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SourceType.values().length];
            try {
                nArray[SourceType.CARD_PRESENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.INTERAC_PRESENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

