/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.transaction.payment;

import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.proto.api.rest.RequestedPaymentMethod;
import com.stripe.proto.model.sdk.CardEntryMethod;
import com.stripe.proto.model.sdk.CardPaymentMethod;
import com.stripe.proto.model.sdk.CreditCardBrand;
import com.stripe.proto.model.sdk.PaymentMethod;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/stripe/jvmcore/transaction/payment/MagstripePayment;", "Lcom/stripe/jvmcore/transaction/payment/Payment;", "encryptedTrack2", "", "ksn", "maskedPan", "expiryDate", "fallbackReason", "Lcom/stripe/jvmcore/transaction/payment/MagstripePayment$FallbackReason;", "epb", "epbKsn", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/jvmcore/transaction/payment/MagstripePayment$FallbackReason;Ljava/lang/String;Ljava/lang/String;)V", "cardBrand", "Lcom/stripe/proto/model/sdk/CreditCardBrand;", "FallbackReason", "jvm-transaction"})
public final class MagstripePayment
extends Payment {
    public MagstripePayment(@NotNull String encryptedTrack2, @NotNull String ksn, @NotNull String maskedPan, @NotNull String expiryDate, @NotNull FallbackReason fallbackReason, @Nullable String epb, @Nullable String epbKsn) {
        PaymentMethod paymentMethod;
        String string;
        Intrinsics.checkNotNullParameter((Object)encryptedTrack2, (String)"encryptedTrack2");
        Intrinsics.checkNotNullParameter((Object)ksn, (String)"ksn");
        Intrinsics.checkNotNullParameter((Object)maskedPan, (String)"maskedPan");
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)((Object)fallbackReason), (String)"fallbackReason");
        RequestedPaymentMethod requestedPaymentMethod = this.getRestSource();
        String string2 = fallbackReason == FallbackReason.NONE ? "magnetic_stripe_track2" : "magnetic_stripe_fallback";
        switch (WhenMappings.$EnumSwitchMapping$0[fallbackReason.ordinal()]) {
            case 1: {
                string = "chip_error";
                break;
            }
            case 2: {
                string = "chip_error";
                break;
            }
            case 3: {
                string = "empty_candidate_list";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object = string;
        this.setRestSource(RequestedPaymentMethod.copy$default(requestedPaymentMethod, "card_present", new RequestedPaymentMethod.RequestedCardPresent("encrypted_track_data", string2, (String)object, encryptedTrack2, null, null, epb, epbKsn, null, null, null, ksn, null, null, null, 30512, null), null, null, null, null, 60, null));
        PaymentMethod paymentMethod2 = this.getSdkSource();
        if (paymentMethod2 != null) {
            object = this.cardBrand(maskedPan);
            CardEntryMethod cardEntryMethod = fallbackReason == FallbackReason.NONE ? CardEntryMethod.SWIPED : CardEntryMethod.FSWIPE;
            paymentMethod = PaymentMethod.copy$default(paymentMethod2, new CardPaymentMethod(maskedPan, expiryDate, (CreditCardBrand)((Object)object), cardEntryMethod, null, 16, null), null, null, 6, null);
        } else {
            paymentMethod = null;
        }
        this.setSdkSource(paymentMethod);
    }

    public /* synthetic */ MagstripePayment(String string, String string2, String string3, String string4, FallbackReason fallbackReason, String string5, String string6, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            string5 = null;
        }
        if ((n2 & 0x40) != 0) {
            string6 = null;
        }
        this(string, string2, string3, string4, fallbackReason, string5, string6);
    }

    private final CreditCardBrand cardBrand(String maskedPan) {
        CreditCardBrand creditCardBrand;
        if (maskedPan.length() < 2) {
            return CreditCardBrand.INVALID_CREDIT_CARD_BRAND;
        }
        try {
            CreditCardBrand creditCardBrand2;
            block4: {
                Object[] objectArray;
                int n2;
                block3: {
                    String string = maskedPan.substring(0, 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    n2 = Integer.parseInt(string);
                    boolean bl = 40 <= n2 ? n2 < 50 : false;
                    if (!bl) break block3;
                    creditCardBrand2 = CreditCardBrand.VISA;
                    break block4;
                }
                creditCardBrand2 = (50 <= n2 ? n2 < 60 : false) ? CreditCardBrand.MASTERCARD : ((22 <= n2 ? n2 < 28 : false) ? CreditCardBrand.MASTERCARD : (n2 == 67 ? CreditCardBrand.MASTERCARD : (n2 == 35 ? CreditCardBrand.JCB : (ArraysKt.contains((Object[])(objectArray = new Integer[]{30, 36, 38, 39}), (Object)n2) ? CreditCardBrand.DINERS : (ArraysKt.contains((Object[])(objectArray = new Integer[]{60, 64, 65}), (Object)n2) ? CreditCardBrand.DISCOVER : (n2 == 62 ? CreditCardBrand.CUP : CreditCardBrand.UNKNOWN_CREDIT))))));
            }
            creditCardBrand = creditCardBrand2;
        }
        catch (NumberFormatException e2) {
            creditCardBrand = CreditCardBrand.INVALID_CREDIT_CARD_BRAND;
        }
        return creditCardBrand;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/jvmcore/transaction/payment/MagstripePayment$FallbackReason;", "", "(Ljava/lang/String;I)V", "NONE", "CHIP_ERROR", "EMPTY_CANDIDATE_LIST", "jvm-transaction"})
    public static final class FallbackReason
    extends Enum<FallbackReason> {
        public static final /* enum */ FallbackReason NONE = new FallbackReason();
        public static final /* enum */ FallbackReason CHIP_ERROR = new FallbackReason();
        public static final /* enum */ FallbackReason EMPTY_CANDIDATE_LIST = new FallbackReason();
        private static final /* synthetic */ FallbackReason[] $VALUES;

        public static FallbackReason[] values() {
            return (FallbackReason[])$VALUES.clone();
        }

        public static FallbackReason valueOf(String value) {
            return Enum.valueOf(FallbackReason.class, value);
        }

        static {
            $VALUES = fallbackReasonArray = new FallbackReason[]{FallbackReason.NONE, FallbackReason.CHIP_ERROR, FallbackReason.EMPTY_CANDIDATE_LIST};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FallbackReason.values().length];
            try {
                nArray[FallbackReason.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FallbackReason.CHIP_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FallbackReason.EMPTY_CANDIDATE_LIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

