/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode;

import com.squareup.wire.Message;
import com.stripe.jvmcore.dagger.Offline;
import com.stripe.jvmcore.device.ActiveReaderConfigRepository;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.terminal.api.ActivateReaderResponse;
import com.stripe.jvmcore.terminal.api.PosInfo;
import com.stripe.jvmcore.terminal.api.PosInfoFactory;
import com.stripe.jvmcore.time.Clock;
import com.stripe.offlinemode.DefaultOfflineEventHandler;
import com.stripe.offlinemode.DefaultOfflineEventHandler$special$;
import com.stripe.offlinemode.OfflineEventHandler;
import com.stripe.offlinemode.OfflineIdGenerator;
import com.stripe.offlinemode.forwarding.OfflineForwardingManager;
import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import com.stripe.offlinemode.storage.OfflineRepository;
import com.stripe.proto.api.rest.ConfirmPaymentIntentRequest;
import com.stripe.proto.api.rest.ConnectionType;
import com.stripe.proto.api.rest.CreatePaymentIntentRequest;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.VersionInfoPb;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.offline_mode.NameValuePair;
import com.stripe.proto.model.offline_mode.OfflineConnection;
import com.stripe.proto.model.offline_mode.OfflinePaymentIntentRequest;
import com.stripe.proto.model.offline_mode.OfflineReader;
import com.stripe.proto.model.rest.Method;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.OfflineDomain;
import com.stripe.proto.terminal.terminal.pub.message.config.OfflineConfigPb;
import com.stripe.stripeterminal.external.models.CaptureMethod;
import com.stripe.stripeterminal.external.models.ConnectionConfiguration;
import com.stripe.stripeterminal.external.models.Location;
import com.stripe.stripeterminal.external.models.NetworkStatus;
import com.stripe.stripeterminal.external.models.OfflineDetails;
import com.stripe.stripeterminal.external.models.PaymentIntent;
import com.stripe.stripeterminal.external.models.PaymentIntentStatus;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.external.models.Tip;
import com.stripe.stripeterminal.internal.common.adapter.OfflineAdapterKt;
import com.stripe.stripeterminal.internal.common.extensions.ReaderExtensionsKt;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 e2\u00020\u0001:\u0001eB\u0084\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0013\b\u0001\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013\u0012\"\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0017j\u0002`\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0016\u00103\u001a\u00020,2\f\u00104\u001a\b\u0012\u0004\u0012\u00020,05H\u0016J\u0010\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\"H\u0016J\b\u00108\u001a\u00020,H\u0016J'\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020#2\b\u0010>\u001a\u0004\u0018\u00010/H\u0002\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020\"H\u0002J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u000200H\u0016JV\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020L2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!2\u0018\u0010N\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0P0O2\u0006\u0010Q\u001a\u00020\"H\u0016JF\u0010R\u001a\u00020H2\u0006\u0010S\u001a\u00020<2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!2\u0018\u0010N\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0P0O2\u0006\u0010Q\u001a\u00020\"H\u0016J\"\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020U0!2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\"0OH\u0016J \u0010W\u001a\u00020,2\u0006\u0010A\u001a\u00020\"2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u000200H\u0016J\b\u0010X\u001a\u00020\u001fH\u0002J\u0010\u0010Y\u001a\u00020,2\u0006\u0010A\u001a\u00020\"H\u0002J\b\u0010Z\u001a\u00020,H\u0016J\u0010\u0010[\u001a\u00020,2\u0006\u00107\u001a\u00020\"H\u0016J!\u0010\\\u001a\u00020,2\b\u0010]\u001a\u0004\u0018\u00010\"2\b\u0010^\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010_J,\u0010`\u001a\u0002Ha\"\u0006\b\u0000\u0010a\u0018\u00012\u0006\u0010b\u001a\u00020\"2\f\u0010c\u001a\b\u0012\u0004\u0012\u0002Ha05H\u0082\b\u00a2\u0006\u0002\u0010dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0017j\u0002`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010*\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010.\u001a\u00020/*\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006f"}, d2={"Lcom/stripe/offlinemode/DefaultOfflineEventHandler;", "Lcom/stripe/offlinemode/OfflineEventHandler;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "offlineRepository", "Lcom/stripe/offlinemode/storage/OfflineRepository;", "offlineIdGenerator", "Lcom/stripe/offlinemode/OfflineIdGenerator;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "activeReaderConfigRepository", "Lcom/stripe/jvmcore/device/ActiveReaderConfigRepository;", "posInfoFactory", "Lcom/stripe/jvmcore/terminal/api/PosInfoFactory;", "offlineForwardingManager", "Lcom/stripe/offlinemode/forwarding/OfflineForwardingManager;", "offlineConfigHelper", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "stripeNetworkStatusFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/stripeterminal/external/models/NetworkStatus;", "Lkotlin/jvm/JvmSuppressWildcards;", "offlineDiscreteLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope$Builder;", "Lcom/stripe/offlinemode/log/OfflineDiscreteLogger;", "(Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/offlinemode/storage/OfflineRepository;Lcom/stripe/offlinemode/OfflineIdGenerator;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/jvmcore/device/ActiveReaderConfigRepository;Lcom/stripe/jvmcore/terminal/api/PosInfoFactory;Lcom/stripe/offlinemode/forwarding/OfflineForwardingManager;Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;Lkotlinx/coroutines/flow/Flow;Lcom/stripe/jvmcore/logging/HealthLogger;)V", "enqueueActivateReaderJob", "Lkotlinx/coroutines/Job;", "offlinePaymentAmountsByCurrency", "", "", "", "getOfflinePaymentAmountsByCurrency", "()Ljava/util/Map;", "offlinePaymentsCount", "", "getOfflinePaymentsCount", "()I", "onlineTransitionFlow", "restartForwardingFlow", "", "restartForwardingOfflinePaymentsJob", "supportsOffline", "", "Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;", "getSupportsOffline", "(Lcom/stripe/stripeterminal/external/models/ConnectionConfiguration;)Z", "activateReaderWhenOnline", "enqueueActivateReader", "Lkotlin/Function0;", "cancelPendingActivations", "reason", "clear", "createPaymentIntent", "Lcom/stripe/proto/model/rest/PaymentIntent;", "createPaymentIntentRequest", "Lcom/stripe/proto/api/rest/CreatePaymentIntentRequest;", "timestampMs", "livemode", "(Lcom/stripe/proto/api/rest/CreatePaymentIntentRequest;JLjava/lang/Boolean;)Lcom/stripe/proto/model/rest/PaymentIntent;", "listenForReaderOfflineConfig", "accountId", "onActivateReaderRequest", "Lcom/stripe/jvmcore/terminal/api/ActivateReaderResponse;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "connectionConfiguration", "onConfirmPaymentIntentRequest", "Lcom/stripe/stripeterminal/external/models/PaymentIntent;", "intent", "emvData", "confirmPaymentIntentRequest", "Lcom/stripe/proto/api/rest/ConfirmPaymentIntentRequest;", "requestHeaders", "requestParams", "", "Lkotlin/Pair;", "endpoint", "onCreatePaymentIntentRequest", "request", "onLocationsRequests", "Lcom/stripe/stripeterminal/external/models/Location;", "deviceSerials", "onReaderActivated", "resumeForwardingOfflinePayments", "setAccountId", "startForwardingOfflinePayments", "stopForwardingOfflinePayments", "validatePaymentAmount", "currency", "amount", "(Ljava/lang/String;Ljava/lang/Long;)V", "wrapErrorsAsTerminalException", "T", "errorMessage", "block", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nDefaultOfflineEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultOfflineEventHandler.kt\ncom/stripe/offlinemode/DefaultOfflineEventHandler\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,600:1\n21#2:601\n23#2:605\n53#2:606\n55#2:610\n50#3:602\n55#3:604\n50#3:607\n55#3:609\n106#4:603\n106#4:608\n1#5:611\n1549#6:612\n1620#6,3:613\n1549#6:616\n1620#6,3:617\n1238#6,4:626\n48#7,4:620\n442#8:624\n392#8:625\n*S KotlinDebug\n*F\n+ 1 DefaultOfflineEventHandler.kt\ncom/stripe/offlinemode/DefaultOfflineEventHandler\n*L\n92#1:601\n92#1:605\n101#1:606\n101#1:610\n92#1:602\n92#1:604\n101#1:607\n101#1:609\n92#1:603\n101#1:608\n342#1:612\n342#1:613,3\n393#1:616\n393#1:617,3\n574#1:626,4\n484#1:620,4\n574#1:624\n574#1:625\n*E\n"})
public final class DefaultOfflineEventHandler
implements OfflineEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final OfflineRepository offlineRepository;
    @NotNull
    private final OfflineIdGenerator offlineIdGenerator;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ActiveReaderConfigRepository activeReaderConfigRepository;
    @NotNull
    private final PosInfoFactory posInfoFactory;
    @NotNull
    private final OfflineForwardingManager offlineForwardingManager;
    @NotNull
    private final OfflineConfigHelper offlineConfigHelper;
    @NotNull
    private final HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> offlineDiscreteLogger;
    @NotNull
    private Job restartForwardingOfflinePaymentsJob;
    @Nullable
    private Job enqueueActivateReaderJob;
    @NotNull
    private final Flow<NetworkStatus> onlineTransitionFlow;
    @NotNull
    private final Flow<Unit> restartForwardingFlow;
    private static final long ONE_SECOND_MS = 1000L;
    private static final long FORCE_RESUME_INTERVAL_MS = 600000L;
    @NotNull
    private static final String PAYMENT_OFFLINE_ID_KEY = "payment_method_options[card_present][offline][id]";
    @NotNull
    private static final String PAYMENT_STORED_AT_KEY = "payment_method_data[card_present][offline][stored_at]";
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(DefaultOfflineEventHandler.class);

    @Inject
    public DefaultOfflineEventHandler(@NotNull Clock clock, @Offline @NotNull OfflineRepository offlineRepository, @NotNull OfflineIdGenerator offlineIdGenerator, @Offline @NotNull CoroutineDispatcher dispatcher, @NotNull ActiveReaderConfigRepository activeReaderConfigRepository, @NotNull PosInfoFactory posInfoFactory, @NotNull OfflineForwardingManager offlineForwardingManager, @NotNull OfflineConfigHelper offlineConfigHelper, @Offline @NotNull Flow<NetworkStatus> stripeNetworkStatusFlow, @NotNull HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> offlineDiscreteLogger) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)offlineRepository, (String)"offlineRepository");
        Intrinsics.checkNotNullParameter((Object)offlineIdGenerator, (String)"offlineIdGenerator");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)activeReaderConfigRepository, (String)"activeReaderConfigRepository");
        Intrinsics.checkNotNullParameter((Object)posInfoFactory, (String)"posInfoFactory");
        Intrinsics.checkNotNullParameter((Object)offlineForwardingManager, (String)"offlineForwardingManager");
        Intrinsics.checkNotNullParameter((Object)offlineConfigHelper, (String)"offlineConfigHelper");
        Intrinsics.checkNotNullParameter(stripeNetworkStatusFlow, (String)"stripeNetworkStatusFlow");
        Intrinsics.checkNotNullParameter(offlineDiscreteLogger, (String)"offlineDiscreteLogger");
        this.clock = clock;
        this.offlineRepository = offlineRepository;
        this.offlineIdGenerator = offlineIdGenerator;
        this.dispatcher = dispatcher;
        this.activeReaderConfigRepository = activeReaderConfigRepository;
        this.posInfoFactory = posInfoFactory;
        this.offlineForwardingManager = offlineForwardingManager;
        this.offlineConfigHelper = offlineConfigHelper;
        this.offlineDiscreteLogger = offlineDiscreteLogger;
        this.restartForwardingOfflinePaymentsJob = this.resumeForwardingOfflinePayments();
        Flow<NetworkStatus> $this$filter$iv = stripeNetworkStatusFlow;
        boolean $i$f$filter = false;
        Flow<NetworkStatus> $this$unsafeTransform$iv$iv = $this$filter$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        this.onlineTransitionFlow = (Flow)new Flow<NetworkStatus>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof special$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                Object L$1;
                                final /* synthetic */ special$$inlined$filter$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = value;
                                $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                (Continuation)$continuation;
                                it = (NetworkStatus)value;
                                $i$a$-filter-DefaultOfflineEventHandler$onlineTransitionFlow$1 = false;
                                if (!(it == NetworkStatus.ONLINE)) break;
                                $continuation.label = 1;
                                v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                break;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        Object[] objectArray = new Flow[2];
        Flow<NetworkStatus> $this$map$iv = this.onlineTransitionFlow;
        boolean $i$f$map = false;
        Flow<NetworkStatus> $this$unsafeTransform$iv$iv2 = $this$map$iv;
        boolean $i$f$unsafeTransform2 = false;
        boolean $i$f$unsafeFlow2 = false;
        objectArray[0] = (Flow)new Flow<Unit>($this$unsafeTransform$iv$iv2){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof special$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var9_10 = $this$map_u24lambda_u245;
                                (Continuation)$continuation;
                                (NetworkStatus)value;
                                $i$a$-map-DefaultOfflineEventHandler$restartForwardingFlow$1 = false;
                                $continuation.label = 1;
                                v0 = var9_10.emit((Object)Unit.INSTANCE, (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl30
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl30:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        objectArray[1] = FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Unit>, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
lbl6:
                        // 2 sources

                        while (true) {
                            $i$f$currentCoroutineContext = false;
                            if (!JobKt.isActive((CoroutineContext)this.getContext())) break block0;
                            this.L$0 = $this$flow;
                            this.label = 1;
                            v0 = DelayKt.delay((long)600000L, (Continuation)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl20
                            break;
                        }
                    }
                    case 1: {
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        this.L$0 = $this$flow;
                        this.label = 2;
                        v1 = $this$flow.emit((Object)Unit.INSTANCE, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl30:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super Unit>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super Unit> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.restartForwardingFlow = FlowKt.merge((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    private final void setAccountId(String accountId) {
        this.offlineRepository.setActiveAccountId(accountId);
    }

    @Override
    @NotNull
    public Map<String, Long> getOfflinePaymentAmountsByCurrency() {
        Object object;
        Object object2 = this;
        try {
            DefaultOfflineEventHandler $this$_get_offlinePaymentAmountsByCurrency__u24lambda_u242 = object2;
            boolean bl = false;
            object = Result.constructor-impl($this$_get_offlinePaymentAmountsByCurrency__u24lambda_u242.offlineRepository.getOfflinePaymentAmountsByCurrency());
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object error = object = throwable;
            boolean bl = false;
            LOGGER.w((Throwable)error, "Failed to get offline payments by currency", new Pair[0]);
        }
        object = MapsKt.emptyMap();
        return (Map)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    @Override
    public int getOfflinePaymentsCount() {
        Object object;
        Object object2 = this;
        try {
            DefaultOfflineEventHandler $this$_get_offlinePaymentsCount__u24lambda_u244 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$_get_offlinePaymentsCount__u24lambda_u244.offlineRepository.getOfflinePaymentsCount());
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object error = object = throwable;
            boolean bl = false;
            LOGGER.w((Throwable)error, "Failed to get offline payments count", new Pair[0]);
        }
        object = 0;
        return ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue();
    }

    @Override
    public void onReaderActivated(@NotNull String accountId, @NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration) {
        block8: {
            Throwable throwable;
            Object object;
            Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
            try {
                boolean bl = false;
                if (this.offlineRepository.isSupported() && this.getSupportsOffline(connectionConfiguration)) {
                    String string = reader.getId();
                    if (string == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    String id = string;
                    String string3 = reader.getSerialNumber();
                    if (string3 == null) {
                        String string4 = "Required value was null.";
                        throw new IllegalArgumentException(string4.toString());
                    }
                    String serialNumber = string3;
                    String string5 = reader.getFirmwareVersion();
                    if (string5 == null) {
                        String string6 = "Required value was null.";
                        throw new IllegalArgumentException(string6.toString());
                    }
                    String firmwareVersion = string5;
                    String string7 = reader.getConfigVersion();
                    if (string7 == null) {
                        String string8 = "Required value was null.";
                        throw new IllegalArgumentException(string8.toString());
                    }
                    String configVersion = string7;
                    String string9 = reader.getPinKeysetId();
                    if (string9 == null) {
                        String string10 = "Required value was null.";
                        throw new IllegalArgumentException(string10.toString());
                    }
                    String pinKeySetId = string9;
                    this.setAccountId(accountId);
                    long currentTime = this.clock.currentTimeMillis();
                    PosInfo posInfo = this.posInfoFactory.createForLocalPos();
                    OfflineReader offlineReader = this.offlineRepository.getOfflineReader(serialNumber, accountId);
                    OfflineConfigPb.ReaderOfflineConfigPb previouslySavedReaderConfig = offlineReader != null ? offlineReader.reader_offline_config : null;
                    String string11 = reader.getDeviceType().getDeviceName();
                    VersionInfoPb versionInfoPb = posInfo.getVersionInfo();
                    DeviceInfo deviceInfo = reader.toDeviceInfo();
                    DeviceInfo deviceInfo2 = posInfo.getDeviceInfo();
                    ConnectionType connectionType = ReaderExtensionsKt.getConnectionType(reader);
                    Location location = reader.getLocation();
                    ApiLocationPb apiLocationPb = location != null ? ProtoConverter.INSTANCE.toProtoLocation(location) : null;
                    long l2 = this.offlineRepository.saveOfflineReaderAndConnection(new OfflineReader(serialNumber, id, currentTime, accountId, 0L, currentTime, previouslySavedReaderConfig, null, 144, null), new OfflineConnection(firmwareVersion, configVersion, pinKeySetId, accountId, 0L, 0L, currentTime, string11, versionInfoPb, deviceInfo2, deviceInfo, connectionType, apiLocationPb, null, 8240, null));
                    versionInfoPb = (KMutableProperty0)new MutablePropertyReference0Impl(this.offlineRepository){

                        @Nullable
                        public Object get() {
                            return ((OfflineRepository)this.receiver).getCurrentConnectionId();
                        }

                        public void set(@Nullable Object value) {
                            ((OfflineRepository)this.receiver).setCurrentConnectionId(((Number)value).longValue());
                        }
                    };
                    long p0 = l2;
                    boolean bl2 = false;
                    versionInfoPb.set(p0);
                    this.listenForReaderOfflineConfig(accountId);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block8;
            Throwable error = throwable = throwable3;
            boolean bl = false;
            LOGGER.e("Failed to save activated reader.", error, new Pair[0]);
        }
    }

    private final boolean getSupportsOffline(ConnectionConfiguration $this$supportsOffline) {
        boolean bl;
        ConnectionConfiguration connectionConfiguration = $this$supportsOffline;
        if (connectionConfiguration instanceof ConnectionConfiguration.BluetoothConnectionConfiguration ? true : connectionConfiguration instanceof ConnectionConfiguration.UsbConnectionConfiguration) {
            bl = true;
        } else if (connectionConfiguration instanceof ConnectionConfiguration.EmbeddedConnectionConfiguration) {
            bl = ((ConnectionConfiguration.EmbeddedConnectionConfiguration)$this$supportsOffline).getSupportsOfflineMode();
        } else if ((connectionConfiguration instanceof ConnectionConfiguration.HandoffConnectionConfiguration ? true : connectionConfiguration instanceof ConnectionConfiguration.InternetConnectionConfiguration) ? true : connectionConfiguration instanceof ConnectionConfiguration.LocalMobileConnectionConfiguration) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @NotNull
    public ActivateReaderResponse onActivateReaderRequest(@NotNull Reader reader, @NotNull ConnectionConfiguration connectionConfiguration) {
        Object $this$onActivateReaderRequest_u24lambda_u2413;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)connectionConfiguration, (String)"connectionConfiguration");
        Object object = this;
        try {
            Pair pair;
            Object object2;
            long currentTime;
            String pinKeySetId;
            String configVersion;
            String firmwareVersion;
            block14: {
                Object object3;
                Object offlineConnection;
                String accountId;
                String serial;
                block11: {
                    OfflineReader offlineReader;
                    block13: {
                        block12: {
                            $this$onActivateReaderRequest_u24lambda_u2413 = object;
                            boolean bl = false;
                            String string = reader.getSerialNumber();
                            if (string == null) {
                                boolean $i$a$-requireNotNull-DefaultOfflineEventHandler$onActivateReaderRequest$1$serial$22 = false;
                                String $i$a$-requireNotNull-DefaultOfflineEventHandler$onActivateReaderRequest$1$serial$22 = "Reader serial must not be null.";
                                throw new IllegalArgumentException($i$a$-requireNotNull-DefaultOfflineEventHandler$onActivateReaderRequest$1$serial$22.toString());
                            }
                            serial = string;
                            String string2 = reader.getFirmwareVersion();
                            if (string2 == null) {
                                String string3 = "Required value was null.";
                                throw new IllegalArgumentException(string3.toString());
                            }
                            firmwareVersion = string2;
                            String string4 = reader.getConfigVersion();
                            if (string4 == null) {
                                String string5 = "Required value was null.";
                                throw new IllegalArgumentException(string5.toString());
                            }
                            configVersion = string4;
                            String string6 = reader.getPinKeysetId();
                            if (string6 == null) {
                                String string7 = "Required value was null.";
                                throw new IllegalArgumentException(string7.toString());
                            }
                            pinKeySetId = string6;
                            currentTime = ((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413).clock.currentTimeMillis();
                            accountId = ((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413).offlineRepository.getActiveAccountId();
                            KMutableProperty0 kMutableProperty0 = ((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413).offlineRepository.getOfflineReaderAndConnectionIfSaved(reader, accountId);
                            if (kMutableProperty0 == null) break block11;
                            object2 = kMutableProperty0;
                            boolean bl2 = false;
                            offlineReader = (OfflineReader)((Object)object2.component1());
                            offlineConnection = (OfflineConnection)((Object)object2.component2());
                            OfflineConfigPb.ReaderOfflineConfigPb readerOfflineConfigPb = offlineReader.reader_offline_config;
                            if (!(readerOfflineConfigPb != null ? readerOfflineConfigPb.enabled : false)) {
                                boolean $i$a$-check-DefaultOfflineEventHandler$onActivateReaderRequest$1$1$22 = false;
                                String $i$a$-check-DefaultOfflineEventHandler$onActivateReaderRequest$1$1$22 = "Reader " + serial + " is not configured for offline use.";
                                throw new IllegalStateException($i$a$-check-DefaultOfflineEventHandler$onActivateReaderRequest$1$1$22.toString());
                            }
                            object3 = connectionConfiguration.getLocationRegistration();
                            if (!(object3 instanceof ConnectionConfiguration.LocationRegistration.UseId)) break block12;
                            String locationId = connectionConfiguration.getLocationId();
                            ApiLocationPb apiLocationPb = offlineConnection.location;
                            if (Intrinsics.areEqual((Object)locationId, (Object)(apiLocationPb != null ? apiLocationPb.id : null))) break block13;
                            pair = new Pair((Object)offlineReader, (Object)OfflineConnection.copy$default(offlineConnection, null, null, null, null, 0L, 0L, currentTime, null, null, null, null, null, null, null, 12223, null));
                            break block14;
                        }
                        if (Intrinsics.areEqual((Object)object3, (Object)ConnectionConfiguration.LocationRegistration.UsePreSet.INSTANCE)) {
                            // empty if block
                        }
                    }
                    pair = new Pair((Object)offlineReader, offlineConnection);
                    break block14;
                }
                Object $this$onActivateReaderRequest_u24lambda_u2413_u24lambda_u2411 = $this$onActivateReaderRequest_u24lambda_u2413;
                boolean bl = false;
                PosInfo posInfo = ((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413_u24lambda_u2411).posInfoFactory.createForLocalPos();
                offlineConnection = reader.getDeviceType().getDeviceName();
                VersionInfoPb versionInfoPb = posInfo.getVersionInfo();
                object3 = reader.toDeviceInfo();
                DeviceInfo deviceInfo = posInfo.getDeviceInfo();
                ConnectionType connectionType = ReaderExtensionsKt.getConnectionType(reader);
                Pair pair2 = new Pair((Object)new OfflineReader(serial, null, currentTime, accountId, 0L, currentTime, new OfflineConfigPb.ReaderOfflineConfigPb(true, null, 2, null), null, 146, null), (Object)new OfflineConnection(firmwareVersion, configVersion, pinKeySetId, accountId, 0L, 0L, currentTime, (String)offlineConnection, versionInfoPb, deviceInfo, (DeviceInfo)((Object)object3), connectionType, null, null, 8240, null));
                pair = pair2;
            }
            Pair pair3 = pair;
            OfflineReader offlineReader = (OfflineReader)((Object)pair3.component1());
            OfflineConnection offlineConnection = (OfflineConnection)((Object)pair3.component2());
            if (!((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413).offlineConfigHelper.shouldAllowOfflineConnection(reader.getDeviceType(), firmwareVersion, configVersion, pinKeySetId, currentTime) && !(connectionConfiguration instanceof ConnectionConfiguration.EmbeddedConnectionConfiguration)) {
                throw new TerminalException(TerminalException.TerminalErrorCode.READER_CONNECTION_NOT_AVAILABLE_OFFLINE, "The selected reader requires a software update before it can be used to collect payments offline.", null, null, 12, null);
            }
            long l2 = ((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413).offlineRepository.saveOfflineReaderAndConnection(offlineReader, offlineConnection);
            object2 = (KMutableProperty0)new MutablePropertyReference0Impl(((DefaultOfflineEventHandler)$this$onActivateReaderRequest_u24lambda_u2413).offlineRepository){

                @Nullable
                public Object get() {
                    return ((OfflineRepository)this.receiver).getCurrentConnectionId();
                }

                public void set(@Nullable Object value) {
                    ((OfflineRepository)this.receiver).setCurrentConnectionId(((Number)value).longValue());
                }
            };
            long p0 = l2;
            boolean bl = false;
            object2.set((Object)p0);
            String string = offlineReader.account_id;
            object2 = offlineReader.stripe_id;
            Object object4 = offlineConnection.location;
            boolean bl3 = object4 != null && (object4 = object4.livemode) != null ? (Boolean)object4 : true;
            ApiLocationPb apiLocationPb = offlineConnection.location;
            $this$onActivateReaderRequest_u24lambda_u2413 = Result.constructor-impl((Object)new ActivateReaderResponse(string, bl3, (String)object2, null, null, null, null, null, apiLocationPb));
        }
        catch (Throwable bl) {
            $this$onActivateReaderRequest_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$onActivateReaderRequest_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            if (error instanceof TerminalException) {
                throw error;
            }
            TerminalException.TerminalErrorCode terminalErrorCode = TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(terminalErrorCode, "Failed to activate reader offline.", error, null, 8, null);
        }
        return (ActivateReaderResponse)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PaymentIntent onConfirmPaymentIntentRequest(@NotNull PaymentIntent intent, @NotNull String emvData, @NotNull ConfirmPaymentIntentRequest confirmPaymentIntentRequest, @NotNull Map<String, String> requestHeaders, @NotNull List<Pair<String, String>> requestParams, @NotNull String endpoint) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)emvData, (String)"emvData");
        Intrinsics.checkNotNullParameter((Object)((Object)confirmPaymentIntentRequest), (String)"confirmPaymentIntentRequest");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.validatePaymentAmount(intent.getCurrency(), intent.getAmount());
        long epochTimeMs = this.clock.currentTimeMillis();
        String string = OfflineAdapterKt.offlineId(intent);
        Message message = confirmPaymentIntentRequest.payment_method_data;
        String string2 = message != null && (message = message.card_present) != null ? message.read_method : null;
        Tip tip = new Tip(confirmPaymentIntentRequest.amount_tip);
        OfflineDetails offlineDetails = new OfflineDetails(string, epochTimeMs, emvData, tip, string2);
        string2 = Intrinsics.areEqual((Object)intent.getCaptureMethod(), (Object)CaptureMethod.Manual.getKey()) ? PaymentIntentStatus.REQUIRES_CAPTURE : PaymentIntentStatus.SUCCEEDED;
        Long l2 = confirmPaymentIntentRequest.amount_tip;
        long l3 = intent.getAmount() + (l2 != null ? l2 : 0L);
        string2 = PaymentIntent.copy$default((PaymentIntent)intent, null, (long)l3, (long)0L, (long)0L, null, (long)0L, (long)0L, null, null, null, null, null, (long)0L, null, null, null, null, null, (boolean)false, null, null, null, null, null, null, null, (PaymentIntentStatus)string2, null, null, null, null, null, null, (int)-67108867, (int)1, null);
        Object it = string2;
        boolean bl = false;
        OfflineAdapterKt.setOfflineDetails((PaymentIntent)it, offlineDetails);
        String updatedPI = string2;
        it = CollectionsKt.plus((Collection)requestParams, (Object)TuplesKt.to((Object)PAYMENT_STORED_AT_KEY, (Object)String.valueOf(epochTimeMs / 1000L)));
        boolean $i$f$map = false;
        void var14_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            collection.add(new NameValuePair(name, value, null, 4, null));
        }
        List params = (List)destination$iv$iv;
        try {
            this.offlineRepository.saveOfflinePaymentIntentRequest(new OfflinePaymentIntentRequest(OfflinePaymentIntentRequest.PaymentIntentRequestType.PROCESS_PAYMENT_INTENT, this.offlineRepository.getActiveAccountId(), OfflineAdapterKt.offlineId(intent), intent.getId(), this.offlineRepository.getCurrentConnectionId(), 0L, requestHeaders, params, endpoint, ProtoConverter.INSTANCE.toProtoPaymentIntent((PaymentIntent)updatedPI), epochTimeMs, null, 2080, null));
        }
        catch (TerminalException insertionError) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DeclineReason", (Object)"insert_error"), TuplesKt.to((Object)"InsertError", (Object)insertionError.getErrorCode().name())};
            HealthLogger.incrementCounter$default(this.offlineDiscreteLogger, null, MapsKt.mapOf((Pair[])pairArray), null, onConfirmPaymentIntentRequest.1.INSTANCE, 5, null);
            throw insertionError;
        }
        return updatedPI;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PaymentIntent onCreatePaymentIntentRequest(@NotNull CreatePaymentIntentRequest request, @NotNull Map<String, String> requestHeaders, @NotNull List<Pair<String, String>> requestParams, @NotNull String endpoint) {
        String string;
        Object object;
        String $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(requestParams, (String)"requestParams");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.validatePaymentAmount(request.currency, request.amount);
        String offlineId = this.offlineIdGenerator.generateOfflineId();
        long epochTimeMs = this.clock.currentTimeMillis();
        long currentConnectionId = this.offlineRepository.getCurrentConnectionId();
        OfflineConnection offlineConnection = this.offlineRepository.getOfflineConnection(currentConnectionId);
        Object object2 = offlineConnection.location;
        com.stripe.proto.model.rest.PaymentIntent paymentIntent2 = this.createPaymentIntent(request, epochTimeMs, object2 != null && (object2 = object2.livemode) != null ? (Boolean)object2 : true);
        Iterable iterable = CollectionsKt.plus((Collection)requestParams, (Object)TuplesKt.to((Object)PAYMENT_OFFLINE_ID_KEY, (Object)offlineId));
        boolean $i$f$map = false;
        void var15_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            Pair pair = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            object.add(new NameValuePair(name, value, null, 4, null));
        }
        List params = (List)destination$iv$iv;
        Object object3 = this.offlineRepository;
        OfflinePaymentIntentRequest.PaymentIntentRequestType paymentIntentRequestType = OfflinePaymentIntentRequest.PaymentIntentRequestType.CREATE_PAYMENT_INTENT;
        String string2 = this.offlineRepository.getActiveAccountId();
        String string3 = offlineId;
        String string4 = paymentIntent2.id;
        if (string4 != null) {
            void it;
            $this$mapTo$iv$iv = $i$f$map = string4;
            String string5 = string3;
            String string6 = string2;
            OfflinePaymentIntentRequest.PaymentIntentRequestType paymentIntentRequestType2 = paymentIntentRequestType;
            object = object3;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            object3 = object;
            paymentIntentRequestType = paymentIntentRequestType2;
            string2 = string6;
            string3 = string5;
            string = bl2 ? $i$f$map : null;
        } else {
            string = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 2080;
        ByteString byteString = null;
        long l2 = epochTimeMs;
        com.stripe.proto.model.rest.PaymentIntent paymentIntent3 = paymentIntent2;
        String string7 = endpoint;
        List list = params;
        Map<String, String> map2 = requestHeaders;
        long l3 = 0L;
        long l4 = currentConnectionId;
        String string8 = string;
        String string9 = string3;
        String string10 = string2;
        OfflinePaymentIntentRequest.PaymentIntentRequestType paymentIntentRequestType3 = paymentIntentRequestType;
        object3.saveOfflinePaymentIntentRequest(new OfflinePaymentIntentRequest(paymentIntentRequestType3, string10, string9, string8, l4, l3, map2, list, string7, paymentIntent3, l2, byteString, n2, defaultConstructorMarker));
        Iterable it = iterable = PaymentIntent.copy$default((PaymentIntent)ProtoConverter.INSTANCE.toSdkPaymentIntent(paymentIntent2), null, (long)0L, (long)0L, (long)0L, null, (long)0L, (long)0L, null, null, null, null, null, (long)0L, null, null, null, null, null, (boolean)false, null, null, null, null, null, null, null, (PaymentIntentStatus)PaymentIntentStatus.REQUIRES_PAYMENT_METHOD, null, null, null, null, null, null, (int)-67108865, (int)1, null);
        boolean bl = false;
        Date date = new Date(epochTimeMs);
        OfflineAdapterKt.setOfflineDetails((PaymentIntent)it, new OfflineDetails(offlineId, date, null, null, true));
        return iterable;
    }

    @Override
    public void activateReaderWhenOnline(@NotNull Function0<Unit> enqueueActivateReader) {
        Intrinsics.checkNotNullParameter(enqueueActivateReader, (String)"enqueueActivateReader");
        Job job = this.enqueueActivateReaderJob;
        if (job != null) {
            Job $this$activateReaderWhenOnline_u24lambda_u2420 = job;
            boolean bl = false;
            if ($this$activateReaderWhenOnline_u24lambda_u2420.isActive()) {
                JobKt.cancel$default((Job)$this$activateReaderWhenOnline_u24lambda_u2420, (String)"Enqueuing a new activate reader job.", null, (int)2, null);
            }
        }
        Job job2 = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, enqueueActivateReader, null){
            int label;
            final /* synthetic */ DefaultOfflineEventHandler this$0;
            final /* synthetic */ Function0<Unit> $enqueueActivateReader;
            {
                this.this$0 = $receiver;
                this.$enqueueActivateReader = $enqueueActivateReader;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FlowKt.first((Flow)DefaultOfflineEventHandler.access$getOnlineTransitionFlow$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$enqueueActivateReader.invoke();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return DefaultOfflineEventHandler.access$getEnqueueActivateReaderJob$p((DefaultOfflineEventHandler)this.receiver);
            }

            public void set(@Nullable Object value) {
                DefaultOfflineEventHandler.access$setEnqueueActivateReaderJob$p((DefaultOfflineEventHandler)this.receiver, (Job)value);
            }
        };
        Job p0 = job2;
        boolean bl = false;
        kMutableProperty0.set((Object)p0);
    }

    @Override
    public void cancelPendingActivations(@NotNull String reason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Job job = this.enqueueActivateReaderJob;
            if (job == null) break block0;
            JobKt.cancel$default((Job)job, (String)reason, null, (int)2, null);
        }
    }

    private final com.stripe.proto.model.rest.PaymentIntent createPaymentIntent(CreatePaymentIntentRequest createPaymentIntentRequest, long timestampMs, Boolean livemode) {
        Object object;
        block3: {
            com.stripe.proto.model.rest.PaymentIntent pi;
            block2: {
                CreatePaymentIntentRequest $this$createPaymentIntent_u24lambda_u2424 = createPaymentIntentRequest;
                boolean bl = false;
                Long l2 = $this$createPaymentIntent_u24lambda_u2424.amount;
                String string = $this$createPaymentIntent_u24lambda_u2424.currency;
                String string2 = $this$createPaymentIntent_u24lambda_u2424.statement_descriptor;
                String string3 = $this$createPaymentIntent_u24lambda_u2424.description;
                String string4 = $this$createPaymentIntent_u24lambda_u2424.receipt_email;
                Map<String, String> map2 = $this$createPaymentIntent_u24lambda_u2424.metadata;
                Long l3 = $this$createPaymentIntent_u24lambda_u2424.application_fee_amount;
                String string5 = $this$createPaymentIntent_u24lambda_u2424.customer;
                String string6 = $this$createPaymentIntent_u24lambda_u2424.transfer_group;
                pi = new com.stripe.proto.model.rest.PaymentIntent("", timestampMs, null, l2, string, null, string2, string3, string4, livemode, null, map2, null, null, null, null, l3, null, null, null, null, string5, string6, null, null, null, null, null, null, 530510884, null);
                boolean bl2 = false;
                object = $this$createPaymentIntent_u24lambda_u2424.capture_method;
                if (object == null) break block2;
                String it = object;
                boolean bl3 = false;
                com.stripe.proto.model.rest.PaymentIntent paymentIntent2 = com.stripe.proto.model.rest.PaymentIntent.copy$default(pi, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.valueOf(it), null, null, null, null, null, null, null, null, null, null, 0x1FFBFFFF, null);
                object = paymentIntent2;
                if (paymentIntent2 != null) break block3;
            }
            object = pi;
        }
        return object;
    }

    private final void listenForReaderOfflineConfig(String accountId) {
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler handler2 = new CoroutineExceptionHandler(key){

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable exception2 = exception;
                boolean bl = false;
                DefaultOfflineEventHandler.access$getLOGGER$cp().e("failed to update reader with offline config", exception2, new Pair[0]);
            }
        };
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), (CoroutineContext)((CoroutineContext)handler2), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accountId, null){
            int label;
            final /* synthetic */ DefaultOfflineEventHandler this$0;
            final /* synthetic */ String $accountId;
            {
                this.this$0 = $receiver;
                this.$accountId = $accountId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FlowKt.first(DefaultOfflineEventHandler.access$getActiveReaderConfigRepository$p(this.this$0).getReaderConfigFlow(), (Continuation)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Pair)v0;
                        serial = (String)var2_3.component1();
                        config = (OfflineConfigPb.ReaderOfflineConfigPb)var2_3.component2();
                        this.label = 2;
                        v1 = DefaultOfflineEventHandler.access$getOfflineRepository$p(this.this$0).updateOfflineReaderWithConfig((String)var3_4, this.$accountId, config, (Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Job resumeForwardingOfflinePayments() {
        return BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultOfflineEventHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)DefaultOfflineEventHandler.access$getRestartForwardingFlow$p(this.this$0), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DefaultOfflineEventHandler this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DefaultOfflineEventHandler.access$getOfflineForwardingManager$p(this.this$0).startForwarding();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void validatePaymentAmount(String currency, Long amount) throws TerminalException {
        try {
            if (currency == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Payment currency cannot be null", null, null, 12, null);
            }
            if (amount == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Payment amount cannot be null", null, null, 12, null);
            }
            Long l2 = this.offlineConfigHelper.getMaxTransactionLimit(currency);
            if (l2 == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.INVALID_OFFLINE_CURRENCY, "Payment currency (" + currency + ") is not configured for offline transactions.", null, null, 12, null);
            }
            long maxLimit = l2;
            if (maxLimit < amount) {
                throw new TerminalException(TerminalException.TerminalErrorCode.AMOUNT_EXCEEDS_MAX_OFFLINE_AMOUNT, "Payment amount (" + amount + ") must not exceed maximum limit (" + maxLimit + ") allowed offline.", null, null, 12, null);
            }
        }
        catch (TerminalException validationError) {
            HealthLogger.incrementCounter$default(this.offlineDiscreteLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"DeclineReason", (Object)"amount_error")), null, validatePaymentAmount.1.INSTANCE, 5, null);
            throw validationError;
        }
    }

    @Override
    public void clear() {
        this.offlineRepository.clearCache();
    }

    @Override
    public void startForwardingOfflinePayments() {
        Job $this$startForwardingOfflinePayments_u24lambda_u2426 = this.restartForwardingOfflinePaymentsJob;
        boolean bl = false;
        if (!($this$startForwardingOfflinePayments_u24lambda_u2426.start() || $this$startForwardingOfflinePayments_u24lambda_u2426.isActive())) {
            Job job;
            Job it = job = this.resumeForwardingOfflinePayments();
            boolean bl2 = false;
            this.restartForwardingOfflinePaymentsJob = it;
            it.start();
        }
        this.offlineForwardingManager.startForwarding();
    }

    @Override
    public void stopForwardingOfflinePayments(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        JobKt.cancel$default((Job)this.restartForwardingOfflinePaymentsJob, (String)reason, null, (int)2, null);
        this.offlineForwardingManager.stopForwarding(reason);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Location> onLocationsRequests(@NotNull List<String> deviceSerials) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(deviceSerials, (String)"deviceSerials");
        Map $this$mapValues$iv = OfflineRepository.getSavedLocationsMap$default(this.offlineRepository, null, deviceSerials, 1, null);
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            ApiLocationPb v2 = (ApiLocationPb)((Object)entry2.getValue());
            Location location = ProtoConverter.INSTANCE.toSdkLocation(v2);
            map4.put(k2, location);
        }
        return destination$iv$iv;
    }

    private final /* synthetic */ <T> T wrapErrorsAsTerminalException(String errorMessage, Function0<? extends T> block) {
        Object object;
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            object = block.invoke();
        }
        catch (Throwable e2) {
            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, errorMessage, e2, null, 8, null);
        }
        return (T)object;
    }

    public static final /* synthetic */ Flow access$getOnlineTransitionFlow$p(DefaultOfflineEventHandler $this) {
        return $this.onlineTransitionFlow;
    }

    public static final /* synthetic */ Job access$getEnqueueActivateReaderJob$p(DefaultOfflineEventHandler $this) {
        return $this.enqueueActivateReaderJob;
    }

    public static final /* synthetic */ void access$setEnqueueActivateReaderJob$p(DefaultOfflineEventHandler $this, Job job) {
        $this.enqueueActivateReaderJob = job;
    }

    public static final /* synthetic */ ActiveReaderConfigRepository access$getActiveReaderConfigRepository$p(DefaultOfflineEventHandler $this) {
        return $this.activeReaderConfigRepository;
    }

    public static final /* synthetic */ OfflineRepository access$getOfflineRepository$p(DefaultOfflineEventHandler $this) {
        return $this.offlineRepository;
    }

    public static final /* synthetic */ Flow access$getRestartForwardingFlow$p(DefaultOfflineEventHandler $this) {
        return $this.restartForwardingFlow;
    }

    public static final /* synthetic */ OfflineForwardingManager access$getOfflineForwardingManager$p(DefaultOfflineEventHandler $this) {
        return $this.offlineForwardingManager;
    }

    public static final /* synthetic */ Log access$getLOGGER$cp() {
        return LOGGER;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/offlinemode/DefaultOfflineEventHandler$Companion;", "", "()V", "FORCE_RESUME_INTERVAL_MS", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "ONE_SECOND_MS", "PAYMENT_OFFLINE_ID_KEY", "", "PAYMENT_STORED_AT_KEY", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

