/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode;

import com.stripe.offlinemode.OfflineIdGenerator;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/offlinemode/OfflineUUIDGenerator;", "Lcom/stripe/offlinemode/OfflineIdGenerator;", "()V", "generateOfflineId", "", "isOfflineId", "", "id", "Companion", "offlinemode_release"})
public final class OfflineUUIDGenerator
implements OfflineIdGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PREFIX = "pio_";
    @NotNull
    private static final String DASH = "-";
    private static final int OFFLINE_ID_LEN = 36;

    @Inject
    public OfflineUUIDGenerator() {
    }

    @Override
    @NotNull
    public String generateOfflineId() {
        StringBuilder stringBuilder = new StringBuilder().append(PREFIX);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return stringBuilder.append(StringsKt.replace$default((String)string, (String)DASH, (String)"", (boolean)false, (int)4, null)).toString();
    }

    @Override
    public boolean isOfflineId(@NotNull String id) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return StringsKt.startsWith$default((String)id, (String)PREFIX, (boolean)false, (int)2, null) && id.length() == 36 && new Regex("^[a-z0-9]*$").matches(charSequence = (CharSequence)StringsKt.replace$default((String)id, (String)PREFIX, (String)"", (boolean)false, (int)4, null));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/offlinemode/OfflineUUIDGenerator$Companion;", "", "()V", "DASH", "", "OFFLINE_ID_LEN", "", "PREFIX", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

