/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.cipher;

import com.squareup.wire.Message;
import com.stripe.offlinemode.cipher.OfflineCipherException;
import com.stripe.offlinemode.cipher.OfflineDataMismatchException;
import com.stripe.offlinemode.cipher.OfflineDecryptionException;
import com.stripe.offlinemode.cipher.OfflineEncryptionException;
import com.stripe.offlinemode.cipher.OfflineEntityCipher;
import com.stripe.offlinemode.storage.OfflineEntity;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 **\u001c\b\u0000\u0010\u0001*\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003*\b\b\u0001\u0010\u0004*\u00020\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0006:\u0001*B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ%\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H&\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H&\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00028\u00012\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J3\u0010!\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0006\u0012\u0004\u0018\u00010$0#0\"2\u0006\u0010%\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006+"}, d2={"Lcom/stripe/offlinemode/cipher/BaseOfflineCipher;", "M", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "E", "Lcom/stripe/offlinemode/storage/OfflineEntity;", "Lcom/stripe/offlinemode/cipher/OfflineEntityCipher;", "cipher", "Ljavax/crypto/Cipher;", "key", "Ljava/security/Key;", "(Ljavax/crypto/Cipher;Ljava/security/Key;)V", "tableName", "", "getTableName", "()Ljava/lang/String;", "buildEncryptedEntity", "message", "encryptedData", "", "encryptionIV", "(Lcom/squareup/wire/Message;[B[B)Lcom/stripe/offlinemode/storage/OfflineEntity;", "decode", "encoded", "id", "", "([BJ)Lcom/squareup/wire/Message;", "decrypt", "encrypted", "(Lcom/stripe/offlinemode/storage/OfflineEntity;)Lcom/squareup/wire/Message;", "encrypt", "toEncrypt", "(Lcom/squareup/wire/Message;)Lcom/stripe/offlinemode/storage/OfflineEntity;", "getCommonFields", "", "Lkotlin/Pair;", "", "entity", "(Lcom/stripe/offlinemode/storage/OfflineEntity;Lcom/squareup/wire/Message;)Ljava/util/List;", "sanityCheck", "", "(Lcom/stripe/offlinemode/storage/OfflineEntity;Lcom/squareup/wire/Message;)V", "Companion", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nBaseOfflineCipher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseOfflineCipher.kt\ncom/stripe/offlinemode/cipher/BaseOfflineCipher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n819#2:127\n847#2,2:128\n1549#2:130\n1620#2,3:131\n1#3:134\n*S KotlinDebug\n*F\n+ 1 BaseOfflineCipher.kt\ncom/stripe/offlinemode/cipher/BaseOfflineCipher\n*L\n110#1:127\n110#1:128,2\n111#1:130\n111#1:131,3\n*E\n"})
public abstract class BaseOfflineCipher<M extends Message<M, ?>, E extends OfflineEntity>
implements OfflineEntityCipher<M, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cipher cipher;
    @NotNull
    private final Key key;
    private static final int TAG_LENGTH = 128;

    public BaseOfflineCipher(@NotNull Cipher cipher, @NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.cipher = cipher;
        this.key = key;
    }

    @NotNull
    public abstract String getTableName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public E encrypt(@NotNull M toEncrypt) throws OfflineCipherException {
        E e2;
        Intrinsics.checkNotNullParameter(toEncrypt, (String)"toEncrypt");
        try {
            E e3;
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                boolean bl = false;
                this.cipher.init(1, this.key);
                byte[] data = toEncrypt.encode();
                byte[] encryptedData = this.cipher.doFinal(data);
                Intrinsics.checkNotNullExpressionValue((Object)encryptedData, (String)"encryptedData");
                byte[] byArray = this.cipher.getIV();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.iv");
                e3 = this.buildEncryptedEntity(toEncrypt, encryptedData, byArray);
            }
            e2 = e3;
        }
        catch (Exception e4) {
            throw new OfflineEncryptionException(this.getTableName(), e4);
        }
        E entity = e2;
        this.sanityCheck(entity, toEncrypt);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public M decrypt(@NotNull E encrypted) throws OfflineCipherException {
        M m2;
        Intrinsics.checkNotNullParameter(encrypted, (String)"encrypted");
        try {
            M m3;
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                boolean bl = false;
                this.cipher.init(2, this.key, new GCMParameterSpec(128, encrypted.getEncryptionIv()));
                byte[] encoded = this.cipher.doFinal(encrypted.getEncryptedData());
                Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
                m3 = this.decode(encoded, encrypted.getId());
            }
            m2 = m3;
        }
        catch (Exception e2) {
            throw new OfflineDecryptionException(this.getTableName(), e2);
        }
        M message = m2;
        this.sanityCheck(encrypted, message);
        return message;
    }

    @NotNull
    public abstract E buildEncryptedEntity(@NotNull M var1, @NotNull byte[] var2, @NotNull byte[] var3);

    @NotNull
    public abstract M decode(@NotNull byte[] var1, long var2);

    /*
     * WARNING - void declaration
     */
    private final void sanityCheck(E entity, M message) throws OfflineDataMismatchException {
        Iterable iterable;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object dec;
        Object enc;
        Pair pair;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Iterable iterable2 = this.getCommonFields(entity, message);
        boolean $i$f$filterNot = false;
        void var6_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            enc = pair.component1();
            if (Intrinsics.areEqual((Object)enc, (Object)(dec = pair.component2()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            enc = pair.component1();
            dec = pair.component2();
            collection.add(TuplesKt.to((Object)String.valueOf(enc), (Object)String.valueOf(dec)));
        }
        Iterable p0 = iterable2 = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable3 = iterable = !((Collection)p0).isEmpty() ? iterable2 : null;
        if (iterable != null) {
            Iterable fields = iterable;
            boolean bl2 = false;
            throw new OfflineDataMismatchException(this.getTableName(), (List<Pair<String, String>>)fields);
        }
    }

    @NotNull
    public abstract List<Pair<Object, Object>> getCommonFields(@NotNull E var1, @NotNull M var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/offlinemode/cipher/BaseOfflineCipher$Companion;", "", "()V", "TAG_LENGTH", "", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

