/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.cipher;

import android.annotation.TargetApi;
import android.security.keystore.KeyGenParameterSpec;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0003J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\t"}, d2={"Lcom/stripe/offlinemode/cipher/OfflineAesKeyProvider;", "Ljavax/inject/Provider;", "Ljava/security/Key;", "()V", "generateKey", "Ljavax/crypto/SecretKey;", "get", "getSavedKey", "Companion", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nOfflineAesKeyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineAesKeyProvider.kt\ncom/stripe/offlinemode/cipher/OfflineAesKeyProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class OfflineAesKeyProvider
implements Provider<Key> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int KEY_SIZE = 256;
    @NotNull
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    @NotNull
    private static final String OFFLINE_KEY_NAME = "offline_mode_db_key";

    @Inject
    public OfflineAesKeyProvider() {
    }

    @NotNull
    public Key get() {
        SecretKey secretKey = this.getSavedKey();
        return secretKey != null ? (Key)secretKey : (Key)this.generateKey();
    }

    @TargetApi(value=23)
    private final SecretKey generateKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", ANDROID_KEY_STORE);
        String[] stringArray = new String[]{"GCM"};
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(OFFLINE_KEY_NAME, 3).setBlockModes(stringArray).setKeySize(256);
        stringArray = new String[]{"NoPadding"};
        KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"Builder(\n            OFF\u2026ONE)\n            .build()");
        KeyGenParameterSpec keyGenParamSpec = keyGenParameterSpec;
        keyGenerator.init((AlgorithmParameterSpec)keyGenParamSpec);
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"keyGenerator.generateKey()");
        return secretKey;
    }

    private final SecretKey getSavedKey() {
        SecretKey secretKey;
        KeyStore keyStore;
        KeyStore $this$getSavedKey_u24lambda_u240 = keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        boolean bl = false;
        $this$getSavedKey_u24lambda_u240.load(null);
        KeyStore keystore = keyStore;
        if (keystore.containsAlias(OFFLINE_KEY_NAME)) {
            KeyStore.Entry entry = keystore.getEntry(OFFLINE_KEY_NAME, null);
            KeyStore.SecretKeyEntry secretKeyEntry = entry instanceof KeyStore.SecretKeyEntry ? (KeyStore.SecretKeyEntry)entry : null;
            secretKey = secretKeyEntry != null ? secretKeyEntry.getSecretKey() : null;
        } else {
            secretKey = null;
        }
        return secretKey;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/offlinemode/cipher/OfflineAesKeyProvider$Companion;", "", "()V", "ANDROID_KEY_STORE", "", "KEY_SIZE", "", "OFFLINE_KEY_NAME", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

