/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.cipher;

import com.stripe.offlinemode.cipher.BaseOfflineCipher;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestEntity;
import com.stripe.proto.model.offline_mode.OfflinePaymentIntentRequest;
import java.security.Key;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J.\u0010\u0016\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/stripe/offlinemode/cipher/OfflinePaymentIntentRequestCipher;", "Lcom/stripe/offlinemode/cipher/BaseOfflineCipher;", "Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;", "Lcom/stripe/offlinemode/storage/OfflinePaymentIntentRequestEntity;", "cipher", "Ljavax/crypto/Cipher;", "key", "Ljava/security/Key;", "(Ljavax/crypto/Cipher;Ljava/security/Key;)V", "tableName", "", "getTableName", "()Ljava/lang/String;", "buildEncryptedEntity", "message", "encryptedData", "", "encryptionIV", "decode", "encoded", "id", "", "getCommonFields", "", "Lkotlin/Pair;", "", "entity", "offlinemode_release"})
public final class OfflinePaymentIntentRequestCipher
extends BaseOfflineCipher<OfflinePaymentIntentRequest, OfflinePaymentIntentRequestEntity> {
    @NotNull
    private final String tableName;

    public OfflinePaymentIntentRequestCipher(@NotNull Cipher cipher, @NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(cipher, key);
        this.tableName = "offline_payment_intent";
    }

    @Override
    @NotNull
    public OfflinePaymentIntentRequestEntity buildEncryptedEntity(@NotNull OfflinePaymentIntentRequest message, @NotNull byte[] encryptedData, @NotNull byte[] encryptionIV) {
        Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        Intrinsics.checkNotNullParameter((Object)encryptionIV, (String)"encryptionIV");
        long l2 = message.id;
        String string = message.offline_id;
        long l3 = message.connection_id;
        String string2 = message.payment_intent_id;
        String string3 = message.account_id;
        OfflinePaymentIntentRequest.PaymentIntentRequestType paymentIntentRequestType = message.type;
        Date date = new Date(message.created_at);
        return new OfflinePaymentIntentRequestEntity(string, l3, string2, string3, paymentIntentRequestType, false, encryptedData, encryptionIV, date, l2);
    }

    @Override
    @NotNull
    public OfflinePaymentIntentRequest decode(@NotNull byte[] encoded, long id) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        return OfflinePaymentIntentRequest.copy$default((OfflinePaymentIntentRequest)((Object)OfflinePaymentIntentRequest.ADAPTER.decode(encoded)), null, null, null, null, 0L, id, null, null, null, null, 0L, null, 4063, null);
    }

    @Override
    @NotNull
    public List<Pair<Object, Object>> getCommonFields(@NotNull OfflinePaymentIntentRequestEntity entity, @NotNull OfflinePaymentIntentRequest message) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)entity.getId(), (Object)message.id), TuplesKt.to((Object)entity.getOfflineId(), (Object)message.offline_id), TuplesKt.to((Object)entity.getConnectionId(), (Object)message.connection_id), TuplesKt.to((Object)entity.getPaymentIntentId(), (Object)message.payment_intent_id), TuplesKt.to((Object)entity.getAccountId(), (Object)message.account_id), TuplesKt.to((Object)((Object)entity.getType()), (Object)((Object)message.type)), TuplesKt.to((Object)entity.getCreated().getTime(), (Object)message.created_at)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }
}

