/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.dagger;

import android.content.Context;
import com.stripe.core.storage.dagger.AndroidStorageModule;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.dagger.Offline;
import com.stripe.jvmcore.dagger.OfflineForwarding;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.terminal.contracts.Logger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.offlinemode.dagger.JvmOfflineModule;
import com.stripe.jvmcore.offlinemode.storage.OfflineKeyValueStore;
import com.stripe.jvmcore.time.Clock;
import com.stripe.offlinemode.cipher.OfflineAesKeyProvider;
import com.stripe.offlinemode.cipher.OfflineCipherProvider;
import com.stripe.offlinemode.cipher.OfflineConnectionCipher;
import com.stripe.offlinemode.cipher.OfflinePaymentIntentRequestCipher;
import com.stripe.offlinemode.cipher.OfflineReaderCipher;
import com.stripe.offlinemode.dagger.DefaultOfflineRepositoryFactory;
import com.stripe.offlinemode.helpers.DefaultOfflineRequestHelper;
import com.stripe.offlinemode.helpers.OfflineApiLevelChecker;
import com.stripe.offlinemode.log.OfflineForwardingTraceLogger;
import com.stripe.offlinemode.storage.DefaultOfflineRepository;
import com.stripe.offlinemode.storage.OfflineDatabase;
import com.stripe.offlinemode.storage.OfflineRepository;
import com.stripe.offlinemode.storage.ProxyOfflineRepository;
import com.stripe.offlinemode.storage.UnsupportedOfflineRepository;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.OfflineDomain;
import dagger.Module;
import dagger.Provides;
import java.security.Key;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Module(includes={AndroidStorageModule.class, JvmOfflineModule.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0007Jf\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00112\"\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0017j\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007\u00a8\u0006("}, d2={"Lcom/stripe/offlinemode/dagger/OfflineStorageModule;", "", "()V", "provideCoroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "provideDefaultOfflineRepository", "Lcom/stripe/offlinemode/storage/OfflineRepository;", "offlineApiLevelChecker", "Lcom/stripe/offlinemode/helpers/OfflineApiLevelChecker;", "unsupportedOfflineRepository", "Lcom/stripe/offlinemode/storage/UnsupportedOfflineRepository;", "defaultOfflineRepositoryFactory", "Lcom/stripe/offlinemode/dagger/DefaultOfflineRepositoryFactory;", "provideForwardingOfflineRepository", "forwardingLogger", "Lcom/stripe/offlinemode/log/OfflineForwardingTraceLogger;", "provideOfflineDatabase", "Lcom/stripe/offlinemode/storage/OfflineDatabase;", "context", "Landroid/content/Context;", "provideOfflineRepositoryFactory", "db", "discreteLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope$Builder;", "Lcom/stripe/offlinemode/log/OfflineDiscreteLogger;", "cipherProvider", "Lcom/stripe/offlinemode/cipher/OfflineCipherProvider;", "keyProvider", "Lcom/stripe/offlinemode/cipher/OfflineAesKeyProvider;", "offlineRequestHelper", "Lcom/stripe/offlinemode/helpers/DefaultOfflineRequestHelper;", "offlineDispatcher", "offlineKeyValueStore", "Lcom/stripe/jvmcore/offlinemode/storage/OfflineKeyValueStore;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nOfflineStorageModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineStorageModule.kt\ncom/stripe/offlinemode/dagger/OfflineStorageModule\n+ 2 Log.kt\ncom/stripe/jvmcore/logging/terminal/log/Log$Companion\n*L\n1#1,115:1\n193#2:116\n*S KotlinDebug\n*F\n+ 1 OfflineStorageModule.kt\ncom/stripe/offlinemode/dagger/OfflineStorageModule\n*L\n94#1:116\n*E\n"})
public final class OfflineStorageModule {
    @NotNull
    public static final OfflineStorageModule INSTANCE = new OfflineStorageModule();

    private OfflineStorageModule() {
    }

    @Provides
    @Singleton
    @NotNull
    public final OfflineDatabase provideOfflineDatabase(@ForApplication @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return OfflineDatabase.Companion.create$default(OfflineDatabase.Companion, context, null, 2, null);
    }

    @Provides
    @Offline
    @Singleton
    @NotNull
    public final CoroutineDispatcher provideCoroutineDispatcher() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        return (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)executorService);
    }

    @Provides
    @Singleton
    @NotNull
    public final DefaultOfflineRepositoryFactory provideOfflineRepositoryFactory(@NotNull OfflineDatabase db, @NotNull HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> discreteLogger, @NotNull OfflineCipherProvider cipherProvider, @NotNull OfflineAesKeyProvider keyProvider, @NotNull DefaultOfflineRequestHelper offlineRequestHelper, @Offline @NotNull CoroutineDispatcher offlineDispatcher, @NotNull OfflineKeyValueStore offlineKeyValueStore, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        Intrinsics.checkNotNullParameter(discreteLogger, (String)"discreteLogger");
        Intrinsics.checkNotNullParameter((Object)cipherProvider, (String)"cipherProvider");
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkNotNullParameter((Object)offlineRequestHelper, (String)"offlineRequestHelper");
        Intrinsics.checkNotNullParameter((Object)offlineDispatcher, (String)"offlineDispatcher");
        Intrinsics.checkNotNullParameter((Object)offlineKeyValueStore, (String)"offlineKeyValueStore");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new DefaultOfflineRepositoryFactory(cipherProvider, keyProvider, db, offlineRequestHelper, offlineDispatcher, offlineKeyValueStore, clock, discreteLogger){
            final /* synthetic */ OfflineCipherProvider $cipherProvider;
            final /* synthetic */ OfflineAesKeyProvider $keyProvider;
            final /* synthetic */ OfflineDatabase $db;
            final /* synthetic */ DefaultOfflineRequestHelper $offlineRequestHelper;
            final /* synthetic */ CoroutineDispatcher $offlineDispatcher;
            final /* synthetic */ OfflineKeyValueStore $offlineKeyValueStore;
            final /* synthetic */ Clock $clock;
            final /* synthetic */ HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> $discreteLogger;
            {
                this.$cipherProvider = $cipherProvider;
                this.$keyProvider = $keyProvider;
                this.$db = $db;
                this.$offlineRequestHelper = $offlineRequestHelper;
                this.$offlineDispatcher = $offlineDispatcher;
                this.$offlineKeyValueStore = $offlineKeyValueStore;
                this.$clock = $clock;
                this.$discreteLogger = $discreteLogger;
            }

            @NotNull
            public DefaultOfflineRepository create(@NotNull Logger<?, ?> logger2) {
                Intrinsics.checkNotNullParameter(logger2, (String)"logger");
                Cipher cipher = this.$cipherProvider.get();
                Key key = this.$keyProvider.get();
                return new DefaultOfflineRepository(this.$db.offlineReaderDao(), this.$db.offlineConnectionDao(), this.$db.offlinePaymentIntentRequestDao(), new OfflineReaderCipher(cipher, key), new OfflineConnectionCipher(cipher, key), new OfflinePaymentIntentRequestCipher(cipher, key), this.$offlineRequestHelper, this.$offlineDispatcher, this.$offlineKeyValueStore, this.$clock, this.$discreteLogger, logger2);
            }
        };
    }

    @Provides
    @Singleton
    @Offline
    @NotNull
    public final OfflineRepository provideDefaultOfflineRepository(@NotNull OfflineApiLevelChecker offlineApiLevelChecker, @NotNull UnsupportedOfflineRepository unsupportedOfflineRepository, @NotNull DefaultOfflineRepositoryFactory defaultOfflineRepositoryFactory) {
        Intrinsics.checkNotNullParameter((Object)offlineApiLevelChecker, (String)"offlineApiLevelChecker");
        Intrinsics.checkNotNullParameter((Object)unsupportedOfflineRepository, (String)"unsupportedOfflineRepository");
        Intrinsics.checkNotNullParameter((Object)defaultOfflineRepositoryFactory, (String)"defaultOfflineRepositoryFactory");
        Log.Companion this_$iv = Log.Companion;
        boolean $i$f$getLogger = false;
        return new ProxyOfflineRepository(offlineApiLevelChecker, unsupportedOfflineRepository, defaultOfflineRepositoryFactory, this_$iv.getLogger(DefaultOfflineRepository.class));
    }

    @Provides
    @Singleton
    @OfflineForwarding
    @NotNull
    public final OfflineRepository provideForwardingOfflineRepository(@NotNull OfflineApiLevelChecker offlineApiLevelChecker, @NotNull UnsupportedOfflineRepository unsupportedOfflineRepository, @NotNull DefaultOfflineRepositoryFactory defaultOfflineRepositoryFactory, @NotNull OfflineForwardingTraceLogger forwardingLogger) {
        Intrinsics.checkNotNullParameter((Object)offlineApiLevelChecker, (String)"offlineApiLevelChecker");
        Intrinsics.checkNotNullParameter((Object)unsupportedOfflineRepository, (String)"unsupportedOfflineRepository");
        Intrinsics.checkNotNullParameter((Object)defaultOfflineRepositoryFactory, (String)"defaultOfflineRepositoryFactory");
        Intrinsics.checkNotNullParameter((Object)forwardingLogger, (String)"forwardingLogger");
        return new ProxyOfflineRepository(offlineApiLevelChecker, unsupportedOfflineRepository, defaultOfflineRepositoryFactory, forwardingLogger);
    }
}

