/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.forwarding;

import com.stripe.offlinemode.forwarding.OfflineForwardingDelayCalculator;
import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/offlinemode/forwarding/DefaultOfflineForwardingDelayCalculator;", "Lcom/stripe/offlinemode/forwarding/OfflineForwardingDelayCalculator;", "offlineConfigHelper", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "random", "Lkotlin/random/Random;", "(Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;Lkotlin/random/Random;)V", "calculateExponentialDelay", "", "failureCount", "", "getConsecutiveForwardingJitter", "consecutiveSuccesses", "getMaxConsecutiveSuccesses", "getRandomForwardingJitter", "Companion", "offlinemode_release"})
public final class DefaultOfflineForwardingDelayCalculator
implements OfflineForwardingDelayCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OfflineConfigHelper offlineConfigHelper;
    @NotNull
    private final Random random;
    private static final int MAX_CONSECUTIVE_FAILURES = 16;
    private static final int MAX_CONSECUTIVE_SUCCESSES = 5;
    private static final long MAX_DELAY_MS = 300000L;
    private static final long DELAY_QUANTUM_MS = 1000L;
    private static final double DELAY_BASE = 2.0;

    @Inject
    public DefaultOfflineForwardingDelayCalculator(@NotNull OfflineConfigHelper offlineConfigHelper, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)offlineConfigHelper, (String)"offlineConfigHelper");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.offlineConfigHelper = offlineConfigHelper;
        this.random = random;
    }

    @Override
    public long calculateExponentialDelay(int failureCount) {
        long l2;
        if (failureCount > 0) {
            int count = Math.min(failureCount, 16);
            boolean bl = false;
            long delayFromCount = (long)Math.pow(2.0, count) * 1000L;
            l2 = Math.min(delayFromCount, 300000L);
        } else {
            l2 = 0L;
        }
        return l2;
    }

    @Override
    public long getConsecutiveForwardingJitter(int consecutiveSuccesses) {
        return consecutiveSuccesses > 0 && consecutiveSuccesses % this.getMaxConsecutiveSuccesses() == 0 ? this.getRandomForwardingJitter() : 0L;
    }

    @Override
    public long getRandomForwardingJitter() {
        return this.offlineConfigHelper.getForwardingJitterMs() > 0L ? this.random.nextLong(this.offlineConfigHelper.getForwardingJitterMs()) : 0L;
    }

    @Override
    public int getMaxConsecutiveSuccesses() {
        return 5;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/offlinemode/forwarding/DefaultOfflineForwardingDelayCalculator$Companion;", "", "()V", "DELAY_BASE", "", "DELAY_QUANTUM_MS", "", "MAX_CONSECUTIVE_FAILURES", "", "MAX_CONSECUTIVE_SUCCESSES", "MAX_DELAY_MS", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

