/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.forwarding;

import com.squareup.moshi.Moshi;
import com.squareup.wire.Message;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.PendingTimer;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.loggingmodels.Tag;
import com.stripe.jvmcore.loggingmodels.TagKt;
import com.stripe.jvmcore.loggingmodels.Trace;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.redaction.terminal.TerminalMessageRedactor;
import com.stripe.jvmcore.restclient.CustomHeadersInterceptor;
import com.stripe.jvmcore.restclient.RestClient;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.offlinemode.forwarding.AuthTokenListener;
import com.stripe.offlinemode.forwarding.OfflineRestService;
import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import com.stripe.proto.model.rest.ErrorResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.StatusCode;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.OfflineDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.StageScope;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 :2\u00020\u0001:\u0001:BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\"\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000bj\u0002`\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0002Jj\u0010\u001c\u001a\u00020\u001d\"\u001c\b\u0000\u0010\u001e*\u0016\u0012\u0004\u0012\u0002H\u001e\u0012\u0002\b\u00030\u001fj\b\u0012\u0004\u0012\u0002H\u001e` \"\u001c\b\u0001\u0010!*\u0016\u0012\u0004\u0012\u0002H!\u0012\u0002\b\u00030\u001fj\b\u0012\u0004\u0012\u0002H!` 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H!0#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\u00bf\u0001\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H!0#\"\u001c\b\u0000\u0010)*\u0016\u0012\u0004\u0012\u0002H)\u0012\u0002\b\u00030\u001fj\b\u0012\u0004\u0012\u0002H)` \"\u001c\b\u0001\u0010\u001e*\u0016\u0012\u0004\u0012\u0002H\u001e\u0012\u0002\b\u00030\u001fj\b\u0012\u0004\u0012\u0002H\u001e` \"\u001c\b\u0002\u0010!*\u0016\u0012\u0004\u0012\u0002H!\u0012\u0002\b\u00030\u001fj\b\u0012\u0004\u0012\u0002H!` 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002H!2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001e012\b\u00102\u001a\u0004\u0018\u0001H)2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J(\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019*\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001fj\u0006\u0012\u0002\b\u0003` H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00078B@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000bj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lcom/stripe/offlinemode/forwarding/OfflineRestService;", "Lcom/stripe/offlinemode/forwarding/AuthTokenListener;", "moshi", "Lcom/squareup/moshi/Moshi;", "baseUrlProvider", "Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;", "okHttpClient", "Lokhttp3/OkHttpClient;", "offlineConfigHelper", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/StageScope$Builder;", "Lcom/stripe/offlinemode/log/OfflineStageLogger;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lcom/squareup/moshi/Moshi;Lcom/stripe/jvmcore/restclient/RestClient$BaseUrlProvider;Lokhttp3/OkHttpClient;Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/jvmcore/loggingmodels/TraceLogger;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "<set-?>", "client", "authHeaders", "", "", "token", "endLogs", "", "Rsp", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "Err", "response", "Lcom/stripe/jvmcore/restclient/RestResponse;", "timer", "Lcom/stripe/jvmcore/logging/PendingTimer;", "trace", "Lcom/stripe/jvmcore/loggingmodels/Trace;", "post", "Req", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/FormBody;", "endpoint", "error", "responseType", "Ljava/lang/Class;", "rpcRequest", "requestType", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/StageScope$RequestType;", "context", "Lcom/stripe/jvmcore/loggingmodels/Trace$Context;", "(Lokhttp3/Headers;Lokhttp3/FormBody;Ljava/lang/String;Lcom/squareup/wire/Message;Ljava/lang/Class;Lcom/squareup/wire/Message;Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/StageScope$RequestType;Lcom/stripe/jvmcore/loggingmodels/Trace$Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setAuthToken", "toMetricTags", "Companion", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nOfflineRestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineRestService.kt\ncom/stripe/offlinemode/forwarding/OfflineRestService\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n314#2,11:226\n1#3:237\n1179#4,2:238\n1253#4,4:240\n*S KotlinDebug\n*F\n+ 1 OfflineRestService.kt\ncom/stripe/offlinemode/forwarding/OfflineRestService\n*L\n71#1:226,11\n216#1:238,2\n216#1:240,4\n*E\n"})
public abstract class OfflineRestService
implements AuthTokenListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Moshi moshi;
    @NotNull
    private final RestClient.BaseUrlProvider baseUrlProvider;
    @NotNull
    private final HealthLogger<OfflineDomain, OfflineDomain.Builder, StageScope, StageScope.Builder> logger;
    @NotNull
    private final TraceLogger traceLogger;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private OkHttpClient client;
    @NotNull
    private static final String KEY_AUTH_HEADER = "Authorization";
    @NotNull
    private static final String TOKEN_PREFIX = "Bearer";
    @NotNull
    private static final String SERVICE_NAME = "OfflineRestService";

    public OfflineRestService(@NotNull Moshi moshi2, @NotNull RestClient.BaseUrlProvider baseUrlProvider, @NotNull OkHttpClient okHttpClient, @NotNull OfflineConfigHelper offlineConfigHelper, @NotNull HealthLogger<OfflineDomain, OfflineDomain.Builder, StageScope, StageScope.Builder> logger2, @NotNull TraceLogger traceLogger, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)moshi2, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"baseUrlProvider");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)offlineConfigHelper, (String)"offlineConfigHelper");
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.moshi = moshi2;
        this.baseUrlProvider = baseUrlProvider;
        this.logger = logger2;
        this.traceLogger = traceLogger;
        this.logWriter = logWriter;
        this.client = okHttpClient.newBuilder().connectTimeout(offlineConfigHelper.getHttpHighTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout(offlineConfigHelper.getHttpHighTimeoutMs(), TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public final <Req extends Message<Req, ?>, Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> Object post(@NotNull Headers headers, @NotNull FormBody body, @NotNull String endpoint, @NotNull Err error, @NotNull Class<Rsp> responseType, @Nullable Req rpcRequest, @NotNull StageScope.RequestType requestType, @NotNull Trace.Context context, @NotNull Continuation<? super RestResponse<Rsp, Err>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super RestResponse<Rsp, Err>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        HttpUrl httpUrl = HttpUrl.Companion.get(this.baseUrlProvider.getBaseUrl()).newBuilder().addPathSegments(endpoint).build();
        Request request = new Request.Builder().url(httpUrl).headers(headers).post((RequestBody)body).build();
        PendingTimer timer2 = this.logger.startTimer(MapsKt.mapOf((Pair)TuplesKt.to((Object)"RequestType", (Object)requestType.name())), post.2.timer.1.INSTANCE);
        TraceLogger traceLogger = this.traceLogger;
        String string = requestType.name();
        String string2 = request.url().toString();
        String string3 = request.method();
        Map map2 = MapsKt.toMap((Iterable)((Iterable)request.headers()));
        Trace trace = TraceLogger.startTrace$default(traceLogger, SERVICE_NAME, string, rpcRequest, null, null, null, context, string2, string3, map2, null, 1080, null);
        Call $this$post_u24lambda_u241_u24lambda_u240 = this.client.newCall(request);
        boolean bl3 = false;
        $this$post_u24lambda_u241_u24lambda_u240.enqueue(new Callback(error, httpUrl, this, continuation, timer2, trace, responseType){
            final /* synthetic */ Err $error;
            final /* synthetic */ HttpUrl $httpUrl;
            final /* synthetic */ OfflineRestService this$0;
            final /* synthetic */ CancellableContinuation<RestResponse<Rsp, Err>> $continuation;
            final /* synthetic */ PendingTimer $timer;
            final /* synthetic */ Trace $trace;
            final /* synthetic */ Class<Rsp> $responseType;
            {
                this.$error = $error;
                this.$httpUrl = $httpUrl;
                this.this$0 = $receiver;
                this.$continuation = $continuation;
                this.$timer = $timer;
                this.$trace = $trace;
                this.$responseType = $responseType;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                RestResponse.ServerError<M, Err> serverError = new RestResponse.ServerError<M, Err>(this.$error, StatusCode.HTTP_ERROR_UNKNOWN_STATE, this.$httpUrl.toString(), null, OfflineRestService.access$getMoshi$p(this.this$0), TerminalMessageRedactor.INSTANCE, new TreeMap<String, String>());
                CancellableContinuation<RestResponse<Rsp, Err>> cancellableContinuation = this.this$0;
                PendingTimer pendingTimer = this.$timer;
                Trace trace = this.$trace;
                RestResponse.ServerError<M, Err> it = serverError;
                boolean bl = false;
                OfflineRestService.access$endLogs((OfflineRestService)cancellableContinuation, it, pendingTimer, trace);
                cancellableContinuation = this.$continuation;
                RestResponse.ServerError<M, Err> p0 = serverError;
                boolean bl2 = false;
                ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(p0));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                RestResponse<Rsp, Err> restResponse = RestResponse.Companion.toRestResponse(response, OfflineRestService.access$getMoshi$p(this.this$0), this.$responseType, this.$error, TerminalMessageRedactor.INSTANCE, OfflineRestService.access$getLogWriter$p(this.this$0));
                CancellableContinuation<RestResponse<Rsp, Err>> cancellableContinuation = this.this$0;
                PendingTimer pendingTimer = this.$timer;
                Trace trace = this.$trace;
                RestResponse<Rsp, Err> it = restResponse;
                boolean bl = false;
                OfflineRestService.access$endLogs((OfflineRestService)cancellableContinuation, it, pendingTimer, trace);
                cancellableContinuation = this.$continuation;
                RestResponse<Rsp, Err> p0 = restResponse;
                boolean bl2 = false;
                ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl(p0));
            }
        });
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this, timer2, $this$post_u24lambda_u241_u24lambda_u240){
            final /* synthetic */ OfflineRestService this$0;
            final /* synthetic */ PendingTimer $timer;
            final /* synthetic */ Call $this_run;
            {
                this.this$0 = $receiver;
                this.$timer = $timer;
                this.$this_run = $receiver2;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                try {
                    OfflineRestService.access$getLogger$p(this.this$0).endTimer(this.$timer, Outcome.Canceled.INSTANCE, MapsKt.emptyMap(), it);
                    this.$this_run.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAuthToken(@NotNull String token) {
        void $this$setAuthToken_u24lambda_u242;
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        OkHttpClient.Builder builder2 = builder = this.client.newBuilder();
        OfflineRestService offlineRestService = this;
        boolean bl = false;
        CollectionsKt.removeAll((List)$this$setAuthToken_u24lambda_u242.interceptors(), (Function1)setAuthToken.1.1.INSTANCE);
        offlineRestService.client = builder.addInterceptor((Interceptor)new CustomHeadersInterceptor(this.authHeaders(token))).build();
    }

    private final Map<String, String> authHeaders(String token) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)KEY_AUTH_HEADER, (Object)("Bearer " + token)));
    }

    private final <Rsp extends Message<Rsp, ?>, Err extends Message<Err, ?>> void endLogs(RestResponse<Rsp, Err> response, PendingTimer timer2, Trace trace) {
        RestResponse<Rsp, Err> restResponse = response;
        if (restResponse instanceof RestResponse.Success) {
            PendingTimer pendingTimer = timer2;
            if (pendingTimer != null) {
                PendingTimer t2 = pendingTimer;
                boolean bl = false;
                HealthLogger.endTimer$default(this.logger, t2, Outcome.Ok.INSTANCE, MapsKt.emptyMap(), null, 8, null);
            }
            this.traceLogger.endTraceWithSuccess(trace, (Message<?, ?>)((RestResponse.Success)response).getResponse(), (Map<String, String>)response.getHeaders());
        } else if (restResponse instanceof RestResponse.ServerError) {
            PendingTimer pendingTimer = timer2;
            if (pendingTimer != null) {
                PendingTimer t3 = pendingTimer;
                boolean bl = false;
                HealthLogger.endTimer$default(this.logger, t3, Outcome.HttpError.Companion.toOutcome(response.getStatusCode()), this.toMetricTags((Message<?, ?>)((RestResponse.ServerError)response).getResponse()), null, 8, null);
            }
            TraceLogger.endTraceWithErrorMessage$default(this.traceLogger, trace, response.toLogString(), String.valueOf((Object)response.getStatusCode()), null, 8, null);
        } else if (restResponse instanceof RestResponse.ParseError) {
            PendingTimer pendingTimer = timer2;
            if (pendingTimer != null) {
                PendingTimer t4 = pendingTimer;
                boolean bl = false;
                HealthLogger.endTimer$default(this.logger, t4, Outcome.HttpError.ParseError.INSTANCE, MapsKt.emptyMap(), null, 8, null);
            }
            TraceLogger.endTraceWithErrorMessage$default(this.traceLogger, trace, "Failed to Parse REST body, " + response, String.valueOf((Object)response.getStatusCode()), null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> toMetricTags(Message<?, ?> $this$toMetricTags) {
        void $this$associateTo$iv$iv;
        List list;
        Object object;
        if ($this$toMetricTags instanceof ErrorWrapper) {
            Tag.HealthTag healthTag;
            String string;
            TerminalException.TerminalErrorCode terminalErrorCode;
            Collection collection = TagKt.toTags((ErrorWrapper)$this$toMetricTags);
            ErrorResponse errorResponse = ((ErrorWrapper)$this$toMetricTags).error;
            if (errorResponse != null && (object = ProtoConverter.INSTANCE.toTerminalException(errorResponse)) != null && (terminalErrorCode = object.getErrorCode()) != null && (string = terminalErrorCode.toLogString()) != null) {
                String it = string;
                boolean bl = false;
                healthTag = new Tag.HealthTag("ErrorReason", it);
            } else {
                healthTag = null;
            }
            errorResponse = healthTag;
            list = CollectionsKt.plus((Collection)collection, (Object)((Object)errorResponse));
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$associate$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        object = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Tag t2 = (Tag)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)t2.getKey(), (Object)t2.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ Moshi access$getMoshi$p(OfflineRestService $this) {
        return $this.moshi;
    }

    public static final /* synthetic */ LogWriter access$getLogWriter$p(OfflineRestService $this) {
        return $this.logWriter;
    }

    public static final /* synthetic */ void access$endLogs(OfflineRestService $this, RestResponse response, PendingTimer timer2, Trace trace) {
        $this.endLogs(response, timer2, trace);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/offlinemode/forwarding/OfflineRestService$Companion;", "", "()V", "KEY_AUTH_HEADER", "", "SERVICE_NAME", "TOKEN_PREFIX", "offlinemode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

