/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.forwarding;

import com.squareup.wire.Message;
import com.stripe.jvmcore.restclient.RestResponse;
import com.stripe.offlinemode.forwarding.ForwardingApiException;
import com.stripe.proto.model.rest.ErrorResponse;
import com.stripe.proto.model.rest.ErrorWrapper;
import com.stripe.proto.model.rest.StatusCode;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.proto.ProtoConverter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001ae\u0010\u0000\u001a\u0002H\u0001\"\u001c\b\u0000\u0010\u0001*\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00050\u00042$\u0010\u0006\u001a \b\u0001\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a6\u0010\f\u001a\u00020\r\"\u001c\b\u0000\u0010\u000e*\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u000e`\u0003*\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00050\u000fH\u0002\u001a6\u0010\u0010\u001a\u00020\r\"\u001c\b\u0000\u0010\u000e*\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u000e`\u0003*\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00050\u000fH\u0002\u001a6\u0010\u0011\u001a\u00020\r\"\u001c\b\u0000\u0010\u000e*\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0002\b\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u000e`\u0003*\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"decodeResponseAndHandleAuthFailure", "T", "Lcom/squareup/wire/Message;", "Lcom/stripe/jvmcore/restclient/Proto;", "Lcom/stripe/jvmcore/restclient/RestResponse;", "Lcom/stripe/proto/model/rest/ErrorWrapper;", "handleAuthFailure", "Lkotlin/Function2;", "Lcom/stripe/proto/model/rest/ErrorResponse;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/stripe/jvmcore/restclient/RestResponse;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAuthError", "", "Rsp", "Lcom/stripe/jvmcore/restclient/RestResponse$ServerError;", "isConnectionError", "isTransient", "offlinemode_release"})
public final class RestResponseHandlerKt {
    @Nullable
    public static final <T extends Message<T, ?>> Object decodeResponseAndHandleAuthFailure(@NotNull RestResponse<T, ErrorWrapper> $this$decodeResponseAndHandleAuthFailure, @NotNull Function2<? super ErrorResponse, ? super Continuation<? super T>, ? extends Object> handleAuthFailure, @NotNull Continuation<? super T> $completion) {
        RestResponse<T, ErrorWrapper> restResponse = $this$decodeResponseAndHandleAuthFailure;
        if (restResponse instanceof RestResponse.Success) {
            return ((RestResponse.Success)$this$decodeResponseAndHandleAuthFailure).getResponse();
        }
        if (restResponse instanceof RestResponse.ServerError) {
            if (RestResponseHandlerKt.isAuthError((RestResponse.ServerError)$this$decodeResponseAndHandleAuthFailure)) {
                return handleAuthFailure.invoke((Object)((ErrorWrapper)((Object)((RestResponse.ServerError)$this$decodeResponseAndHandleAuthFailure).getResponse())).error, $completion);
            }
            if (RestResponseHandlerKt.isConnectionError((RestResponse.ServerError)$this$decodeResponseAndHandleAuthFailure)) {
                TerminalException terminalException = new TerminalException(TerminalException.TerminalErrorCode.STRIPE_API_CONNECTION_ERROR, "Could not connect to Stripe. Please retry.", null, null, 12, null);
                throw new ForwardingApiException(terminalException, true);
            }
            boolean bl = RestResponseHandlerKt.isTransient($this$decodeResponseAndHandleAuthFailure);
            TerminalException terminalException = ProtoConverter.INSTANCE.toTerminalException(((ErrorWrapper)((Object)((RestResponse.ServerError)$this$decodeResponseAndHandleAuthFailure).getResponse())).error);
            throw new ForwardingApiException(terminalException, bl);
        }
        if (restResponse instanceof RestResponse.ParseError) {
            boolean bl = RestResponseHandlerKt.isTransient($this$decodeResponseAndHandleAuthFailure);
            TerminalException terminalException = new TerminalException(TerminalException.TerminalErrorCode.STRIPE_API_RESPONSE_DECODING_ERROR, $this$decodeResponseAndHandleAuthFailure.toLogString(), null, null, 12, null);
            throw new ForwardingApiException(terminalException, bl);
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final <Rsp extends Message<Rsp, ?>> boolean isAuthError(RestResponse.ServerError<Rsp, ErrorWrapper> $this$isAuthError) {
        Object[] objectArray = new String[]{"api_key_expired", "platform_api_key_expired"};
        ErrorResponse errorResponse = $this$isAuthError.getResponse().error;
        return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)(errorResponse != null ? errorResponse.code : null));
    }

    private static final <Rsp extends Message<Rsp, ?>> boolean isConnectionError(RestResponse.ServerError<Rsp, ErrorWrapper> $this$isConnectionError) {
        StatusCode[] statusCodeArray = new StatusCode[]{StatusCode.HTTP_ERROR, StatusCode.HTTP_ERROR_UNKNOWN_STATE};
        return SetsKt.setOf((Object[])statusCodeArray).contains((Object)$this$isConnectionError.getStatusCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final <Rsp extends Message<Rsp, ?>> boolean isTransient(RestResponse<Rsp, ErrorWrapper> $this$isTransient) {
        if ($this$isTransient.shouldRetry()) return true;
        StatusCode[] statusCodeArray = new StatusCode[]{StatusCode.HTTP_ERROR, StatusCode.HTTP_ERROR_UNKNOWN_STATE, StatusCode.SERVER_ERROR};
        if (!SetsKt.setOf((Object[])statusCodeArray).contains((Object)$this$isTransient.getStatusCode())) return false;
        return true;
    }
}

