/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.helpers;

import com.squareup.wire.Message;
import com.stripe.core.readerupdate.UpdateClient;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.jvmcore.dagger.Offline;
import com.stripe.jvmcore.device.ActiveReaderConfigRepository;
import com.stripe.offlinemode.helpers.OfflineConfigHelper;
import com.stripe.offlinemode.storage.OfflineRepository;
import com.stripe.proto.model.offline_mode.OfflinePaymentIntentRequest;
import com.stripe.proto.terminal.terminal.pub.message.config.OfflineConfigPb;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.callable.ProxyOfflineListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u001a\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J0\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0013H\u0016J\b\u0010,\u001a\u00020\u0016H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020\u0013H\u0016J\b\u0010/\u001a\u00020\u0013H\u0002J\u0012\u00100\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/stripe/offlinemode/helpers/DefaultOfflineConfigHelper;", "Lcom/stripe/offlinemode/helpers/OfflineConfigHelper;", "Lcom/stripe/core/readerupdate/UpdateClient$OfflineConfigUpdateListener;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "offlineRepository", "Lcom/stripe/offlinemode/storage/OfflineRepository;", "proxyOfflineListener", "Lcom/stripe/stripeterminal/internal/common/callable/ProxyOfflineListener;", "activeReaderConfigRepository", "Lcom/stripe/jvmcore/device/ActiveReaderConfigRepository;", "(Lcom/stripe/core/transaction/SettingsRepository;Lcom/stripe/offlinemode/storage/OfflineRepository;Lcom/stripe/stripeterminal/internal/common/callable/ProxyOfflineListener;Lcom/stripe/jvmcore/device/ActiveReaderConfigRepository;)V", "getForwardingJitterMs", "", "getHttpHealthCheckTimeoutMs", "getHttpHighTimeoutMs", "getHttpLowTimeoutMs", "getMaxTransactionLimit", "currencyCode", "", "(Ljava/lang/String;)Ljava/lang/Long;", "isDeferredAuthorizationCountry", "", "isKnownForwardingError", "type", "Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest$PaymentIntentRequestType;", "errorCode", "isOfflineEnabledForReader", "serialNumber", "isOfflineModeEnabled", "onOfflineConfigUpdate", "", "offlineConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb;", "saveOfflineConfig", "shouldAllowOfflineConnection", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "firmware", "config", "keyProfile", "currentTimeMs", "shouldAllowOfflineTransaction", "tvrStringHex", "supportsSca", "switchInterfaceAuthorizationResponseCodeForAid", "aid", "tvrMask", "updateAccountOfflineConfig", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nDefaultOfflineConfigHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultOfflineConfigHelper.kt\ncom/stripe/offlinemode/helpers/DefaultOfflineConfigHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1#2:167\n1855#3,2:168\n1855#3,2:170\n*S KotlinDebug\n*F\n+ 1 DefaultOfflineConfigHelper.kt\ncom/stripe/offlinemode/helpers/DefaultOfflineConfigHelper\n*L\n113#1:168,2\n140#1:170,2\n*E\n"})
public final class DefaultOfflineConfigHelper
implements OfflineConfigHelper,
UpdateClient.OfflineConfigUpdateListener {
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final OfflineRepository offlineRepository;
    @NotNull
    private final ProxyOfflineListener proxyOfflineListener;
    @NotNull
    private final ActiveReaderConfigRepository activeReaderConfigRepository;

    @Inject
    public DefaultOfflineConfigHelper(@NotNull SettingsRepository settingsRepository, @Offline @NotNull OfflineRepository offlineRepository, @NotNull ProxyOfflineListener proxyOfflineListener, @NotNull ActiveReaderConfigRepository activeReaderConfigRepository) {
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)offlineRepository, (String)"offlineRepository");
        Intrinsics.checkNotNullParameter((Object)proxyOfflineListener, (String)"proxyOfflineListener");
        Intrinsics.checkNotNullParameter((Object)activeReaderConfigRepository, (String)"activeReaderConfigRepository");
        this.settingsRepository = settingsRepository;
        this.offlineRepository = offlineRepository;
        this.proxyOfflineListener = proxyOfflineListener;
        this.activeReaderConfigRepository = activeReaderConfigRepository;
    }

    @Override
    public void saveOfflineConfig(@NotNull String serialNumber, @Nullable OfflineConfigPb offlineConfig) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Message message = offlineConfig;
        if (message == null || (message = message.reader_offline_config) == null) {
            message = new OfflineConfigPb.ReaderOfflineConfigPb(false, null, 3, null);
        }
        Message readerOfflineConfig = message;
        this.updateAccountOfflineConfig(offlineConfig);
        this.activeReaderConfigRepository.setReaderOfflineConfig(serialNumber, (OfflineConfigPb.ReaderOfflineConfigPb)readerOfflineConfig);
    }

    @Override
    public void onOfflineConfigUpdate(@NotNull String serialNumber, @Nullable OfflineConfigPb offlineConfig) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        this.saveOfflineConfig(serialNumber, offlineConfig);
    }

    @Override
    public boolean isOfflineModeEnabled() {
        return (Boolean)this.proxyOfflineListener.isListenerSetFlow().getValue() != false && this.offlineRepository.isOfflineModeEnabledOnActiveReader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOfflineEnabledForReader(@NotNull String serialNumber) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        if ((Boolean)this.proxyOfflineListener.isListenerSetFlow().getValue() == false) return false;
        Object object2 = this.offlineRepository;
        try {
            OfflineRepository $this$isOfflineEnabledForReader_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)OfflineRepository.isOfflineEnabledForReader$default($this$isOfflineEnabledForReader_u24lambda_u240, serialNumber, null, 2, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        if ((Boolean)(Result.isFailure-impl((Object)object2) ? object : object2) == false) return false;
        return true;
    }

    @Override
    public long getHttpLowTimeoutMs() {
        return this.settingsRepository.getAccountOfflineConfig().http_low_timeout_ms;
    }

    @Override
    public long getHttpHighTimeoutMs() {
        return this.settingsRepository.getAccountOfflineConfig().http_high_timeout_ms;
    }

    @Override
    public long getHttpHealthCheckTimeoutMs() {
        return this.settingsRepository.getAccountOfflineConfig().http_health_check_timeout_ms;
    }

    @Override
    public long getForwardingJitterMs() {
        return this.settingsRepository.getAccountOfflineConfig().forwarding_jitter_ms;
    }

    @Override
    @Nullable
    public Long getMaxTransactionLimit(@NotNull String currencyCode) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Map<String, Long> map2 = this.settingsRepository.getAccountOfflineConfig().max_transaction_amount_by_currency;
        String string = currencyCode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return map2.get(string);
    }

    @Override
    public boolean isKnownForwardingError(@NotNull OfflinePaymentIntentRequest.PaymentIntentRequestType type, @NotNull String errorCode) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        OfflineConfigPb.AccountOfflineConfigPb $this$isKnownForwardingError_u24lambda_u241 = this.settingsRepository.getAccountOfflineConfig();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                list = $this$isKnownForwardingError_u24lambda_u241.expected_create_error_codes;
                break;
            }
            case 2: {
                list = $this$isKnownForwardingError_u24lambda_u241.expected_confirm_error_codes;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list.contains(errorCode);
    }

    @Override
    public boolean supportsSca() {
        return this.settingsRepository.getAccountOfflineConfig().supports_sca;
    }

    @Override
    @Nullable
    public String switchInterfaceAuthorizationResponseCodeForAid(@NotNull String aid) {
        Intrinsics.checkNotNullParameter((Object)aid, (String)"aid");
        return this.settingsRepository.getAccountOfflineConfig().aid_to_offline_pin_response_auth_code.get(aid);
    }

    private final String tvrMask() {
        return this.settingsRepository.getAccountOfflineConfig().tvr_mask;
    }

    @Override
    public boolean isDeferredAuthorizationCountry() {
        return this.settingsRepository.getAccountOfflineConfig().is_deferred_authorization_country;
    }

    @Override
    public boolean shouldAllowOfflineTransaction(@NotNull String tvrStringHex) {
        Intrinsics.checkNotNullParameter((Object)tvrStringHex, (String)"tvrStringHex");
        return (Long.parseLong(tvrStringHex, CharsKt.checkRadix((int)16)) & Long.parseLong(this.tvrMask(), CharsKt.checkRadix((int)16))) == 0L;
    }

    @Override
    public boolean shouldAllowOfflineConnection(@NotNull DeviceType deviceType, @NotNull String firmware, @NotNull String config, @NotNull String keyProfile, long currentTimeMs) {
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)firmware, (String)"firmware");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)keyProfile, (String)"keyProfile");
        Iterable $this$forEach$iv = MapsKt.toMap(this.settingsRepository.getAccountOfflineConfig().region_to_region_offline_config).values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OfflineConfigPb.OfflineAllowedVersionDetailsPb deviceTypeVersionAllowlist;
            OfflineConfigPb.RegionOfflineConfigPb it = (OfflineConfigPb.RegionOfflineConfigPb)((Object)element$iv);
            boolean bl = false;
            if (it.device_type_to_offline_allowed_versions.get(deviceType.getBbPosHardware().name()) == null) continue;
            boolean bl2 = false;
            List<String> list = deviceTypeVersionAllowlist.firmware_versions;
            String string = firmware.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!list.contains(string)) continue;
            List<String> list2 = deviceTypeVersionAllowlist.config_versions;
            String string2 = config.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!list2.contains(string2) || !Intrinsics.areEqual((Object)deviceTypeVersionAllowlist.key_profile_version, (Object)keyProfile) || deviceTypeVersionAllowlist.expiration_time < currentTimeMs) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAccountOfflineConfig(OfflineConfigPb offlineConfig) {
        void $this$forEach$iv;
        Message message = offlineConfig;
        if (message == null || (message = message.account_offline_config) == null) {
            message = new OfflineConfigPb.AccountOfflineConfigPb(0, null, 0, 0, 0, 0, null, false, false, null, null, false, null, null, null, null, null, 131071, null);
        }
        Message accountOfflineConfig = message;
        Map mergedRegionConfigMap = MapsKt.toMutableMap(accountOfflineConfig.region_to_region_offline_config);
        Iterable iterable = this.settingsRepository.getAccountOfflineConfig().region_to_region_offline_config.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OfflineConfigPb.RegionOfflineConfigPb newRegionOfflineConfig;
            Object object;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String region = (String)entry.getKey();
            OfflineConfigPb.RegionOfflineConfigPb savedRegionOfflineConfig = (OfflineConfigPb.RegionOfflineConfigPb)((Object)entry.getValue());
            if (!accountOfflineConfig.region_to_region_offline_config.containsKey(region)) continue;
            if (accountOfflineConfig.region_to_region_offline_config.get(region) == null) {
                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "RegionOfflineConfig unexpectedly null for region " + region + '.', null, null, 12, null);
            }
            Map map2 = mergedRegionConfigMap;
            Map $this$updateAccountOfflineConfig_u24lambda_u245_u24lambda_u244 = object = MapsKt.toMutableMap(savedRegionOfflineConfig.device_type_to_offline_allowed_versions);
            boolean bl2 = false;
            $this$updateAccountOfflineConfig_u24lambda_u245_u24lambda_u244.putAll(newRegionOfflineConfig.device_type_to_offline_allowed_versions);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 2;
            ByteString byteString = null;
            Map map3 = object;
            object = new OfflineConfigPb.RegionOfflineConfigPb(map3, byteString, n2, defaultConstructorMarker);
            map2.put(region, object);
        }
        this.settingsRepository.setAccountOfflineConfig(OfflineConfigPb.AccountOfflineConfigPb.copy$default((OfflineConfigPb.AccountOfflineConfigPb)accountOfflineConfig, 0, null, 0, 0, 0, 0, null, false, false, null, null, false, null, null, mergedRegionConfigMap, null, null, 114687, null));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OfflinePaymentIntentRequest.PaymentIntentRequestType.values().length];
            try {
                nArray[OfflinePaymentIntentRequest.PaymentIntentRequestType.CREATE_PAYMENT_INTENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OfflinePaymentIntentRequest.PaymentIntentRequestType.PROCESS_PAYMENT_INTENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

