/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.log;

import com.google.gson.Gson;
import com.stripe.jvmcore.logging.terminal.contracts.LogOperationCollector;
import com.stripe.jvmcore.loggingmodels.ApplicationTraceResult;
import com.stripe.jvmcore.loggingmodels.Trace;
import com.stripe.jvmcore.loggingmodels.TraceLogger;
import com.stripe.offlinemode.log.OfflineForwardingLogOperation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/offlinemode/log/OfflineForwardingLogOperationCollector;", "Lcom/stripe/jvmcore/logging/terminal/contracts/LogOperationCollector;", "Lcom/stripe/jvmcore/loggingmodels/ApplicationTraceResult;", "Lcom/stripe/offlinemode/log/OfflineForwardingLogOperation;", "traceLogger", "Lcom/stripe/jvmcore/loggingmodels/TraceLogger;", "gson", "Lcom/google/gson/Gson;", "(Lcom/stripe/jvmcore/loggingmodels/TraceLogger;Lcom/google/gson/Gson;)V", "collect", "", "result", "data", "isComplete", "", "offlinemode_release"})
public final class OfflineForwardingLogOperationCollector
implements LogOperationCollector<ApplicationTraceResult, OfflineForwardingLogOperation> {
    @NotNull
    private final TraceLogger traceLogger;
    @NotNull
    private final Gson gson;

    public OfflineForwardingLogOperationCollector(@NotNull TraceLogger traceLogger, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)traceLogger, (String)"traceLogger");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.traceLogger = traceLogger;
        this.gson = gson;
    }

    @Override
    public void collect(@NotNull ApplicationTraceResult result2, @NotNull OfflineForwardingLogOperation data, boolean isComplete) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (result2.getException() != null) {
            Trace trace = data.getTrace();
            Throwable throwable = result2.getException();
            Intrinsics.checkNotNull((Object)throwable);
            TraceLogger.endTraceWithException$default(this.traceLogger, trace, throwable, result2.getErrorCode(), null, 8, null);
        } else if (result2.getErrorMessage() != null) {
            TraceLogger.endTraceWithErrorMessage$default(this.traceLogger, data.getTrace(), result2.getErrorMessage(), result2.getErrorCode(), null, 8, null);
        } else {
            Trace trace = data.getTrace();
            String string = this.gson.toJson((Object)result2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(result)");
            TraceLogger.endTraceWithSuccess$default(this.traceLogger, trace, string, null, 4, null);
        }
    }
}

