/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import android.database.SQLException;
import android.database.sqlite.SQLiteFullException;
import androidx.room.Transaction;
import com.squareup.wire.Message;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.terminal.contracts.Logger;
import com.stripe.jvmcore.offlinemode.storage.OfflineKeyValueStore;
import com.stripe.jvmcore.time.Clock;
import com.stripe.offlinemode.cipher.OfflineConnectionCipher;
import com.stripe.offlinemode.cipher.OfflineDataMismatchException;
import com.stripe.offlinemode.cipher.OfflineDecryptionException;
import com.stripe.offlinemode.cipher.OfflinePaymentIntentRequestCipher;
import com.stripe.offlinemode.cipher.OfflineReaderCipher;
import com.stripe.offlinemode.helpers.OfflineRequestHelper;
import com.stripe.offlinemode.models.ForwardOfflinePaymentRequest;
import com.stripe.offlinemode.models.OfflineRequestsToSync;
import com.stripe.offlinemode.storage.DefaultOfflineRepository;
import com.stripe.offlinemode.storage.DefaultOfflineRepository$getActiveReaderConfigFlow$;
import com.stripe.offlinemode.storage.DefaultOfflineRepository$getOfflineConnections$lambda$26$;
import com.stripe.offlinemode.storage.DefaultOfflineRepository$getOfflinePaymentRequestsToSync$lambda$17$;
import com.stripe.offlinemode.storage.DefaultOfflineRepository$getOfflineReaders$lambda$21$;
import com.stripe.offlinemode.storage.OfflineConnectionDao;
import com.stripe.offlinemode.storage.OfflineConnectionEntity;
import com.stripe.offlinemode.storage.OfflineEntity;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestDao;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestEntity;
import com.stripe.offlinemode.storage.OfflineReaderDao;
import com.stripe.offlinemode.storage.OfflineReaderEntity;
import com.stripe.offlinemode.storage.OfflineRepository;
import com.stripe.proto.model.merchant.ApiLocationPb;
import com.stripe.proto.model.offline_mode.OfflineConnection;
import com.stripe.proto.model.offline_mode.OfflinePaymentIntentRequest;
import com.stripe.proto.model.offline_mode.OfflineReader;
import com.stripe.proto.model.rest.PaymentIntent;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.offline.OfflineDomain;
import com.stripe.proto.terminal.terminal.pub.message.config.OfflineConfigPb;
import com.stripe.stripeterminal.external.models.DeviceType;
import com.stripe.stripeterminal.external.models.Reader;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.stripe.stripeterminal.internal.common.makers.DeviceTypeMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\"\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0017j\u0002`\u001c\u0012\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\b\u0010F\u001a\u00020GH\u0016J\u0019\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ\u0019\u0010L\u001a\u00020G2\u0006\u0010M\u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u001f\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0P2\u0006\u0010M\u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u0010\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0(H\u0016J!\u0010S\u001a\b\u0012\u0004\u0012\u00020)0P2\b\u0010T\u001a\u0004\u0018\u00010*H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010UJ\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020*H\u0016J!\u0010Y\u001a\u00020Q2\u0006\u0010Z\u001a\u00020@2\u0006\u0010[\u001a\u00020*H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\\J\u001c\u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020W0?0P2\u0006\u0010M\u001a\u00020!H\u0016J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020_0P2\u0006\u0010M\u001a\u00020!H\u0016J\u001a\u0010`\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020!2\u0006\u0010M\u001a\u00020!H\u0016J&\u0010c\u001a\u0010\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020W\u0018\u00010d2\u0006\u0010e\u001a\u00020f2\u0006\u0010M\u001a\u00020!H\u0016J\u001c\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020a0?0P2\u0006\u0010M\u001a\u00020!H\u0016J*\u0010h\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020i072\u0006\u0010M\u001a\u00020!2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020!0?H\u0016J\u0010\u0010k\u001a\u0002022\u0006\u0010l\u001a\u00020mH\u0002J\u0018\u0010n\u001a\u0002022\u0006\u0010o\u001a\u00020!2\u0006\u0010M\u001a\u00020!H\u0016J\u0018\u0010p\u001a\u00020G2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020!H\u0002J\u0010\u0010t\u001a\u00020G2\u0006\u0010M\u001a\u00020!H\u0016J\u0010\u0010u\u001a\u00020G2\u0006\u0010v\u001a\u00020JH\u0016J\u0018\u0010w\u001a\u00020*2\u0006\u0010x\u001a\u00020a2\u0006\u0010y\u001a\u00020WH\u0017J\u0019\u0010z\u001a\u00020;2\u0006\u0010{\u001a\u00020JH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ)\u0010|\u001a\u00020G2\u0006\u0010o\u001a\u00020!2\u0006\u0010M\u001a\u00020!2\u0006\u0010}\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010~J%\u0010\u007f\u001a\u00020G2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020JH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0083\u0001JE\u0010\u0084\u0001\u001a\u0003H\u0085\u0001\"\u0007\b\u0000\u0010\u0085\u0001\u0018\u00012\u0006\u0010s\u001a\u00020!2\u0010\b\u0002\u0010\u0086\u0001\u001a\t\u0012\u0004\u0012\u00020G0\u0087\u00012\u000f\u0010\u0088\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0085\u00010\u0087\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u0089\u0001J\u0017\u0010\u008a\u0001\u001a\u000202*\u00020@H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008b\u0001J\u0016\u0010\u008c\u0001\u001a\u000202*\u00020JH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KR$\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020*2\u0006\u0010 \u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0017j\u0002`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u000202X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00103R\u0016\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*05X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00106\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020*078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0?0(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bA\u0010B\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u008d\u0001"}, d2={"Lcom/stripe/offlinemode/storage/DefaultOfflineRepository;", "Lcom/stripe/offlinemode/storage/OfflineRepository;", "offlineReaderDao", "Lcom/stripe/offlinemode/storage/OfflineReaderDao;", "offlineConnectionDao", "Lcom/stripe/offlinemode/storage/OfflineConnectionDao;", "offlinePaymentIntentRequestDao", "Lcom/stripe/offlinemode/storage/OfflinePaymentIntentRequestDao;", "offlineReaderCipher", "Lcom/stripe/offlinemode/cipher/OfflineReaderCipher;", "offlineConnectionCipher", "Lcom/stripe/offlinemode/cipher/OfflineConnectionCipher;", "offlinePaymentIntentRequestCipher", "Lcom/stripe/offlinemode/cipher/OfflinePaymentIntentRequestCipher;", "offlineRequestHelper", "Lcom/stripe/offlinemode/helpers/OfflineRequestHelper;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "offlineKeyValueStore", "Lcom/stripe/jvmcore/offlinemode/storage/OfflineKeyValueStore;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "discreteLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/OfflineDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/offline/DiscreteScope$Builder;", "Lcom/stripe/offlinemode/log/OfflineDiscreteLogger;", "logger", "Lcom/stripe/jvmcore/logging/terminal/contracts/Logger;", "(Lcom/stripe/offlinemode/storage/OfflineReaderDao;Lcom/stripe/offlinemode/storage/OfflineConnectionDao;Lcom/stripe/offlinemode/storage/OfflinePaymentIntentRequestDao;Lcom/stripe/offlinemode/cipher/OfflineReaderCipher;Lcom/stripe/offlinemode/cipher/OfflineConnectionCipher;Lcom/stripe/offlinemode/cipher/OfflinePaymentIntentRequestCipher;Lcom/stripe/offlinemode/helpers/OfflineRequestHelper;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/jvmcore/offlinemode/storage/OfflineKeyValueStore;Lcom/stripe/jvmcore/time/Clock;Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/jvmcore/logging/terminal/contracts/Logger;)V", "value", "", "activeAccountId", "getActiveAccountId", "()Ljava/lang/String;", "setActiveAccountId", "(Ljava/lang/String;)V", "activeReaderConfigFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb$ReaderOfflineConfigPb;", "", "currentConnectionId", "getCurrentConnectionId", "()J", "setCurrentConnectionId", "(J)V", "defaultOfflineReaderConfig", "isSupported", "", "()Z", "offlineConnectionIdFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "offlinePaymentAmountsByCurrency", "", "getOfflinePaymentAmountsByCurrency", "()Ljava/util/Map;", "offlinePaymentsCount", "", "getOfflinePaymentsCount", "()I", "unprocessedPaymentsFlow", "", "Lcom/stripe/offlinemode/storage/OfflinePaymentIntentRequestEntity;", "getUnprocessedPaymentsFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "unprocessedPaymentsFlow$delegate", "Lkotlin/Lazy;", "activeReaderOfflineConfigFlow", "clearCache", "", "delete", "toDelete", "Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;", "(Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteExpiredEntities", "accountId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchNextToForward", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/offlinemode/models/ForwardOfflinePaymentRequest;", "getActiveAccountFlow", "getActiveReaderConfigFlow", "offlineConnectionId", "(Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOfflineConnection", "Lcom/stripe/proto/model/offline_mode/OfflineConnection;", "connectionId", "getOfflineConnectionAndReaderForPaymentRequest", "offlinePIREntity", "mostRecentRowId", "(Lcom/stripe/offlinemode/storage/OfflinePaymentIntentRequestEntity;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOfflineConnections", "getOfflinePaymentRequestsToSync", "Lcom/stripe/offlinemode/models/OfflineRequestsToSync;", "getOfflineReader", "Lcom/stripe/proto/model/offline_mode/OfflineReader;", "serialNumber", "getOfflineReaderAndConnectionIfSaved", "Lkotlin/Pair;", "reader", "Lcom/stripe/stripeterminal/external/models/Reader;", "getOfflineReaders", "getSavedLocationsMap", "Lcom/stripe/proto/model/merchant/ApiLocationPb;", "serials", "isExpired", "offlineReaderEntity", "Lcom/stripe/offlinemode/storage/OfflineReaderEntity;", "isOfflineEnabledForReader", "readerSerial", "logError", "error", "", "errorMessage", "restoreSoftDeletedPayments", "saveOfflinePaymentIntentRequest", "offlinePaymentIntentRequest", "saveOfflineReaderAndConnection", "offlineReader", "offlineConnection", "softDelete", "toSoftDelete", "updateOfflineReaderWithConfig", "config", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb$ReaderOfflineConfigPb;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateWithOnlinePaymentIntent", "paymentIntent", "Lcom/stripe/proto/model/rest/PaymentIntent;", "createRequest", "(Lcom/stripe/proto/model/rest/PaymentIntent;Lcom/stripe/proto/model/offline_mode/OfflinePaymentIntentRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wrapErrorsAsTerminalException", "T", "doFinally", "Lkotlin/Function0;", "block", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "hasMoreRelatedPayments", "(Lcom/stripe/offlinemode/storage/OfflinePaymentIntentRequestEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validatePendingCreateRequirement", "offlinemode_release"})
@SourceDebugExtension(value={"SMAP\nDefaultOfflineRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultOfflineRepository.kt\ncom/stripe/offlinemode/storage/DefaultOfflineRepository\n+ 2 Merge.kt\nkotlinx/coroutines/flow/FlowKt__MergeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DefaultOfflineRepository.kt\ncom/stripe/offlinemode/storage/DefaultOfflineRepository$wrapErrorsAsTerminalException$1\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 8 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 9 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,674:1\n618#1,7:676\n638#1:684\n639#1:686\n625#1,11:687\n618#1,7:698\n638#1:738\n639#1:740\n625#1,11:741\n618#1,7:752\n638#1:759\n639#1:761\n625#1,11:762\n618#1,7:773\n638#1:780\n639#1:782\n625#1,11:783\n618#1,7:794\n638#1:801\n639#1:803\n625#1,11:804\n618#1,7:815\n638#1:827\n639#1:829\n625#1,11:830\n618#1,7:841\n638#1:853\n639#1:855\n625#1,11:856\n618#1,7:867\n638#1:874\n639#1:876\n625#1,11:877\n618#1,7:888\n638#1:900\n639#1:902\n625#1,11:903\n618#1,7:914\n638#1:921\n639#1:923\n625#1,11:924\n618#1,7:935\n638#1:942\n639#1:944\n625#1,11:945\n618#1,7:956\n638#1:963\n639#1:965\n625#1,11:966\n618#1,7:977\n638#1:984\n639#1:986\n625#1,11:987\n623#1,2:998\n638#1,2:1000\n625#1,11:1002\n618#1,7:1013\n638#1:1020\n639#1:1022\n625#1,11:1023\n618#1,7:1034\n638#1:1041\n639#1:1043\n625#1,11:1044\n618#1,7:1055\n638#1:1062\n639#1:1064\n625#1,11:1065\n618#1,7:1076\n638#1:1083\n639#1:1085\n625#1,11:1086\n618#1,7:1097\n638#1:1104\n639#1:1106\n625#1,11:1107\n618#1,7:1118\n638#1:1125\n639#1:1127\n625#1,11:1128\n618#1,7:1139\n638#1:1146\n639#1:1148\n625#1,11:1149\n193#2:675\n1#3:683\n1#3:715\n620#4:685\n620#4:739\n620#4:760\n620#4:781\n620#4:802\n620#4:828\n620#4:854\n620#4:875\n620#4:901\n620#4:922\n620#4:943\n620#4:964\n620#4:985\n620#4:1021\n620#4:1042\n620#4:1063\n620#4:1084\n620#4:1105\n620#4:1126\n620#4:1147\n1603#5,9:705\n1855#5:714\n1856#5:716\n1612#5:717\n1490#5:718\n1520#5,3:719\n1523#5,3:729\n1238#5,4:734\n361#6,7:722\n442#6:732\n392#6:733\n53#7:822\n55#7:826\n53#7:848\n55#7:852\n53#7:895\n55#7:899\n53#7:1160\n55#7:1164\n50#8:823\n55#8:825\n50#8:849\n55#8:851\n50#8:896\n55#8:898\n50#8:1161\n55#8:1163\n106#9:824\n106#9:850\n106#9:897\n106#9:1162\n*S KotlinDebug\n*F\n+ 1 DefaultOfflineRepository.kt\ncom/stripe/offlinemode/storage/DefaultOfflineRepository\n*L\n125#1:676,7\n125#1:684\n125#1:686\n125#1:687,11\n133#1:698,7\n133#1:738\n133#1:740\n133#1:741,11\n144#1:752,7\n144#1:759\n144#1:761\n144#1:762,11\n162#1:773,7\n162#1:780\n162#1:782\n162#1:783,11\n201#1:794,7\n201#1:801\n201#1:803\n201#1:804,11\n227#1:815,7\n227#1:827\n227#1:829\n227#1:830,11\n245#1:841,7\n245#1:853\n245#1:855\n245#1:856,11\n259#1:867,7\n259#1:874\n259#1:876\n259#1:877,11\n269#1:888,7\n269#1:900\n269#1:902\n269#1:903,11\n283#1:914,7\n283#1:921\n283#1:923\n283#1:924,11\n296#1:935,7\n296#1:942\n296#1:944\n296#1:945,11\n319#1:956,7\n319#1:963\n319#1:965\n319#1:966,11\n333#1:977,7\n333#1:984\n333#1:986\n333#1:987,11\n356#1:998,2\n356#1:1000,2\n356#1:1002,11\n387#1:1013,7\n387#1:1020\n387#1:1022\n387#1:1023,11\n415#1:1034,7\n415#1:1041\n415#1:1043\n415#1:1044,11\n435#1:1055,7\n435#1:1062\n435#1:1064\n435#1:1065,11\n482#1:1076,7\n482#1:1083\n482#1:1085\n482#1:1086,11\n506#1:1097,7\n506#1:1104\n506#1:1106\n506#1:1107,11\n525#1:1118,7\n525#1:1125\n525#1:1127\n525#1:1128,11\n542#1:1139,7\n542#1:1146\n542#1:1148\n542#1:1149,11\n83#1:675\n135#1:715\n125#1:685\n133#1:739\n144#1:760\n162#1:781\n201#1:802\n227#1:828\n245#1:854\n259#1:875\n269#1:901\n283#1:922\n296#1:943\n319#1:964\n333#1:985\n387#1:1021\n415#1:1042\n435#1:1063\n482#1:1084\n506#1:1105\n525#1:1126\n542#1:1147\n135#1:705,9\n135#1:714\n135#1:716\n135#1:717\n136#1:718\n136#1:719,3\n136#1:729,3\n140#1:734,4\n136#1:722,7\n140#1:732\n140#1:733\n232#1:822\n232#1:826\n250#1:848\n250#1:852\n274#1:895\n274#1:899\n571#1:1160\n571#1:1164\n232#1:823\n232#1:825\n250#1:849\n250#1:851\n274#1:896\n274#1:898\n571#1:1161\n571#1:1163\n232#1:824\n250#1:850\n274#1:897\n571#1:1162\n*E\n"})
public final class DefaultOfflineRepository
implements OfflineRepository {
    @NotNull
    private final OfflineReaderDao offlineReaderDao;
    @NotNull
    private final OfflineConnectionDao offlineConnectionDao;
    @NotNull
    private final OfflinePaymentIntentRequestDao offlinePaymentIntentRequestDao;
    @NotNull
    private final OfflineReaderCipher offlineReaderCipher;
    @NotNull
    private final OfflineConnectionCipher offlineConnectionCipher;
    @NotNull
    private final OfflinePaymentIntentRequestCipher offlinePaymentIntentRequestCipher;
    @NotNull
    private final OfflineRequestHelper offlineRequestHelper;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final OfflineKeyValueStore offlineKeyValueStore;
    @NotNull
    private final Clock clock;
    @NotNull
    private final HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> discreteLogger;
    @NotNull
    private final Logger<?, ?> logger;
    @NotNull
    private final OfflineConfigPb.ReaderOfflineConfigPb defaultOfflineReaderConfig;
    @NotNull
    private final MutableStateFlow<Long> offlineConnectionIdFlow;
    @NotNull
    private final StateFlow<OfflineConfigPb.ReaderOfflineConfigPb> activeReaderConfigFlow;
    @NotNull
    private final Lazy unprocessedPaymentsFlow$delegate;
    private final boolean isSupported;

    /*
     * WARNING - void declaration
     */
    public DefaultOfflineRepository(@NotNull OfflineReaderDao offlineReaderDao, @NotNull OfflineConnectionDao offlineConnectionDao, @NotNull OfflinePaymentIntentRequestDao offlinePaymentIntentRequestDao, @NotNull OfflineReaderCipher offlineReaderCipher, @NotNull OfflineConnectionCipher offlineConnectionCipher, @NotNull OfflinePaymentIntentRequestCipher offlinePaymentIntentRequestCipher, @NotNull OfflineRequestHelper offlineRequestHelper, @NotNull CoroutineDispatcher dispatcher, @NotNull OfflineKeyValueStore offlineKeyValueStore, @NotNull Clock clock, @NotNull HealthLogger<OfflineDomain, OfflineDomain.Builder, DiscreteScope, DiscreteScope.Builder> discreteLogger, @NotNull Logger<?, ?> logger2) {
        void $this$flatMapLatest$iv;
        Intrinsics.checkNotNullParameter((Object)offlineReaderDao, (String)"offlineReaderDao");
        Intrinsics.checkNotNullParameter((Object)offlineConnectionDao, (String)"offlineConnectionDao");
        Intrinsics.checkNotNullParameter((Object)offlinePaymentIntentRequestDao, (String)"offlinePaymentIntentRequestDao");
        Intrinsics.checkNotNullParameter((Object)offlineReaderCipher, (String)"offlineReaderCipher");
        Intrinsics.checkNotNullParameter((Object)offlineConnectionCipher, (String)"offlineConnectionCipher");
        Intrinsics.checkNotNullParameter((Object)offlinePaymentIntentRequestCipher, (String)"offlinePaymentIntentRequestCipher");
        Intrinsics.checkNotNullParameter((Object)offlineRequestHelper, (String)"offlineRequestHelper");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)offlineKeyValueStore, (String)"offlineKeyValueStore");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(discreteLogger, (String)"discreteLogger");
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        this.offlineReaderDao = offlineReaderDao;
        this.offlineConnectionDao = offlineConnectionDao;
        this.offlinePaymentIntentRequestDao = offlinePaymentIntentRequestDao;
        this.offlineReaderCipher = offlineReaderCipher;
        this.offlineConnectionCipher = offlineConnectionCipher;
        this.offlinePaymentIntentRequestCipher = offlinePaymentIntentRequestCipher;
        this.offlineRequestHelper = offlineRequestHelper;
        this.dispatcher = dispatcher;
        this.offlineKeyValueStore = offlineKeyValueStore;
        this.clock = clock;
        this.discreteLogger = discreteLogger;
        this.logger = logger2;
        this.defaultOfflineReaderConfig = new OfflineConfigPb.ReaderOfflineConfigPb(false, null, 2, null);
        this.offlineConnectionIdFlow = StateFlowKt.MutableStateFlow(null);
        Flow flow = (Flow)this.offlineConnectionIdFlow;
        boolean $i$f$flatMapLatest = false;
        this.activeReaderConfigFlow = FlowKt.stateIn((Flow)FlowKt.transformLatest((Flow)$this$flatMapLatest$iv, (Function3)((Function3)new Function3<FlowCollector<? super OfflineConfigPb.ReaderOfflineConfigPb>, Long, Continuation<? super Unit>, Object>(null, this){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ DefaultOfflineRepository $receiver$inlined;
            {
                this.$receiver$inlined = defaultOfflineRepository;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$transformLatest = (FlowCollector)this.L$0;
                        it = this.L$1;
                        var5_5 = $this$transformLatest;
                        (Continuation)this;
                        p0 = (Long)it;
                        $i$a$-flatMapLatest-DefaultOfflineRepository$activeReaderConfigFlow$1 = false;
                        this.L$0 = var5_5;
                        this.label = 1;
                        v0 = DefaultOfflineRepository.access$getActiveReaderConfigFlow(this.$receiver$inlined, p0, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        $i$a$-flatMapLatest-DefaultOfflineRepository$activeReaderConfigFlow$1 = false;
                        var5_5 = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = FlowKt.emitAll((FlowCollector)var5_5, (Flow)((Flow)v0), (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl33
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl33:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @Nullable
            public final Object invoke(@NotNull FlowCollector p1, Object p2, @Nullable Continuation p3) {
                Function3<FlowCollector<? super OfflineConfigPb.ReaderOfflineConfigPb>, Long, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        })), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatcher)), (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)((Object)this.defaultOfflineReaderConfig));
        this.unprocessedPaymentsFlow$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StateFlow<? extends List<? extends OfflinePaymentIntentRequestEntity>>>(this){
            final /* synthetic */ DefaultOfflineRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final StateFlow<List<OfflinePaymentIntentRequestEntity>> invoke() {
                void $this$flatMapLatest$iv;
                Flow flow = (Flow)this.this$0.getActiveAccountFlow();
                DefaultOfflineRepository defaultOfflineRepository = this.this$0;
                boolean $i$f$flatMapLatest = false;
                return FlowKt.stateIn((Flow)FlowKt.retry$default((Flow)FlowKt.catch((Flow)FlowKt.transformLatest((Flow)$this$flatMapLatest$iv, (Function3)((Function3)new Function3<FlowCollector<? super List<? extends OfflinePaymentIntentRequestEntity>>, String, Continuation<? super Unit>, Object>(null, defaultOfflineRepository){
                    int label;
                    private /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;
                    final /* synthetic */ DefaultOfflineRepository this$0;
                    {
                        this.this$0 = defaultOfflineRepository;
                        super(3, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                FlowCollector $this$transformLatest = (FlowCollector)this.L$0;
                                Object it = this.L$1;
                                FlowCollector flowCollector = $this$transformLatest;
                                Continuation cfr_ignored_0 = (Continuation)this;
                                String accountId = (String)it;
                                boolean bl = false;
                                this.label = 1;
                                Object object3 = FlowKt.emitAll((FlowCollector)flowCollector, accountId == null ? FlowKt.flowOf((Object)CollectionsKt.emptyList()) : DefaultOfflineRepository.access$getOfflinePaymentIntentRequestDao$p(this.this$0).fetchUnProcessedOfflinePayments(accountId), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @Nullable
                    public final Object invoke(@NotNull FlowCollector p1, Object p2, @Nullable Continuation p3) {
                        Function3<FlowCollector<? super List<? extends OfflinePaymentIntentRequestEntity>>, String, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p1;
                        function3.L$1 = p2;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                })), (Function3)((Function3)new Function3<FlowCollector<? super List<? extends OfflinePaymentIntentRequestEntity>>, Throwable, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ DefaultOfflineRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(3, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Throwable err = (Throwable)this.L$0;
                                DefaultOfflineRepository.access$logError(this.this$0, err, "Failed to get stored offline payments");
                                throw err;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super List<OfflinePaymentIntentRequestEntity>> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                        Function3<FlowCollector<? super List<? extends OfflinePaymentIntentRequestEntity>>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p2;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                })), (long)0L, null, (int)3, null), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DefaultOfflineRepository.access$getDispatcher$p(this.this$0))), (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)CollectionsKt.emptyList());
            }
        }));
        this.isSupported = true;
    }

    private final StateFlow<List<OfflinePaymentIntentRequestEntity>> getUnprocessedPaymentsFlow() {
        Lazy lazy = this.unprocessedPaymentsFlow$delegate;
        return (StateFlow)lazy.getValue();
    }

    @Override
    public boolean isSupported() {
        return this.isSupported;
    }

    @Override
    @NotNull
    public String getActiveAccountId() throws TerminalException {
        String string = (String)this.offlineKeyValueStore.getSavedAccountIdStateFlow().getValue();
        if (string == null) {
            throw new TerminalException(TerminalException.TerminalErrorCode.NO_LAST_SEEN_ACCOUNT, "Account id must not be null, connect to reader while online.", null, null, 12, null);
        }
        return string;
    }

    @Override
    public void setActiveAccountId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.offlineKeyValueStore.saveAccountId(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentConnectionId() {
        long l2;
        String errorMessage$iv = "Missing connection id";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            Object object = this.offlineConnectionIdFlow.getValue();
            if (object == null) {
                boolean $i$a$-checkNotNull-DefaultOfflineRepository$currentConnectionId$1$22 = false;
                String $i$a$-checkNotNull-DefaultOfflineRepository$currentConnectionId$1$22 = "Connection id is null";
                throw new IllegalStateException($i$a$-checkNotNull-DefaultOfflineRepository$currentConnectionId$1$22.toString());
            }
            l2 = ((Number)object).longValue();
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return l2;
    }

    @Override
    public void setCurrentConnectionId(long value) {
        this.offlineConnectionIdFlow.setValue((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Long> getOfflinePaymentAmountsByCurrency() {
        Object object;
        String errorMessage$iv = "Failed to fetch offline payments by currency";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object object2;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            boolean bl = false;
            Iterable iterable = (Iterable)this.getUnprocessedPaymentsFlow().getValue();
            boolean $i$f$mapNotNull = false;
            void var6_10 = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PaymentIntent it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                OfflinePaymentIntentRequestEntity it = (OfflinePaymentIntentRequestEntity)element$iv$iv;
                boolean bl3 = false;
                if (((OfflinePaymentIntentRequest)((Object)this.offlinePaymentIntentRequestCipher.decrypt((OfflineEntity)it))).payment_intent == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object3;
                String key$iv$iv;
                PaymentIntent it2 = (PaymentIntent)((Object)element$iv$iv);
                boolean $i$a$-groupBy-DefaultOfflineRepository$offlinePaymentAmountsByCurrency$1$42 = false;
                if (it2.currency == null) {
                    boolean $i$a$-checkNotNull-DefaultOfflineRepository$offlinePaymentAmountsByCurrency$1$2$22 = false;
                    String $i$a$-checkNotNull-DefaultOfflineRepository$offlinePaymentAmountsByCurrency$1$2$22 = "Payment intent must have a currency";
                    throw new IllegalStateException($i$a$-checkNotNull-DefaultOfflineRepository$offlinePaymentAmountsByCurrency$1$2$22.toString());
                }
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                PaymentIntent $i$a$-groupBy-DefaultOfflineRepository$offlinePaymentAmountsByCurrency$1$42 = (PaymentIntent)((Object)element$iv$iv);
                object2 = list$iv$iv;
                boolean bl6 = false;
                Long l2 = it.amount;
                if (l2 == null) {
                    boolean bl7 = false;
                    String string = "Payment intent must have an amount";
                    throw new IllegalStateException(string.toString());
                }
                object2.add(((Number)l2).longValue());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry bl6 = (Map.Entry)element$iv$iv$iv;
                Object object4 = destination$iv$iv;
                boolean bl8 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k2 = it$iv$iv.getKey();
                object2 = object4;
                boolean bl9 = false;
                List amounts = (List)entry.getValue();
                Long l3 = CollectionsKt.sumOfLong((Iterable)amounts);
                object2.put(k2, l3);
            }
            object = destination$iv$iv;
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOfflinePaymentsCount() {
        int n2;
        String errorMessage$iv = "Failed to fetch offline payments count";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            n2 = ((List)this.getUnprocessedPaymentsFlow().getValue()).size();
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return n2;
    }

    @Override
    public void clearCache() {
        this.offlineKeyValueStore.clear();
        this.offlineConnectionIdFlow.setValue(null);
    }

    @Override
    @NotNull
    public StateFlow<String> getActiveAccountFlow() {
        return this.offlineKeyValueStore.getSavedAccountIdStateFlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transaction
    public long saveOfflineReaderAndConnection(@NotNull OfflineReader offlineReader, @NotNull OfflineConnection offlineConnection) {
        long l2;
        Intrinsics.checkNotNullParameter((Object)((Object)offlineReader), (String)"offlineReader");
        Intrinsics.checkNotNullParameter((Object)((Object)offlineConnection), (String)"offlineConnection");
        String errorMessage$iv = "Failed to save offline reader and connection";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            l2 = ((Number)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(this, offlineReader, offlineConnection, null){
                Object L$0;
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ OfflineReader $offlineReader;
                final /* synthetic */ OfflineConnection $offlineConnection;
                {
                    this.this$0 = $receiver;
                    this.$offlineReader = $offlineReader;
                    this.$offlineConnection = $offlineConnection;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).getBySerialAndAccount(this.$offlineReader.serial_number, this.$offlineReader.account_id, (Continuation<? super OfflineReaderEntity>)((Continuation)this));
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((oldReaderEntity = (OfflineReaderEntity)v0) != null) break;
                            this.label = 2;
                            v1 = DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).insert((OfflineReaderEntity)DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0).encrypt((Message)this.$offlineReader), (Continuation<? super Long>)((Continuation)this));
                            if (v1 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl22
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            v2 = ((Number)v1).longValue();
                            ** GOTO lbl35
                        }
                    }
                    this.L$0 = oldReaderEntity;
                    this.label = 3;
                    v3 = DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).update((OfflineReaderEntity)DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0).encrypt((Message)OfflineReader.copy$default(this.$offlineReader, null, null, 0L, null, oldReaderEntity.getId(), oldReaderEntity.getCreated().getTime(), null, null, 207, null)), (Continuation<? super Unit>)((Continuation)this));
                    if (v3 == var10_2) {
                        return var10_2;
                    }
                    ** GOTO lbl34
                    {
                        case 3: {
                            oldReaderEntity = (OfflineReaderEntity)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl34:
                            // 2 sources

                            v2 = oldReaderEntity.getId();
lbl35:
                            // 2 sources

                            readerId = v2;
                            var6_5 = OfflineConnection.copy$default(this.$offlineConnection, null, null, null, null, 0L, readerId, 0L, null, null, null, null, null, null, null, 16351, null);
                            var7_6 = DefaultOfflineRepository.access$getOfflineConnectionCipher$p(this.this$0);
                            p0 = var6_5;
                            $i$a$-let-DefaultOfflineRepository$saveOfflineReaderAndConnection$1$1$encryptedOfflineConnection$1 = false;
                            encryptedOfflineConnection = (OfflineConnectionEntity)var7_6.encrypt((Message)p0);
                            this.L$0 = encryptedOfflineConnection;
                            this.label = 4;
                            v4 = DefaultOfflineRepository.access$getOfflineConnectionDao$p(this.this$0).getById(this.$offlineConnection.id, (Continuation<? super OfflineConnectionEntity>)((Continuation)this));
                            if (v4 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl52
                        }
                        case 4: {
                            encryptedOfflineConnection = (OfflineConnectionEntity)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl52:
                            // 2 sources

                            if (v4 == null) break;
                            this.L$0 = null;
                            this.label = 5;
                            v5 = DefaultOfflineRepository.access$getOfflineConnectionDao$p(this.this$0).update(encryptedOfflineConnection, (Continuation<? super Unit>)((Continuation)this));
                            if (v5 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl62
                        }
                        case 5: {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl62:
                            // 2 sources

                            v6 = this.$offlineConnection.id;
                            ** GOTO lbl74
                        }
                    }
                    this.L$0 = null;
                    this.label = 6;
                    v7 = DefaultOfflineRepository.access$getOfflineConnectionDao$p(this.this$0).insert(encryptedOfflineConnection, (Continuation<? super Long>)((Continuation)this));
                    if (v7 == var10_2) {
                        return var10_2;
                    }
                    ** GOTO lbl73
                    {
                        case 6: {
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl73:
                            // 2 sources

                            v6 = ((Number)v7).longValue();
lbl74:
                            // 2 sources

                            return Boxing.boxLong((long)v6);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }))).longValue();
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOfflinePaymentIntentRequest(@NotNull OfflinePaymentIntentRequest offlinePaymentIntentRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)offlinePaymentIntentRequest), (String)"offlinePaymentIntentRequest");
        String errorMessage$iv = "Failed to save offline payment intent requests";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            long l2 = ((Number)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(this, offlinePaymentIntentRequest, null){
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ OfflinePaymentIntentRequest $offlinePaymentIntentRequest;
                {
                    this.this$0 = $receiver;
                    this.$offlinePaymentIntentRequest = $offlinePaymentIntentRequest;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultOfflineRepository.access$validatePendingCreateRequirement(this.this$0, this.$offlinePaymentIntentRequest, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) {
                                throw new TerminalException(TerminalException.TerminalErrorCode.OFFLINE_PAYMENT_INTENT_NOT_FOUND, "Cannot confirm offline payment without a corresponding create request.", null, null, 12, null);
                            }
                            this.label = 2;
                            v1 = DefaultOfflineRepository.access$getOfflinePaymentIntentRequestDao$p(this.this$0).insert((OfflinePaymentIntentRequestEntity)DefaultOfflineRepository.access$getOfflinePaymentIntentRequestCipher$p(this.this$0).encrypt((Message)this.$offlinePaymentIntentRequest), (Continuation<? super Long>)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl23
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }))).longValue();
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flow<OfflineRequestsToSync> getOfflinePaymentRequestsToSync(@NotNull String accountId) {
        Flow flow;
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage = "Failed to fetch offline payment intent requests";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            void $this$map$iv;
            boolean bl = false;
            Flow flow2 = FlowKt.distinctUntilChanged(this.offlinePaymentIntentRequestDao.getByAccountId(accountId));
            boolean $i$f$map = false;
            void $this$unsafeTransform$iv$iv = $this$map$iv;
            boolean $i$f$unsafeTransform = false;
            boolean $i$f$unsafeFlow = false;
            flow = (Flow)new Flow<OfflineRequestsToSync>((Flow)$this$unsafeTransform$iv$iv, this, errorMessage){
                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $errorMessage$inlined;
                {
                    this.$this_unsafeTransform$inlined = flow;
                    this.this$0 = defaultOfflineRepository;
                    this.$errorMessage$inlined = string;
                }

                @Nullable
                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                    Continuation continuation = $completion;
                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                    boolean bl = false;
                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0, this.$errorMessage$inlined){
                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                        final /* synthetic */ DefaultOfflineRepository this$0;
                        final /* synthetic */ String $errorMessage$inlined;
                        {
                            this.$this_unsafeFlow = $receiver;
                            this.this$0 = defaultOfflineRepository;
                            this.$errorMessage$inlined = string;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                            if (!(var2_2 instanceof getOfflinePaymentRequestsToSync$lambda$17$$inlined$map$1$2$1)) ** GOTO lbl-1000
                            var3_3 = var2_2;
                            if ((var3_3.label & -2147483648) != 0) {
                                var3_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, var2_2){
                                    /* synthetic */ Object result;
                                    int label;
                                    Object L$0;
                                    final /* synthetic */ getOfflinePaymentRequestsToSync$lambda$17$$inlined$map$1$2 this$0;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.emit(null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var6_6 = value;
                                    $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    var9_10 = $this$map_u24lambda_u245;
                                    (Continuation)$continuation;
                                    entities = (List)value;
                                    $i$a$-map-DefaultOfflineRepository$getOfflinePaymentRequestsToSync$1$1 = false;
                                    $i$f$wrapErrorsAsTerminalException = false;
                                    try {
                                        $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflinePaymentRequestsToSync$1$1$1 = false;
                                        var14_17 = entities;
                                        var15_19 = DefaultOfflineRepository.access$getOfflinePaymentIntentRequestCipher$p(this.this$0);
                                        $i$f$map = false;
                                        var17_24 = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            var22_29 = (OfflinePaymentIntentRequestEntity)item$iv$iv;
                                            var23_30 = destination$iv$iv;
                                            $i$a$-map-DefaultOfflineRepository$getOfflinePaymentRequestsToSync$1$1$1$1 = false;
                                            var23_30.add((OfflinePaymentIntentRequest)var15_19.decrypt((OfflineEntity)p0));
                                        }
                                        var25_32 = (List)destination$iv$iv;
                                    }
                                    catch (Throwable e$iv) {
                                        DefaultOfflineRepository.access$logError(this.this$0, e$iv, this.$errorMessage$inlined);
                                        $this$map$iv = e$iv;
                                        if ($this$map$iv instanceof TerminalException) {
                                            throw e$iv;
                                        }
                                        errorCode$iv = $this$map$iv instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                                        throw new TerminalException(errorCode$iv, this.$errorMessage$inlined, e$iv, null, 8, null);
                                    }
                                    finally {
                                        $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                                    }
                                    var28_35 = entities;
                                    var27_36 = var25_32;
                                    $i$f$filter = false;
                                    errorCode$iv = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (OfflinePaymentIntentRequestEntity)element$iv$iv;
                                        $i$a$-filter-DefaultOfflineRepository$getOfflinePaymentRequestsToSync$1$1$2 = false;
                                        if (!it.getDeleted()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$map$iv = (List)destination$iv$iv;
                                    $i$f$map = false;
                                    $this$filterTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        it = (OfflinePaymentIntentRequestEntity)item$iv$iv;
                                        var29_37 = destination$iv$iv;
                                        $i$a$-map-DefaultOfflineRepository$getOfflinePaymentRequestsToSync$1$1$3 = false;
                                        var29_37.add(it.getPaymentId());
                                    }
                                    var30_38 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                    var31_39 = var27_36;
                                    $continuation.label = 1;
                                    v0 = var9_10.emit((Object)new OfflineRequestsToSync(var31_39, var30_38), (Continuation)$continuation);
                                    if (v0 == var5_5) {
                                        return var5_5;
                                    }
                                    ** GOTO lbl86
                                }
                                case 1: {
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl86:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            };
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flow<List<OfflineReader>> getOfflineReaders(@NotNull String accountId) {
        Flow flow;
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage = "Failed to fetch offline readers";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            void $this$map$iv;
            boolean bl = false;
            Flow flow2 = FlowKt.distinctUntilChanged(this.offlineReaderDao.getByAccountId(accountId));
            boolean $i$f$map = false;
            void $this$unsafeTransform$iv$iv = $this$map$iv;
            boolean $i$f$unsafeTransform = false;
            boolean $i$f$unsafeFlow = false;
            flow = (Flow)new Flow<List<? extends OfflineReader>>((Flow)$this$unsafeTransform$iv$iv, this, errorMessage){
                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $errorMessage$inlined;
                {
                    this.$this_unsafeTransform$inlined = flow;
                    this.this$0 = defaultOfflineRepository;
                    this.$errorMessage$inlined = string;
                }

                @Nullable
                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                    Continuation continuation = $completion;
                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                    boolean bl = false;
                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0, this.$errorMessage$inlined){
                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                        final /* synthetic */ DefaultOfflineRepository this$0;
                        final /* synthetic */ String $errorMessage$inlined;
                        {
                            this.$this_unsafeFlow = $receiver;
                            this.this$0 = defaultOfflineRepository;
                            this.$errorMessage$inlined = string;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                            if (!(var2_2 instanceof getOfflineReaders$lambda$21$$inlined$map$1$2$1)) ** GOTO lbl-1000
                            var3_3 = var2_2;
                            if ((var3_3.label & -2147483648) != 0) {
                                var3_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, var2_2){
                                    /* synthetic */ Object result;
                                    int label;
                                    Object L$0;
                                    final /* synthetic */ getOfflineReaders$lambda$21$$inlined$map$1$2 this$0;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.emit(null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var6_6 = value;
                                    $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    var9_10 = $this$map_u24lambda_u245;
                                    (Continuation)$continuation;
                                    it = (List)value;
                                    $i$a$-map-DefaultOfflineRepository$getOfflineReaders$1$1 = false;
                                    $i$f$wrapErrorsAsTerminalException = false;
                                    try {
                                        $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflineReaders$1$1$1 = false;
                                        var14_16 = it;
                                        var15_18 = DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0);
                                        $i$f$map = false;
                                        var17_21 = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            var22_26 = (OfflineReaderEntity)item$iv$iv;
                                            var23_27 = destination$iv$iv;
                                            $i$a$-map-DefaultOfflineRepository$getOfflineReaders$1$1$1$1 = false;
                                            var23_27.add((OfflineReader)var15_18.decrypt((OfflineEntity)p0));
                                        }
                                        var25_29 = (List)destination$iv$iv;
                                    }
                                    catch (Throwable e$iv) {
                                        DefaultOfflineRepository.access$logError(this.this$0, e$iv, this.$errorMessage$inlined);
                                        var14_17 = e$iv;
                                        if (var14_17 instanceof TerminalException) {
                                            throw e$iv;
                                        }
                                        errorCode$iv = var14_17 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                                        throw new TerminalException(errorCode$iv, this.$errorMessage$inlined, e$iv, null, 8, null);
                                    }
                                    finally {
                                        $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                                    }
                                    $continuation.label = 1;
                                    v0 = var9_10.emit((Object)var25_29, (Continuation)$continuation);
                                    if (v0 == var5_5) {
                                        return var5_5;
                                    }
                                    ** GOTO lbl60
                                }
                                case 1: {
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl60:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            };
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OfflineReader getOfflineReader(@NotNull String serialNumber, @NotNull String accountId) {
        OfflineReader offlineReader;
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage$iv = "Failed to fetch offline reader with serial number " + serialNumber;
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            offlineReader = (OfflineReader)((Object)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OfflineReader>, Object>(this, serialNumber, accountId, null){
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $serialNumber;
                final /* synthetic */ String $accountId;
                {
                    this.this$0 = $receiver;
                    this.$serialNumber = $serialNumber;
                    this.$accountId = $accountId;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).getBySerialAndAccount(this.$serialNumber, this.$accountId, (Continuation<? super OfflineReaderEntity>)((Continuation)this));
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((var2_3 = (OfflineReaderEntity)v0) != null) {
                                var3_4 = var2_3;
                                var4_5 = DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0);
                                p0 = var3_4;
                                $i$a$-let-DefaultOfflineRepository$getOfflineReader$1$1$1 = false;
                                v1 = (OfflineReader)var4_5.decrypt((OfflineEntity)p0);
                            } else {
                                v1 = null;
                            }
                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super OfflineReader> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return offlineReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Flow<List<OfflineConnection>> getOfflineConnections(@NotNull String accountId) {
        Flow flow;
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage = "Failed to fetch offline connections";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            void $this$map$iv;
            boolean bl = false;
            Flow flow2 = FlowKt.distinctUntilChanged(this.offlineConnectionDao.getByAccountId(accountId));
            boolean $i$f$map = false;
            void $this$unsafeTransform$iv$iv = $this$map$iv;
            boolean $i$f$unsafeTransform = false;
            boolean $i$f$unsafeFlow = false;
            flow = (Flow)new Flow<List<? extends OfflineConnection>>((Flow)$this$unsafeTransform$iv$iv, this, errorMessage){
                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $errorMessage$inlined;
                {
                    this.$this_unsafeTransform$inlined = flow;
                    this.this$0 = defaultOfflineRepository;
                    this.$errorMessage$inlined = string;
                }

                @Nullable
                public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                    Continuation continuation = $completion;
                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                    boolean bl = false;
                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0, this.$errorMessage$inlined){
                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                        final /* synthetic */ DefaultOfflineRepository this$0;
                        final /* synthetic */ String $errorMessage$inlined;
                        {
                            this.$this_unsafeFlow = $receiver;
                            this.this$0 = defaultOfflineRepository;
                            this.$errorMessage$inlined = string;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                            if (!(var2_2 instanceof getOfflineConnections$lambda$26$$inlined$map$1$2$1)) ** GOTO lbl-1000
                            var3_3 = var2_2;
                            if ((var3_3.label & -2147483648) != 0) {
                                var3_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, var2_2){
                                    /* synthetic */ Object result;
                                    int label;
                                    Object L$0;
                                    final /* synthetic */ getOfflineConnections$lambda$26$$inlined$map$1$2 this$0;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.emit(null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var6_6 = value;
                                    $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    var9_10 = $this$map_u24lambda_u245;
                                    (Continuation)$continuation;
                                    it = (List)value;
                                    $i$a$-map-DefaultOfflineRepository$getOfflineConnections$1$1 = false;
                                    $i$f$wrapErrorsAsTerminalException = false;
                                    try {
                                        $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflineConnections$1$1$1 = false;
                                        var14_16 = it;
                                        var15_18 = DefaultOfflineRepository.access$getOfflineConnectionCipher$p(this.this$0);
                                        $i$f$map = false;
                                        var17_21 = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            var22_26 = (OfflineConnectionEntity)item$iv$iv;
                                            var23_27 = destination$iv$iv;
                                            $i$a$-map-DefaultOfflineRepository$getOfflineConnections$1$1$1$1 = false;
                                            var23_27.add((OfflineConnection)var15_18.decrypt((OfflineEntity)p0));
                                        }
                                        var25_29 = (List)destination$iv$iv;
                                    }
                                    catch (Throwable e$iv) {
                                        DefaultOfflineRepository.access$logError(this.this$0, e$iv, this.$errorMessage$inlined);
                                        var14_17 = e$iv;
                                        if (var14_17 instanceof TerminalException) {
                                            throw e$iv;
                                        }
                                        errorCode$iv = var14_17 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                                        throw new TerminalException(errorCode$iv, this.$errorMessage$inlined, e$iv, null, 8, null);
                                    }
                                    finally {
                                        $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                                    }
                                    $continuation.label = 1;
                                    v0 = var9_10.emit((Object)var25_29, (Continuation)$continuation);
                                    if (v0 == var5_5) {
                                        return var5_5;
                                    }
                                    ** GOTO lbl60
                                }
                                case 1: {
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl60:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            };
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public OfflineConnection getOfflineConnection(long connectionId) {
        OfflineConnection offlineConnection;
        String errorMessage$iv = "Failed to fetch offline connection with ID " + connectionId;
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            offlineConnection = (OfflineConnection)((Object)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OfflineConnection>, Object>(this, connectionId, null){
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ long $connectionId;
                {
                    this.this$0 = $receiver;
                    this.$connectionId = $connectionId;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultOfflineRepository.access$getOfflineConnectionDao$p(this.this$0).getById(this.$connectionId, (Continuation<? super OfflineConnectionEntity>)((Continuation)this));
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((var2_3 = (OfflineConnectionEntity)v0) == null) ** GOTO lbl21
                            var4_4 = var2_3;
                            var5_5 = DefaultOfflineRepository.access$getOfflineConnectionCipher$p(this.this$0);
                            p0 = var4_4;
                            $i$a$-let-DefaultOfflineRepository$getOfflineConnection$1$1$1 = false;
                            var3_8 = (OfflineConnection)var5_5.decrypt((OfflineEntity)p0);
                            if (var3_8 != null) ** GOTO lbl22
lbl21:
                            // 2 sources

                            throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Finding offline connection with ID " + this.$connectionId + " returned null.", null, null, 12, null);
lbl22:
                            // 1 sources

                            return var3_8;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super OfflineConnection> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return offlineConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object fetchNextToForward(@NotNull String accountId, @NotNull Continuation<? super Flow<ForwardOfflinePaymentRequest>> $completion) {
        Flow flow;
        String errorMessage$iv = "Failed to fetch the next offline entity to forward";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            flow = FlowKt.flowCombine((Flow)FlowKt.filterNotNull((Flow)FlowKt.distinctUntilChanged(this.offlinePaymentIntentRequestDao.fetchNextPaymentToForward(accountId))), (Flow)FlowKt.distinctUntilChanged((Flow)FlowKt.filterNotNull(this.offlinePaymentIntentRequestDao.getMostRecentRowId(accountId))), (Function3)((Function3)new Function3<OfflinePaymentIntentRequestEntity, Long, Continuation<? super ForwardOfflinePaymentRequest>, Object>((Object)this){

                @Nullable
                public final Object invoke(@NotNull OfflinePaymentIntentRequestEntity p0, long p1, @NotNull Continuation<? super ForwardOfflinePaymentRequest> $completion) {
                    return DefaultOfflineRepository.access$getOfflineConnectionAndReaderForPaymentRequest((DefaultOfflineRepository)this.receiver, p0, p1, $completion);
                }
            }));
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object delete(@NotNull OfflinePaymentIntentRequest var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof delete.1)) ** GOTO lbl-1000
        var16_3 = var2_2;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.delete(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage$iv = "Failed to delete offline payment intent request.";
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$delete$2 = false;
                v0 = this.offlinePaymentIntentRequestDao;
                v1 = toDelete.offline_id;
                if (v1 == null) {
                    v2 = toDelete.payment_intent_id;
                    if (v2 != null) {
                        it = var8_11 = v2;
                        var10_13 = v0;
                        $i$a$-takeIf-DefaultOfflineRepository$delete$2$1 = false;
                        var12_15 = ((CharSequence)it).length() > 0;
                        v0 = var10_13;
                        v1 = var12_15 ? var8_11 : null;
                    } else {
                        v1 = null;
                    }
                }
                if (v1 == null) {
                    var10_13 = v0;
                    $i$a$-requireNotNull-DefaultOfflineRepository$delete$2$2 = false;
                    v3 = var10_13;
                    $i$a$-requireNotNull-DefaultOfflineRepository$delete$2$2 = "One of offline or payment intent id must not be null.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-DefaultOfflineRepository$delete$2$2.toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = errorMessage$iv;
                $continuation.label = 1;
                v4 = v0.deleteByOfflineOrPaymentIntentId(v1, (Continuation<? super Unit>)$continuation);
                ** if (v4 != var17_5) goto lbl43
lbl42:
                // 1 sources

                return var17_5;
lbl43:
                // 1 sources

                ** GOTO lbl53
            }
            case 1: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$delete$2 = false;
                errorMessage$iv = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl53:
                    // 2 sources

                    var13_19 = Unit.INSTANCE;
                    ** GOTO lbl68
                }
                catch (Throwable e$iv) {
                    DefaultOfflineRepository.access$logError(this, e$iv, errorMessage$iv);
                    var6_22 = e$iv;
                    if (var6_22 instanceof TerminalException) {
                        throw e$iv;
                    }
                    errorCode$iv = var6_22 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                    throw new TerminalException(errorCode$iv, (String)var3_6, e$iv, null, 8, null);
                }
            }
            catch (Throwable var14_21) {
                throw var14_21;
            }
            {
                finally {
                    $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                }
lbl68:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object softDelete(@NotNull OfflinePaymentIntentRequest var1_1, @NotNull Continuation<? super Integer> var2_2) {
        if (!(var2_2 instanceof softDelete.1)) ** GOTO lbl-1000
        var19_3 = var2_2;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.softDelete(null, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage$iv = "Failed to soft delete offline payment intent request.";
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$softDelete$2 = false;
                v0 = this.offlinePaymentIntentRequestDao;
                v1 = var6_11 = new String[1];
                v2 = 0;
                v3 = toSoftDelete.offline_id;
                if (v3 == null) {
                    v4 = toSoftDelete.payment_intent_id;
                    if (v4 != null) {
                        it = var9_13 = v4;
                        var11_15 = v2;
                        var12_16 = v1;
                        var13_17 = v0;
                        $i$a$-takeIf-DefaultOfflineRepository$softDelete$2$1 = false;
                        var15_19 = ((CharSequence)it).length() > 0;
                        v0 = var13_17;
                        v1 = var12_16;
                        v2 = var11_15;
                        v3 = var15_19 ? var9_13 : null;
                    } else {
                        v3 = null;
                    }
                }
                if (v3 == null) {
                    var11_15 = v2;
                    var12_16 = v1;
                    var13_17 = v0;
                    $i$a$-requireNotNull-DefaultOfflineRepository$softDelete$2$2 = false;
                    var15_20 = "One of offline or payment intent id must not be null.";
                    v5 = var13_17;
                    v6 = var12_16;
                    v7 = var11_15;
                    var8_22 = var15_20;
                    throw new IllegalArgumentException(var8_22.toString());
                }
                v1[v2] = v3;
                $continuation.L$0 = this;
                $continuation.L$1 = errorMessage$iv;
                $continuation.label = 1;
                v8 = v0.softDeleteByPaymentId(var6_11, (Continuation<? super Integer>)$continuation);
                ** if (v8 != var20_5) goto lbl55
lbl54:
                // 1 sources

                return var20_5;
lbl55:
                // 1 sources

                ** GOTO lbl65
            }
            case 1: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$softDelete$2 = false;
                errorMessage$iv = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl65:
                    // 2 sources

                    var16_23 = Boxing.boxInt((int)((Number)v8).intValue());
                    ** GOTO lbl80
                }
                catch (Throwable e$iv) {
                    DefaultOfflineRepository.access$logError(this, e$iv, errorMessage$iv);
                    var6_12 = e$iv;
                    if (var6_12 instanceof TerminalException) {
                        throw e$iv;
                    }
                    errorCode$iv = var6_12 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                    throw new TerminalException(errorCode$iv, (String)var3_6, e$iv, null, 8, null);
                }
            }
            catch (Throwable var17_25) {
                throw var17_25;
            }
            {
                finally {
                    $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                }
lbl80:
                // 1 sources

                return var16_23;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Transaction
    @Nullable
    public Object updateWithOnlinePaymentIntent(@NotNull PaymentIntent var1_1, @NotNull OfflinePaymentIntentRequest var2_2, @NotNull Continuation<? super Unit> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 7[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object getOfflineConnectionAndReaderForPaymentRequest(OfflinePaymentIntentRequestEntity var1_1, long var2_2, Continuation<? super ForwardOfflinePaymentRequest> var4_3) {
        if (!(var4_3 instanceof getOfflineConnectionAndReaderForPaymentRequest.1)) ** GOTO lbl-1000
        var22_4 = var4_3;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultOfflineRepository.access$getOfflineConnectionAndReaderForPaymentRequest(this.this$0, null, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage$iv = "Failed to fetch the next offline entity to forward";
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflineConnectionAndReaderForPaymentRequest$2 = false;
                paymentId = offlinePIREntity.getPaymentId();
                $continuation.L$0 = this;
                $continuation.L$1 = offlinePIREntity;
                $continuation.L$2 = errorMessage$iv;
                $continuation.L$3 = paymentId;
                $continuation.J$0 = mostRecentRowId;
                $continuation.label = 1;
                v0 = this.offlineConnectionDao.getById(offlinePIREntity.getConnectionId(), (Continuation<? super OfflineConnectionEntity>)$continuation);
                ** if (v0 != var28_6) goto lbl28
lbl27:
                // 1 sources

                return var28_6;
lbl28:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflineConnectionAndReaderForPaymentRequest$2 = false;
                mostRecentRowId = $continuation.J$0;
                paymentId = (String)$continuation.L$3;
                errorMessage$iv = (String)$continuation.L$2;
                offlinePIREntity = (OfflinePaymentIntentRequestEntity)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl41:
                // 2 sources

                if (v0 == null) {
                    $i$a$-requireNotNull-DefaultOfflineRepository$getOfflineConnectionAndReaderForPaymentRequest$2$offlineConnectionEntity$1 = false;
                    var10_12 = "Couldn't find an offline connection for this payment request " + paymentId;
                    throw new IllegalArgumentException(var10_12.toString());
                }
                offlineConnectionEntity = (OfflineConnectionEntity)v0;
                $continuation.L$0 = this;
                $continuation.L$1 = offlinePIREntity;
                $continuation.L$2 = errorMessage$iv;
                $continuation.L$3 = paymentId;
                $continuation.L$4 = offlineConnectionEntity;
                $continuation.J$0 = mostRecentRowId;
                $continuation.label = 2;
                v1 = this.offlineReaderDao.getByReaderId(offlineConnectionEntity.getReaderId(), (Continuation<? super OfflineReaderEntity>)$continuation);
                ** if (v1 != var28_6) goto lbl56
lbl55:
                // 1 sources

                return var28_6;
lbl56:
                // 1 sources

                ** GOTO lbl70
            }
            case 2: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflineConnectionAndReaderForPaymentRequest$2 = false;
                mostRecentRowId = $continuation.J$0;
                offlineConnectionEntity = (OfflineConnectionEntity)$continuation.L$4;
                paymentId = (String)$continuation.L$3;
                errorMessage$iv = (String)$continuation.L$2;
                offlinePIREntity = (OfflinePaymentIntentRequestEntity)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl70:
                // 2 sources

                if (v1 == null) {
                    $i$a$-requireNotNull-DefaultOfflineRepository$getOfflineConnectionAndReaderForPaymentRequest$2$offlineReaderEntity$1 = false;
                    var12_15 = "Couldn't find an offline reader for this payment request " + paymentId;
                    throw new IllegalArgumentException(var12_15.toString());
                }
                offlineReaderEntity = (OfflineReaderEntity)v1;
                var13_17 = (OfflinePaymentIntentRequest)this.offlinePaymentIntentRequestCipher.decrypt((OfflineEntity)offlinePIREntity);
                var14_18 = (OfflineConnection)this.offlineConnectionCipher.decrypt((OfflineEntity)offlineConnectionEntity);
                var15_19 = (OfflineReader)this.offlineReaderCipher.decrypt((OfflineEntity)offlineReaderEntity);
                $continuation.L$0 = this;
                $continuation.L$1 = offlinePIREntity;
                $continuation.L$2 = errorMessage$iv;
                $continuation.L$3 = var13_17;
                $continuation.L$4 = var14_18;
                $continuation.L$5 = var15_19;
                $continuation.J$0 = mostRecentRowId;
                $continuation.label = 3;
                v2 = this.hasMoreRelatedPayments(offlinePIREntity, (Continuation<? super Boolean>)$continuation);
                ** if (v2 != var28_6) goto lbl89
lbl88:
                // 1 sources

                return var28_6;
lbl89:
                // 1 sources

                ** GOTO lbl104
            }
            case 3: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$getOfflineConnectionAndReaderForPaymentRequest$2 = false;
                mostRecentRowId = $continuation.J$0;
                var15_19 = (OfflineReader)$continuation.L$5;
                var14_18 = (OfflineConnection)$continuation.L$4;
                var13_17 = (OfflinePaymentIntentRequest)$continuation.L$3;
                errorMessage$iv = (String)$continuation.L$2;
                offlinePIREntity = (OfflinePaymentIntentRequestEntity)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl104:
                    // 2 sources

                    var16_20 = v2;
                    var23_21 = offlinePIREntity.getId() < mostRecentRowId;
                    var24_22 = (Boolean)var16_20;
                    var25_23 = var13_17;
                    var26_24 = var14_18;
                    var27_25 = var15_19;
                    var17_26 = new ForwardOfflinePaymentRequest(var27_25, var26_24, var25_23, var24_22 != false, var23_21 != false);
                    ** GOTO lbl125
                }
                catch (Throwable e$iv) {
                    DefaultOfflineRepository.access$logError(this, e$iv, errorMessage$iv);
                    var19_29 = e$iv;
                    if (var19_29 instanceof TerminalException) {
                        throw e$iv;
                    }
                    errorCode$iv = var19_29 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                    throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
                }
            }
            catch (Throwable var18_28) {
                throw var18_28;
            }
            {
                finally {
                    $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                }
lbl125:
                // 1 sources

                return var17_26;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object updateOfflineReaderWithConfig(@NotNull String var1_1, @NotNull String var2_2, @NotNull OfflineConfigPb.ReaderOfflineConfigPb var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof updateOfflineReaderWithConfig.1)) ** GOTO lbl-1000
        var15_5 = var4_4;
        if ((var15_5.label & -2147483648) != 0) {
            var15_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateOfflineReaderWithConfig(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = "Failed to update offline reader";
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$updateOfflineReaderWithConfig$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = config;
                $continuation.L$2 = errorMessage;
                $continuation.label = 1;
                v0 = this.offlineReaderDao.getBySerialAndAccount((String)readerSerial, (String)accountId, (Continuation<? super OfflineReaderEntity>)$continuation);
                ** if (v0 != var16_7) goto lbl25
lbl24:
                // 1 sources

                return var16_7;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$updateOfflineReaderWithConfig$2 = false;
                errorMessage = (String)$continuation.L$2;
                config = (OfflineConfigPb.ReaderOfflineConfigPb)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                v1 = (OfflineReaderEntity)v0;
                if (v1 == null) {
                    throw new Exception("Couldn't find reader for given serial + account");
                }
                reader = v1;
                updated = OfflineReader.copy$default((OfflineReader)this.offlineReaderCipher.decrypt((OfflineEntity)reader), null, null, 0L, null, 0L, 0L, config, null, 191, null);
                $continuation.L$0 = this;
                $continuation.L$1 = errorMessage;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v2 = this.offlineReaderDao.update((OfflineReaderEntity)this.offlineReaderCipher.encrypt((Message)updated), (Continuation<? super Unit>)$continuation);
                ** if (v2 != var16_7) goto lbl48
lbl47:
                // 1 sources

                return var16_7;
lbl48:
                // 1 sources

                ** GOTO lbl58
            }
            case 2: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$updateOfflineReaderWithConfig$2 = false;
                errorMessage = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl58:
                    // 2 sources

                    var10_15 = Unit.INSTANCE;
                    ** GOTO lbl73
                }
                catch (Throwable e$iv) {
                    DefaultOfflineRepository.access$logError(this, e$iv, errorMessage);
                    var12_18 = e$iv;
                    if (var12_18 instanceof TerminalException) {
                        throw e$iv;
                    }
                    errorCode$iv = var12_18 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                    throw new TerminalException(errorCode$iv, errorMessage, e$iv, null, 8, null);
                }
            }
            catch (Throwable var11_17) {
                throw var11_17;
            }
            {
                finally {
                    $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                }
lbl73:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Pair<OfflineReader, OfflineConnection> getOfflineReaderAndConnectionIfSaved(@NotNull Reader reader, @NotNull String accountId) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage$iv = "Failed to get offline reader and connection pair";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            pair = (Pair)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends OfflineReader, ? extends OfflineConnection>>, Object>(this, accountId, reader, null){
                Object L$0;
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $accountId;
                final /* synthetic */ Reader $reader;
                {
                    this.this$0 = $receiver;
                    this.$accountId = $accountId;
                    this.$reader = $reader;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var27_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.first(DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).getByAccountId(this.$accountId), (Continuation)((Continuation)this));
                            if (v0 == var27_2) {
                                return var27_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            $this$mapNotNull$iv = (Iterable)v0;
                            var4_4 = this.this$0;
                            var5_5 /* !! */  = this.$reader;
                            $i$f$mapNotNull = false;
                            var7_8 = $this$mapNotNull$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$mapNotNullTo = false;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = false;
                            var12_14 = $this$forEach$iv$iv$iv.iterator();
                            while (var12_14.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = var12_14.next();
                                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                savedReader = (OfflineReaderEntity)element$iv$iv;
                                $i$a$-mapNotNull-DefaultOfflineRepository$getOfflineReaderAndConnectionIfSaved$1$1$savedOfflineReadersForDeviceType$1 = false;
                                it = var18_20 = savedReader;
                                $i$a$-takeIf-DefaultOfflineRepository$getOfflineReaderAndConnectionIfSaved$1$1$savedOfflineReadersForDeviceType$1$1 = false;
                                try {
                                    $i$a$-runCatching-DefaultOfflineRepository$getOfflineReaderAndConnectionIfSaved$1$1$savedOfflineReadersForDeviceType$1$1$deviceType$1 = false;
                                    var21_23 = Result.constructor-impl((Object)DeviceTypeMaker.Companion.fromSerial(it.getSerialNumber()));
                                }
                                catch (Throwable var22_26) {
                                    var21_23 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var22_26));
                                }
                                var22_25 = DeviceType.UNKNOWN;
                                deviceType /* !! */  = Result.isFailure-impl((Object)var21_23) != false ? var22_25 : var21_23;
                                v1 = var24_28 = deviceType /* !! */  == var5_5 /* !! */ .getDeviceType() != false ? var18_20 : null;
                                if (var24_28 != null) {
                                    p0 = var18_20 = var24_28;
                                    $i$a$-takeUnless-DefaultOfflineRepository$getOfflineReaderAndConnectionIfSaved$1$1$savedOfflineReadersForDeviceType$1$2 = false;
                                    v2 = !DefaultOfflineRepository.access$isExpired(var4_4, p0) ? var18_20 : null;
                                } else {
                                    v2 = null;
                                }
                                if (v2 == null) continue;
                                it$iv$iv = v2;
                                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            savedOfflineReadersForDeviceType = (List)destination$iv$iv;
                            if (savedOfflineReadersForDeviceType.isEmpty()) {
                                throw new TerminalException(TerminalException.TerminalErrorCode.READER_CONNECTION_NOT_AVAILABLE_OFFLINE, "No saved offline readers of this type found for " + this.$accountId + '.', null, null, 12, null);
                            }
                            var5_5 /* !! */  = savedOfflineReadersForDeviceType;
                            var6_7 = this.$reader;
                            var7_8 = var5_5 /* !! */ ;
                            for (T var9_11 : var7_8) {
                                it = (OfflineReaderEntity)var9_11;
                                $i$a$-find-DefaultOfflineRepository$getOfflineReaderAndConnectionIfSaved$1$1$offlineReader$1 = false;
                                if (!Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)var6_7.getSerialNumber())) continue;
                                v3 = var9_11;
                                ** GOTO lbl67
                            }
                            v3 = null;
lbl67:
                            // 2 sources

                            v4 = v3;
                            if (v4 == null) {
                                return null;
                            }
                            offlineReader = v4;
                            this.L$0 = offlineReader;
                            this.label = 2;
                            v5 = DefaultOfflineRepository.access$getOfflineConnectionDao$p(this.this$0).getMostRecentConnectionForReader(offlineReader.getId(), (Continuation<? super OfflineConnectionEntity>)((Continuation)this));
                            if (v5 == var27_2) {
                                return var27_2;
                            }
                            ** GOTO lbl81
                        }
                        case 2: {
                            offlineReader = (OfflineReaderEntity)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl81:
                            // 2 sources

                            v6 = (OfflineConnectionEntity)v5;
                            if (v6 == null) {
                                throw new TerminalException(TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR, "Failed to find connection record for saved reader " + this.$reader.getSerialNumber() + '.', null, null, 12, null);
                            }
                            connection = v6;
                            return TuplesKt.to(DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0).decrypt((OfflineEntity)offlineReader), DefaultOfflineRepository.access$getOfflineConnectionCipher$p(this.this$0).decrypt((OfflineEntity)connection));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<OfflineReader, OfflineConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, ApiLocationPb> getSavedLocationsMap(@NotNull String accountId, @NotNull List<String> serials) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter(serials, (String)"serials");
        String errorMessage$iv = "Failed to get saved locations for account";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            map2 = (Map)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends ApiLocationPb>>, Object>(this, accountId, serials, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $accountId;
                final /* synthetic */ List<String> $serials;
                {
                    this.this$0 = $receiver;
                    this.$accountId = $accountId;
                    this.$serials = $serials;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var25_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).getBySerialsForAccount(this.$accountId, this.$serials, (Continuation<? super List<OfflineReaderEntity>>)((Continuation)this));
                            if (v0 == var25_2) {
                                return var25_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            $this$filterNot$iv = (Iterable)v0;
                            var3_4 = this.this$0;
                            $i$f$filterNot = false;
                            var5_10 = $this$filterNot$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterNotTo = false;
                            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                p0 = (OfflineReaderEntity)element$iv$iv;
                                $i$a$-filterNot-DefaultOfflineRepository$getSavedLocationsMap$1$1$1 = false;
                                if (DefaultOfflineRepository.access$isExpired((DefaultOfflineRepository)var3_4, p0)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            var3_4 = DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0);
                            $i$f$map = false;
                            $this$filterNotTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                p0 = (OfflineReaderEntity)item$iv$iv;
                                var24_25 = destination$iv$iv;
                                $i$a$-map-DefaultOfflineRepository$getSavedLocationsMap$1$1$2 = false;
                                var24_25.add((OfflineReader)var3_4.decrypt((OfflineEntity)p0));
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$filter = false;
                            $i$f$map = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (OfflineReader)element$iv$iv;
                                $i$a$-filter-DefaultOfflineRepository$getSavedLocationsMap$1$1$3 = false;
                                v1 = it.reader_offline_config;
                                v2 = v1 != null ? v1.enabled : false;
                                if (!v2) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$mapNotNull$iv = (List)destination$iv$iv;
                            var3_6 = this.this$0;
                            $i$f$mapNotNull = false;
                            destination$iv$iv = $this$mapNotNull$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$mapNotNullTo = false;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = false;
                            var10_22 = $this$forEach$iv$iv$iv.iterator();
lbl62:
                            // 3 sources

                            while (var10_22.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = var10_22.next();
                                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                offlineReader = (OfflineReader)element$iv$iv;
                                $i$a$-mapNotNull-DefaultOfflineRepository$getSavedLocationsMap$1$1$4 = false;
                                this.L$0 = var3_6;
                                this.L$1 = destination$iv$iv;
                                this.L$2 = var10_22;
                                this.L$3 = offlineReader;
                                this.label = 2;
                                v3 = DefaultOfflineRepository.access$getOfflineConnectionDao$p(var3_6).getMostRecentConnectionForReader(offlineReader.id, (Continuation<? super OfflineConnectionEntity>)this);
                                if (v3 == var25_2) {
                                    return var25_2;
                                }
                                ** GOTO lbl89
                            }
                            break;
                        }
                        case 2: {
                            $i$f$mapNotNull = false;
                            $i$f$mapNotNullTo = false;
                            $i$f$forEach = false;
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            $i$a$-mapNotNull-DefaultOfflineRepository$getSavedLocationsMap$1$1$4 = false;
                            offlineReader = (OfflineReader)this.L$3;
                            var10_22 = (Iterator<T>)this.L$2;
                            destination$iv$iv = (Collection)this.L$1;
                            var3_6 = (DefaultOfflineRepository)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl89:
                            // 2 sources

                            if ((var16_30 = (OfflineConnectionEntity)v3) == null) ** GOTO lbl-1000
                            var17_31 /* !! */  = var16_30;
                            var18_32 = DefaultOfflineRepository.access$getOfflineConnectionCipher$p(var3_6);
                            p0 /* !! */  = var17_31 /* !! */ ;
                            $i$a$-let-DefaultOfflineRepository$getSavedLocationsMap$1$1$4$1 = false;
                            var21_35 = (OfflineConnection)var18_32.decrypt((OfflineEntity)p0 /* !! */ );
                            if (var21_35 == null) ** GOTO lbl-1000
                            p0 /* !! */  = var21_35;
                            $i$a$-let-DefaultOfflineRepository$getSavedLocationsMap$1$1$4$2 = false;
                            var17_31 /* !! */  = p0 /* !! */ .location;
                            if (var17_31 /* !! */  != null) {
                                location /* !! */  = var17_31 /* !! */ ;
                                $i$a$-let-DefaultOfflineRepository$getSavedLocationsMap$1$1$4$3 = false;
                                v4 = TuplesKt.to((Object)offlineReader.serial_number, (Object)location /* !! */ );
                            } else lbl-1000:
                            // 3 sources

                            {
                                v4 = null;
                            }
                            if (v4 == null) ** GOTO lbl62
                            it$iv$iv = v4;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                            ** GOTO lbl62
                        }
                    }
                    return MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Map<String, ApiLocationPb>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOfflineEnabledForReader(@NotNull String readerSerial, @NotNull String accountId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)readerSerial, (String)"readerSerial");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage$iv = "Failed to get offline reader.";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl2 = false;
            bl = (Boolean)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, readerSerial, accountId, null){
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $readerSerial;
                final /* synthetic */ String $accountId;
                {
                    this.this$0 = $receiver;
                    this.$readerSerial = $readerSerial;
                    this.$accountId = $accountId;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DefaultOfflineRepository.access$getOfflineReaderDao$p(this.this$0).getBySerialAndAccount(this.$readerSerial, this.$accountId, (Continuation<? super OfflineReaderEntity>)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = (OfflineReaderEntity)v0;
                            if (v1 == null) {
                                return Boxing.boxBoolean((boolean)true);
                            }
                            var2_3 = v1;
                            var3_4 = DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0);
                            p0 = var2_3;
                            $i$a$-let-DefaultOfflineRepository$isOfflineEnabledForReader$1$1$1 = false;
                            v2 = ((OfflineReader)var3_4.decrypt((OfflineEntity)p0)).reader_offline_config;
                            return Boxing.boxBoolean((boolean)(v2 != null ? v2.enabled : false));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl3 = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public StateFlow<OfflineConfigPb.ReaderOfflineConfigPb> activeReaderOfflineConfigFlow() {
        return this.activeReaderConfigFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreSoftDeletedPayments(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        String errorMessage$iv = "Failed to restore deleted payments";
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            boolean bl = false;
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accountId, null){
                int label;
                final /* synthetic */ DefaultOfflineRepository this$0;
                final /* synthetic */ String $accountId;
                {
                    this.this$0 = $receiver;
                    this.$accountId = $accountId;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DefaultOfflineRepository.access$getOfflinePaymentIntentRequestDao$p(this.this$0).restoreSoftDeletedPayments(this.$accountId, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            this.logError(e$iv, errorMessage$iv);
            Throwable throwable = e$iv;
            if (throwable instanceof TerminalException) {
                throw e$iv;
            }
            TerminalException.TerminalErrorCode errorCode$iv = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode$iv, errorMessage$iv, e$iv, null, 8, null);
        }
        finally {
            boolean bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object deleteExpiredEntities(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof deleteExpiredEntities.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteExpiredEntities(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage$iv = "Failed to delete expired entities";
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$deleteExpiredEntities$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = accountId;
                $continuation.L$2 = errorMessage$iv;
                $continuation.label = 1;
                v0 = this.offlinePaymentIntentRequestDao.deleteOrphanedPayments(accountId, new Date(this.clock.currentTimeMillis() - 2592000000L), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var15_5) goto lbl25
lbl24:
                // 1 sources

                return var15_5;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$deleteExpiredEntities$2 = false;
                errorMessage$iv = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                $this$deleteExpiredEntities_u24lambda_u2451_u24lambda_u2450 = var6_14 = (Set)new LinkedHashSet<E>();
                $i$a$-apply-DefaultOfflineRepository$deleteExpiredEntities$2$connectionIdsToRetain$1 = false;
                var9_20 = $this$deleteExpiredEntities_u24lambda_u2451_u24lambda_u2450;
                $continuation.L$0 = this;
                $continuation.L$1 = accountId;
                $continuation.L$2 = errorMessage$iv;
                $continuation.L$3 = var6_14;
                $continuation.L$4 = $this$deleteExpiredEntities_u24lambda_u2451_u24lambda_u2450;
                $continuation.L$5 = var9_20;
                $continuation.label = 2;
                v1 = this.offlinePaymentIntentRequestDao.getConnectionIds(accountId, (Continuation<? super List<Long>>)$continuation);
                ** if (v1 != var15_5) goto lbl49
lbl48:
                // 1 sources

                return var15_5;
lbl49:
                // 1 sources

                ** GOTO lbl64
            }
            case 2: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$deleteExpiredEntities$2 = false;
                $i$a$-apply-DefaultOfflineRepository$deleteExpiredEntities$2$connectionIdsToRetain$1 = false;
                var9_20 = (Set)$continuation.L$5;
                $this$deleteExpiredEntities_u24lambda_u2451_u24lambda_u2450 = (Set)$continuation.L$4;
                var6_14 = (Set)$continuation.L$3;
                errorMessage$iv = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl64:
                // 2 sources

                var9_20.addAll((Collection)v1);
                var9_20 = $this$deleteExpiredEntities_u24lambda_u2451_u24lambda_u2450;
                $continuation.L$0 = this;
                $continuation.L$1 = accountId;
                $continuation.L$2 = errorMessage$iv;
                $continuation.L$3 = var6_14;
                $continuation.L$4 = var9_20;
                $continuation.L$5 = null;
                $continuation.label = 3;
                v2 = this.offlineConnectionDao.getMostRecentConnectionIdForEachReader(accountId, (Continuation<? super List<Long>>)$continuation);
                ** if (v2 != var15_5) goto lbl77
lbl76:
                // 1 sources

                return var15_5;
lbl77:
                // 1 sources

                ** GOTO lbl91
            }
            case 3: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$deleteExpiredEntities$2 = false;
                $i$a$-apply-DefaultOfflineRepository$deleteExpiredEntities$2$connectionIdsToRetain$1 = false;
                var9_20 = (Set)$continuation.L$4;
                var6_14 = (Set)$continuation.L$3;
                errorMessage$iv = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl91:
                // 2 sources

                var9_20.addAll((Collection)v2);
                connectionIdsToRetain = var6_14;
                $continuation.L$0 = this;
                $continuation.L$1 = errorMessage$iv;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 4;
                v3 = this.offlineConnectionDao.retainByIds(accountId, (Set<Long>)connectionIdsToRetain, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var15_5) goto lbl104
lbl103:
                // 1 sources

                return var15_5;
lbl104:
                // 1 sources

                ** GOTO lbl114
            }
            case 4: {
                $i$f$wrapErrorsAsTerminalException = false;
                $i$a$-wrapErrorsAsTerminalException$default-DefaultOfflineRepository$deleteExpiredEntities$2 = false;
                errorMessage$iv = (String)$continuation.L$1;
                this = (DefaultOfflineRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl114:
                    // 2 sources

                    var11_22 = Unit.INSTANCE;
                    ** GOTO lbl129
                }
                catch (Throwable e$iv) {
                    DefaultOfflineRepository.access$logError(this, e$iv, errorMessage$iv);
                    var6_14 = e$iv;
                    if (var6_14 instanceof TerminalException) {
                        throw e$iv;
                    }
                    errorCode$iv = var6_14 instanceof SQLiteFullException != false ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
                    throw new TerminalException(errorCode$iv, (String)var3_6, e$iv, null, 8, null);
                }
            }
            catch (Throwable var12_24) {
                throw var12_24;
            }
            {
                finally {
                    $i$a$-wrapErrorsAsTerminalException-DefaultOfflineRepository$wrapErrorsAsTerminalException$1 = false;
                }
lbl129:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getActiveReaderConfigFlow(Long var1_1, Continuation<? super Flow<OfflineConfigPb.ReaderOfflineConfigPb>> var2_2) {
        if (!(var2_2 instanceof getActiveReaderConfigFlow.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultOfflineRepository.access$getActiveReaderConfigFlow(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (offlineConnectionId == null) ** GOTO lbl-1000
                it = ((Number)var1_1).longValue();
                $i$a$-let-DefaultOfflineRepository$getActiveReaderConfigFlow$2 = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.offlineConnectionDao.getById(it, (Continuation<? super OfflineConnectionEntity>)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                $i$a$-let-DefaultOfflineRepository$getActiveReaderConfigFlow$2 = false;
                this = (DefaultOfflineRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                var3_10 = (OfflineConnectionEntity)v0;
                if (var3_10 == null) ** GOTO lbl-1000
                it = var3_10;
                $i$a$-let-DefaultOfflineRepository$getActiveReaderConfigFlow$3 = false;
                var4_12 = this.offlineReaderDao.getByIdFlow(it.getReaderId());
                if (var4_12 == null || (var5_7 = FlowKt.distinctUntilChanged(var4_12)) == null) ** GOTO lbl-1000
                $this$map$iv = var5_7;
                $i$f$map = false;
                $this$unsafeTransform$iv$iv = $this$map$iv;
                $i$f$unsafeTransform = false;
                $i$f$unsafeFlow = false;
                var7_9 = FlowKt.catch((Flow)((Flow)new Flow<OfflineConfigPb.ReaderOfflineConfigPb>($this$unsafeTransform$iv$iv, this){
                    final /* synthetic */ Flow $this_unsafeTransform$inlined;
                    final /* synthetic */ DefaultOfflineRepository this$0;
                    {
                        this.$this_unsafeTransform$inlined = flow;
                        this.this$0 = defaultOfflineRepository;
                    }

                    @Nullable
                    public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                        Continuation continuation = $completion;
                        FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                        boolean bl = false;
                        Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0){
                            final /* synthetic */ FlowCollector $this_unsafeFlow;
                            final /* synthetic */ DefaultOfflineRepository this$0;
                            {
                                this.$this_unsafeFlow = $receiver;
                                this.this$0 = defaultOfflineRepository;
                            }

                            /*
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            @Nullable
                            public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                if (!(var2_2 instanceof getActiveReaderConfigFlow$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                var3_3 = var2_2;
                                if ((var3_3.label & -2147483648) != 0) {
                                    var3_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, var2_2){
                                        /* synthetic */ Object result;
                                        int label;
                                        Object L$0;
                                        final /* synthetic */ getActiveReaderConfigFlow$$inlined$map$1$2 this$0;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation)this);
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var6_6 = value;
                                        $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                        $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                        var9_10 = $this$map_u24lambda_u245;
                                        (Continuation)$continuation;
                                        it = (OfflineReaderEntity)value;
                                        $i$a$-map-DefaultOfflineRepository$getActiveReaderConfigFlow$4 = false;
                                        v0 /* !! */  = it;
                                        if (v0 /* !! */  == null) ** GOTO lbl30
                                        var12_13 = v0 /* !! */ ;
                                        var13_14 = DefaultOfflineRepository.access$getOfflineReaderCipher$p(this.this$0);
                                        p0 = var12_13;
                                        $i$a$-let-DefaultOfflineRepository$getActiveReaderConfigFlow$4$1 = false;
                                        v1 = (OfflineReader)var13_14.decrypt((OfflineEntity)p0);
                                        v0 /* !! */  = v1;
                                        if (v1 != null && (v0 /* !! */  = v0 /* !! */ .reader_offline_config) != null) ** GOTO lbl31
lbl30:
                                        // 2 sources

                                        v0 /* !! */  = DefaultOfflineRepository.access$getDefaultOfflineReaderConfig$p(this.this$0);
lbl31:
                                        // 2 sources

                                        $continuation.label = 1;
                                        v2 = var9_10.emit((Object)v0 /* !! */ , (Continuation)$continuation);
                                        if (v2 == var5_5) {
                                            return var5_5;
                                        }
                                        ** GOTO lbl40
                                    }
                                    case 1: {
                                        $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl40:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }
                }), (Function3)((Function3)new Function3<FlowCollector<? super OfflineConfigPb.ReaderOfflineConfigPb>, Throwable, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;
                    final /* synthetic */ DefaultOfflineRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(3, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                FlowCollector $this$catch = (FlowCollector)this.L$0;
                                Throwable error = (Throwable)this.L$1;
                                DefaultOfflineRepository.access$getLogger$p(this.this$0).w(error, "Failed to get active reader offline config.", new Pair[0]);
                                this.L$0 = null;
                                this.label = 1;
                                Object object3 = $this$catch.emit((Object)((Object)DefaultOfflineRepository.access$getDefaultOfflineReaderConfig$p(this.this$0)), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super OfflineConfigPb.ReaderOfflineConfigPb> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                        Function3<FlowCollector<? super OfflineConfigPb.ReaderOfflineConfigPb>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p1;
                        function3.L$1 = p2;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                }));
                if (var7_9 != null) {
                    v1 = var7_9;
                } else lbl-1000:
                // 4 sources

                {
                    v1 = FlowKt.flowOf((Object)this.defaultOfflineReaderConfig);
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isExpired(OfflineReaderEntity offlineReaderEntity) {
        Date expiryDate = new Date(this.clock.currentTimeMillis() - 7776000000L);
        return offlineReaderEntity.getLastActivatedAt().before(expiryDate);
    }

    private final Object hasMoreRelatedPayments(OfflinePaymentIntentRequestEntity $this$hasMoreRelatedPayments, Continuation<? super Boolean> $completion) {
        if (WhenMappings.$EnumSwitchMapping$0[$this$hasMoreRelatedPayments.getType().ordinal()] != 1) {
            return this.offlinePaymentIntentRequestDao.hasMorePaymentsAfter($this$hasMoreRelatedPayments.getPaymentId(), $this$hasMoreRelatedPayments.getId(), $this$hasMoreRelatedPayments.getAccountId(), $completion);
        }
        return Boxing.boxBoolean((boolean)false);
    }

    /*
     * Unable to fully structure code
     */
    private final Object validatePendingCreateRequirement(OfflinePaymentIntentRequest var1_1, Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof validatePendingCreateRequirement.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ DefaultOfflineRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultOfflineRepository.access$validatePendingCreateRequirement(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = $this$validatePendingCreateRequirement.payment_intent_id;
                if (!(var3_6 == null || var3_6.length() == 0) || (var3_6 = (CharSequence)$this$validatePendingCreateRequirement.offline_id) == null || var3_6.length() == 0 || $this$validatePendingCreateRequirement.type != OfflinePaymentIntentRequest.PaymentIntentRequestType.PROCESS_PAYMENT_INTENT) ** GOTO lbl-1000
                v0 = $this$validatePendingCreateRequirement.offline_id;
                Intrinsics.checkNotNull((Object)v0);
                $continuation.label = 1;
                v1 = this.offlinePaymentIntentRequestDao.getByOfflineIdAndType(v0, OfflinePaymentIntentRequest.PaymentIntentRequestType.CREATE_PAYMENT_INTENT, (Continuation<? super OfflinePaymentIntentRequestEntity>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl24:
                // 2 sources

                if (!((var3_6 = (OfflinePaymentIntentRequestEntity)v1) != null ? !var3_6.getDeleted() : false)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                return Boxing.boxBoolean((boolean)v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final /* synthetic */ <T> T wrapErrorsAsTerminalException(String errorMessage, Function0<Unit> doFinally, Function0<? extends T> block) {
        Object object;
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            object = block.invoke();
        }
        catch (Throwable e2) {
            this.logError(e2, errorMessage);
            Throwable throwable = e2;
            if (throwable instanceof TerminalException) {
                throw e2;
            }
            TerminalException.TerminalErrorCode errorCode = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode, errorMessage, e2, null, 8, null);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            doFinally.invoke();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object wrapErrorsAsTerminalException$default(DefaultOfflineRepository $this, String errorMessage, Function0 doFinally, Function0 block, int n2, Object object) {
        if ((n2 & 2) != 0) {
            doFinally = wrapErrorsAsTerminalException.1.INSTANCE;
        }
        boolean $i$f$wrapErrorsAsTerminalException = false;
        try {
            object = block.invoke();
        }
        catch (Throwable e2) {
            $this.logError(e2, errorMessage);
            Throwable throwable = e2;
            if (throwable instanceof TerminalException) {
                throw e2;
            }
            TerminalException.TerminalErrorCode errorCode = throwable instanceof SQLiteFullException ? TerminalException.TerminalErrorCode.OFFLINE_PAYMENTS_DATABASE_TOO_LARGE : TerminalException.TerminalErrorCode.UNEXPECTED_SDK_ERROR;
            throw new TerminalException(errorCode, errorMessage, e2, null, 8, null);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            doFinally.invoke();
            InlineMarker.finallyEnd((int)1);
        }
        return object;
    }

    private final void logError(Throwable error, String errorMessage) {
        Throwable throwable = error;
        if (throwable instanceof OfflineDataMismatchException) {
            HealthLogger.incrementCounter$default(this.discreteLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Table", (Object)((OfflineDataMismatchException)error).getTable())), null, logError.1.INSTANCE, 5, null);
        } else if (throwable instanceof OfflineDecryptionException) {
            HealthLogger.incrementCounter$default(this.discreteLogger, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Table", (Object)((OfflineDecryptionException)error).getTable())), null, logError.2.INSTANCE, 5, null);
        } else if (throwable instanceof SQLException) {
            HealthLogger.incrementCounter$default(this.discreteLogger, null, null, null, logError.3.INSTANCE, 7, null);
        }
        this.logger.e("DefaultOfflineRepository Error:: " + errorMessage, error, new Pair[0]);
    }

    public static final /* synthetic */ Object access$getOfflineConnectionAndReaderForPaymentRequest(DefaultOfflineRepository $this, OfflinePaymentIntentRequestEntity offlinePIREntity, long mostRecentRowId, Continuation $completion) {
        return $this.getOfflineConnectionAndReaderForPaymentRequest(offlinePIREntity, mostRecentRowId, (Continuation<? super ForwardOfflinePaymentRequest>)$completion);
    }

    public static final /* synthetic */ Object access$getActiveReaderConfigFlow(DefaultOfflineRepository $this, Long offlineConnectionId, Continuation $completion) {
        return $this.getActiveReaderConfigFlow(offlineConnectionId, (Continuation<? super Flow<OfflineConfigPb.ReaderOfflineConfigPb>>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultOfflineRepository $this) {
        return $this.logger;
    }

    public static final /* synthetic */ OfflineConfigPb.ReaderOfflineConfigPb access$getDefaultOfflineReaderConfig$p(DefaultOfflineRepository $this) {
        return $this.defaultOfflineReaderConfig;
    }

    public static final /* synthetic */ Object access$hasMoreRelatedPayments(DefaultOfflineRepository $this, OfflinePaymentIntentRequestEntity $receiver, Continuation $completion) {
        return $this.hasMoreRelatedPayments($receiver, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$validatePendingCreateRequirement(DefaultOfflineRepository $this, OfflinePaymentIntentRequest $receiver, Continuation $completion) {
        return $this.validatePendingCreateRequirement($receiver, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ OfflineReaderDao access$getOfflineReaderDao$p(DefaultOfflineRepository $this) {
        return $this.offlineReaderDao;
    }

    public static final /* synthetic */ OfflineReaderCipher access$getOfflineReaderCipher$p(DefaultOfflineRepository $this) {
        return $this.offlineReaderCipher;
    }

    public static final /* synthetic */ OfflineConnectionCipher access$getOfflineConnectionCipher$p(DefaultOfflineRepository $this) {
        return $this.offlineConnectionCipher;
    }

    public static final /* synthetic */ OfflineConnectionDao access$getOfflineConnectionDao$p(DefaultOfflineRepository $this) {
        return $this.offlineConnectionDao;
    }

    public static final /* synthetic */ OfflinePaymentIntentRequestDao access$getOfflinePaymentIntentRequestDao$p(DefaultOfflineRepository $this) {
        return $this.offlinePaymentIntentRequestDao;
    }

    public static final /* synthetic */ OfflinePaymentIntentRequestCipher access$getOfflinePaymentIntentRequestCipher$p(DefaultOfflineRepository $this) {
        return $this.offlinePaymentIntentRequestCipher;
    }

    public static final /* synthetic */ boolean access$isExpired(DefaultOfflineRepository $this, OfflineReaderEntity offlineReaderEntity) {
        return $this.isExpired(offlineReaderEntity);
    }

    public static final /* synthetic */ CoroutineDispatcher access$getDispatcher$p(DefaultOfflineRepository $this) {
        return $this.dispatcher;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OfflinePaymentIntentRequest.PaymentIntentRequestType.values().length];
            try {
                nArray[OfflinePaymentIntentRequest.PaymentIntentRequestType.PROCESS_PAYMENT_INTENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

