/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.stripe.offlinemode.storage.DateTimeConverter;
import com.stripe.offlinemode.storage.OfflineConnectionDao;
import com.stripe.offlinemode.storage.OfflineConnectionEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class OfflineConnectionDao_Impl
implements OfflineConnectionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OfflineConnectionEntity> __insertionAdapterOfOfflineConnectionEntity;
    private final DateTimeConverter __dateTimeConverter = new DateTimeConverter();
    private final EntityDeletionOrUpdateAdapter<OfflineConnectionEntity> __deletionAdapterOfOfflineConnectionEntity;
    private final EntityDeletionOrUpdateAdapter<OfflineConnectionEntity> __updateAdapterOfOfflineConnectionEntity;

    public OfflineConnectionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOfflineConnectionEntity = new EntityInsertionAdapter<OfflineConnectionEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `offline_connection` (`reader_id`,`account_id`,`data_blob`,`iv_blob`,`created_timestamp`,`id`) VALUES (?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, OfflineConnectionEntity value) {
                stmt.bindLong(1, value.getReaderId());
                if (value.getAccountId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getAccountId());
                }
                if (value.getEncryptedData() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindBlob(3, value.getEncryptedData());
                }
                if (value.getEncryptionIv() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindBlob(4, value.getEncryptionIv());
                }
                long _tmp = OfflineConnectionDao_Impl.this.__dateTimeConverter.toTimeMs(value.getCreated());
                stmt.bindLong(5, _tmp);
                stmt.bindLong(6, value.getId());
            }
        };
        this.__deletionAdapterOfOfflineConnectionEntity = new EntityDeletionOrUpdateAdapter<OfflineConnectionEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `offline_connection` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OfflineConnectionEntity value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfOfflineConnectionEntity = new EntityDeletionOrUpdateAdapter<OfflineConnectionEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `offline_connection` SET `reader_id` = ?,`account_id` = ?,`data_blob` = ?,`iv_blob` = ?,`created_timestamp` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OfflineConnectionEntity value) {
                stmt.bindLong(1, value.getReaderId());
                if (value.getAccountId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getAccountId());
                }
                if (value.getEncryptedData() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindBlob(3, value.getEncryptedData());
                }
                if (value.getEncryptionIv() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindBlob(4, value.getEncryptionIv());
                }
                long _tmp = OfflineConnectionDao_Impl.this.__dateTimeConverter.toTimeMs(value.getCreated());
                stmt.bindLong(5, _tmp);
                stmt.bindLong(6, value.getId());
                stmt.bindLong(7, value.getId());
            }
        };
    }

    @Override
    public Object insert(final OfflineConnectionEntity entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                OfflineConnectionDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = OfflineConnectionDao_Impl.this.__insertionAdapterOfOfflineConnectionEntity.insertAndReturnId((Object)entity);
                    OfflineConnectionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l2 = _result;
                    return l2;
                }
                finally {
                    OfflineConnectionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertAll(final OfflineConnectionEntity[] entity, Continuation<? super List<Long>> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<List<Long>>(){

            @Override
            public List<Long> call() throws Exception {
                OfflineConnectionDao_Impl.this.__db.beginTransaction();
                try {
                    List _result = OfflineConnectionDao_Impl.this.__insertionAdapterOfOfflineConnectionEntity.insertAndReturnIdsList((Object[])entity);
                    OfflineConnectionDao_Impl.this.__db.setTransactionSuccessful();
                    List list = _result;
                    return list;
                }
                finally {
                    OfflineConnectionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object delete(final OfflineConnectionEntity entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OfflineConnectionDao_Impl.this.__db.beginTransaction();
                try {
                    OfflineConnectionDao_Impl.this.__deletionAdapterOfOfflineConnectionEntity.handle((Object)entity);
                    OfflineConnectionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflineConnectionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object update(final OfflineConnectionEntity entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OfflineConnectionDao_Impl.this.__db.beginTransaction();
                try {
                    OfflineConnectionDao_Impl.this.__updateAdapterOfOfflineConnectionEntity.handle((Object)entity);
                    OfflineConnectionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflineConnectionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<OfflineConnectionEntity>> getByAccountId(String accountId) {
        String _sql = "SELECT * FROM offline_connection WHERE account_id = ? ORDER BY id";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM offline_connection WHERE account_id = ? ORDER BY id", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"offline_connection"}, (Callable)new Callable<List<OfflineConnectionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflineConnectionEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflineConnectionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfReaderId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reader_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflineConnectionEntity> _result = new ArrayList<OfflineConnectionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpReaderId = _cursor.getLong(_cursorIndexOfReaderId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineConnectionDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflineConnectionEntity _item = new OfflineConnectionEntity(_tmpReaderId, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflineConnectionEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getAll(int limit, int offset, Continuation<? super List<OfflineConnectionEntity>> $completion) {
        String _sql = "SELECT * FROM offline_connection ORDER BY id LIMIT ? OFFSET ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM offline_connection ORDER BY id LIMIT ? OFFSET ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)offset);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<OfflineConnectionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<OfflineConnectionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineConnectionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfReaderId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reader_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    ArrayList<OfflineConnectionEntity> _result = new ArrayList<OfflineConnectionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpReaderId = _cursor.getLong(_cursorIndexOfReaderId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineConnectionDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        OfflineConnectionEntity _item = new OfflineConnectionEntity(_tmpReaderId, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                        _result.add(_item);
                    }
                    ArrayList<OfflineConnectionEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getById(long id, Continuation<? super OfflineConnectionEntity> $completion) {
        String _sql = "SELECT * FROM offline_connection WHERE id = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM offline_connection WHERE id = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<OfflineConnectionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflineConnectionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineConnectionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    OfflineConnectionEntity _result;
                    int _cursorIndexOfReaderId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reader_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        long _tmpReaderId = _cursor.getLong(_cursorIndexOfReaderId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineConnectionDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflineConnectionEntity(_tmpReaderId, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflineConnectionEntity offlineConnectionEntity = _result;
                    return offlineConnectionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getMostRecentConnectionForReader(long readerId, Continuation<? super OfflineConnectionEntity> $completion) {
        String _sql = "\n        WITH MostRecentId AS (SELECT MAX(id) FROM offline_connection WHERE reader_id = ?)\n        SELECT * FROM offline_connection WHERE id IN MostRecentId\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH MostRecentId AS (SELECT MAX(id) FROM offline_connection WHERE reader_id = ?)\n        SELECT * FROM offline_connection WHERE id IN MostRecentId\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, readerId);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<OfflineConnectionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OfflineConnectionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineConnectionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    OfflineConnectionEntity _result;
                    int _cursorIndexOfReaderId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reader_id");
                    int _cursorIndexOfAccountId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"account_id");
                    int _cursorIndexOfEncryptedData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data_blob");
                    int _cursorIndexOfEncryptionIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_blob");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created_timestamp");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        long _tmpReaderId = _cursor.getLong(_cursorIndexOfReaderId);
                        String _tmpAccountId = _cursor.isNull(_cursorIndexOfAccountId) ? null : _cursor.getString(_cursorIndexOfAccountId);
                        byte[] _tmpEncryptedData = _cursor.isNull(_cursorIndexOfEncryptedData) ? null : _cursor.getBlob(_cursorIndexOfEncryptedData);
                        byte[] _tmpEncryptionIv = _cursor.isNull(_cursorIndexOfEncryptionIv) ? null : _cursor.getBlob(_cursorIndexOfEncryptionIv);
                        long _tmp = _cursor.getLong(_cursorIndexOfCreated);
                        Date _tmpCreated = OfflineConnectionDao_Impl.this.__dateTimeConverter.toDate(_tmp);
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        _result = new OfflineConnectionEntity(_tmpReaderId, _tmpAccountId, _tmpEncryptedData, _tmpEncryptionIv, _tmpCreated, _tmpId);
                    } else {
                        _result = null;
                    }
                    OfflineConnectionEntity offlineConnectionEntity = _result;
                    return offlineConnectionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getMostRecentConnectionIdForEachReader(String accountId, Continuation<? super List<Long>> $completion) {
        String _sql = "SELECT MAX(id) FROM offline_connection WHERE account_id = ? GROUP BY reader_id";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT MAX(id) FROM offline_connection WHERE account_id = ? GROUP BY reader_id", (int)1);
        int _argIndex = 1;
        if (accountId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Long> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OfflineConnectionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Long> _result = new ArrayList<Long>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Long _tmp = _cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0));
                        Long _item = _tmp;
                        _result.add(_item);
                    }
                    ArrayList<Long> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object retainByIds(final String accountId, final Set<Long> idsToRetain, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM offline_connection WHERE account_id = ");
                _stringBuilder.append("?");
                _stringBuilder.append(" AND id NOT IN (");
                int _inputSize = idsToRetain.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = OfflineConnectionDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                if (accountId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accountId);
                }
                _argIndex = 2;
                for (Long _item : idsToRetain) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindLong(_argIndex, _item.longValue());
                    }
                    ++_argIndex;
                }
                OfflineConnectionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OfflineConnectionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OfflineConnectionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

