/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.stripe.offlinemode.storage.OfflineDbPathHelperKt;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lcom/stripe/offlinemode/storage/OfflineDatabasePathHelper;", "", "()V", "getDefaultDatabasePath", "Ljava/io/File;", "context", "Landroid/content/Context;", "getNoBackupPath", "migrateDatabase", "", "migrationPaths", "", "offlinemode_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nOfflineDbPathHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineDbPathHelper.kt\ncom/stripe/offlinemode/storage/OfflineDatabasePathHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,102:1\n215#2,2:103\n8676#3,2:105\n9358#3,4:107\n*S KotlinDebug\n*F\n+ 1 OfflineDbPathHelper.kt\ncom/stripe/offlinemode/storage/OfflineDatabasePathHelper\n*L\n48#1:103,2\n77#1:105,2\n77#1:107,4\n*E\n"})
public final class OfflineDatabasePathHelper {
    @NotNull
    public static final OfflineDatabasePathHelper INSTANCE = new OfflineDatabasePathHelper();

    private OfflineDatabasePathHelper() {
    }

    @JvmStatic
    public static final void migrateDatabase(@NotNull Context context) {
        block5: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object2 = INSTANCE;
            try {
                OfflineDatabasePathHelper $this$migrateDatabase_u24lambda_u241 = object2;
                boolean bl = false;
                File defaultDatabasePath = $this$migrateDatabase_u24lambda_u241.getDefaultDatabasePath(context);
                if (defaultDatabasePath.exists()) {
                    OfflineDbPathHelperKt.access$getLogger$p().d("Migrating OfflineDatabase to the no-backup directory", new Pair[0]);
                    Map<File, File> $this$forEach$iv = $this$migrateDatabase_u24lambda_u241.migrationPaths(context);
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<File, File>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        boolean renamed;
                        Map.Entry<File, File> element$iv;
                        Map.Entry<File, File> entry = element$iv = iterator.next();
                        boolean bl2 = false;
                        File source = entry.getKey();
                        File destination = entry.getValue();
                        if (!source.exists()) continue;
                        if (destination.exists()) {
                            OfflineDbPathHelperKt.access$getLogger$p().w("Over-writing contents of " + destination, new Pair[0]);
                        }
                        String message = (renamed = source.renameTo(destination)) ? "Migrated " + source + " to " + destination : "Renaming " + source + " to " + destination + " failed";
                        OfflineDbPathHelperKt.access$getLogger$p().d(message, new Pair[0]);
                    }
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block5;
            Object e2 = object = throwable;
            boolean bl = false;
            OfflineDbPathHelperKt.access$getLogger$p().e("Unexpected error during offline db migration", (Throwable)e2, new Pair[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, File> migrationPaths(Context context) {
        void $this$associateTo$iv$iv;
        File databasePath = this.getDefaultDatabasePath(context);
        File migratedPath = this.getNoBackupPath(context);
        String[] $this$associate$iv = OfflineDbPathHelperKt.getDATABASE_EXTRA_FILES();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        String[] stringArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            void extra = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)new File(databasePath.getPath() + (String)extra), (Object)new File(migratedPath.getPath() + (String)extra));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        return MapsKt.plus((Map)map3, (Pair)TuplesKt.to((Object)databasePath, (Object)migratedPath));
    }

    private final File getDefaultDatabasePath(Context context) {
        File file = context.getDatabasePath("stripe_offline_db");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDatabasePath(OFFLINE_DATABASE_NAME)");
        return file;
    }

    private final File getNoBackupPath(Context context) {
        return new File(context.getNoBackupFilesDir(), "stripe_offline_db");
    }
}

