/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.offlinemode.storage;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.stripe.offlinemode.storage.OfflineConnectionDao;
import com.stripe.offlinemode.storage.OfflineConnectionDao_Impl;
import com.stripe.offlinemode.storage.OfflineDatabase;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestDao;
import com.stripe.offlinemode.storage.OfflinePaymentIntentRequestDao_Impl;
import com.stripe.offlinemode.storage.OfflineReaderDao;
import com.stripe.offlinemode.storage.OfflineReaderDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OfflineDatabase_Impl
extends OfflineDatabase {
    private volatile OfflineReaderDao _offlineReaderDao;
    private volatile OfflineConnectionDao _offlineConnectionDao;
    private volatile OfflinePaymentIntentRequestDao _offlinePaymentIntentRequestDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `reader` (`serial_number` TEXT NOT NULL, `last_activated_timestamp` INTEGER NOT NULL, `created_timestamp` INTEGER NOT NULL, `account_id` TEXT NOT NULL, `data_blob` BLOB NOT NULL, `iv_blob` BLOB NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_reader_serial_number_account_id` ON `reader` (`serial_number`, `account_id`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_reader_serial_number` ON `reader` (`serial_number`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `offline_connection` (`reader_id` INTEGER NOT NULL, `account_id` TEXT NOT NULL, `data_blob` BLOB NOT NULL, `iv_blob` BLOB NOT NULL, `created_timestamp` INTEGER NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, FOREIGN KEY(`reader_id`) REFERENCES `reader`(`id`) ON UPDATE NO ACTION ON DELETE RESTRICT )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_offline_connection_reader_id` ON `offline_connection` (`reader_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `offline_payment_intent` (`offline_id` TEXT, `connection_id` INTEGER NOT NULL, `payment_intent_id` TEXT, `account_id` TEXT NOT NULL, `type` TEXT NOT NULL, `deleted` INTEGER NOT NULL, `data_blob` BLOB NOT NULL, `iv_blob` BLOB NOT NULL, `created_timestamp` INTEGER NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, FOREIGN KEY(`connection_id`) REFERENCES `offline_connection`(`id`) ON UPDATE NO ACTION ON DELETE RESTRICT )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_offline_payment_intent_offline_id` ON `offline_payment_intent` (`offline_id`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_offline_payment_intent_connection_id` ON `offline_payment_intent` (`connection_id`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_offline_payment_intent_payment_intent_id` ON `offline_payment_intent` (`payment_intent_id`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_offline_payment_intent_account_id` ON `offline_payment_intent` (`account_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'd4c6aeb67a02e761eba0f7ed268955a3')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `reader`");
                _db.execSQL("DROP TABLE IF EXISTS `offline_connection`");
                _db.execSQL("DROP TABLE IF EXISTS `offline_payment_intent`");
                if (OfflineDatabase_Impl.this.mCallbacks != null) {
                    int _size = OfflineDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)OfflineDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (OfflineDatabase_Impl.this.mCallbacks != null) {
                    int _size = OfflineDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)OfflineDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                OfflineDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                OfflineDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (OfflineDatabase_Impl.this.mCallbacks != null) {
                    int _size = OfflineDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)OfflineDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsReader = new HashMap<String, TableInfo.Column>(7);
                _columnsReader.put("serial_number", new TableInfo.Column("serial_number", "TEXT", true, 0, null, 1));
                _columnsReader.put("last_activated_timestamp", new TableInfo.Column("last_activated_timestamp", "INTEGER", true, 0, null, 1));
                _columnsReader.put("created_timestamp", new TableInfo.Column("created_timestamp", "INTEGER", true, 0, null, 1));
                _columnsReader.put("account_id", new TableInfo.Column("account_id", "TEXT", true, 0, null, 1));
                _columnsReader.put("data_blob", new TableInfo.Column("data_blob", "BLOB", true, 0, null, 1));
                _columnsReader.put("iv_blob", new TableInfo.Column("iv_blob", "BLOB", true, 0, null, 1));
                _columnsReader.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysReader = new HashSet(0);
                HashSet<TableInfo.Index> _indicesReader = new HashSet<TableInfo.Index>(2);
                _indicesReader.add(new TableInfo.Index("index_reader_serial_number_account_id", true, Arrays.asList("serial_number", "account_id"), Arrays.asList("ASC", "ASC")));
                _indicesReader.add(new TableInfo.Index("index_reader_serial_number", false, Arrays.asList("serial_number"), Arrays.asList("ASC")));
                TableInfo _infoReader = new TableInfo("reader", _columnsReader, _foreignKeysReader, _indicesReader);
                TableInfo _existingReader = TableInfo.read((SupportSQLiteDatabase)_db, (String)"reader");
                if (!_infoReader.equals((Object)_existingReader)) {
                    return new RoomOpenHelper.ValidationResult(false, "reader(com.stripe.offlinemode.storage.OfflineReaderEntity).\n Expected:\n" + _infoReader + "\n Found:\n" + _existingReader);
                }
                HashMap<String, TableInfo.Column> _columnsOfflineConnection = new HashMap<String, TableInfo.Column>(6);
                _columnsOfflineConnection.put("reader_id", new TableInfo.Column("reader_id", "INTEGER", true, 0, null, 1));
                _columnsOfflineConnection.put("account_id", new TableInfo.Column("account_id", "TEXT", true, 0, null, 1));
                _columnsOfflineConnection.put("data_blob", new TableInfo.Column("data_blob", "BLOB", true, 0, null, 1));
                _columnsOfflineConnection.put("iv_blob", new TableInfo.Column("iv_blob", "BLOB", true, 0, null, 1));
                _columnsOfflineConnection.put("created_timestamp", new TableInfo.Column("created_timestamp", "INTEGER", true, 0, null, 1));
                _columnsOfflineConnection.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysOfflineConnection = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysOfflineConnection.add(new TableInfo.ForeignKey("reader", "RESTRICT", "NO ACTION", Arrays.asList("reader_id"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesOfflineConnection = new HashSet<TableInfo.Index>(1);
                _indicesOfflineConnection.add(new TableInfo.Index("index_offline_connection_reader_id", false, Arrays.asList("reader_id"), Arrays.asList("ASC")));
                TableInfo _infoOfflineConnection = new TableInfo("offline_connection", _columnsOfflineConnection, _foreignKeysOfflineConnection, _indicesOfflineConnection);
                TableInfo _existingOfflineConnection = TableInfo.read((SupportSQLiteDatabase)_db, (String)"offline_connection");
                if (!_infoOfflineConnection.equals((Object)_existingOfflineConnection)) {
                    return new RoomOpenHelper.ValidationResult(false, "offline_connection(com.stripe.offlinemode.storage.OfflineConnectionEntity).\n Expected:\n" + _infoOfflineConnection + "\n Found:\n" + _existingOfflineConnection);
                }
                HashMap<String, TableInfo.Column> _columnsOfflinePaymentIntent = new HashMap<String, TableInfo.Column>(10);
                _columnsOfflinePaymentIntent.put("offline_id", new TableInfo.Column("offline_id", "TEXT", false, 0, null, 1));
                _columnsOfflinePaymentIntent.put("connection_id", new TableInfo.Column("connection_id", "INTEGER", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("payment_intent_id", new TableInfo.Column("payment_intent_id", "TEXT", false, 0, null, 1));
                _columnsOfflinePaymentIntent.put("account_id", new TableInfo.Column("account_id", "TEXT", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("deleted", new TableInfo.Column("deleted", "INTEGER", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("data_blob", new TableInfo.Column("data_blob", "BLOB", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("iv_blob", new TableInfo.Column("iv_blob", "BLOB", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("created_timestamp", new TableInfo.Column("created_timestamp", "INTEGER", true, 0, null, 1));
                _columnsOfflinePaymentIntent.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysOfflinePaymentIntent = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysOfflinePaymentIntent.add(new TableInfo.ForeignKey("offline_connection", "RESTRICT", "NO ACTION", Arrays.asList("connection_id"), Arrays.asList("id")));
                HashSet<TableInfo.Index> _indicesOfflinePaymentIntent = new HashSet<TableInfo.Index>(4);
                _indicesOfflinePaymentIntent.add(new TableInfo.Index("index_offline_payment_intent_offline_id", false, Arrays.asList("offline_id"), Arrays.asList("ASC")));
                _indicesOfflinePaymentIntent.add(new TableInfo.Index("index_offline_payment_intent_connection_id", false, Arrays.asList("connection_id"), Arrays.asList("ASC")));
                _indicesOfflinePaymentIntent.add(new TableInfo.Index("index_offline_payment_intent_payment_intent_id", false, Arrays.asList("payment_intent_id"), Arrays.asList("ASC")));
                _indicesOfflinePaymentIntent.add(new TableInfo.Index("index_offline_payment_intent_account_id", false, Arrays.asList("account_id"), Arrays.asList("ASC")));
                TableInfo _infoOfflinePaymentIntent = new TableInfo("offline_payment_intent", _columnsOfflinePaymentIntent, _foreignKeysOfflinePaymentIntent, _indicesOfflinePaymentIntent);
                TableInfo _existingOfflinePaymentIntent = TableInfo.read((SupportSQLiteDatabase)_db, (String)"offline_payment_intent");
                if (!_infoOfflinePaymentIntent.equals((Object)_existingOfflinePaymentIntent)) {
                    return new RoomOpenHelper.ValidationResult(false, "offline_payment_intent(com.stripe.offlinemode.storage.OfflinePaymentIntentRequestEntity).\n Expected:\n" + _infoOfflinePaymentIntent + "\n Found:\n" + _existingOfflinePaymentIntent);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "d4c6aeb67a02e761eba0f7ed268955a3", "cac89eef8ee82d71ee722d62427c1377");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"reader", "offline_connection", "offline_payment_intent"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `offline_payment_intent`");
            _db.execSQL("DELETE FROM `offline_connection`");
            _db.execSQL("DELETE FROM `reader`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(OfflineReaderDao.class, OfflineReaderDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(OfflineConnectionDao.class, OfflineConnectionDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(OfflinePaymentIntentRequestDao.class, OfflinePaymentIntentRequestDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OfflineReaderDao offlineReaderDao() {
        if (this._offlineReaderDao != null) {
            return this._offlineReaderDao;
        }
        OfflineDatabase_Impl offlineDatabase_Impl = this;
        synchronized (offlineDatabase_Impl) {
            if (this._offlineReaderDao == null) {
                this._offlineReaderDao = new OfflineReaderDao_Impl(this);
            }
            return this._offlineReaderDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OfflineConnectionDao offlineConnectionDao() {
        if (this._offlineConnectionDao != null) {
            return this._offlineConnectionDao;
        }
        OfflineDatabase_Impl offlineDatabase_Impl = this;
        synchronized (offlineDatabase_Impl) {
            if (this._offlineConnectionDao == null) {
                this._offlineConnectionDao = new OfflineConnectionDao_Impl(this);
            }
            return this._offlineConnectionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OfflinePaymentIntentRequestDao offlinePaymentIntentRequestDao() {
        if (this._offlinePaymentIntentRequestDao != null) {
            return this._offlinePaymentIntentRequestDao;
        }
        OfflineDatabase_Impl offlineDatabase_Impl = this;
        synchronized (offlineDatabase_Impl) {
            if (this._offlinePaymentIntentRequestDao == null) {
                this._offlinePaymentIntentRequestDao = new OfflinePaymentIntentRequestDao_Impl(this);
            }
            return this._offlinePaymentIntentRequestDao;
        }
    }
}

